/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Notification;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableDematerialize<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends Notification<R>> selector;

    public FlowableDematerialize(Flowable<T> source2, Function<? super T, ? extends Notification<R>> selector) {
        super(source2);
        this.selector = selector;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> subscriber) {
        this.source.subscribe(new DematerializeSubscriber<T, R>(subscriber, this.selector));
    }

    static final class DematerializeSubscriber<T, R>
    implements FlowableSubscriber<T>,
    Subscription {
        final Subscriber<? super R> downstream;
        final Function<? super T, ? extends Notification<R>> selector;
        boolean done;
        Subscription upstream;

        DematerializeSubscriber(Subscriber<? super R> downstream, Function<? super T, ? extends Notification<R>> selector) {
            this.downstream = downstream;
            this.selector = selector;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T item) {
            Notification<R> notification;
            if (this.done) {
                Notification notification2;
                if (item instanceof Notification && (notification2 = (Notification)item).isOnError()) {
                    RxJavaPlugins.onError(notification2.getError());
                }
                return;
            }
            try {
                notification = Objects.requireNonNull(this.selector.apply(item), "The selector returned a null Notification");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.upstream.cancel();
                this.onError(ex);
                return;
            }
            if (notification.isOnError()) {
                this.upstream.cancel();
                this.onError(notification.getError());
            } else if (notification.isOnComplete()) {
                this.upstream.cancel();
                this.onComplete();
            } else {
                this.downstream.onNext(notification.getValue());
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                RxJavaPlugins.onError(t2);
                return;
            }
            this.done = true;
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onComplete();
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }
    }
}

