/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableConditionalSubscriber;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableSubscriber;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import org.reactivestreams.Subscriber;

public final class FlowableDoAfterNext<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Consumer<? super T> onAfterNext;

    public FlowableDoAfterNext(Flowable<T> source2, Consumer<? super T> onAfterNext) {
        super(source2);
        this.onAfterNext = onAfterNext;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s2) {
        if (s2 instanceof ConditionalSubscriber) {
            this.source.subscribe(new DoAfterConditionalSubscriber<T>((ConditionalSubscriber)s2, this.onAfterNext));
        } else {
            this.source.subscribe(new DoAfterSubscriber<T>(s2, this.onAfterNext));
        }
    }

    static final class DoAfterConditionalSubscriber<T>
    extends BasicFuseableConditionalSubscriber<T, T> {
        final Consumer<? super T> onAfterNext;

        DoAfterConditionalSubscriber(ConditionalSubscriber<? super T> actual, Consumer<? super T> onAfterNext) {
            super(actual);
            this.onAfterNext = onAfterNext;
        }

        @Override
        public void onNext(T t2) {
            this.downstream.onNext(t2);
            if (this.sourceMode == 0) {
                try {
                    this.onAfterNext.accept(t2);
                }
                catch (Throwable ex) {
                    this.fail(ex);
                }
            }
        }

        @Override
        public boolean tryOnNext(T t2) {
            boolean b = this.downstream.tryOnNext(t2);
            try {
                this.onAfterNext.accept(t2);
            }
            catch (Throwable ex) {
                this.fail(ex);
            }
            return b;
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v = this.qs.poll();
            if (v != null) {
                this.onAfterNext.accept(v);
            }
            return v;
        }
    }

    static final class DoAfterSubscriber<T>
    extends BasicFuseableSubscriber<T, T> {
        final Consumer<? super T> onAfterNext;

        DoAfterSubscriber(Subscriber<? super T> actual, Consumer<? super T> onAfterNext) {
            super(actual);
            this.onAfterNext = onAfterNext;
        }

        @Override
        public void onNext(T t2) {
            if (this.done) {
                return;
            }
            this.downstream.onNext(t2);
            if (this.sourceMode == 0) {
                try {
                    this.onAfterNext.accept(t2);
                }
                catch (Throwable ex) {
                    this.fail(ex);
                }
            }
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v = this.qs.poll();
            if (v != null) {
                this.onAfterNext.accept(v);
            }
            return v;
        }
    }
}

