/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractBackpressureThrottlingSubscriber;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import java.util.Objects;
import org.reactivestreams.Subscriber;

public final class FlowableOnBackpressureReduce<T>
extends AbstractFlowableWithUpstream<T, T> {
    final BiFunction<T, T, T> reducer;

    public FlowableOnBackpressureReduce(@NonNull Flowable<T> source2, @NonNull BiFunction<T, T, T> reducer) {
        super(source2);
        this.reducer = reducer;
    }

    @Override
    protected void subscribeActual(@NonNull Subscriber<? super T> s2) {
        this.source.subscribe(new BackpressureReduceSubscriber<T>(s2, this.reducer));
    }

    static final class BackpressureReduceSubscriber<T>
    extends AbstractBackpressureThrottlingSubscriber<T, T> {
        private static final long serialVersionUID = 821363947659780367L;
        final BiFunction<T, T, T> reducer;

        BackpressureReduceSubscriber(@NonNull Subscriber<? super T> downstream, @NonNull BiFunction<T, T, T> reducer) {
            super(downstream);
            this.reducer = reducer;
        }

        @Override
        public void onNext(T t2) {
            Object v = this.current.get();
            if (v != null) {
                v = this.current.getAndSet(null);
            }
            if (v == null) {
                this.current.lazySet(t2);
            } else {
                try {
                    this.current.lazySet(Objects.requireNonNull(this.reducer.apply(v, t2), "The reducer returned a null value"));
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.upstream.cancel();
                    this.onError(ex);
                    return;
                }
            }
            this.drain();
        }
    }
}

