/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.HalfSerializer;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSkipUntil<T, U>
extends AbstractFlowableWithUpstream<T, T> {
    final Publisher<U> other;

    public FlowableSkipUntil(Flowable<T> source2, Publisher<U> other) {
        super(source2);
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> child) {
        SkipUntilMainSubscriber<? super T> parent = new SkipUntilMainSubscriber<T>(child);
        child.onSubscribe(parent);
        this.other.subscribe(parent.other);
        this.source.subscribe(parent);
    }

    static final class SkipUntilMainSubscriber<T>
    extends AtomicInteger
    implements ConditionalSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -6270983465606289181L;
        final Subscriber<? super T> downstream;
        final AtomicReference<Subscription> upstream;
        final AtomicLong requested;
        final OtherSubscriber other;
        final AtomicThrowable error;
        volatile boolean gate;

        SkipUntilMainSubscriber(Subscriber<? super T> downstream) {
            this.downstream = downstream;
            this.upstream = new AtomicReference();
            this.requested = new AtomicLong();
            this.other = new OtherSubscriber();
            this.error = new AtomicThrowable();
        }

        @Override
        public void onSubscribe(Subscription s2) {
            SubscriptionHelper.deferredSetOnce(this.upstream, this.requested, s2);
        }

        @Override
        public void onNext(T t2) {
            if (!this.tryOnNext(t2)) {
                this.upstream.get().request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t2) {
            if (this.gate) {
                HalfSerializer.onNext(this.downstream, t2, (AtomicInteger)this, this.error);
                return true;
            }
            return false;
        }

        @Override
        public void onError(Throwable t2) {
            SubscriptionHelper.cancel(this.other);
            HalfSerializer.onError(this.downstream, t2, (AtomicInteger)this, this.error);
        }

        @Override
        public void onComplete() {
            SubscriptionHelper.cancel(this.other);
            HalfSerializer.onComplete(this.downstream, (AtomicInteger)this, this.error);
        }

        @Override
        public void request(long n) {
            SubscriptionHelper.deferredRequest(this.upstream, this.requested, n);
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this.upstream);
            SubscriptionHelper.cancel(this.other);
        }

        final class OtherSubscriber
        extends AtomicReference<Subscription>
        implements FlowableSubscriber<Object> {
            private static final long serialVersionUID = -5592042965931999169L;

            OtherSubscriber() {
            }

            @Override
            public void onSubscribe(Subscription s2) {
                SubscriptionHelper.setOnce(this, s2, Long.MAX_VALUE);
            }

            @Override
            public void onNext(Object t2) {
                SkipUntilMainSubscriber.this.gate = true;
                ((Subscription)this.get()).cancel();
            }

            @Override
            public void onError(Throwable t2) {
                SubscriptionHelper.cancel(SkipUntilMainSubscriber.this.upstream);
                HalfSerializer.onError(SkipUntilMainSubscriber.this.downstream, t2, (AtomicInteger)SkipUntilMainSubscriber.this, SkipUntilMainSubscriber.this.error);
            }

            @Override
            public void onComplete() {
                SkipUntilMainSubscriber.this.gate = true;
            }
        }
    }
}

