/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableMap;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.HalfSerializer;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableWithLatestFromMany<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    @Nullable
    final Publisher<?>[] otherArray;
    @Nullable
    final Iterable<? extends Publisher<?>> otherIterable;
    final Function<? super Object[], R> combiner;

    public FlowableWithLatestFromMany(@NonNull Flowable<T> source2, @NonNull Publisher<?>[] otherArray, Function<? super Object[], R> combiner) {
        super(source2);
        this.otherArray = otherArray;
        this.otherIterable = null;
        this.combiner = combiner;
    }

    public FlowableWithLatestFromMany(@NonNull Flowable<T> source2, @NonNull Iterable<? extends Publisher<?>> otherIterable, @NonNull Function<? super Object[], R> combiner) {
        super(source2);
        this.otherArray = null;
        this.otherIterable = otherIterable;
        this.combiner = combiner;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s2) {
        Publisher<?>[] others = this.otherArray;
        int n = 0;
        if (others == null) {
            others = new Publisher[8];
            try {
                for (Publisher<?> p : this.otherIterable) {
                    if (n == others.length) {
                        others = Arrays.copyOf(others, n + (n >> 1));
                    }
                    others[n++] = p;
                }
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                EmptySubscription.error(ex, s2);
                return;
            }
        } else {
            n = others.length;
        }
        if (n == 0) {
            new FlowableMap(this.source, new SingletonArrayFunc()).subscribeActual(s2);
            return;
        }
        WithLatestFromSubscriber parent = new WithLatestFromSubscriber(s2, this.combiner, n);
        s2.onSubscribe(parent);
        parent.subscribe(others, n);
        this.source.subscribe(parent);
    }

    final class SingletonArrayFunc
    implements Function<T, R> {
        SingletonArrayFunc() {
        }

        @Override
        public R apply(T t2) throws Throwable {
            return Objects.requireNonNull(FlowableWithLatestFromMany.this.combiner.apply((Object[])new Object[]{t2}), "The combiner returned a null value");
        }
    }

    static final class WithLatestInnerSubscriber
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<Object> {
        private static final long serialVersionUID = 3256684027868224024L;
        final WithLatestFromSubscriber<?, ?> parent;
        final int index;
        boolean hasValue;

        WithLatestInnerSubscriber(WithLatestFromSubscriber<?, ?> parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            SubscriptionHelper.setOnce(this, s2, Long.MAX_VALUE);
        }

        @Override
        public void onNext(Object t2) {
            if (!this.hasValue) {
                this.hasValue = true;
            }
            this.parent.innerNext(this.index, t2);
        }

        @Override
        public void onError(Throwable t2) {
            this.parent.innerError(this.index, t2);
        }

        @Override
        public void onComplete() {
            this.parent.innerComplete(this.index, this.hasValue);
        }

        void dispose() {
            SubscriptionHelper.cancel(this);
        }
    }

    static final class WithLatestFromSubscriber<T, R>
    extends AtomicInteger
    implements ConditionalSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = 1577321883966341961L;
        final Subscriber<? super R> downstream;
        final Function<? super Object[], R> combiner;
        final WithLatestInnerSubscriber[] subscribers;
        final AtomicReferenceArray<Object> values;
        final AtomicReference<Subscription> upstream;
        final AtomicLong requested;
        final AtomicThrowable error;
        volatile boolean done;

        WithLatestFromSubscriber(Subscriber<? super R> actual, Function<? super Object[], R> combiner, int n) {
            this.downstream = actual;
            this.combiner = combiner;
            WithLatestInnerSubscriber[] s2 = new WithLatestInnerSubscriber[n];
            for (int i = 0; i < n; ++i) {
                s2[i] = new WithLatestInnerSubscriber(this, i);
            }
            this.subscribers = s2;
            this.values = new AtomicReferenceArray(n);
            this.upstream = new AtomicReference();
            this.requested = new AtomicLong();
            this.error = new AtomicThrowable();
        }

        void subscribe(Publisher<?>[] others, int n) {
            WithLatestInnerSubscriber[] subscribers = this.subscribers;
            AtomicReference<Subscription> upstream = this.upstream;
            for (int i = 0; i < n; ++i) {
                if (upstream.get() == SubscriptionHelper.CANCELLED) {
                    return;
                }
                others[i].subscribe(subscribers[i]);
            }
        }

        @Override
        public void onSubscribe(Subscription s2) {
            SubscriptionHelper.deferredSetOnce(this.upstream, this.requested, s2);
        }

        @Override
        public void onNext(T t2) {
            if (!this.tryOnNext(t2) && !this.done) {
                this.upstream.get().request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t2) {
            R v;
            if (this.done) {
                return false;
            }
            AtomicReferenceArray<Object> ara = this.values;
            int n = ara.length();
            Object[] objects = new Object[n + 1];
            objects[0] = t2;
            for (int i = 0; i < n; ++i) {
                Object o = ara.get(i);
                if (o == null) {
                    return false;
                }
                objects[i + 1] = o;
            }
            try {
                v = Objects.requireNonNull(this.combiner.apply((Object[])objects), "The combiner returned a null value");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.cancel();
                this.onError(ex);
                return false;
            }
            HalfSerializer.onNext(this.downstream, v, (AtomicInteger)this, this.error);
            return true;
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                RxJavaPlugins.onError(t2);
                return;
            }
            this.done = true;
            this.cancelAllBut(-1);
            HalfSerializer.onError(this.downstream, t2, (AtomicInteger)this, this.error);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.cancelAllBut(-1);
                HalfSerializer.onComplete(this.downstream, (AtomicInteger)this, this.error);
            }
        }

        @Override
        public void request(long n) {
            SubscriptionHelper.deferredRequest(this.upstream, this.requested, n);
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this.upstream);
            for (WithLatestInnerSubscriber s2 : this.subscribers) {
                s2.dispose();
            }
        }

        void innerNext(int index, Object o) {
            this.values.set(index, o);
        }

        void innerError(int index, Throwable t2) {
            this.done = true;
            SubscriptionHelper.cancel(this.upstream);
            this.cancelAllBut(index);
            HalfSerializer.onError(this.downstream, t2, (AtomicInteger)this, this.error);
        }

        void innerComplete(int index, boolean nonEmpty) {
            if (!nonEmpty) {
                this.done = true;
                SubscriptionHelper.cancel(this.upstream);
                this.cancelAllBut(index);
                HalfSerializer.onComplete(this.downstream, (AtomicInteger)this, this.error);
            }
        }

        void cancelAllBut(int index) {
            WithLatestInnerSubscriber[] subscribers = this.subscribers;
            for (int i = 0; i < subscribers.length; ++i) {
                if (i == index) continue;
                subscribers[i].dispose();
            }
        }
    }
}

