/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.operators.QueueDisposable;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ConcatMapXMainObserver<T>
extends AtomicInteger
implements Observer<T>,
Disposable {
    private static final long serialVersionUID = -3214213361171757852L;
    final AtomicThrowable errors;
    final int prefetch;
    final ErrorMode errorMode;
    SimpleQueue<T> queue;
    Disposable upstream;
    volatile boolean done;
    volatile boolean disposed;

    public ConcatMapXMainObserver(int prefetch, ErrorMode errorMode) {
        this.errorMode = errorMode;
        this.errors = new AtomicThrowable();
        this.prefetch = prefetch;
    }

    @Override
    public final void onSubscribe(Disposable d) {
        if (DisposableHelper.validate(this.upstream, d)) {
            this.upstream = d;
            if (d instanceof QueueDisposable) {
                QueueDisposable qd = (QueueDisposable)d;
                int mode = qd.requestFusion(7);
                if (mode == 1) {
                    this.queue = qd;
                    this.done = true;
                    this.onSubscribeDownstream();
                    this.drain();
                    return;
                }
                if (mode == 2) {
                    this.queue = qd;
                    this.onSubscribeDownstream();
                    return;
                }
            }
            this.queue = new SpscLinkedArrayQueue(this.prefetch);
            this.onSubscribeDownstream();
        }
    }

    @Override
    public final void onNext(T t2) {
        if (t2 != null) {
            this.queue.offer(t2);
        }
        this.drain();
    }

    @Override
    public final void onError(Throwable t2) {
        if (this.errors.tryAddThrowableOrReport(t2)) {
            if (this.errorMode == ErrorMode.IMMEDIATE) {
                this.disposeInner();
            }
            this.done = true;
            this.drain();
        }
    }

    @Override
    public final void onComplete() {
        this.done = true;
        this.drain();
    }

    @Override
    public final void dispose() {
        this.disposed = true;
        this.upstream.dispose();
        this.disposeInner();
        this.errors.tryTerminateAndReport();
        if (this.getAndIncrement() == 0) {
            this.queue.clear();
            this.clearValue();
        }
    }

    @Override
    public final boolean isDisposed() {
        return this.disposed;
    }

    void clearValue() {
    }

    abstract void onSubscribeDownstream();

    abstract void disposeInner();

    abstract void drain();
}

