/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.observers.QueueDrainObserver;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.queue.MpscLinkedQueue;
import io.reactivex.rxjava3.internal.util.QueueDrainHelper;
import io.reactivex.rxjava3.observers.DisposableObserver;
import io.reactivex.rxjava3.observers.SerializedObserver;
import java.util.Collection;
import java.util.Objects;

public final class ObservableBufferExactBoundary<T, U extends Collection<? super T>, B>
extends AbstractObservableWithUpstream<T, U> {
    final ObservableSource<B> boundary;
    final Supplier<U> bufferSupplier;

    public ObservableBufferExactBoundary(ObservableSource<T> source2, ObservableSource<B> boundary, Supplier<U> bufferSupplier) {
        super(source2);
        this.boundary = boundary;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    protected void subscribeActual(Observer<? super U> t2) {
        this.source.subscribe(new BufferExactBoundaryObserver(new SerializedObserver<U>(t2), this.bufferSupplier, this.boundary));
    }

    static final class BufferBoundaryObserver<T, U extends Collection<? super T>, B>
    extends DisposableObserver<B> {
        final BufferExactBoundaryObserver<T, U, B> parent;

        BufferBoundaryObserver(BufferExactBoundaryObserver<T, U, B> parent) {
            this.parent = parent;
        }

        @Override
        public void onNext(B t2) {
            this.parent.next();
        }

        @Override
        public void onError(Throwable t2) {
            this.parent.onError(t2);
        }

        @Override
        public void onComplete() {
            this.parent.onComplete();
        }
    }

    static final class BufferExactBoundaryObserver<T, U extends Collection<? super T>, B>
    extends QueueDrainObserver<T, U, U>
    implements Observer<T>,
    Disposable {
        final Supplier<U> bufferSupplier;
        final ObservableSource<B> boundary;
        Disposable upstream;
        Disposable other;
        U buffer;

        BufferExactBoundaryObserver(Observer<? super U> actual, Supplier<U> bufferSupplier, ObservableSource<B> boundary) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.boundary = boundary;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                BufferBoundaryObserver bs;
                Collection b;
                this.upstream = d;
                try {
                    b = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The buffer supplied is null");
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.cancelled = true;
                    d.dispose();
                    EmptyDisposable.error(e, this.downstream);
                    return;
                }
                this.buffer = b;
                this.other = bs = new BufferBoundaryObserver(this);
                this.downstream.onSubscribe(this);
                if (!this.cancelled) {
                    this.boundary.subscribe(bs);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t2) {
            BufferExactBoundaryObserver bufferExactBoundaryObserver = this;
            synchronized (bufferExactBoundaryObserver) {
                U b = this.buffer;
                if (b == null) {
                    return;
                }
                b.add(t2);
            }
        }

        @Override
        public void onError(Throwable t2) {
            this.dispose();
            this.downstream.onError(t2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            U b;
            BufferExactBoundaryObserver bufferExactBoundaryObserver = this;
            synchronized (bufferExactBoundaryObserver) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                this.buffer = null;
            }
            this.queue.offer(b);
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainLoop(this.queue, this.downstream, false, this, this);
            }
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.other.dispose();
                this.upstream.dispose();
                if (this.enter()) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void next() {
            U b;
            Collection next2;
            try {
                next2 = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The buffer supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.dispose();
                this.downstream.onError(e);
                return;
            }
            BufferExactBoundaryObserver bufferExactBoundaryObserver = this;
            synchronized (bufferExactBoundaryObserver) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                this.buffer = next2;
            }
            this.fastPathEmit(b, false, this);
        }

        @Override
        public void accept(Observer<? super U> a, U v) {
            this.downstream.onNext(v);
        }
    }
}

