/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class ObservableDelaySubscriptionOther<T, U>
extends Observable<T> {
    final ObservableSource<? extends T> main;
    final ObservableSource<U> other;

    public ObservableDelaySubscriptionOther(ObservableSource<? extends T> main, ObservableSource<U> other) {
        this.main = main;
        this.other = other;
    }

    @Override
    public void subscribeActual(Observer<? super T> child) {
        SequentialDisposable serial = new SequentialDisposable();
        child.onSubscribe(serial);
        DelayObserver otherObserver = new DelayObserver(serial, child);
        this.other.subscribe(otherObserver);
    }

    final class DelayObserver
    implements Observer<U> {
        final SequentialDisposable serial;
        final Observer<? super T> child;
        boolean done;

        DelayObserver(SequentialDisposable serial, Observer<? super T> child) {
            this.serial = serial;
            this.child = child;
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.serial.update(d);
        }

        @Override
        public void onNext(U t2) {
            this.onComplete();
        }

        @Override
        public void onError(Throwable e) {
            if (this.done) {
                RxJavaPlugins.onError(e);
                return;
            }
            this.done = true;
            this.child.onError(e);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            ObservableDelaySubscriptionOther.this.main.subscribe(new OnComplete());
        }

        final class OnComplete
        implements Observer<T> {
            OnComplete() {
            }

            @Override
            public void onSubscribe(Disposable d) {
                DelayObserver.this.serial.update(d);
            }

            @Override
            public void onNext(T value) {
                DelayObserver.this.child.onNext(value);
            }

            @Override
            public void onError(Throwable e) {
                DelayObserver.this.child.onError(e);
            }

            @Override
            public void onComplete() {
                DelayObserver.this.child.onComplete();
            }
        }
    }
}

