/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.fuseable.FuseToObservable;
import io.reactivex.rxjava3.internal.operators.observable.ObservableIgnoreElements;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class ObservableIgnoreElementsCompletable<T>
extends Completable
implements FuseToObservable<T> {
    final ObservableSource<T> source;

    public ObservableIgnoreElementsCompletable(ObservableSource<T> source2) {
        this.source = source2;
    }

    @Override
    public void subscribeActual(CompletableObserver t2) {
        this.source.subscribe(new IgnoreObservable(t2));
    }

    @Override
    public Observable<T> fuseToObservable() {
        return RxJavaPlugins.onAssembly(new ObservableIgnoreElements<T>(this.source));
    }

    static final class IgnoreObservable<T>
    implements Observer<T>,
    Disposable {
        final CompletableObserver downstream;
        Disposable upstream;

        IgnoreObservable(CompletableObserver t2) {
            this.downstream = t2;
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.upstream = d;
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onNext(T v) {
        }

        @Override
        public void onError(Throwable e) {
            this.downstream.onError(e);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }
    }
}

