/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.operators.SimplePlainQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableMergeWithMaybe<T>
extends AbstractObservableWithUpstream<T, T> {
    final MaybeSource<? extends T> other;

    public ObservableMergeWithMaybe(Observable<T> source2, MaybeSource<? extends T> other) {
        super(source2);
        this.other = other;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        MergeWithObserver<? super T> parent = new MergeWithObserver<T>(observer);
        observer.onSubscribe(parent);
        this.source.subscribe(parent);
        this.other.subscribe(parent.otherObserver);
    }

    static final class MergeWithObserver<T>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -4592979584110982903L;
        final Observer<? super T> downstream;
        final AtomicReference<Disposable> mainDisposable;
        final OtherObserver<T> otherObserver;
        final AtomicThrowable errors;
        volatile SimplePlainQueue<T> queue;
        T singleItem;
        volatile boolean disposed;
        volatile boolean mainDone;
        volatile int otherState;
        static final int OTHER_STATE_HAS_VALUE = 1;
        static final int OTHER_STATE_CONSUMED_OR_EMPTY = 2;

        MergeWithObserver(Observer<? super T> downstream) {
            this.downstream = downstream;
            this.mainDisposable = new AtomicReference();
            this.otherObserver = new OtherObserver(this);
            this.errors = new AtomicThrowable();
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce(this.mainDisposable, d);
        }

        @Override
        public void onNext(T t2) {
            if (this.compareAndSet(0, 1)) {
                this.downstream.onNext(t2);
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimplePlainQueue<T> q = this.getOrCreateQueue();
                q.offer(t2);
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable ex) {
            if (this.errors.tryAddThrowableOrReport(ex)) {
                DisposableHelper.dispose(this.otherObserver);
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.mainDone = true;
            this.drain();
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed(this.mainDisposable.get());
        }

        @Override
        public void dispose() {
            this.disposed = true;
            DisposableHelper.dispose(this.mainDisposable);
            DisposableHelper.dispose(this.otherObserver);
            this.errors.tryTerminateAndReport();
            if (this.getAndIncrement() == 0) {
                this.queue = null;
                this.singleItem = null;
            }
        }

        void otherSuccess(T value) {
            if (this.compareAndSet(0, 1)) {
                this.downstream.onNext(value);
                this.otherState = 2;
            } else {
                this.singleItem = value;
                this.otherState = 1;
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        void otherError(Throwable ex) {
            if (this.errors.tryAddThrowableOrReport(ex)) {
                DisposableHelper.dispose(this.mainDisposable);
                this.drain();
            }
        }

        void otherComplete() {
            this.otherState = 2;
            this.drain();
        }

        SimplePlainQueue<T> getOrCreateQueue() {
            SimplePlainQueue<T> q = this.queue;
            if (q == null) {
                this.queue = q = new SpscLinkedArrayQueue(Observable.bufferSize());
            }
            return q;
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            Observer<T> actual = this.downstream;
            int missed = 1;
            while (true) {
                boolean empty;
                if (this.disposed) {
                    this.singleItem = null;
                    this.queue = null;
                    return;
                }
                if (this.errors.get() != null) {
                    this.singleItem = null;
                    this.queue = null;
                    this.errors.tryTerminateConsumer(actual);
                    return;
                }
                int os = this.otherState;
                if (os == 1) {
                    T v = this.singleItem;
                    this.singleItem = null;
                    this.otherState = 2;
                    os = 2;
                    actual.onNext(v);
                }
                boolean d = this.mainDone;
                SimplePlainQueue<T> q = this.queue;
                Object v = q != null ? (Object)q.poll() : null;
                boolean bl = empty = v == null;
                if (d && empty && os == 2) {
                    this.queue = null;
                    actual.onComplete();
                    return;
                }
                if (!empty) {
                    actual.onNext(v);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        static final class OtherObserver<T>
        extends AtomicReference<Disposable>
        implements MaybeObserver<T> {
            private static final long serialVersionUID = -2935427570954647017L;
            final MergeWithObserver<T> parent;

            OtherObserver(MergeWithObserver<T> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onSuccess(T t2) {
                this.parent.otherSuccess(t2);
            }

            @Override
            public void onError(Throwable e) {
                this.parent.otherError(e);
            }

            @Override
            public void onComplete() {
                this.parent.otherComplete();
            }
        }
    }
}

