/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiPredicate;
import io.reactivex.rxjava3.internal.disposables.ArrayCompositeDisposable;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableSequenceEqual<T>
extends Observable<Boolean> {
    final ObservableSource<? extends T> first;
    final ObservableSource<? extends T> second;
    final BiPredicate<? super T, ? super T> comparer;
    final int bufferSize;

    public ObservableSequenceEqual(ObservableSource<? extends T> first, ObservableSource<? extends T> second, BiPredicate<? super T, ? super T> comparer, int bufferSize) {
        this.first = first;
        this.second = second;
        this.comparer = comparer;
        this.bufferSize = bufferSize;
    }

    @Override
    public void subscribeActual(Observer<? super Boolean> observer) {
        EqualCoordinator<T> ec = new EqualCoordinator<T>(observer, this.bufferSize, this.first, this.second, this.comparer);
        observer.onSubscribe(ec);
        ec.subscribe();
    }

    static final class EqualObserver<T>
    implements Observer<T> {
        final EqualCoordinator<T> parent;
        final SpscLinkedArrayQueue<T> queue;
        final int index;
        volatile boolean done;
        Throwable error;

        EqualObserver(EqualCoordinator<T> parent, int index, int bufferSize) {
            this.parent = parent;
            this.index = index;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.parent.setDisposable(d, this.index);
        }

        @Override
        public void onNext(T t2) {
            this.queue.offer(t2);
            this.parent.drain();
        }

        @Override
        public void onError(Throwable t2) {
            this.error = t2;
            this.done = true;
            this.parent.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }
    }

    static final class EqualCoordinator<T>
    extends AtomicInteger
    implements Disposable {
        private static final long serialVersionUID = -6178010334400373240L;
        final Observer<? super Boolean> downstream;
        final BiPredicate<? super T, ? super T> comparer;
        final ArrayCompositeDisposable resources;
        final ObservableSource<? extends T> first;
        final ObservableSource<? extends T> second;
        final EqualObserver<T>[] observers;
        volatile boolean cancelled;
        T v1;
        T v2;

        EqualCoordinator(Observer<? super Boolean> actual, int bufferSize, ObservableSource<? extends T> first, ObservableSource<? extends T> second, BiPredicate<? super T, ? super T> comparer) {
            this.downstream = actual;
            this.first = first;
            this.second = second;
            this.comparer = comparer;
            EqualObserver[] as = new EqualObserver[2];
            this.observers = as;
            as[0] = new EqualObserver(this, 0, bufferSize);
            as[1] = new EqualObserver(this, 1, bufferSize);
            this.resources = new ArrayCompositeDisposable(2);
        }

        boolean setDisposable(Disposable d, int index) {
            return this.resources.setResource(index, d);
        }

        void subscribe() {
            EqualObserver<T>[] as = this.observers;
            this.first.subscribe(as[0]);
            this.second.subscribe(as[1]);
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.resources.dispose();
                if (this.getAndIncrement() == 0) {
                    EqualObserver<T>[] as = this.observers;
                    as[0].queue.clear();
                    as[1].queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void cancel(SpscLinkedArrayQueue<T> q1, SpscLinkedArrayQueue<T> q2) {
            this.cancelled = true;
            q1.clear();
            q2.clear();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            EqualObserver<T>[] as = this.observers;
            EqualObserver<T> observer1 = as[0];
            SpscLinkedArrayQueue q1 = observer1.queue;
            EqualObserver<T> observer2 = as[1];
            SpscLinkedArrayQueue q2 = observer2.queue;
            while (true) {
                boolean e2;
                boolean e1;
                Throwable e;
                Throwable e3;
                if (this.cancelled) {
                    q1.clear();
                    q2.clear();
                    return;
                }
                boolean d1 = observer1.done;
                if (d1 && (e3 = observer1.error) != null) {
                    this.cancel(q1, q2);
                    this.downstream.onError(e3);
                    return;
                }
                boolean d2 = observer2.done;
                if (d2 && (e = observer2.error) != null) {
                    this.cancel(q1, q2);
                    this.downstream.onError(e);
                    return;
                }
                if (this.v1 == null) {
                    this.v1 = q1.poll();
                }
                boolean bl = e1 = this.v1 == null;
                if (this.v2 == null) {
                    this.v2 = q2.poll();
                }
                boolean bl2 = e2 = this.v2 == null;
                if (d1 && d2 && e1 && e2) {
                    this.downstream.onNext((Boolean)true);
                    this.downstream.onComplete();
                    return;
                }
                if (d1 && d2 && e1 != e2) {
                    this.cancel(q1, q2);
                    this.downstream.onNext((Boolean)false);
                    this.downstream.onComplete();
                    return;
                }
                if (!e1 && !e2) {
                    boolean c;
                    try {
                        c = this.comparer.test(this.v1, this.v2);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.cancel(q1, q2);
                        this.downstream.onError(ex);
                        return;
                    }
                    if (!c) {
                        this.cancel(q1, q2);
                        this.downstream.onNext((Boolean)false);
                        this.downstream.onComplete();
                        return;
                    }
                    this.v1 = null;
                    this.v2 = null;
                }
                if (!e1 && !e2) continue;
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

