/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableSwitchIfEmpty<T>
extends AbstractObservableWithUpstream<T, T> {
    final ObservableSource<? extends T> other;

    public ObservableSwitchIfEmpty(ObservableSource<T> source2, ObservableSource<? extends T> other) {
        super(source2);
        this.other = other;
    }

    @Override
    public void subscribeActual(Observer<? super T> t2) {
        SwitchIfEmptyObserver<? extends T> parent = new SwitchIfEmptyObserver<T>(t2, this.other);
        t2.onSubscribe(parent.arbiter);
        this.source.subscribe(parent);
    }

    static final class SwitchIfEmptyObserver<T>
    implements Observer<T> {
        final Observer<? super T> downstream;
        final ObservableSource<? extends T> other;
        final SequentialDisposable arbiter;
        boolean empty;

        SwitchIfEmptyObserver(Observer<? super T> actual, ObservableSource<? extends T> other) {
            this.downstream = actual;
            this.other = other;
            this.empty = true;
            this.arbiter = new SequentialDisposable();
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.arbiter.update(d);
        }

        @Override
        public void onNext(T t2) {
            if (this.empty) {
                this.empty = false;
            }
            this.downstream.onNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            if (this.empty) {
                this.empty = false;
                this.other.subscribe(this);
            } else {
                this.downstream.onComplete();
            }
        }
    }
}

