/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.HalfSerializer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableTakeUntil<T, U>
extends AbstractObservableWithUpstream<T, T> {
    final ObservableSource<? extends U> other;

    public ObservableTakeUntil(ObservableSource<T> source2, ObservableSource<? extends U> other) {
        super(source2);
        this.other = other;
    }

    @Override
    public void subscribeActual(Observer<? super T> child) {
        TakeUntilMainObserver parent = new TakeUntilMainObserver(child);
        child.onSubscribe(parent);
        this.other.subscribe(parent.otherObserver);
        this.source.subscribe(parent);
    }

    static final class TakeUntilMainObserver<T, U>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = 1418547743690811973L;
        final Observer<? super T> downstream;
        final AtomicReference<Disposable> upstream;
        final OtherObserver otherObserver;
        final AtomicThrowable error;

        TakeUntilMainObserver(Observer<? super T> downstream) {
            this.downstream = downstream;
            this.upstream = new AtomicReference();
            this.otherObserver = new OtherObserver();
            this.error = new AtomicThrowable();
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.upstream);
            DisposableHelper.dispose(this.otherObserver);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed(this.upstream.get());
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce(this.upstream, d);
        }

        @Override
        public void onNext(T t2) {
            HalfSerializer.onNext(this.downstream, t2, (AtomicInteger)this, this.error);
        }

        @Override
        public void onError(Throwable e) {
            DisposableHelper.dispose(this.otherObserver);
            HalfSerializer.onError(this.downstream, e, (AtomicInteger)this, this.error);
        }

        @Override
        public void onComplete() {
            DisposableHelper.dispose(this.otherObserver);
            HalfSerializer.onComplete(this.downstream, (AtomicInteger)this, this.error);
        }

        void otherError(Throwable e) {
            DisposableHelper.dispose(this.upstream);
            HalfSerializer.onError(this.downstream, e, (AtomicInteger)this, this.error);
        }

        void otherComplete() {
            DisposableHelper.dispose(this.upstream);
            HalfSerializer.onComplete(this.downstream, (AtomicInteger)this, this.error);
        }

        final class OtherObserver
        extends AtomicReference<Disposable>
        implements Observer<U> {
            private static final long serialVersionUID = -8693423678067375039L;

            OtherObserver() {
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onNext(U t2) {
                DisposableHelper.dispose(this);
                TakeUntilMainObserver.this.otherComplete();
            }

            @Override
            public void onError(Throwable e) {
                TakeUntilMainObserver.this.otherError(e);
            }

            @Override
            public void onComplete() {
                TakeUntilMainObserver.this.otherComplete();
            }
        }
    }
}

