/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.parallel;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.LongConsumer;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelPeek<T>
extends ParallelFlowable<T> {
    final ParallelFlowable<T> source;
    final Consumer<? super T> onNext;
    final Consumer<? super T> onAfterNext;
    final Consumer<? super Throwable> onError;
    final Action onComplete;
    final Action onAfterTerminated;
    final Consumer<? super Subscription> onSubscribe;
    final LongConsumer onRequest;
    final Action onCancel;

    public ParallelPeek(ParallelFlowable<T> source2, Consumer<? super T> onNext, Consumer<? super T> onAfterNext, Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminated, Consumer<? super Subscription> onSubscribe, LongConsumer onRequest, Action onCancel) {
        this.source = source2;
        this.onNext = Objects.requireNonNull(onNext, "onNext is null");
        this.onAfterNext = Objects.requireNonNull(onAfterNext, "onAfterNext is null");
        this.onError = Objects.requireNonNull(onError, "onError is null");
        this.onComplete = Objects.requireNonNull(onComplete, "onComplete is null");
        this.onAfterTerminated = Objects.requireNonNull(onAfterTerminated, "onAfterTerminated is null");
        this.onSubscribe = Objects.requireNonNull(onSubscribe, "onSubscribe is null");
        this.onRequest = Objects.requireNonNull(onRequest, "onRequest is null");
        this.onCancel = Objects.requireNonNull(onCancel, "onCancel is null");
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers = RxJavaPlugins.onSubscribe(this, subscribers))) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            parents[i] = new ParallelPeekSubscriber<T>(subscribers[i], this);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelPeekSubscriber<T>
    implements FlowableSubscriber<T>,
    Subscription {
        final Subscriber<? super T> downstream;
        final ParallelPeek<T> parent;
        Subscription upstream;
        boolean done;

        ParallelPeekSubscriber(Subscriber<? super T> actual, ParallelPeek<T> parent) {
            this.downstream = actual;
            this.parent = parent;
        }

        @Override
        public void request(long n) {
            try {
                this.parent.onRequest.accept(n);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                RxJavaPlugins.onError(ex);
            }
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            try {
                this.parent.onCancel.run();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                RxJavaPlugins.onError(ex);
            }
            this.upstream.cancel();
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                try {
                    this.parent.onSubscribe.accept(s2);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    s2.cancel();
                    this.downstream.onSubscribe(EmptySubscription.INSTANCE);
                    this.onError(ex);
                    return;
                }
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            if (!this.done) {
                try {
                    this.parent.onNext.accept(t2);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.onError(ex);
                    return;
                }
                this.downstream.onNext(t2);
                try {
                    this.parent.onAfterNext.accept(t2);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.onError(ex);
                }
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                RxJavaPlugins.onError(t2);
                return;
            }
            this.done = true;
            try {
                this.parent.onError.accept(t2);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                t2 = new CompositeException(t2, ex);
            }
            this.downstream.onError(t2);
            try {
                this.parent.onAfterTerminated.run();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                RxJavaPlugins.onError(ex);
            }
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                try {
                    this.parent.onComplete.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.downstream.onError(ex);
                    return;
                }
                this.downstream.onComplete();
                try {
                    this.parent.onAfterTerminated.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    RxJavaPlugins.onError(ex);
                }
            }
        }
    }
}

