/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.schedulers;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class TrampolineScheduler
extends Scheduler {
    private static final TrampolineScheduler INSTANCE = new TrampolineScheduler();

    public static TrampolineScheduler instance() {
        return INSTANCE;
    }

    @Override
    @NonNull
    public Scheduler.Worker createWorker() {
        return new TrampolineWorker();
    }

    TrampolineScheduler() {
    }

    @Override
    @NonNull
    public Disposable scheduleDirect(@NonNull Runnable run) {
        RxJavaPlugins.onSchedule(run).run();
        return EmptyDisposable.INSTANCE;
    }

    @Override
    @NonNull
    public Disposable scheduleDirect(@NonNull Runnable run, long delay, TimeUnit unit) {
        try {
            unit.sleep(delay);
            RxJavaPlugins.onSchedule(run).run();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            RxJavaPlugins.onError(ex);
        }
        return EmptyDisposable.INSTANCE;
    }

    static final class SleepingRunnable
    implements Runnable {
        private final Runnable run;
        private final TrampolineWorker worker;
        private final long execTime;

        SleepingRunnable(Runnable run, TrampolineWorker worker, long execTime) {
            this.run = run;
            this.worker = worker;
            this.execTime = execTime;
        }

        @Override
        public void run() {
            if (!this.worker.disposed) {
                long t2 = this.worker.now(TimeUnit.MILLISECONDS);
                if (this.execTime > t2) {
                    long delay = this.execTime - t2;
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        RxJavaPlugins.onError(e);
                        return;
                    }
                }
                if (!this.worker.disposed) {
                    this.run.run();
                }
            }
        }
    }

    static final class TimedRunnable
    implements Comparable<TimedRunnable> {
        final Runnable run;
        final long execTime;
        final int count;
        volatile boolean disposed;

        TimedRunnable(Runnable run, Long execTime, int count) {
            this.run = run;
            this.execTime = execTime;
            this.count = count;
        }

        @Override
        public int compareTo(TimedRunnable that) {
            int result2 = Long.compare(this.execTime, that.execTime);
            if (result2 == 0) {
                return Integer.compare(this.count, that.count);
            }
            return result2;
        }
    }

    static final class TrampolineWorker
    extends Scheduler.Worker
    implements Disposable {
        final PriorityBlockingQueue<TimedRunnable> queue = new PriorityBlockingQueue();
        private final AtomicInteger wip = new AtomicInteger();
        final AtomicInteger counter = new AtomicInteger();
        volatile boolean disposed;

        TrampolineWorker() {
        }

        @Override
        @NonNull
        public Disposable schedule(@NonNull Runnable action) {
            return this.enqueue(action, this.now(TimeUnit.MILLISECONDS));
        }

        @Override
        @NonNull
        public Disposable schedule(@NonNull Runnable action, long delayTime, @NonNull TimeUnit unit) {
            long execTime = this.now(TimeUnit.MILLISECONDS) + unit.toMillis(delayTime);
            return this.enqueue(new SleepingRunnable(action, this, execTime), execTime);
        }

        Disposable enqueue(Runnable action, long execTime) {
            if (this.disposed) {
                return EmptyDisposable.INSTANCE;
            }
            TimedRunnable timedRunnable = new TimedRunnable(action, execTime, this.counter.incrementAndGet());
            this.queue.add(timedRunnable);
            if (this.wip.getAndIncrement() == 0) {
                int missed = 1;
                while (true) {
                    if (this.disposed) {
                        this.queue.clear();
                        return EmptyDisposable.INSTANCE;
                    }
                    TimedRunnable polled = this.queue.poll();
                    if (polled != null) {
                        if (polled.disposed) continue;
                        polled.run.run();
                        continue;
                    }
                    if ((missed = this.wip.addAndGet(-missed)) == 0) break;
                }
                return EmptyDisposable.INSTANCE;
            }
            return Disposable.fromRunnable(new AppendToQueueTask(timedRunnable));
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        final class AppendToQueueTask
        implements Runnable {
            final TimedRunnable timedRunnable;

            AppendToQueueTask(TimedRunnable timedRunnable) {
                this.timedRunnable = timedRunnable;
            }

            @Override
            public void run() {
                this.timedRunnable.disposed = true;
                TrampolineWorker.this.queue.remove(this.timedRunnable);
            }
        }
    }
}

