/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Vector;
import javax.media.j3d.BHInsertStructure;
import javax.media.j3d.BHInternalNode;
import javax.media.j3d.BHLeafInterface;
import javax.media.j3d.BHLeafNode;
import javax.media.j3d.BHNode;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.Locale;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.PickShape;
import javax.media.j3d.RenderBin;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.UnorderList;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point4d;

class BHTree {
    Locale locale;
    BHNode root;
    BHInsertStructure insertStructure = null;
    Point4d tPoint4d = new Point4d();
    private boolean stable = false;
    int estMaxDepth;
    static final double LOG_OF_2 = Math.log(2.0);
    static final int DEPTH_UPPER_BOUND = 56;
    static final int INCR_DEPTH_BOUND = 5;
    int depthUpperBound = 56;

    BHTree() {
        this.locale = null;
        this.root = null;
    }

    BHTree(Locale locale) {
        this.locale = locale;
        this.root = null;
    }

    BHTree(BHNode[] bHNodeArray) {
        this.locale = null;
        this.root = null;
        this.create(bHNodeArray);
    }

    void setLocale(Locale locale) {
        this.locale = locale;
    }

    Locale getLocale() {
        return this.locale;
    }

    void cluster(BHInternalNode bHInternalNode, BHNode[] bHNodeArray) {
        if (bHNodeArray == null || bHNodeArray.length < 2 || bHInternalNode == null) {
            return;
        }
        int[] nArray = new int[bHNodeArray.length];
        float[][] fArray = this.computeCenterValues(bHNodeArray, nArray);
        this.constructTree(bHInternalNode, bHNodeArray, fArray, nArray);
    }

    void boundsChanged(BHNode[] bHNodeArray, int n) {
        this.markParentChain(bHNodeArray, n);
        this.root.updateMarkedBoundingHull();
    }

    boolean getVisibleBHTrees(RenderBin renderBin, ArrayList arrayList, BoundingBox boundingBox, long l, boolean bl, int n, boolean bl2) {
        if (boundingBox != null && this.root != null) {
            boolean bl3 = BHTree.aEncompassB(boundingBox, this.root.bHull);
            if (bl2 && !bl && bl3 && this.stable) {
                arrayList.add(this.root);
                return true;
            }
            if (!bl && bl3) {
                this.select(renderBin, arrayList, boundingBox, this.root, l, n, true);
                arrayList.add(this.root);
                this.stable = true;
            } else {
                this.select(renderBin, arrayList, boundingBox, this.root, l, n, false);
                this.stable = false;
            }
        }
        return false;
    }

    private void select(RenderBin renderBin, ArrayList arrayList, BoundingBox boundingBox, BHNode bHNode, long l, int n, boolean bl) {
        if (bHNode == null || bHNode.bHull.isEmpty()) {
            return;
        }
        switch (bHNode.nodeType) {
            case 2: {
                if (!(((BHLeafNode)bHNode).leafIF instanceof GeometryAtom) || !((BHLeafNode)bHNode).isEnable(n) || !bl && !boundingBox.intersect(bHNode.bHull)) break;
                renderBin.processGeometryAtom((GeometryAtom)((BHLeafNode)bHNode).leafIF, l);
                if (bl) break;
                arrayList.add(bHNode);
                break;
            }
            case 1: {
                if (bl) {
                    this.select(renderBin, arrayList, boundingBox, ((BHInternalNode)bHNode).getRightChild(), l, n, true);
                    this.select(renderBin, arrayList, boundingBox, ((BHInternalNode)bHNode).getLeftChild(), l, n, true);
                    break;
                }
                if (BHTree.aEncompassB(boundingBox, bHNode.bHull)) {
                    arrayList.add(bHNode);
                    this.select(renderBin, arrayList, boundingBox, ((BHInternalNode)bHNode).getRightChild(), l, n, true);
                    this.select(renderBin, arrayList, boundingBox, ((BHInternalNode)bHNode).getLeftChild(), l, n, true);
                    break;
                }
                if (!boundingBox.intersect(bHNode.bHull)) break;
                this.select(renderBin, arrayList, boundingBox, ((BHInternalNode)bHNode).getRightChild(), l, n, false);
                this.select(renderBin, arrayList, boundingBox, ((BHInternalNode)bHNode).getLeftChild(), l, n, false);
            }
        }
    }

    static boolean aEncompassB(BoundingBox boundingBox, BoundingBox boundingBox2) {
        return boundingBox.upper.x >= boundingBox2.upper.x && boundingBox.upper.y >= boundingBox2.upper.y && boundingBox.upper.z >= boundingBox2.upper.z && boundingBox.lower.x <= boundingBox2.lower.x && boundingBox.lower.y <= boundingBox2.lower.y && boundingBox.lower.z <= boundingBox2.lower.z;
    }

    BHLeafInterface selectAny(GeometryAtom geometryAtom, int n) {
        if (geometryAtom.source.geometryList == null) {
            return null;
        }
        BHNode bHNode = this.doSelectAny(geometryAtom, this.root, n);
        if (bHNode == null) {
            return null;
        }
        return ((BHLeafNode)bHNode).leafIF;
    }

    BHLeafInterface selectAny(GeometryAtom[] geometryAtomArray, int n, int n2) {
        BHNode bHNode = this.doSelectAny(geometryAtomArray, n, this.root, n2);
        if (bHNode == null) {
            return null;
        }
        return ((BHLeafNode)bHNode).leafIF;
    }

    private BHNode doSelectAny(GeometryAtom[] geometryAtomArray, int n, BHNode bHNode, int n2) {
        if (bHNode == null || bHNode.bHull.isEmpty()) {
            return null;
        }
        switch (bHNode.nodeType) {
            case 2: {
                BHLeafInterface bHLeafInterface = ((BHLeafNode)bHNode).leafIF;
                if (bHLeafInterface instanceof GeometryAtom) {
                    GeometryAtom geometryAtom = (GeometryAtom)bHLeafInterface;
                    if (((BHLeafNode)bHNode).isEnable() && geometryAtom.source.isCollidable) {
                        int n3 = n - 1;
                        while (n3 >= 0) {
                            if (geometryAtomArray[n3] == geometryAtom) {
                                return null;
                            }
                            --n3;
                        }
                        n3 = n - 1;
                        while (n3 >= 0) {
                            GeometryAtom geometryAtom2 = geometryAtomArray[n3];
                            if (geometryAtom2.source.sourceNode != geometryAtom.source.sourceNode && geometryAtom2.source.collisionVwcBound.intersect(geometryAtom.source.collisionVwcBound) && (n2 == 11 || geometryAtom.source.geometryList != null && geometryAtom2.source.intersectGeometryList(geometryAtom.source))) {
                                return bHNode;
                            }
                            --n3;
                        }
                    }
                } else if (bHLeafInterface instanceof GroupRetained && ((BHLeafNode)bHNode).isEnable() && ((GroupRetained)bHLeafInterface).sourceNode.collidable) {
                    int n4 = n - 1;
                    while (n4 >= 0) {
                        GeometryAtom geometryAtom = geometryAtomArray[n4];
                        if (geometryAtom.source.collisionVwcBound.intersect(bHNode.bHull) && (n2 == 11 || geometryAtom.source.intersectGeometryList(geometryAtom.source.getCurrentLocalToVworld(0), bHNode.bHull))) {
                            return bHNode;
                        }
                        --n4;
                    }
                }
                return null;
            }
            case 1: {
                int n5 = n - 1;
                while (n5 >= 0) {
                    GeometryAtom geometryAtom = geometryAtomArray[n5];
                    if (geometryAtom.source.collisionVwcBound.intersect(bHNode.bHull)) {
                        BHNode bHNode2 = this.doSelectAny(geometryAtomArray, n, ((BHInternalNode)bHNode).getRightChild(), n2);
                        if (bHNode2 != null) {
                            return bHNode2;
                        }
                        return this.doSelectAny(geometryAtomArray, n, ((BHInternalNode)bHNode).getLeftChild(), n2);
                    }
                    --n5;
                }
                return null;
            }
        }
        return null;
    }

    private BHNode doSelectAny(GeometryAtom geometryAtom, BHNode bHNode, int n) {
        if (bHNode == null || bHNode.bHull.isEmpty()) {
            return null;
        }
        switch (bHNode.nodeType) {
            case 2: {
                BHLeafInterface bHLeafInterface = ((BHLeafNode)bHNode).leafIF;
                if (bHLeafInterface instanceof GeometryAtom) {
                    GeometryAtom geometryAtom2 = (GeometryAtom)bHLeafInterface;
                    if (geometryAtom.source.sourceNode != geometryAtom2.source.sourceNode && ((BHLeafNode)bHNode).isEnable() && geometryAtom2.source.isCollidable && geometryAtom.source.collisionVwcBound.intersect(geometryAtom2.source.collisionVwcBound) && (n == 11 || geometryAtom2.source.geometryList != null && geometryAtom.source.intersectGeometryList(geometryAtom2.source))) {
                        return bHNode;
                    }
                } else if (bHLeafInterface instanceof GroupRetained && ((BHLeafNode)bHNode).isEnable() && ((GroupRetained)bHLeafInterface).sourceNode.collidable && geometryAtom.source.collisionVwcBound.intersect(bHNode.bHull) && (n == 11 || geometryAtom.source.intersectGeometryList(geometryAtom.source.getCurrentLocalToVworld(0), bHNode.bHull))) {
                    return bHNode;
                }
                return null;
            }
            case 1: {
                if (geometryAtom.source.collisionVwcBound.intersect(bHNode.bHull)) {
                    BHNode bHNode2 = this.doSelectAny(geometryAtom, ((BHInternalNode)bHNode).getRightChild(), n);
                    if (bHNode2 != null) {
                        return bHNode2;
                    }
                    return this.doSelectAny(geometryAtom, ((BHInternalNode)bHNode).getLeftChild(), n);
                }
                return null;
            }
        }
        return null;
    }

    BHLeafInterface selectAny(Bounds bounds, int n, NodeRetained nodeRetained) {
        if (bounds == null) {
            return null;
        }
        BHNode bHNode = this.doSelectAny(bounds, this.root, n, nodeRetained);
        if (bHNode == null) {
            return null;
        }
        return ((BHLeafNode)bHNode).leafIF;
    }

    private BHNode doSelectAny(Bounds bounds, BHNode bHNode, int n, NodeRetained nodeRetained) {
        if (bHNode == null || bHNode.bHull.isEmpty()) {
            return null;
        }
        switch (bHNode.nodeType) {
            case 2: {
                BHLeafInterface bHLeafInterface = ((BHLeafNode)bHNode).leafIF;
                if (bHLeafInterface instanceof GeometryAtom) {
                    GeometryAtom geometryAtom = (GeometryAtom)bHLeafInterface;
                    if (((BHLeafNode)bHNode).isEnable() && geometryAtom.source.isCollidable && bounds.intersect(geometryAtom.source.collisionVwcBound) && (n == 11 || geometryAtom.source.geometryList != null && geometryAtom.source.intersectGeometryList(geometryAtom.source.getCurrentLocalToVworld(0), bounds))) {
                        return bHNode;
                    }
                } else if (bHLeafInterface instanceof GroupRetained && bHLeafInterface != nodeRetained && ((BHLeafNode)bHNode).isEnable() && ((GroupRetained)bHLeafInterface).sourceNode.collidable && bounds.intersect(bHNode.bHull)) {
                    return bHNode;
                }
                return null;
            }
            case 1: {
                if (bounds.intersect(bHNode.bHull)) {
                    BHNode bHNode2 = this.doSelectAny(bounds, ((BHInternalNode)bHNode).getRightChild(), n, nodeRetained);
                    if (bHNode2 != null) {
                        return bHNode2;
                    }
                    return this.doSelectAny(bounds, ((BHInternalNode)bHNode).getLeftChild(), n, nodeRetained);
                }
                return null;
            }
        }
        return null;
    }

    BHLeafInterface selectAny(Bounds bounds, int n, GroupRetained groupRetained) {
        if (bounds == null) {
            return null;
        }
        BHNode bHNode = this.doSelectAny(bounds, this.root, n, groupRetained);
        if (bHNode == null) {
            return null;
        }
        return ((BHLeafNode)bHNode).leafIF;
    }

    private BHNode doSelectAny(Bounds bounds, BHNode bHNode, int n, GroupRetained groupRetained) {
        if (bHNode == null || bHNode.bHull.isEmpty()) {
            return null;
        }
        switch (bHNode.nodeType) {
            case 2: {
                BHLeafInterface bHLeafInterface = ((BHLeafNode)bHNode).leafIF;
                if (bHLeafInterface instanceof GeometryAtom) {
                    GeometryAtom geometryAtom = (GeometryAtom)bHLeafInterface;
                    if (((BHLeafNode)bHNode).isEnable() && geometryAtom.source.isCollidable && bounds.intersect(geometryAtom.source.collisionVwcBound) && !this.isDescendent(geometryAtom.source.sourceNode, groupRetained, geometryAtom.source.key) && (n == 11 || geometryAtom.source.geometryList != null && geometryAtom.source.intersectGeometryList(geometryAtom.source.getCurrentLocalToVworld(0), bounds))) {
                        return bHNode;
                    }
                } else if (bHLeafInterface instanceof GroupRetained) {
                    GroupRetained groupRetained2 = (GroupRetained)bHLeafInterface;
                    if (((BHLeafNode)bHNode).isEnable() && groupRetained2.sourceNode.collidable && bounds.intersect(bHNode.bHull) && !this.isDescendent(groupRetained2.sourceNode, groupRetained, groupRetained2.key)) {
                        return bHNode;
                    }
                }
                return null;
            }
            case 1: {
                if (bounds.intersect(bHNode.bHull)) {
                    BHNode bHNode2 = this.doSelectAny(bounds, ((BHInternalNode)bHNode).getRightChild(), n, groupRetained);
                    if (bHNode2 != null) {
                        return bHNode2;
                    }
                    return this.doSelectAny(bounds, ((BHInternalNode)bHNode).getLeftChild(), n, groupRetained);
                }
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDescendent(NodeRetained nodeRetained, GroupRetained groupRetained, HashKey hashKey) {
        Object object = groupRetained.universe.sceneGraphLock;
        synchronized (object) {
            if (nodeRetained.inSharedGroup && hashKey != null) {
                hashKey = new HashKey(hashKey);
            }
            do {
                if (nodeRetained == groupRetained) {
                    return true;
                }
                if (!(nodeRetained instanceof SharedGroupRetained)) continue;
                String string2 = hashKey.getLastNodeId();
                NodeRetained nodeRetained2 = nodeRetained;
                Vector vector = ((SharedGroupRetained)nodeRetained).parents;
                int n = vector.size() - 1;
                while (n >= 0) {
                    NodeRetained nodeRetained3 = (NodeRetained)vector.elementAt(n);
                    if (nodeRetained3.nodeId.equals(string2)) {
                        nodeRetained = nodeRetained3;
                        break;
                    }
                    --n;
                }
                if (nodeRetained2 != nodeRetained) continue;
                return true;
            } while ((nodeRetained = nodeRetained.parent) != null);
            return false;
        }
    }

    void select(PickShape pickShape, UnorderList unorderList) {
        if (pickShape == null || this.root == null) {
            return;
        }
        this.doSelect(pickShape, unorderList, this.root, this.tPoint4d);
    }

    private void doSelect(PickShape pickShape, UnorderList unorderList, BHNode bHNode, Point4d point4d) {
        if (bHNode == null || bHNode.bHull.isEmpty()) {
            return;
        }
        switch (bHNode.nodeType) {
            case 2: {
                if (!((BHLeafNode)bHNode).isEnable() || !(((BHLeafNode)bHNode).leafIF instanceof GeometryAtom) || !((GeometryAtom)((BHLeafNode)bHNode).leafIF).source.isPickable || !pickShape.intersect(bHNode.bHull, point4d)) break;
                unorderList.add(bHNode);
                break;
            }
            case 1: {
                if (!pickShape.intersect(bHNode.bHull, point4d)) break;
                this.doSelect(pickShape, unorderList, ((BHInternalNode)bHNode).getRightChild(), point4d);
                this.doSelect(pickShape, unorderList, ((BHInternalNode)bHNode).getLeftChild(), point4d);
            }
        }
    }

    BHNode selectAny(PickShape pickShape) {
        if (pickShape == null || this.root == null) {
            return null;
        }
        return this.doSelectAny(pickShape, this.root, this.tPoint4d);
    }

    private BHNode doSelectAny(PickShape pickShape, BHNode bHNode, Point4d point4d) {
        BHNode bHNode2 = null;
        if (bHNode == null || bHNode.bHull.isEmpty()) {
            return null;
        }
        switch (bHNode.nodeType) {
            case 2: {
                if (!((BHLeafNode)bHNode).isEnable() || !(((BHLeafNode)bHNode).leafIF instanceof GeometryAtom) || !((GeometryAtom)((BHLeafNode)bHNode).leafIF).source.isPickable || !pickShape.intersect(bHNode.bHull, point4d)) break;
                return bHNode;
            }
            case 1: {
                if (!pickShape.intersect(bHNode.bHull, point4d)) break;
                bHNode2 = this.doSelectAny(pickShape, ((BHInternalNode)bHNode).getRightChild(), point4d);
                if (bHNode2 != null) {
                    return bHNode2;
                }
                return this.doSelectAny(pickShape, ((BHInternalNode)bHNode).getLeftChild(), point4d);
            }
        }
        return null;
    }

    private void create(BHNode[] bHNodeArray) {
        if (bHNodeArray == null) {
            this.root = null;
            return;
        }
        if (bHNodeArray.length == 1) {
            bHNodeArray[0].computeBoundingHull();
            this.root = bHNodeArray[0];
            return;
        }
        int[] nArray = new int[bHNodeArray.length];
        float[][] fArray = this.computeCenterValues(bHNodeArray, nArray);
        this.root = VirtualUniverse.mc.getBHNode(1);
        this.constructTree((BHInternalNode)this.root, bHNodeArray, fArray, nArray);
    }

    void insert(BHNode[] bHNodeArray, int n) {
        if (bHNodeArray == null || n < 1 || bHNodeArray.length < 1) {
            return;
        }
        if (this.root == null) {
            BHNode[] bHNodeArray2 = new BHNode[n];
            System.arraycopy(bHNodeArray, 0, bHNodeArray2, 0, n);
            this.create(bHNodeArray2);
            return;
        }
        if (this.root.nodeType == 2) {
            BHNode[] bHNodeArray3 = bHNodeArray;
            bHNodeArray = new BHNode[n + 1];
            System.arraycopy(bHNodeArray3, 0, bHNodeArray, 0, n);
            bHNodeArray[n] = this.root;
            this.create(bHNodeArray);
            return;
        }
        if (this.insertStructure == null) {
            this.insertStructure = new BHInsertStructure(n);
        } else {
            this.insertStructure.clear();
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.root.isInside(bHNodeArray[n2].bHull)) {
                ((BHInternalNode)this.root).insert(bHNodeArray[n2], this.insertStructure);
            } else {
                this.root.bHull.combine(bHNodeArray[n2].bHull);
                this.insertStructure.lookupAndInsert(this.root, bHNodeArray[n2]);
            }
            ++n2;
        }
        this.insertStructure.updateBoundingTree(this);
        this.estMaxDepth += (int)(Math.log(n) / LOG_OF_2) + 1;
        if (this.estMaxDepth > this.depthUpperBound) {
            int n3 = this.root.computeMaxDepth(0);
            int n4 = this.root.countNumberOfLeaves();
            double d = Math.log(n4) / LOG_OF_2;
            if (n3 > this.depthUpperBound) {
                this.reConstructTree(n4);
                n3 = this.root.computeMaxDepth(0);
            }
            if (n3 > this.depthUpperBound) {
                this.depthUpperBound += 5;
            } else if (this.depthUpperBound != 56 && (double)n3 * 1.5 < (double)this.depthUpperBound) {
                this.depthUpperBound -= 5;
                if (this.depthUpperBound < 56) {
                    this.depthUpperBound = 56;
                }
            }
            this.estMaxDepth = n3;
        }
    }

    private void markParentChain(BHNode[] bHNodeArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            BHNode bHNode = bHNodeArray[n2];
            bHNode.mark = true;
            while (bHNode.parent != null && !bHNode.parent.mark) {
                bHNode = bHNode.parent;
                bHNode.mark = true;
            }
            ++n2;
        }
    }

    private void markParentChain(BHNode bHNode) {
        bHNode.mark = true;
        while (bHNode.parent != null && !bHNode.parent.mark) {
            bHNode = bHNode.parent;
            bHNode.mark = true;
        }
    }

    void delete(BHNode[] bHNodeArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            if (bHNodeArray[n2] != null && bHNodeArray[n2].nodeType == 2) {
                this.markParentChain(bHNodeArray[n2]);
            }
            ++n2;
        }
        this.root = this.root.deleteAndUpdateMarkedNodes();
    }

    float[][] computeCenterValues(BHNode[] bHNodeArray, int[] nArray) {
        float[][] fArray = new float[bHNodeArray.length][3];
        int n = 0;
        while (n < bHNodeArray.length) {
            nArray[n] = n;
            bHNodeArray[n].computeBoundingHull();
            fArray[n][0] = (float)(bHNodeArray[n].bHull.upper.x + bHNodeArray[n].bHull.lower.x) / 2.0f;
            fArray[n][1] = (float)(bHNodeArray[n].bHull.upper.y + bHNodeArray[n].bHull.lower.y) / 2.0f;
            fArray[n][2] = (float)(bHNodeArray[n].bHull.upper.z + bHNodeArray[n].bHull.lower.z) / 2.0f;
            ++n;
        }
        return fArray;
    }

    void computeMeansAndSumSquares(float[][] fArray, int[] nArray, float[] fArray2, float[] fArray3) {
        float[] fArray4 = new float[3];
        float f = 0.0f;
        int n = nArray.length;
        int n2 = 2;
        while (n2 >= 0) {
            fArray4[n2] = 0.0f;
            fArray3[n2] = 0.0f;
            --n2;
        }
        n2 = n - 1;
        while (n2 >= 0) {
            fArray4[0] = fArray4[0] + fArray[nArray[n2]][0];
            fArray4[1] = fArray4[1] + fArray[nArray[n2]][1];
            fArray4[2] = fArray4[2] + fArray[nArray[n2]][2];
            --n2;
        }
        fArray2[0] = fArray4[0] / (float)n;
        fArray2[1] = fArray4[1] / (float)n;
        fArray2[2] = fArray4[2] / (float)n;
        n2 = n - 1;
        while (n2 >= 0) {
            f = fArray[nArray[n2]][0] - fArray2[0];
            fArray3[0] = fArray3[0] + f * f;
            f = fArray[nArray[n2]][1] - fArray2[1];
            fArray3[1] = fArray3[1] + f * f;
            f = fArray[nArray[n2]][2] - fArray2[2];
            fArray3[2] = fArray3[2] + f * f;
            --n2;
        }
    }

    int findSplitAxis(float[] fArray) {
        int n = -1;
        float f = 0.0f;
        int n2 = 0;
        while (n2 < 3) {
            if (fArray[n2] > f) {
                f = fArray[n2];
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    void constructTree(BHInternalNode bHInternalNode, BHNode[] bHNodeArray, float[][] fArray, int[] nArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        this.computeMeansAndSumSquares(fArray, nArray, fArray2, fArray3);
        int n4 = this.findSplitAxis(fArray3);
        boolean[] blArray = new boolean[bHNodeArray.length];
        if (n4 == -1) {
            n = 0;
            while (n < bHNodeArray.length) {
                if (n3 > n2) {
                    ++n2;
                    blArray[n] = false;
                } else {
                    ++n3;
                    blArray[n] = true;
                }
                ++n;
            }
        } else {
            n = 0;
            while (n < bHNodeArray.length) {
                if (fArray[nArray[n]][n4] < fArray2[n4]) {
                    ++n3;
                    blArray[n] = true;
                } else if (fArray[nArray[n]][n4] > fArray2[n4]) {
                    ++n2;
                    blArray[n] = false;
                } else if (n3 > n2) {
                    ++n2;
                    blArray[n] = false;
                } else {
                    ++n3;
                    blArray[n] = true;
                }
                ++n;
            }
        }
        if (n3 == bHNodeArray.length) {
            n2 = 0;
            n3 = 0;
            n = 0;
            while (n < bHNodeArray.length) {
                if (n3 > n2) {
                    ++n2;
                    blArray[n] = false;
                } else {
                    ++n3;
                    blArray[n] = true;
                }
                ++n;
            }
        } else if (n2 == bHNodeArray.length) {
            n2 = 0;
            n3 = 0;
            n = 0;
            while (n < bHNodeArray.length) {
                if (n3 > n2) {
                    ++n2;
                    blArray[n] = false;
                } else {
                    ++n3;
                    blArray[n] = true;
                }
                ++n;
            }
        }
        BHNode[] bHNodeArray2 = new BHNode[n2];
        BHNode[] bHNodeArray3 = new BHNode[n3];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n3];
        n2 = 0;
        n3 = 0;
        n = 0;
        while (n < bHNodeArray.length) {
            if (blArray[n]) {
                bHNodeArray3[n3] = bHNodeArray[n];
                nArray3[n3] = nArray[n];
                ++n3;
            } else {
                bHNodeArray2[n2] = bHNodeArray[n];
                nArray2[n2] = nArray[n];
                ++n2;
            }
            ++n;
        }
        if (bHNodeArray2.length != 1) {
            bHInternalNode.rChild = VirtualUniverse.mc.getBHNode(1);
            bHInternalNode.rChild.setParent(bHInternalNode);
            this.constructTree((BHInternalNode)bHInternalNode.rChild, bHNodeArray2, fArray, nArray2);
        } else {
            bHInternalNode.rChild = bHNodeArray2[0];
            bHInternalNode.rChild.setParent(bHInternalNode);
        }
        if (bHNodeArray3.length != 1) {
            bHInternalNode.lChild = VirtualUniverse.mc.getBHNode(1);
            bHInternalNode.lChild.setParent(bHInternalNode);
            this.constructTree((BHInternalNode)bHInternalNode.lChild, bHNodeArray3, fArray, nArray3);
        } else {
            bHInternalNode.lChild = bHNodeArray3[0];
            bHInternalNode.lChild.setParent(bHInternalNode);
        }
        bHInternalNode.combineBHull(bHInternalNode.rChild, bHInternalNode.lChild);
    }

    void reConstructTree(int n) {
        if (this.root == null) {
            return;
        }
        BHNode[] bHNodeArray = new BHNode[n];
        int[] nArray = new int[]{0};
        this.root.destroyTree(bHNodeArray, nArray);
        this.create(bHNodeArray);
    }

    void gatherTreeStatistics() {
        int n = this.root.countNumberOfLeaves();
        int n2 = this.root.countNumberOfInternals();
        int n3 = this.root.computeMaxDepth(0);
        float f = this.root.computeAverageLeafDepth(n, 0);
        System.out.println("Statistics for tree = " + this);
        System.out.println("Total Number of nodes in tree = " + (n + n2));
        System.out.println("Number of Leaf Nodes = " + n);
        System.out.println("Number of Internal Nodes = " + n2);
        System.out.println("Maximum Leaf depth = " + n3);
        System.out.println("Average Leaf depth = " + f);
        System.out.println("root.bHull = " + this.root.bHull);
    }

    void printTree(BHNode bHNode) {
        if (bHNode != null) {
            if (bHNode.nodeType == 1) {
                System.out.println("BH_TYPE_INTERNAL - bHull : " + bHNode);
                System.out.println(bHNode.bHull);
                System.out.println("rChild : " + ((BHInternalNode)bHNode).rChild + " lChild : " + ((BHInternalNode)bHNode).lChild);
                this.printTree(((BHInternalNode)bHNode).rChild);
                this.printTree(((BHInternalNode)bHNode).lChild);
            } else if (bHNode.nodeType == 2) {
                System.out.println("BH_TYPE_LEAF - bHull : " + bHNode);
                System.out.println(bHNode.bHull);
            }
        }
    }
}

