/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.AWTEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.media.j3d.Behavior;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.IndexedUnorderSet;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Sensor;
import javax.media.j3d.Transform3D;
import javax.media.j3d.UnorderList;
import javax.media.j3d.UpdateTargets;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupIndexedList;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnActivation;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOnDeactivation;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.media.j3d.WakeupOnSensorEntry;
import javax.media.j3d.WakeupOnSensorExit;
import javax.media.j3d.WakeupOnViewPlatformEntry;
import javax.media.j3d.WakeupOnViewPlatformExit;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

class BehaviorStructure
extends J3dStructure {
    IndexedUnorderSet behaviors;
    IndexedUnorderSet viewPlatforms;
    IndexedUnorderSet scheduleList;
    UnorderList[] processList = new UnorderList[10];
    Point3d vpCenter = new Point3d();
    Point3d vpTransCenter = new Point3d();
    WakeupIndexedList boundsEntryList;
    WakeupIndexedList boundsExitList;
    WakeupIndexedList currentSensorEntryList;
    WakeupIndexedList currentSensorExitList;
    WakeupIndexedList wakeupOnAWTEvent;
    WakeupIndexedList wakeupOnActivation;
    WakeupIndexedList wakeupOnDeactivation;
    WakeupIndexedList wakeupOnBehaviorPost;
    WakeupIndexedList wakeupOnElapsedFrames;
    WakeupIndexedList wakeupOnViewPlatformEntry;
    WakeupIndexedList wakeupOnViewPlatformExit;
    WakeupIndexedList wakeupOnSensorEntry;
    WakeupIndexedList wakeupOnSensorExit;
    UnorderList transformViewPlatformList = new UnorderList(class$javax$media$j3d$ViewPlatformRetained == null ? (class$javax$media$j3d$ViewPlatformRetained = BehaviorStructure.class$("javax.media.j3d.ViewPlatformRetained")) : class$javax$media$j3d$ViewPlatformRetained);
    int activeWakeupOnFrameCount = 0;
    int activeWakeupOnSensorCount = 0;
    UnorderList awtEventsBuffer = new UnorderList(class$java$awt$AWTEvent == null ? (class$java$awt$AWTEvent = BehaviorStructure.class$("java.awt.AWTEvent")) : class$java$awt$AWTEvent);
    int[] postIDBuffer = new int[10];
    int[] clonePostIDBuffer = new int[this.postIDBuffer.length];
    UnorderList behaviorPostBuffer = new UnorderList(class$javax$media$j3d$Behavior == null ? (class$javax$media$j3d$Behavior = BehaviorStructure.class$("javax.media.j3d.Behavior")) : class$javax$media$j3d$Behavior);
    Transform3D sensorTransform = new Transform3D();
    Vector3d sensorLoc = new Vector3d();
    Point3d ptSensorLoc = new Point3d();
    UnorderList physicalEnvironments = new UnorderList(1, class$javax$media$j3d$PhysicalEnvironment == null ? (class$javax$media$j3d$PhysicalEnvironment = BehaviorStructure.class$("javax.media.j3d.PhysicalEnvironment")) : class$javax$media$j3d$PhysicalEnvironment);
    UnorderList pendingBehaviors = new UnorderList(class$javax$media$j3d$BehaviorRetained == null ? (class$javax$media$j3d$BehaviorRetained = BehaviorStructure.class$("javax.media.j3d.BehaviorRetained")) : class$javax$media$j3d$BehaviorRetained);
    boolean branchDetach = false;
    long awtEventTimestamp = 1L;
    boolean transformMsg = false;
    UpdateTargets targets = null;
    static /* synthetic */ Class class$javax$media$j3d$ViewPlatformRetained;
    static /* synthetic */ Class class$java$awt$AWTEvent;
    static /* synthetic */ Class class$javax$media$j3d$Behavior;
    static /* synthetic */ Class class$javax$media$j3d$PhysicalEnvironment;
    static /* synthetic */ Class class$javax$media$j3d$BehaviorRetained;
    static /* synthetic */ Class class$javax$media$j3d$WakeupOnViewPlatformEntry;
    static /* synthetic */ Class class$javax$media$j3d$WakeupOnViewPlatformExit;
    static /* synthetic */ Class class$javax$media$j3d$WakeupOnSensorEntry;
    static /* synthetic */ Class class$javax$media$j3d$WakeupOnSensorExit;
    static /* synthetic */ Class class$javax$media$j3d$WakeupOnAWTEvent;
    static /* synthetic */ Class class$javax$media$j3d$WakeupOnActivation;
    static /* synthetic */ Class class$javax$media$j3d$WakeupOnDeactivation;
    static /* synthetic */ Class class$javax$media$j3d$WakeupOnBehaviorPost;
    static /* synthetic */ Class class$javax$media$j3d$WakeupOnElapsedFrames;

    BehaviorStructure(VirtualUniverse virtualUniverse) {
        super(virtualUniverse, 256);
        int n = 9;
        while (n >= 0) {
            this.processList[n] = new UnorderList(class$javax$media$j3d$BehaviorRetained == null ? BehaviorStructure.class$("javax.media.j3d.BehaviorRetained") : class$javax$media$j3d$BehaviorRetained);
            --n;
        }
        this.behaviors = new IndexedUnorderSet(class$javax$media$j3d$BehaviorRetained == null ? (class$javax$media$j3d$BehaviorRetained = BehaviorStructure.class$("javax.media.j3d.BehaviorRetained")) : class$javax$media$j3d$BehaviorRetained, 0, virtualUniverse);
        this.viewPlatforms = new IndexedUnorderSet(class$javax$media$j3d$ViewPlatformRetained == null ? (class$javax$media$j3d$ViewPlatformRetained = BehaviorStructure.class$("javax.media.j3d.ViewPlatformRetained")) : class$javax$media$j3d$ViewPlatformRetained, 0, virtualUniverse);
        this.scheduleList = new IndexedUnorderSet(class$javax$media$j3d$BehaviorRetained == null ? (class$javax$media$j3d$BehaviorRetained = BehaviorStructure.class$("javax.media.j3d.BehaviorRetained")) : class$javax$media$j3d$BehaviorRetained, 1, virtualUniverse);
        this.boundsEntryList = new WakeupIndexedList(class$javax$media$j3d$WakeupOnViewPlatformEntry == null ? (class$javax$media$j3d$WakeupOnViewPlatformEntry = BehaviorStructure.class$("javax.media.j3d.WakeupOnViewPlatformEntry")) : class$javax$media$j3d$WakeupOnViewPlatformEntry, 1, virtualUniverse);
        this.boundsExitList = new WakeupIndexedList(class$javax$media$j3d$WakeupOnViewPlatformExit == null ? (class$javax$media$j3d$WakeupOnViewPlatformExit = BehaviorStructure.class$("javax.media.j3d.WakeupOnViewPlatformExit")) : class$javax$media$j3d$WakeupOnViewPlatformExit, 1, virtualUniverse);
        this.currentSensorEntryList = new WakeupIndexedList(class$javax$media$j3d$WakeupOnSensorEntry == null ? (class$javax$media$j3d$WakeupOnSensorEntry = BehaviorStructure.class$("javax.media.j3d.WakeupOnSensorEntry")) : class$javax$media$j3d$WakeupOnSensorEntry, 1, virtualUniverse);
        this.currentSensorExitList = new WakeupIndexedList(class$javax$media$j3d$WakeupOnSensorExit == null ? (class$javax$media$j3d$WakeupOnSensorExit = BehaviorStructure.class$("javax.media.j3d.WakeupOnSensorExit")) : class$javax$media$j3d$WakeupOnSensorExit, 1, virtualUniverse);
        this.wakeupOnAWTEvent = new WakeupIndexedList(class$javax$media$j3d$WakeupOnAWTEvent == null ? (class$javax$media$j3d$WakeupOnAWTEvent = BehaviorStructure.class$("javax.media.j3d.WakeupOnAWTEvent")) : class$javax$media$j3d$WakeupOnAWTEvent, 0, virtualUniverse);
        this.wakeupOnActivation = new WakeupIndexedList(class$javax$media$j3d$WakeupOnActivation == null ? (class$javax$media$j3d$WakeupOnActivation = BehaviorStructure.class$("javax.media.j3d.WakeupOnActivation")) : class$javax$media$j3d$WakeupOnActivation, 0, virtualUniverse);
        this.wakeupOnDeactivation = new WakeupIndexedList(class$javax$media$j3d$WakeupOnDeactivation == null ? (class$javax$media$j3d$WakeupOnDeactivation = BehaviorStructure.class$("javax.media.j3d.WakeupOnDeactivation")) : class$javax$media$j3d$WakeupOnDeactivation, 0, virtualUniverse);
        this.wakeupOnBehaviorPost = new WakeupIndexedList(class$javax$media$j3d$WakeupOnBehaviorPost == null ? (class$javax$media$j3d$WakeupOnBehaviorPost = BehaviorStructure.class$("javax.media.j3d.WakeupOnBehaviorPost")) : class$javax$media$j3d$WakeupOnBehaviorPost, 0, virtualUniverse);
        this.wakeupOnElapsedFrames = new WakeupIndexedList(class$javax$media$j3d$WakeupOnElapsedFrames == null ? (class$javax$media$j3d$WakeupOnElapsedFrames = BehaviorStructure.class$("javax.media.j3d.WakeupOnElapsedFrames")) : class$javax$media$j3d$WakeupOnElapsedFrames, 0, virtualUniverse);
        this.wakeupOnViewPlatformEntry = new WakeupIndexedList(class$javax$media$j3d$WakeupOnViewPlatformEntry == null ? (class$javax$media$j3d$WakeupOnViewPlatformEntry = BehaviorStructure.class$("javax.media.j3d.WakeupOnViewPlatformEntry")) : class$javax$media$j3d$WakeupOnViewPlatformEntry, 0, virtualUniverse);
        this.wakeupOnViewPlatformExit = new WakeupIndexedList(class$javax$media$j3d$WakeupOnViewPlatformExit == null ? (class$javax$media$j3d$WakeupOnViewPlatformExit = BehaviorStructure.class$("javax.media.j3d.WakeupOnViewPlatformExit")) : class$javax$media$j3d$WakeupOnViewPlatformExit, 0, virtualUniverse);
        this.wakeupOnSensorEntry = new WakeupIndexedList(class$javax$media$j3d$WakeupOnSensorEntry == null ? (class$javax$media$j3d$WakeupOnSensorEntry = BehaviorStructure.class$("javax.media.j3d.WakeupOnSensorEntry")) : class$javax$media$j3d$WakeupOnSensorEntry, 0, virtualUniverse);
        this.wakeupOnSensorExit = new WakeupIndexedList(class$javax$media$j3d$WakeupOnSensorExit == null ? (class$javax$media$j3d$WakeupOnSensorExit = BehaviorStructure.class$("javax.media.j3d.WakeupOnSensorExit")) : class$javax$media$j3d$WakeupOnSensorExit, 0, virtualUniverse);
    }

    void processMessages(long l) {
        Object[] objectArray = this.getMessages(l);
        int n = this.getNumMessage();
        if (n > 0) {
            Object object;
            int n2 = 0;
            while (n2 < n) {
                J3dMessage j3dMessage = objectArray[n2];
                switch (j3dMessage.type) {
                    case 3: {
                        this.transformMsg = true;
                        break;
                    }
                    case 28: {
                        this.processConditionMet((BehaviorRetained)j3dMessage.args[0], (Boolean)j3dMessage.args[1]);
                        break;
                    }
                    case 0: {
                        this.insertNodes((Object[])j3dMessage.args[0]);
                        break;
                    }
                    case 1: {
                        this.removeNodes(j3dMessage);
                        break;
                    }
                    case 49: {
                        this.activateBehaviors();
                        break;
                    }
                    case 29: {
                        this.addToScheduleList((BehaviorRetained)j3dMessage.args[1]);
                        this.reEvaluateWakeupCount();
                        break;
                    }
                    case 30: {
                        this.removeFromScheduleList((BehaviorRetained)j3dMessage.args[1]);
                        this.reEvaluateWakeupCount();
                        break;
                    }
                    case 55: {
                        ((BehaviorRetained)j3dMessage.args[1]).schedulingInterval = (Integer)j3dMessage.args[2];
                        break;
                    }
                    case 27: {
                        this.processSwitchChanged(j3dMessage);
                        if (!this.universe.transformStructure.getLazyUpdate()) break;
                        this.transformMsg = true;
                        break;
                    }
                    case 23: {
                        this.processBoundingLeafChanged((Object[])j3dMessage.args[3], (Bounds)j3dMessage.args[2]);
                        break;
                    }
                    case 4: {
                        this.reEvaluatePhysicalEnvironments();
                        object = ((View)j3dMessage.args[0]).getViewPlatform();
                        if (object == null) break;
                        this.processViewPlatformTransform((ViewPlatformRetained)((ViewPlatform)object).retained);
                        break;
                    }
                    case 48: {
                        ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)j3dMessage.args[0];
                        viewPlatformRetained.updateActivationRadius(((Float)j3dMessage.args[1]).floatValue());
                        this.processViewPlatformTransform(viewPlatformRetained);
                        break;
                    }
                    case 35: {
                        BehaviorRetained behaviorRetained = (BehaviorRetained)j3dMessage.args[1];
                        behaviorRetained.updateTransformRegion();
                        this.processBehaviorTransform(behaviorRetained);
                        break;
                    }
                    case 60: {
                        BehaviorRetained behaviorRetained = (BehaviorRetained)j3dMessage.args[0];
                        behaviorRetained.active = false;
                        this.addToScheduleList(behaviorRetained);
                    }
                }
                j3dMessage.decRefcount();
                ++n2;
            }
            if (this.transformMsg) {
                this.targets = this.universe.transformStructure.getTargetList();
                object = this.targets.targetList[2];
                if (object != null) {
                    this.processBehXformChanged((UnorderList)object);
                }
                if ((object = this.targets.targetList[4]) != null) {
                    this.processVpfXformChanged((UnorderList)object);
                }
                this.transformMsg = false;
                this.targets = null;
            }
            Arrays.fill(objectArray, 0, n, null);
        }
        if (this.activeWakeupOnSensorCount <= 0) {
            if (this.activeWakeupOnFrameCount > 0) {
                VirtualUniverse.mc.sendRunMessage(this.universe, 17);
            } else {
                VirtualUniverse.mc.sendRunMessage(this.universe, 1);
            }
        } else {
            this.checkSensorEntryExit();
            if (this.activeWakeupOnFrameCount > 0) {
                VirtualUniverse.mc.sendRunMessage(this.universe, 273);
            } else {
                VirtualUniverse.mc.sendRunMessage(this.universe, 257);
            }
        }
    }

    void insertNodes(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof BehaviorRetained) {
                this.pendingBehaviors.add(object);
            } else if (object instanceof ViewPlatformRetained) {
                this.addViewPlatform((ViewPlatformRetained)object);
            }
            ++n;
        }
    }

    void activateBehaviors() {
        BehaviorRetained[] behaviorRetainedArray = (BehaviorRetained[])this.pendingBehaviors.toArray(false);
        int n = this.pendingBehaviors.arraySize() - 1;
        while (n >= 0) {
            BehaviorRetained behaviorRetained = behaviorRetainedArray[n];
            behaviorRetained.wakeupCondition = behaviorRetained.newWakeupCondition;
            if (behaviorRetained.wakeupCondition != null) {
                behaviorRetained.wakeupCondition.buildTree(null, 0, behaviorRetained);
                behaviorRetained.conditionSet = true;
                this.behaviors.add(behaviorRetained);
                behaviorRetained.updateTransformRegion();
                this.addToScheduleList(behaviorRetained);
            }
            --n;
        }
        this.pendingBehaviors.clear();
    }

    void addViewPlatform(ViewPlatformRetained viewPlatformRetained) {
        BehaviorRetained[] behaviorRetainedArray = (BehaviorRetained[])this.behaviors.toArray(false);
        this.viewPlatforms.add(viewPlatformRetained);
        viewPlatformRetained.updateTransformRegion();
        if (!viewPlatformRetained.isActiveViewPlatform()) {
            return;
        }
        int n = this.behaviors.arraySize() - 1;
        while (n >= 0) {
            this.addToScheduleList(behaviorRetainedArray[n]);
            --n;
        }
        WakeupOnViewPlatformEntry[] wakeupOnViewPlatformEntryArray = (WakeupOnViewPlatformEntry[])this.wakeupOnViewPlatformEntry.toArray(false);
        n = this.wakeupOnViewPlatformEntry.arraySize() - 1;
        while (n >= 0) {
            WakeupOnViewPlatformEntry wakeupOnViewPlatformEntry = wakeupOnViewPlatformEntryArray[n];
            if (!this.boundsEntryList.contains(wakeupOnViewPlatformEntry) && wakeupOnViewPlatformEntry.transformedRegion.intersect(viewPlatformRetained.center)) {
                this.boundsEntryList.add(wakeupOnViewPlatformEntry);
                wakeupOnViewPlatformEntry.triggeredVP = viewPlatformRetained;
                wakeupOnViewPlatformEntry.setTriggered();
            }
            --n;
        }
        WakeupOnViewPlatformExit[] wakeupOnViewPlatformExitArray = (WakeupOnViewPlatformExit[])this.wakeupOnViewPlatformExit.toArray(false);
        n = this.wakeupOnViewPlatformExit.arraySize() - 1;
        while (n >= 0) {
            WakeupOnViewPlatformExit wakeupOnViewPlatformExit = wakeupOnViewPlatformExitArray[n];
            if (!this.boundsExitList.contains(wakeupOnViewPlatformExit) && wakeupOnViewPlatformExit.transformedRegion.intersect(viewPlatformRetained.center)) {
                wakeupOnViewPlatformExit.triggeredVP = viewPlatformRetained;
                this.boundsExitList.add(wakeupOnViewPlatformExit);
            }
            --n;
        }
    }

    void removeNodes(J3dMessage j3dMessage) {
        WakeupOnAWTEvent[] wakeupOnAWTEventArray;
        Object[] objectArray = (Object[])j3dMessage.args[0];
        boolean bl = false;
        int n = 0;
        while (n < objectArray.length) {
            wakeupOnAWTEventArray = objectArray[n];
            if (wakeupOnAWTEventArray instanceof BehaviorRetained) {
                bl = true;
                this.removeBehavior((BehaviorRetained)wakeupOnAWTEventArray);
            } else if (wakeupOnAWTEventArray instanceof ViewPlatformRetained) {
                this.removeViewPlatform((ViewPlatformRetained)wakeupOnAWTEventArray);
            }
            ++n;
        }
        this.wakeupOnAWTEvent.clearMirror();
        this.awtEventsBuffer.clearMirror();
        this.wakeupOnBehaviorPost.clearMirror();
        this.behaviorPostBuffer.clearMirror();
        this.wakeupOnSensorEntry.clearMirror();
        this.wakeupOnSensorExit.clearMirror();
        this.branchDetach = true;
        if (bl) {
            wakeupOnAWTEventArray = (WakeupOnAWTEvent[])this.wakeupOnAWTEvent.toArray();
            int n2 = this.wakeupOnAWTEvent.arraySize();
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            int n3 = 0;
            while (n3 < n2) {
                WakeupOnAWTEvent wakeupOnAWTEvent = wakeupOnAWTEventArray[n3];
                int n4 = wakeupOnAWTEvent.AwtId;
                long l = wakeupOnAWTEvent.EventMask;
                if (n4 >= 1004 && n4 <= 1005 || (l & 4L) != 0L) {
                    bl2 = true;
                }
                if (n4 >= 400 && n4 <= 402 || (l & 8L) != 0L) {
                    bl3 = true;
                }
                if (n4 >= 500 && n4 <= 507) {
                    if (n4 == 506 || n4 == 503) {
                        bl4 = true;
                    } else {
                        bl5 = true;
                    }
                } else {
                    if ((l & 0x10L) != 0L) {
                        bl5 = true;
                    }
                    if ((l & 0x20L) != 0L) {
                        bl4 = true;
                    }
                }
                ++n3;
            }
            if (!bl2 && this.universe.enableFocus) {
                bl6 = true;
                this.universe.disableFocusEvents();
            }
            if (!VirtualUniverse.mc.isD3D() && !bl3 && this.universe.enableKey) {
                bl6 = true;
                this.universe.disableKeyEvents();
            }
            if (!bl4 && this.universe.enableMouseMotion) {
                bl6 = true;
                this.universe.disableMouseMotionEvents();
            }
            if (!bl5 && this.universe.enableMouse) {
                bl6 = true;
                this.universe.disableMouseEvents();
            }
            if (bl6) {
                ++this.awtEventTimestamp;
            }
        }
    }

    void removeViewPlatform(ViewPlatformRetained viewPlatformRetained) {
        ViewPlatformRetained viewPlatformRetained2;
        this.viewPlatforms.remove(viewPlatformRetained);
        BehaviorRetained[] behaviorRetainedArray = (BehaviorRetained[])this.scheduleList.toArray(false);
        int n = this.scheduleList.arraySize() - 1;
        while (n >= 0) {
            BehaviorRetained behaviorRetained = behaviorRetainedArray[n];
            if (!this.intersectVPRegion(behaviorRetained.transformedRegion)) {
                this.removeFromScheduleList(behaviorRetained);
            }
            --n;
        }
        WakeupOnViewPlatformEntry[] wakeupOnViewPlatformEntryArray = (WakeupOnViewPlatformEntry[])this.boundsEntryList.toArray(false);
        n = this.boundsEntryList.arraySize() - 1;
        while (n >= 0) {
            WakeupOnViewPlatformEntry wakeupOnViewPlatformEntry = wakeupOnViewPlatformEntryArray[n];
            viewPlatformRetained2 = this.intersectVPCenter(wakeupOnViewPlatformEntry.transformedRegion);
            if (viewPlatformRetained2 == null) {
                this.boundsEntryList.remove(wakeupOnViewPlatformEntry);
            }
            --n;
        }
        WakeupOnViewPlatformExit[] wakeupOnViewPlatformExitArray = (WakeupOnViewPlatformExit[])this.boundsExitList.toArray(false);
        n = this.boundsExitList.arraySize() - 1;
        while (n >= 0) {
            WakeupOnViewPlatformExit wakeupOnViewPlatformExit = wakeupOnViewPlatformExitArray[n];
            viewPlatformRetained2 = this.intersectVPCenter(wakeupOnViewPlatformExit.transformedRegion);
            if (viewPlatformRetained2 == null) {
                this.boundsExitList.remove(wakeupOnViewPlatformExit);
                wakeupOnViewPlatformExit.setTriggered();
            }
            --n;
        }
    }

    void removeBehavior(BehaviorRetained behaviorRetained) {
        this.behaviors.remove(behaviorRetained);
        if (behaviorRetained.wakeupCondition != null && behaviorRetained.wakeupCondition.behav != null) {
            behaviorRetained.wakeupCondition.cleanTree(this);
            if (behaviorRetained.universe == this.universe) {
                behaviorRetained.conditionSet = false;
            }
        }
        WakeupOnViewPlatformEntry[] wakeupOnViewPlatformEntryArray = (WakeupOnViewPlatformEntry[])this.boundsEntryList.toArray(false);
        int n = this.boundsEntryList.arraySize() - 1;
        while (n >= 0) {
            WakeupOnViewPlatformEntry wakeupOnViewPlatformEntry = wakeupOnViewPlatformEntryArray[n];
            if (wakeupOnViewPlatformEntry.behav == behaviorRetained) {
                this.boundsEntryList.remove(wakeupOnViewPlatformEntry);
            }
            --n;
        }
        WakeupOnViewPlatformExit[] wakeupOnViewPlatformExitArray = (WakeupOnViewPlatformExit[])this.boundsExitList.toArray(false);
        int n2 = this.boundsExitList.arraySize() - 1;
        while (n2 >= 0) {
            WakeupOnViewPlatformExit wakeupOnViewPlatformExit = wakeupOnViewPlatformExitArray[n2];
            if (wakeupOnViewPlatformExit.behav == behaviorRetained) {
                this.boundsExitList.remove(wakeupOnViewPlatformExit);
            }
            --n2;
        }
        WakeupOnSensorEntry[] wakeupOnSensorEntryArray = (WakeupOnSensorEntry[])this.currentSensorEntryList.toArray(false);
        int n3 = this.currentSensorEntryList.arraySize() - 1;
        while (n3 >= 0) {
            WakeupOnSensorEntry wakeupOnSensorEntry = wakeupOnSensorEntryArray[n3];
            if (wakeupOnSensorEntry.behav == behaviorRetained) {
                this.currentSensorEntryList.remove(wakeupOnSensorEntry);
            }
            --n3;
        }
        WakeupOnSensorExit[] wakeupOnSensorExitArray = (WakeupOnSensorExit[])this.currentSensorExitList.toArray(false);
        int n4 = this.currentSensorExitList.arraySize() - 1;
        while (n4 >= 0) {
            WakeupOnSensorExit wakeupOnSensorExit = wakeupOnSensorExitArray[n4];
            if (wakeupOnSensorExit.behav == behaviorRetained) {
                this.currentSensorExitList.remove(wakeupOnSensorExit);
            }
            --n4;
        }
        this.removeFromScheduleList(behaviorRetained);
    }

    void handleAWTEvent(AWTEvent aWTEvent) {
        this.awtEventsBuffer.add(aWTEvent);
        VirtualUniverse.mc.sendRunMessage(this.universe, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleAWTEvent() {
        int n;
        AWTEvent[] aWTEventArray;
        WakeupOnAWTEvent[] wakeupOnAWTEventArray = (WakeupOnAWTEvent[])this.wakeupOnAWTEvent.toArray();
        int n2 = this.wakeupOnAWTEvent.arraySize();
        UnorderList unorderList = this.awtEventsBuffer;
        synchronized (unorderList) {
            aWTEventArray = (AWTEvent[])this.awtEventsBuffer.toArray();
            n = this.awtEventsBuffer.size();
            this.awtEventsBuffer.clear();
        }
        int n3 = 0;
        while (n3 < n2) {
            WakeupOnAWTEvent wakeupOnAWTEvent = wakeupOnAWTEventArray[n3];
            int n4 = 0;
            while (n4 < n) {
                AWTEvent aWTEvent = aWTEventArray[n4];
                int n5 = aWTEvent.getID();
                if (wakeupOnAWTEvent.AwtId != 0) {
                    if (wakeupOnAWTEvent.AwtId == n5) {
                        wakeupOnAWTEvent.addAWTEvent(aWTEvent);
                    }
                } else if (n5 >= 100 && n5 <= 103 && (wakeupOnAWTEvent.EventMask & 1L) != 0L) {
                    wakeupOnAWTEvent.addAWTEvent(aWTEvent);
                } else if (n5 >= 1004 && n5 <= 1005 && (wakeupOnAWTEvent.EventMask & 4L) != 0L) {
                    wakeupOnAWTEvent.addAWTEvent(aWTEvent);
                } else if (n5 >= 400 && n5 <= 402 && (wakeupOnAWTEvent.EventMask & 8L) != 0L) {
                    wakeupOnAWTEvent.addAWTEvent(aWTEvent);
                } else if ((n5 == 500 || n5 == 504 || n5 == 505 || n5 == 501 || n5 == 502) && (wakeupOnAWTEvent.EventMask & 0x10L) != 0L) {
                    wakeupOnAWTEvent.addAWTEvent(aWTEvent);
                } else if ((n5 == 506 || n5 == 503) && (wakeupOnAWTEvent.EventMask & 0x20L) != 0L) {
                    wakeupOnAWTEvent.addAWTEvent(aWTEvent);
                }
                ++n4;
            }
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleBehaviorPost(Behavior behavior, int n) {
        UnorderList unorderList = this.behaviorPostBuffer;
        synchronized (unorderList) {
            int n2 = this.behaviorPostBuffer.size();
            if (this.postIDBuffer.length == n2) {
                int[] nArray = this.postIDBuffer;
                this.postIDBuffer = new int[n2 << 1];
                System.arraycopy(nArray, 0, this.postIDBuffer, 0, n2);
            }
            this.postIDBuffer[n2] = n;
            this.behaviorPostBuffer.add(behavior);
        }
        VirtualUniverse.mc.sendRunMessage(this.universe, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleBehaviorPost() {
        int n;
        Behavior[] behaviorArray;
        WakeupOnBehaviorPost[] wakeupOnBehaviorPostArray = (WakeupOnBehaviorPost[])this.wakeupOnBehaviorPost.toArray();
        UnorderList unorderList = this.behaviorPostBuffer;
        synchronized (unorderList) {
            behaviorArray = (Behavior[])this.behaviorPostBuffer.toArray();
            n = this.behaviorPostBuffer.size();
            if (this.clonePostIDBuffer.length < n) {
                this.clonePostIDBuffer = new int[n];
            }
            System.arraycopy(this.postIDBuffer, 0, this.clonePostIDBuffer, 0, n);
            this.behaviorPostBuffer.clear();
        }
        int n2 = this.wakeupOnBehaviorPost.arraySize();
        int n3 = 0;
        while (n3 < n2) {
            WakeupOnBehaviorPost wakeupOnBehaviorPost = wakeupOnBehaviorPostArray[n3];
            int n4 = 0;
            while (n4 < n) {
                Behavior behavior = behaviorArray[n4];
                int n5 = this.clonePostIDBuffer[n4];
                if (!(wakeupOnBehaviorPost.post != n5 && wakeupOnBehaviorPost.post != 0 || behavior != wakeupOnBehaviorPost.armingBehavior && wakeupOnBehaviorPost.armingBehavior != null)) {
                    wakeupOnBehaviorPost.triggeringBehavior = behavior;
                    wakeupOnBehaviorPost.triggeringPost = n5;
                    wakeupOnBehaviorPost.setTriggered();
                }
                ++n4;
            }
            ++n3;
        }
    }

    void incElapsedFrames() {
        WakeupOnElapsedFrames[] wakeupOnElapsedFramesArray = (WakeupOnElapsedFrames[])this.wakeupOnElapsedFrames.toArray(true);
        int n = this.wakeupOnElapsedFrames.arraySize();
        int n2 = 0;
        while (n2 < n) {
            wakeupOnElapsedFramesArray[n2++].newFrame();
        }
        if (n > 0) {
            VirtualUniverse.mc.sendRunMessage(this.universe, 257);
        }
        if (this.branchDetach) {
            this.wakeupOnElapsedFrames.clearMirror();
            this.branchDetach = false;
        }
    }

    void removeVPEntryCondition(WakeupCondition wakeupCondition) {
        this.wakeupOnViewPlatformEntry.remove(wakeupCondition);
    }

    void addVPEntryCondition(WakeupOnViewPlatformEntry wakeupOnViewPlatformEntry) {
        boolean bl = true;
        WakeupOnViewPlatformEntry[] wakeupOnViewPlatformEntryArray = (WakeupOnViewPlatformEntry[])this.boundsEntryList.toArray(false);
        int n = this.boundsEntryList.arraySize() - 1;
        while (n >= 0) {
            WakeupOnViewPlatformEntry wakeupOnViewPlatformEntry2 = wakeupOnViewPlatformEntryArray[n];
            if (wakeupOnViewPlatformEntry2.behav == wakeupOnViewPlatformEntry.behav && wakeupOnViewPlatformEntry2.region.equals(wakeupOnViewPlatformEntry.region)) {
                this.boundsEntryList.remove(n);
                bl = false;
                break;
            }
            --n;
        }
        this.wakeupOnViewPlatformEntry.add(wakeupOnViewPlatformEntry);
        ViewPlatformRetained viewPlatformRetained = this.intersectVPCenter(wakeupOnViewPlatformEntry.transformedRegion);
        if (viewPlatformRetained != null) {
            this.boundsEntryList.add(wakeupOnViewPlatformEntry);
        }
        if (bl && viewPlatformRetained != null) {
            wakeupOnViewPlatformEntry.triggeredVP = viewPlatformRetained;
            wakeupOnViewPlatformEntry.setTriggered();
        }
    }

    void removeVPExitCondition(WakeupOnViewPlatformExit wakeupOnViewPlatformExit) {
        this.wakeupOnViewPlatformExit.remove(wakeupOnViewPlatformExit);
    }

    void addVPExitCondition(WakeupOnViewPlatformExit wakeupOnViewPlatformExit) {
        boolean bl = true;
        WakeupOnViewPlatformExit[] wakeupOnViewPlatformExitArray = (WakeupOnViewPlatformExit[])this.boundsExitList.toArray(false);
        int n = this.boundsExitList.arraySize() - 1;
        while (n >= 0) {
            WakeupOnViewPlatformExit wakeupOnViewPlatformExit2 = wakeupOnViewPlatformExitArray[n];
            if (wakeupOnViewPlatformExit2.behav == wakeupOnViewPlatformExit.behav && wakeupOnViewPlatformExit2.region.equals(wakeupOnViewPlatformExit.region)) {
                this.boundsExitList.remove(n);
                bl = false;
                break;
            }
            --n;
        }
        ViewPlatformRetained viewPlatformRetained = this.intersectVPCenter(wakeupOnViewPlatformExit.transformedRegion);
        this.wakeupOnViewPlatformExit.add(wakeupOnViewPlatformExit);
        if (viewPlatformRetained != null) {
            wakeupOnViewPlatformExit.triggeredVP = viewPlatformRetained;
            this.boundsExitList.add(wakeupOnViewPlatformExit);
        }
        if (!bl) {
            return;
        }
        WakeupOnViewPlatformEntry[] wakeupOnViewPlatformEntryArray = (WakeupOnViewPlatformEntry[])this.boundsEntryList.toArray(false);
        int n2 = this.boundsEntryList.arraySize() - 1;
        while (n2 >= 0) {
            WakeupOnViewPlatformEntry wakeupOnViewPlatformEntry = wakeupOnViewPlatformEntryArray[n2];
            if (wakeupOnViewPlatformEntry.behav == wakeupOnViewPlatformExit.behav && wakeupOnViewPlatformEntry.region.equals(wakeupOnViewPlatformExit.region)) {
                if (viewPlatformRetained != null) break;
                wakeupOnViewPlatformExit.setTriggered();
                break;
            }
            --n2;
        }
    }

    void removeSensorEntryCondition(WakeupOnSensorEntry wakeupOnSensorEntry) {
        this.wakeupOnSensorEntry.remove(wakeupOnSensorEntry);
    }

    void addSensorEntryCondition(WakeupOnSensorEntry wakeupOnSensorEntry) {
        boolean bl = true;
        WakeupOnSensorEntry[] wakeupOnSensorEntryArray = (WakeupOnSensorEntry[])this.currentSensorEntryList.toArray(false);
        int n = this.currentSensorEntryList.arraySize() - 1;
        while (n >= 0) {
            WakeupOnSensorEntry wakeupOnSensorEntry2 = wakeupOnSensorEntryArray[n];
            if (wakeupOnSensorEntry2.behav == wakeupOnSensorEntry.behav && wakeupOnSensorEntry2.region.equals(wakeupOnSensorEntry.region)) {
                this.currentSensorEntryList.remove(n);
                bl = false;
                break;
            }
            --n;
        }
        this.wakeupOnSensorEntry.add(wakeupOnSensorEntry);
        wakeupOnSensorEntry.updateTransformRegion();
        Sensor sensor = this.sensorIntersect(wakeupOnSensorEntry.transformedRegion);
        if (sensor != null) {
            wakeupOnSensorEntry.setTarget(sensor);
            this.currentSensorEntryList.add(wakeupOnSensorEntry);
        }
        if (bl && sensor != null) {
            wakeupOnSensorEntry.setTriggered();
        }
        VirtualUniverse.mc.sendRunMessage(this.universe, 256);
    }

    void removeSensorExitCondition(WakeupOnSensorExit wakeupOnSensorExit) {
        this.wakeupOnSensorExit.remove(wakeupOnSensorExit);
    }

    void addSensorExitCondition(WakeupOnSensorExit wakeupOnSensorExit) {
        boolean bl = true;
        WakeupOnSensorExit[] wakeupOnSensorExitArray = (WakeupOnSensorExit[])this.currentSensorExitList.toArray(false);
        int n = this.currentSensorExitList.arraySize() - 1;
        while (n >= 0) {
            WakeupOnSensorExit wakeupOnSensorExit2 = wakeupOnSensorExitArray[n];
            if (wakeupOnSensorExit2.behav == wakeupOnSensorExit.behav && wakeupOnSensorExit2.region.equals(wakeupOnSensorExit.region)) {
                this.currentSensorExitList.remove(n);
                bl = false;
                break;
            }
            --n;
        }
        wakeupOnSensorExit.updateTransformRegion();
        Sensor sensor = this.sensorIntersect(wakeupOnSensorExit.transformedRegion);
        this.wakeupOnSensorExit.add(wakeupOnSensorExit);
        if (sensor != null) {
            wakeupOnSensorExit.setTarget(sensor);
            this.currentSensorExitList.add(wakeupOnSensorExit);
        }
        if (!bl) {
            return;
        }
        WakeupOnSensorEntry[] wakeupOnSensorEntryArray = (WakeupOnSensorEntry[])this.currentSensorEntryList.toArray(false);
        int n2 = this.currentSensorEntryList.arraySize() - 1;
        while (n2 >= 0) {
            WakeupOnSensorEntry wakeupOnSensorEntry = wakeupOnSensorEntryArray[n2];
            if (wakeupOnSensorEntry.behav == wakeupOnSensorExit.behav && wakeupOnSensorEntry.region.equals(wakeupOnSensorExit.region)) {
                if (sensor != null) break;
                wakeupOnSensorExit.setTriggered();
                break;
            }
            --n2;
        }
        VirtualUniverse.mc.sendRunMessage(this.universe, 256);
    }

    void processConditionMet(BehaviorRetained behaviorRetained, Boolean bl) {
        if (!behaviorRetained.inCallback && (bl == Boolean.FALSE || behaviorRetained.active)) {
            this.processList[behaviorRetained.schedulingInterval].add(behaviorRetained);
        } else if ((behaviorRetained.wakeupMask & 0x10) != 0 && behaviorRetained.source != null && behaviorRetained.source.isLive() && behaviorRetained.wakeupCondition != null) {
            behaviorRetained.wakeupCondition.reInsertElapseTimeCond();
        }
    }

    final void processBehXformChanged(UnorderList unorderList) {
        int n = unorderList.size();
        Object[] objectArray = unorderList.toArray(false);
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray2 = (Object[])objectArray[n2];
            int n3 = 0;
            while (n3 < objectArray2.length) {
                BehaviorRetained behaviorRetained = (BehaviorRetained)objectArray2[n3];
                behaviorRetained.updateTransformRegion();
                this.processBehaviorTransform(behaviorRetained);
                ++n3;
            }
            ++n2;
        }
    }

    final void processVpfXformChanged(UnorderList unorderList) {
        int n = unorderList.size();
        Object[] objectArray = unorderList.toArray(false);
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray2 = (Object[])objectArray[n2];
            int n3 = 0;
            while (n3 < objectArray2.length) {
                this.processViewPlatformTransform((ViewPlatformRetained)objectArray2[n3]);
                ++n3;
            }
            ++n2;
        }
    }

    final void processTransformChanged(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof BehaviorRetained) {
                ((BehaviorRetained)object).updateTransformRegion();
                this.processBehaviorTransform((BehaviorRetained)object);
            } else if (object instanceof ViewPlatformRetained) {
                ((ViewPlatformRetained)object).updateTransformRegion();
                this.transformViewPlatformList.add(object);
            }
            ++n;
        }
        if (this.transformViewPlatformList.size() > 0) {
            ViewPlatformRetained[] viewPlatformRetainedArray = (ViewPlatformRetained[])this.transformViewPlatformList.toArray(false);
            int n2 = this.transformViewPlatformList.arraySize();
            n = 0;
            while (n < n2) {
                this.processViewPlatformTransform(viewPlatformRetainedArray[n]);
                ++n;
            }
            this.transformViewPlatformList.clear();
        }
    }

    final void processBehaviorTransform(BehaviorRetained behaviorRetained) {
        if ((behaviorRetained.wakeupMask & 4) != 0) {
            this.updateVPEntryTransformRegion(behaviorRetained);
        }
        if ((behaviorRetained.wakeupMask & 8) != 0) {
            this.updateVPExitTransformRegion(behaviorRetained);
        }
        if (behaviorRetained.active) {
            if (!this.intersectVPRegion(behaviorRetained.transformedRegion)) {
                this.removeFromScheduleList(behaviorRetained);
            }
        } else {
            this.addToScheduleList(behaviorRetained);
        }
    }

    void processViewPlatformTransform(ViewPlatformRetained viewPlatformRetained) {
        ViewPlatformRetained viewPlatformRetained2;
        int n;
        viewPlatformRetained.updateTransformRegion();
        if (!viewPlatformRetained.isActiveViewPlatform()) {
            return;
        }
        BehaviorRetained[] behaviorRetainedArray = (BehaviorRetained[])this.behaviors.toArray(false);
        int n2 = this.behaviors.arraySize() - 1;
        while (n2 >= 0) {
            BehaviorRetained behaviorRetained = behaviorRetainedArray[n2];
            if (behaviorRetained.active) {
                if (!this.intersectVPRegion(behaviorRetained.transformedRegion)) {
                    this.removeFromScheduleList(behaviorRetained);
                }
            } else {
                this.addToScheduleList(behaviorRetained);
            }
            --n2;
        }
        WakeupOnViewPlatformEntry[] wakeupOnViewPlatformEntryArray = (WakeupOnViewPlatformEntry[])this.wakeupOnViewPlatformEntry.toArray(false);
        n2 = this.wakeupOnViewPlatformEntry.arraySize() - 1;
        while (n2 >= 0) {
            WakeupOnViewPlatformEntry wakeupOnViewPlatformEntry = wakeupOnViewPlatformEntryArray[n2];
            n = this.boundsEntryList.indexOf(wakeupOnViewPlatformEntry);
            if (n < 0) {
                if (wakeupOnViewPlatformEntry.transformedRegion.intersect(viewPlatformRetained.center)) {
                    this.boundsEntryList.add(wakeupOnViewPlatformEntry);
                    wakeupOnViewPlatformEntry.triggeredVP = viewPlatformRetained;
                    wakeupOnViewPlatformEntry.setTriggered();
                }
            } else {
                viewPlatformRetained2 = this.intersectVPCenter(wakeupOnViewPlatformEntry.transformedRegion);
                if (viewPlatformRetained2 == null) {
                    this.boundsEntryList.remove(n);
                }
            }
            --n2;
        }
        WakeupOnViewPlatformExit[] wakeupOnViewPlatformExitArray = (WakeupOnViewPlatformExit[])this.wakeupOnViewPlatformExit.toArray(false);
        n2 = this.wakeupOnViewPlatformExit.arraySize() - 1;
        while (n2 >= 0) {
            WakeupOnViewPlatformExit wakeupOnViewPlatformExit = wakeupOnViewPlatformExitArray[n2];
            n = this.boundsExitList.indexOf(wakeupOnViewPlatformExit);
            if (n < 0) {
                if (wakeupOnViewPlatformExit.transformedRegion.intersect(viewPlatformRetained.center)) {
                    wakeupOnViewPlatformExit.triggeredVP = viewPlatformRetained;
                    this.boundsExitList.add(wakeupOnViewPlatformExit);
                }
            } else {
                viewPlatformRetained2 = this.intersectVPCenter(wakeupOnViewPlatformExit.transformedRegion);
                if (viewPlatformRetained2 == null) {
                    this.boundsExitList.remove(n);
                    wakeupOnViewPlatformExit.setTriggered();
                }
            }
            --n2;
        }
    }

    void updateVPEntryTransformRegion(BehaviorRetained behaviorRetained) {
        WakeupOnViewPlatformEntry[] wakeupOnViewPlatformEntryArray = (WakeupOnViewPlatformEntry[])this.wakeupOnViewPlatformEntry.toArray(false);
        int n = this.wakeupOnViewPlatformEntry.arraySize() - 1;
        while (n >= 0) {
            WakeupOnViewPlatformEntry wakeupOnViewPlatformEntry = wakeupOnViewPlatformEntryArray[n];
            if (wakeupOnViewPlatformEntry.behav == behaviorRetained) {
                wakeupOnViewPlatformEntry.updateTransformRegion(behaviorRetained);
                int n2 = this.boundsEntryList.indexOf(wakeupOnViewPlatformEntry);
                ViewPlatformRetained viewPlatformRetained = this.intersectVPCenter(wakeupOnViewPlatformEntry.transformedRegion);
                if (viewPlatformRetained != null) {
                    if (n2 < 0) {
                        this.boundsEntryList.add(wakeupOnViewPlatformEntry);
                        wakeupOnViewPlatformEntry.triggeredVP = viewPlatformRetained;
                        wakeupOnViewPlatformEntry.setTriggered();
                    }
                } else if (n2 >= 0) {
                    this.boundsEntryList.remove(n2);
                }
            }
            --n;
        }
    }

    void updateVPExitTransformRegion(BehaviorRetained behaviorRetained) {
        WakeupOnViewPlatformExit[] wakeupOnViewPlatformExitArray = (WakeupOnViewPlatformExit[])this.wakeupOnViewPlatformExit.toArray(false);
        int n = this.wakeupOnViewPlatformExit.arraySize() - 1;
        while (n >= 0) {
            WakeupOnViewPlatformExit wakeupOnViewPlatformExit = wakeupOnViewPlatformExitArray[n];
            if (wakeupOnViewPlatformExit.behav == behaviorRetained) {
                wakeupOnViewPlatformExit.updateTransformRegion(behaviorRetained);
                wakeupOnViewPlatformExit = wakeupOnViewPlatformExitArray[n];
                int n2 = this.boundsExitList.indexOf(wakeupOnViewPlatformExit);
                ViewPlatformRetained viewPlatformRetained = this.intersectVPCenter(wakeupOnViewPlatformExit.transformedRegion);
                if (viewPlatformRetained != null) {
                    if (n2 < 0) {
                        wakeupOnViewPlatformExit.triggeredVP = viewPlatformRetained;
                        this.boundsExitList.add(wakeupOnViewPlatformExit);
                    }
                } else if (n2 >= 0) {
                    this.boundsExitList.remove(n2);
                    wakeupOnViewPlatformExit.setTriggered();
                }
            }
            --n;
        }
    }

    void reEvaluatePhysicalEnvironments() {
        ArrayList arrayList = this.universe.viewPlatforms;
        this.physicalEnvironments.clear();
        int n = arrayList.size() - 1;
        while (n >= 0) {
            View[] viewArray = ((ViewPlatformRetained)arrayList.get(n)).getViewList();
            int n2 = viewArray.length - 1;
            while (n2 >= 0) {
                View view = viewArray[n2];
                if (view.active && !this.physicalEnvironments.contains(view.physicalEnvironment)) {
                    this.physicalEnvironments.add(view.physicalEnvironment);
                }
                --n2;
            }
            --n;
        }
    }

    void checkSensorEntryExit() {
        Sensor sensor;
        int n;
        WakeupOnSensorEntry[] wakeupOnSensorEntryArray = (WakeupOnSensorEntry[])this.wakeupOnSensorEntry.toArray();
        int n2 = this.wakeupOnSensorEntry.arraySize() - 1;
        while (n2 >= 0) {
            WakeupOnSensorEntry wakeupOnSensorEntry = wakeupOnSensorEntryArray[n2];
            n = this.currentSensorEntryList.indexOf(wakeupOnSensorEntry);
            wakeupOnSensorEntry.updateTransformRegion();
            sensor = this.sensorIntersect(wakeupOnSensorEntry.transformedRegion);
            if (sensor != null) {
                if (n < 0) {
                    this.currentSensorEntryList.add(wakeupOnSensorEntry);
                    wakeupOnSensorEntry.setTarget(sensor);
                    wakeupOnSensorEntry.setTriggered();
                }
            } else if (n >= 0) {
                this.currentSensorEntryList.remove(n);
            }
            --n2;
        }
        WakeupOnSensorExit[] wakeupOnSensorExitArray = (WakeupOnSensorExit[])this.wakeupOnSensorExit.toArray();
        n2 = this.wakeupOnSensorExit.arraySize() - 1;
        while (n2 >= 0) {
            WakeupOnSensorExit wakeupOnSensorExit = wakeupOnSensorExitArray[n2];
            n = this.currentSensorExitList.indexOf(wakeupOnSensorExit);
            wakeupOnSensorExit.updateTransformRegion();
            sensor = this.sensorIntersect(wakeupOnSensorExit.transformedRegion);
            if (sensor != null) {
                if (n < 0) {
                    this.currentSensorExitList.add(wakeupOnSensorExit);
                    wakeupOnSensorExit.setTarget(sensor);
                }
            } else if (n >= 0) {
                this.currentSensorExitList.remove(n);
                wakeupOnSensorExit.setTriggered();
            }
            --n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Sensor sensorIntersect(Bounds bounds) {
        if (bounds == null) {
            return null;
        }
        PhysicalEnvironment[] physicalEnvironmentArray = (PhysicalEnvironment[])this.physicalEnvironments.toArray(false);
        int n = this.physicalEnvironments.arraySize() - 1;
        while (n >= 0) {
            Sensor[] sensorArray;
            if (physicalEnvironmentArray[n].activeViewRef > 0 && (sensorArray = physicalEnvironmentArray[n].getSensorList()) != null) {
                int n2 = physicalEnvironmentArray[n].users.size() - 1;
                while (n2 >= 0) {
                    View view = (View)physicalEnvironmentArray[n].users.get(n2);
                    Sensor[] sensorArray2 = sensorArray;
                    synchronized (sensorArray2) {
                        int n3 = sensorArray.length - 1;
                        while (n3 >= 0) {
                            Sensor sensor = sensorArray[n3];
                            if (sensor != null) {
                                view.getSensorToVworld(sensor, this.sensorTransform);
                                this.sensorTransform.get(this.sensorLoc);
                                this.ptSensorLoc.set(this.sensorLoc);
                                if (bounds.intersect(this.ptSensorLoc)) {
                                    return sensor;
                                }
                            }
                            --n3;
                        }
                    }
                    --n2;
                }
            }
            --n;
        }
        return null;
    }

    final boolean intersectVPRegion(Bounds bounds) {
        if (bounds == null) {
            return false;
        }
        ViewPlatformRetained[] viewPlatformRetainedArray = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        int n = this.viewPlatforms.arraySize() - 1;
        while (n >= 0) {
            ViewPlatformRetained viewPlatformRetained = viewPlatformRetainedArray[n];
            if (viewPlatformRetained.isActiveViewPlatform() && viewPlatformRetained.schedSphere.intersect(bounds)) {
                return true;
            }
            --n;
        }
        return false;
    }

    final ViewPlatformRetained intersectVPCenter(Bounds bounds) {
        if (bounds == null) {
            return null;
        }
        ViewPlatformRetained[] viewPlatformRetainedArray = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        int n = this.viewPlatforms.arraySize() - 1;
        while (n >= 0) {
            ViewPlatformRetained viewPlatformRetained = viewPlatformRetainedArray[n];
            if (viewPlatformRetained.isActiveViewPlatform() && bounds.intersect(viewPlatformRetained.center)) {
                return viewPlatformRetained;
            }
            --n;
        }
        return null;
    }

    void notifyDeactivationCondition(BehaviorRetained behaviorRetained) {
        WakeupOnDeactivation[] wakeupOnDeactivationArray = (WakeupOnDeactivation[])this.wakeupOnDeactivation.toArray(false);
        int n = this.wakeupOnDeactivation.arraySize() - 1;
        while (n >= 0) {
            WakeupOnDeactivation wakeupOnDeactivation = wakeupOnDeactivationArray[n];
            if (wakeupOnDeactivation.behav == behaviorRetained) {
                wakeupOnDeactivation.setTriggered();
            }
            --n;
        }
    }

    void notifyActivationCondition(BehaviorRetained behaviorRetained) {
        WakeupOnActivation[] wakeupOnActivationArray = (WakeupOnActivation[])this.wakeupOnActivation.toArray(false);
        int n = this.wakeupOnActivation.arraySize() - 1;
        while (n >= 0) {
            WakeupOnActivation wakeupOnActivation = wakeupOnActivationArray[n];
            if (wakeupOnActivation.behav == behaviorRetained) {
                wakeupOnActivation.setTriggered();
            }
            --n;
        }
    }

    void processSwitchChanged(J3dMessage j3dMessage) {
        Object object;
        int n;
        Object[] objectArray;
        int n2;
        Object[] objectArray2;
        int n3;
        UpdateTargets updateTargets = (UpdateTargets)j3dMessage.args[0];
        UnorderList unorderList = updateTargets.targetList[4];
        if (unorderList != null) {
            n3 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            n2 = 0;
            while (n2 < n3) {
                objectArray = (Object[])objectArray2[n2];
                n = objectArray.length - 1;
                while (n >= 0) {
                    object = (ViewPlatformRetained)objectArray[n];
                    ((ViewPlatformRetained)object).processSwitchChanged();
                    --n;
                }
                ++n2;
            }
        }
        if ((unorderList = updateTargets.targetList[2]) != null) {
            n3 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            n2 = 0;
            while (n2 < n3) {
                objectArray = (Object[])objectArray2[n2];
                n = objectArray.length - 1;
                while (n >= 0) {
                    object = (BehaviorRetained)objectArray[n];
                    if (((BehaviorRetained)object).switchState.currentSwitchOn) {
                        this.addToScheduleList((BehaviorRetained)object);
                    } else {
                        this.removeFromScheduleList((BehaviorRetained)object);
                    }
                    --n;
                }
                ++n2;
            }
        }
        if ((unorderList = updateTargets.targetList[5]) != null) {
            n3 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            object = (Object[])j3dMessage.args[1];
            int n4 = 0;
            while (n4 < n3) {
                objectArray = (Object[])objectArray2[n4];
                Object[] objectArray3 = (Object[])object[n4];
                n = objectArray.length - 1;
                while (n >= 0) {
                    Object[] objectArray4 = (Object[])objectArray3[n];
                    Object[] objectArray5 = new Object[1];
                    BoundingLeafRetained boundingLeafRetained = (BoundingLeafRetained)objectArray[n];
                    n2 = 0;
                    while (n2 < objectArray4.length) {
                        if (objectArray4[n2] instanceof BehaviorRetained) {
                            objectArray5[0] = objectArray4[n2];
                            this.processTransformChanged(objectArray5);
                        }
                        ++n2;
                    }
                    --n;
                }
                ++n4;
            }
        }
    }

    void processBoundingLeafChanged(Object[] objectArray, Bounds bounds) {
        int n = objectArray.length - 1;
        while (n >= 0) {
            Object object = objectArray[n];
            if (object instanceof BehaviorRetained) {
                BehaviorRetained behaviorRetained = (BehaviorRetained)object;
                behaviorRetained.updateTransformRegion(bounds);
                this.processBehaviorTransform(behaviorRetained);
            }
            --n;
        }
    }

    final void removeFromScheduleList(BehaviorRetained behaviorRetained) {
        if (behaviorRetained.active) {
            if ((behaviorRetained.wakeupMask & 2) != 0) {
                this.notifyDeactivationCondition(behaviorRetained);
            }
            this.scheduleList.remove(behaviorRetained);
            behaviorRetained.active = false;
            if (behaviorRetained.universe != this.universe) {
                J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
                j3dMessage.threads = 256;
                j3dMessage.type = 60;
                j3dMessage.universe = behaviorRetained.universe;
                j3dMessage.args[0] = behaviorRetained;
                VirtualUniverse.mc.processMessage(j3dMessage);
            }
        }
    }

    final void addToScheduleList(BehaviorRetained behaviorRetained) {
        if (!behaviorRetained.inCallback && !behaviorRetained.active && behaviorRetained.enable && behaviorRetained.switchState.currentSwitchOn && behaviorRetained.wakeupCondition != null && ((Behavior)behaviorRetained.source).isLive() && this.intersectVPRegion(behaviorRetained.transformedRegion)) {
            this.scheduleList.add(behaviorRetained);
            behaviorRetained.active = true;
            if ((behaviorRetained.wakeupMask & 1) != 0) {
                this.notifyActivationCondition(behaviorRetained);
            }
            if (behaviorRetained.wakeupCondition != null) {
                behaviorRetained.wakeupCondition.conditionMet = false;
            }
        }
    }

    void resetConditionMet() {
        BehaviorStructure.resetConditionMet(this.wakeupOnAWTEvent);
        BehaviorStructure.resetConditionMet(this.wakeupOnActivation);
        BehaviorStructure.resetConditionMet(this.wakeupOnDeactivation);
        BehaviorStructure.resetConditionMet(this.wakeupOnBehaviorPost);
        BehaviorStructure.resetConditionMet(this.wakeupOnElapsedFrames);
        BehaviorStructure.resetConditionMet(this.wakeupOnViewPlatformEntry);
        BehaviorStructure.resetConditionMet(this.wakeupOnViewPlatformExit);
        BehaviorStructure.resetConditionMet(this.wakeupOnSensorEntry);
        BehaviorStructure.resetConditionMet(this.wakeupOnSensorExit);
    }

    static void resetConditionMet(WakeupIndexedList wakeupIndexedList) {
        WakeupCondition[] wakeupConditionArray = (WakeupCondition[])wakeupIndexedList.toArray(false);
        int n = wakeupIndexedList.size() - 1;
        while (n >= 0) {
            --n;
            wakeupConditionArray[v0].conditionMet = false;
        }
    }

    void reEvaluateWakeupCount() {
        WakeupOnElapsedFrames[] wakeupOnElapsedFramesArray = (WakeupOnElapsedFrames[])this.wakeupOnElapsedFrames.toArray(true);
        int n = this.wakeupOnElapsedFrames.arraySize();
        int n2 = 0;
        this.activeWakeupOnFrameCount = 0;
        while (n2 < n) {
            WakeupOnElapsedFrames wakeupOnElapsedFrames = wakeupOnElapsedFramesArray[n2++];
            if (wakeupOnElapsedFrames.passive || wakeupOnElapsedFrames.behav == null || !wakeupOnElapsedFrames.behav.enable) continue;
            ++this.activeWakeupOnFrameCount;
        }
        this.activeWakeupOnSensorCount = 0;
        WakeupOnSensorEntry[] wakeupOnSensorEntryArray = (WakeupOnSensorEntry[])this.wakeupOnSensorEntry.toArray();
        n2 = this.wakeupOnSensorEntry.arraySize() - 1;
        while (n2 >= 0) {
            WakeupOnSensorEntry wakeupOnSensorEntry = wakeupOnSensorEntryArray[n2];
            if (wakeupOnSensorEntry.behav != null && wakeupOnSensorEntry.behav.enable) {
                ++this.activeWakeupOnSensorCount;
            }
            --n2;
        }
        WakeupOnSensorExit[] wakeupOnSensorExitArray = (WakeupOnSensorExit[])this.wakeupOnSensorExit.toArray();
        n2 = this.wakeupOnSensorExit.arraySize() - 1;
        while (n2 >= 0) {
            WakeupOnSensorExit wakeupOnSensorExit = wakeupOnSensorExitArray[n2];
            if (wakeupOnSensorExit.behav != null && wakeupOnSensorExit.behav.enable) {
                ++this.activeWakeupOnSensorCount;
            }
            --n2;
        }
    }

    void cleanup() {
        this.behaviors.clear();
        this.viewPlatforms.clear();
        this.scheduleList.clear();
        this.boundsEntryList.clear();
        this.boundsExitList.clear();
        this.currentSensorEntryList.clear();
        this.currentSensorExitList.clear();
        this.wakeupOnAWTEvent.clear();
        this.wakeupOnActivation.clear();
        this.wakeupOnDeactivation.clear();
        this.wakeupOnBehaviorPost.clear();
        this.wakeupOnElapsedFrames.clear();
        this.wakeupOnViewPlatformEntry.clear();
        this.wakeupOnViewPlatformExit.clear();
        this.wakeupOnSensorEntry.clear();
        this.wakeupOnSensorExit.clear();
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

