/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.AttributeBin;
import javax.media.j3d.BehaviorScheduler;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.CachedFrustum;
import javax.media.j3d.CanvasViewCache;
import javax.media.j3d.CanvasViewEventCatcher;
import javax.media.j3d.ColoringAttributesRetained;
import javax.media.j3d.DetailTextureImage;
import javax.media.j3d.DrawingSurfaceObject;
import javax.media.j3d.DrawingSurfaceObjectAWT;
import javax.media.j3d.DrawingSurfaceObjectDSI;
import javax.media.j3d.EnvironmentSet;
import javax.media.j3d.EventCatcher;
import javax.media.j3d.FogRetained;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.J3DGraphics2D;
import javax.media.j3d.J3DGraphics2DImpl;
import javax.media.j3d.J3dGraphicsConfig;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dQueryProps;
import javax.media.j3d.LightBin;
import javax.media.j3d.LightRetained;
import javax.media.j3d.LineAttributesRetained;
import javax.media.j3d.MasterControl;
import javax.media.j3d.MaterialRetained;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.NativeWSInfo;
import javax.media.j3d.PointAttributesRetained;
import javax.media.j3d.PolygonAttributesRetained;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.RenderMolecule;
import javax.media.j3d.Renderer;
import javax.media.j3d.RenderingAttributesRetained;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Screen3D;
import javax.media.j3d.TexCoordGenerationRetained;
import javax.media.j3d.TextureAttributesRetained;
import javax.media.j3d.TextureBin;
import javax.media.j3d.TextureRetained;
import javax.media.j3d.TextureUnitStateRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransparencyAttributesRetained;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector4d;

public class Canvas3D
extends Canvas {
    public static final int FIELD_LEFT = 0;
    public static final int FIELD_RIGHT = 1;
    public static final int FIELD_ALL = 2;
    static final int POLYGONATTRS_DIRTY = 1;
    static final int LINEATTRS_DIRTY = 2;
    static final int POINTATTRS_DIRTY = 4;
    static final int MATERIAL_DIRTY = 8;
    static final int TRANSPARENCYATTRS_DIRTY = 16;
    static final int COLORINGATTRS_DIRTY = 32;
    static final int LIGHTBIN_DIRTY = 64;
    static final int LIGHTENABLES_DIRTY = 128;
    static final int AMBIENTLIGHT_DIRTY = 256;
    static final int ATTRIBUTEBIN_DIRTY = 512;
    static final int TEXTUREBIN_DIRTY = 1024;
    static final int TEXTUREATTRIBUTES_DIRTY = 2048;
    static final int RENDERMOLECULE_DIRTY = 4096;
    static final int FOG_DIRTY = 8192;
    static final int MODELCLIP_DIRTY = 16384;
    static final int VWORLD_SCALE_DIRTY = 32768;
    static final int RESIZE = 1;
    static final int TOGGLEFULLSCREEN = 2;
    static final int NOCHANGE = 0;
    static final int RESETSURFACE = 1;
    static final int RECREATEDDRAW = 2;
    boolean offScreen = false;
    Point offScreenCanvasLoc;
    Dimension offScreenCanvasSize;
    Point offScreenCanvasClippedLoc;
    Dimension offScreenCanvasClippedSize;
    volatile boolean offScreenRendering = false;
    boolean waitingForOffScreenRendering = false;
    ImageComponent2D offScreenBuffer = null;
    byte[] byteBuffer = new byte[1];
    boolean useSharedCtx = true;
    boolean stereoAvailable;
    boolean stereoEnable = true;
    boolean useStereo;
    boolean rightStereoPass = false;
    int monoscopicViewPolicy = 2;
    boolean doubleBufferAvailable;
    boolean doubleBufferEnable = true;
    boolean useDoubleBuffer;
    boolean sceneAntialiasingAvailable;
    boolean sceneAntialiasingMultiSamplesAvailable;
    boolean antialiasingSet = false;
    int textureColorTableSize;
    boolean multiTexAccelerated = false;
    int numTexUnitSupported = 1;
    int numTexCoordSupported = 1;
    int[] texUnitStateMap = null;
    int numActiveTexUnit = 0;
    int lastActiveTexUnit = -1;
    J3dQueryProps queryProps;
    Point3d leftManualEyeInImagePlate = new Point3d(0.142, 0.135, 0.4572);
    Point3d rightManualEyeInImagePlate = new Point3d(0.208, 0.135, 0.4572);
    View view = null;
    View pendingView;
    CanvasViewCache canvasViewCache = null;
    boolean raIsVisible = false;
    RenderAtom ra = null;
    static final int STEREO_DIRTY = 1;
    static final int MONOSCOPIC_VIEW_POLICY_DIRTY = 2;
    static final int EYE_IN_IMAGE_PLATE_DIRTY = 4;
    static final int MOVED_OR_RESIZED_DIRTY = 8;
    static final int BACKGROUND_DIRTY = 16;
    static final int BACKGROUND_IMAGE_DIRTY = 32;
    static final int VIEW_INFO_DIRTY = 63;
    int cvDirtyMask = 63;
    boolean resizeGraphics2D = true;
    volatile boolean isRunning = true;
    volatile boolean isRunningStatus = true;
    boolean active = false;
    boolean visible = false;
    boolean ctxReset = true;
    Screen3D screen = null;
    boolean imageReady = false;
    int fogOn = 0;
    GraphicsContext3D graphicsContext3D = null;
    boolean waiting = false;
    boolean swapDone = false;
    GraphicsConfiguration graphicsConfiguration;
    J3DGraphics2DImpl graphics2D = null;
    Object gfxCreationLock = new Object();
    Transform3D vworldToEc = new Transform3D();
    Transform3D vpcToEc;
    int window = 0;
    int vid = 0;
    long visInfo = 0L;
    static Hashtable visInfoTable = new Hashtable();
    String nativeGraphicsVersion = null;
    NativeWSInfo nativeWSobj = new NativeWSInfo();
    boolean firstPaintCalled = false;
    boolean added = false;
    long ctx = 0L;
    volatile long ctxTimeStamp = 0L;
    boolean ctxEyeLightingEnable = false;
    AppearanceRetained currentAppear = new AppearanceRetained();
    MaterialRetained currentMaterial = new MaterialRetained();
    CachedFrustum viewFrustum = new CachedFrustum();
    LightBin lightBin = null;
    EnvironmentSet environmentSet = null;
    AttributeBin attributeBin = null;
    RenderMolecule renderMolecule = null;
    PolygonAttributesRetained polygonAttributes = null;
    LineAttributesRetained lineAttributes = null;
    PointAttributesRetained pointAttributes = null;
    MaterialRetained material = null;
    boolean enableLighting = false;
    TransparencyAttributesRetained transparency = null;
    ColoringAttributesRetained coloringAttributes = null;
    Transform3D modelMatrix = null;
    TextureBin textureBin = null;
    LightRetained[] lights = null;
    int[] frameCount = null;
    long enableMask = -1L;
    FogRetained fog = null;
    ModelClipRetained modelClip = null;
    Color3f sceneAmbient = new Color3f();
    TextureUnitStateRetained[] texUnitState = null;
    float cachedDvrFactor = 1.0f;
    boolean cachedDvrResizeCompensation = true;
    TextureRetained texture = null;
    TextureAttributesRetained texAttrs = null;
    TexCoordGenerationRetained texCoordGeneration = null;
    RenderingAttributesRetained renderingAttrs = null;
    AppearanceRetained appearance = null;
    Object appHandle = null;
    boolean texLinearMode = false;
    int canvasDirty = 65535;
    boolean dirtyDisplayList = false;
    ArrayList dirtyRenderMoleculeList = new ArrayList();
    ArrayList dirtyRenderAtomList = new ArrayList();
    ArrayList dirtyDlistPerRinfoList = new ArrayList();
    ArrayList displayListResourceFreeList = new ArrayList();
    ArrayList textureIdResourceFreeList = new ArrayList();
    int canvasBit = 0;
    Object cvLock = new Object();
    Object evaluateLock = new Object();
    Object dirtyMaskLock = new Object();
    boolean fullScreenMode = false;
    int fullscreenWidth;
    int fullscreenHeight;
    boolean needToRebuildDisplayList = false;
    int reEvaluateCanvasCmd = 0;
    static final int TEXTURE_3D = 1;
    static final int TEXTURE_COLOR_TABLE = 2;
    static final int TEXTURE_MULTI_TEXTURE = 4;
    static final int TEXTURE_COMBINE = 8;
    static final int TEXTURE_COMBINE_DOT3 = 16;
    static final int TEXTURE_COMBINE_SUBTRACT = 32;
    static final int TEXTURE_REGISTER_COMBINERS = 64;
    static final int TEXTURE_CUBE_MAP = 128;
    static final int TEXTURE_SHARPEN = 256;
    static final int TEXTURE_DETAIL = 512;
    static final int TEXTURE_FILTER4 = 1024;
    static final int TEXTURE_ANISOTROPIC_FILTER = 2048;
    static final int TEXTURE_LOD_RANGE = 4096;
    static final int TEXTURE_LOD_OFFSET = 8192;
    static final int TEXTURE_LERP = 16384;
    int textureExtendedFeatures = 0;
    static final int SUN_GLOBAL_ALPHA = 1;
    static final int EXT_ABGR = 2;
    static final int EXT_BGR = 4;
    static final int EXT_RESCALE_NORMAL = 8;
    static final int EXT_MULTI_DRAW_ARRAYS = 16;
    static final int SUN_MULTI_DRAW_ARRAYS = 32;
    static final int SUN_CONSTANT_DATA = 64;
    static final int EXT_SEPARATE_SPECULAR_COLOR = 128;
    static final int ARB_TRANSPOSE_MATRIX = 256;
    static final int ARB_MULTISAMPLE = 512;
    static final int EXT_COMPILED_VERTEX_ARRAYS = 1024;
    static final int SUN_VIDEO_RESIZE = 2048;
    static final int STENCIL_BUFFER = 4096;
    int extensionsSupported = 0;
    float anisotropicDegreeMax = 1.0f;
    int textureBoundaryWidthMax = 0;
    int textureWidthMax = 0;
    int textureHeightMax = 0;
    Point newPosition = new Point();
    Dimension newSize = new Dimension();
    ArrayList textureIDResourceTable = new ArrayList(5);
    static final int LIGHTBIN_BIT = 0;
    static final int ENVIRONMENTSET_BIT = 1;
    static final int ATTRIBUTEBIN_BIT = 2;
    static final int TEXTUREBIN_BIT = 3;
    static final int RENDERMOLECULE_BIT = 4;
    static final int TRANSPARENCY_BIT = 5;
    int stateUpdateMask = 0;
    Object[] curStateToUpdate = new Object[6];
    LightRetained[] currentLights = null;
    boolean depthBufferWriteEnableOverride = false;
    boolean depthBufferEnableOverride = false;
    boolean depthBufferWriteEnable = true;
    boolean vfPlanesValid = false;
    EventCatcher eventCatcher;
    CanvasViewEventCatcher canvasViewEventCatcher;
    Container parent;
    boolean lightChanged = false;
    DrawingSurfaceObject drawingSurfaceObject;
    boolean validCtx = false;
    boolean validCanvas = false;
    boolean ctxChanged = false;
    private static GraphicsConfiguration defaultGcfg = null;
    static int ENV_STATE_MASK;

    native int getTextureUnitCount(long var1);

    native long createContext(long var1, int var3, int var4, long var5, long var7, boolean var9, boolean var10);

    native void createQueryContext(long var1, int var3, int var4, boolean var5, int var6, int var7);

    static native void destroyContext(long var0, int var2, long var3);

    native int createOffScreenBuffer(long var1, long var3, int var5, int var6, int var7);

    native void destroyOffScreenBuffer(long var1, long var3, int var5);

    native void readOffScreenBuffer(long var1, int var3, int var4, int var5);

    native void accum(long var1, float var3);

    native void accumReturn(long var1);

    native void clearAccum(long var1);

    native int getNumCtxLights(long var1);

    native boolean decal1stChildSetup(long var1);

    native void decalNthChildSetup(long var1);

    native void decalReset(long var1, boolean var3);

    native void ctxUpdateEyeLightingEnable(long var1, boolean var3);

    native void setDepthFunc(long var1, int var3);

    native void setBlendColor(long var1, float var3, float var4, float var5, float var6);

    native void setBlendFunc(long var1, int var3, int var4);

    native void setFogEnableFlag(long var1, boolean var3);

    native void setFullSceneAntialiasing(long var1, boolean var3);

    native int resizeD3DCanvas(long var1);

    native int toggleFullScreenMode(long var1);

    native void setGlobalAlpha(long var1, float var3);

    native void disableGlobalAlpha(long var1);

    native void updateSeparateSpecularColorEnable(long var1, boolean var3);

    native void beginScene(long var1);

    native void endScene(long var1);

    native boolean validGraphicsMode();

    native void setLightEnables(long var1, long var3, int var5);

    native void setSceneAmbient(long var1, float var3, float var4, float var5);

    native void disableFog(long var1);

    native void disableModelClip(long var1);

    native void resetRenderingAttributes(long var1, boolean var3, boolean var4);

    native void resetTextureNative(long var1, int var3);

    native void activeTextureUnit(long var1, int var3);

    native void resetTexCoordGeneration(long var1);

    native void resetTextureAttributes(long var1);

    native void resetPolygonAttributes(long var1);

    native void resetLineAttributes(long var1);

    native void resetPointAttributes(long var1);

    native void resetTransparency(long var1, int var3, int var4, boolean var5, boolean var6);

    native void resetColoringAttributes(long var1, float var3, float var4, float var5, float var6, boolean var7);

    native void updateMaterial(long var1, float var3, float var4, float var5, float var6);

    native void updateTexUnitStateMap(long var1, int var3, int[] var4);

    native void syncRender(long var1, boolean var3);

    private static synchronized GraphicsConfiguration defaultGraphicsConfiguration() {
        if (defaultGcfg == null) {
            GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
            defaultGcfg = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration(graphicsConfigTemplate3D);
        }
        return defaultGcfg;
    }

    private static synchronized GraphicsConfiguration checkForValidGraphicsConfig(GraphicsConfiguration graphicsConfiguration) {
        if (graphicsConfiguration == null) {
            System.err.println("************************************************************************");
            System.err.println(J3dI18N.getString("Canvas3D7"));
            System.err.println(J3dI18N.getString("Canvas3D18"));
            System.err.println("************************************************************************");
            return Canvas3D.defaultGraphicsConfiguration();
        }
        if (!J3dGraphicsConfig.isValidConfig(graphicsConfiguration)) {
            System.err.println("************************************************************************");
            System.err.println(J3dI18N.getString("Canvas3D21"));
            System.err.println(J3dI18N.getString("Canvas3D22"));
            System.err.println("************************************************************************");
            return Canvas3D.defaultGraphicsConfiguration();
        }
        return graphicsConfiguration;
    }

    public Canvas3D(GraphicsConfiguration graphicsConfiguration) {
        this(Canvas3D.checkForValidGraphicsConfig(graphicsConfiguration), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Canvas3D(GraphicsConfiguration graphicsConfiguration, boolean bl) {
        super(graphicsConfiguration);
        Object object;
        if (graphicsConfiguration == null) {
            throw new NullPointerException(J3dI18N.getString("Canvas3D19"));
        }
        if (!J3dGraphicsConfig.isValidConfig(graphicsConfiguration)) {
            throw new IllegalArgumentException(J3dI18N.getString("Canvas3D17"));
        }
        if (!J3dGraphicsConfig.isValidPixelFormat(graphicsConfiguration)) {
            throw new IllegalArgumentException(J3dI18N.getString("Canvas3D17"));
        }
        VirtualUniverse.createMC();
        this.offScreen = bl;
        this.graphicsConfiguration = graphicsConfiguration;
        this.vid = this.nativeWSobj.getCanvasVid(graphicsConfiguration);
        Object v = visInfoTable.get(graphicsConfiguration);
        if (v != null && v instanceof Long) {
            this.visInfo = (Long)v;
        }
        if (bl) {
            this.screen = new Screen3D(graphicsConfiguration, bl);
            this.added = true;
            object = this.dirtyMaskLock;
            synchronized (object) {
                this.cvDirtyMask |= 8;
            }
            this.firstPaintCalled = true;
            this.ctx = 0L;
            this.evaluateActive();
            this.offScreenCanvasLoc = new Point(0, 0);
            this.offScreenCanvasSize = new Dimension(0, 0);
            this.offScreenCanvasClippedLoc = new Point(0, 0);
            this.offScreenCanvasClippedSize = new Dimension(0, 0);
            this.setLocation(this.offScreenCanvasLoc);
            this.setSize(this.offScreenCanvasSize);
            this.newSize = this.offScreenCanvasSize;
            this.newPosition = this.offScreenCanvasLoc;
        } else {
            object = graphicsConfiguration.getDevice();
            this.eventCatcher = new EventCatcher(this);
            this.canvasViewEventCatcher = new CanvasViewEventCatcher(this);
            Hashtable hashtable = VirtualUniverse.mc.deviceScreenMap;
            synchronized (hashtable) {
                this.screen = (Screen3D)VirtualUniverse.mc.deviceScreenMap.get(object);
                if (this.screen == null) {
                    this.screen = new Screen3D(graphicsConfiguration, bl);
                    VirtualUniverse.mc.deviceScreenMap.put(object, this.screen);
                }
            }
        }
        this.drawingSurfaceObject = MasterControl.jvm14AndGreater ? new DrawingSurfaceObjectAWT(this, VirtualUniverse.mc.awt, this.screen.display, this.screen.screen, VirtualUniverse.mc.xineramaDisabled) : new DrawingSurfaceObjectDSI(this);
        this.lights = new LightRetained[VirtualUniverse.mc.maxLights];
        this.frameCount = new int[VirtualUniverse.mc.maxLights];
        int n = 0;
        while (n < this.frameCount.length) {
            this.frameCount[n] = -1;
            ++n;
        }
        GraphicsConfigTemplate3D.getGraphicsConfigFeatures(this);
        this.useDoubleBuffer = this.doubleBufferEnable && this.doubleBufferAvailable;
        this.useStereo = this.stereoEnable && this.stereoAvailable;
        this.useSharedCtx = VirtualUniverse.mc.isSharedCtx;
    }

    void sendEventToBehaviorScheduler(AWTEvent aWTEvent) {
        VirtualUniverse virtualUniverse;
        ViewPlatform viewPlatform;
        if (this.view != null && (viewPlatform = this.view.getViewPlatform()) != null && (virtualUniverse = ((ViewPlatformRetained)viewPlatform.retained).universe) != null) {
            virtualUniverse.behaviorStructure.handleAWTEvent(aWTEvent);
        }
    }

    void redraw() {
        if (this.view != null && this.active && this.isRunning) {
            this.view.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        if (!this.firstPaintCalled && this.added && this.validCanvas && this.validGraphicsMode()) {
            try {
                this.newSize = this.getSize();
                this.newPosition = this.getLocationOnScreen();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                return;
            }
            DrawingSurfaceObject drawingSurfaceObject = this.drawingSurfaceObject;
            synchronized (drawingSurfaceObject) {
                this.drawingSurfaceObject.getDrawingSurfaceObjectInfo();
            }
            this.firstPaintCalled = true;
            this.visible = true;
            this.evaluateActive();
        }
        this.redraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object;
        Renderer renderer = null;
        if (this.isRunning && this.screen != null && (renderer = this.screen.renderer) != null) {
            VirtualUniverse.mc.postRequest(MasterControl.STOP_RENDERER, renderer);
            while (!renderer.userStop) {
                MasterControl.threadYield();
            }
        }
        super.addNotify();
        this.screen.addUser(this);
        this.parent = this.getParent();
        while (!(this.parent instanceof Window)) {
            this.parent = this.parent.getParent();
        }
        ((Window)this.parent).addWindowListener(this.eventCatcher);
        if (VirtualUniverse.mc.isD3D()) {
            ((Window)this.parent).addComponentListener(this.eventCatcher);
        }
        if (!this.offScreen) {
            if (this.canvasViewEventCatcher.parentList.size() > 0) {
                int n = 0;
                while (n < this.canvasViewEventCatcher.parentList.size()) {
                    object = (Component)this.canvasViewEventCatcher.parentList.get(n);
                    ((Component)object).removeComponentListener(this.canvasViewEventCatcher);
                    ++n;
                }
                this.canvasViewEventCatcher.parentList.clear();
            }
            object = this.getParent();
            while (object != null) {
                ((Component)object).addComponentListener(this.canvasViewEventCatcher);
                this.canvasViewEventCatcher.parentList.add(object);
                object = ((Component)object).getParent();
            }
            this.addComponentListener(this.canvasViewEventCatcher);
        }
        object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask |= 8;
        }
        this.canvasBit = VirtualUniverse.mc.getCanvasBit();
        this.validCanvas = true;
        this.added = true;
        if (this.isRunning) {
            this.isRunningStatus = true;
        }
        if (renderer != null) {
            renderer.userStop = false;
        }
        this.ctxTimeStamp = 0L;
        if (this.view != null && this.view.universe != null) {
            this.view.universe.checkForEnableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Renderer renderer = null;
        if (this.isRunning && this.screen != null && (renderer = this.screen.renderer) != null) {
            VirtualUniverse.mc.postRequest(MasterControl.STOP_RENDERER, renderer);
            while (!renderer.userStop) {
                MasterControl.threadYield();
            }
        }
        if (!this.offScreen) {
            this.firstPaintCalled = false;
        }
        DrawingSurfaceObject drawingSurfaceObject = this.drawingSurfaceObject;
        synchronized (drawingSurfaceObject) {
            this.validCtx = false;
            this.validCanvas = false;
        }
        this.removeCtx(false);
        DrawingSurfaceObject drawingSurfaceObject2 = this.drawingSurfaceObject;
        synchronized (drawingSurfaceObject2) {
            if (MasterControl.jvm14AndGreater) {
                DrawingSurfaceObjectAWT drawingSurfaceObjectAWT = (DrawingSurfaceObjectAWT)this.drawingSurfaceObject;
                long l = drawingSurfaceObjectAWT.getDS();
                long[] lArray = new long[]{l, drawingSurfaceObjectAWT.getDSI()};
                if (l != 0L) {
                    VirtualUniverse.mc.postRequest(MasterControl.FREE_DRAWING_SURFACE, lArray);
                }
            }
            this.drawingSurfaceObject.invalidate();
        }
        this.visible = false;
        this.screen.removeUser(this);
        this.evaluateActive();
        VirtualUniverse.mc.freeCanvasBit(this.canvasBit);
        this.ra = null;
        this.graphicsContext3D = null;
        this.ctx = 0L;
        this.graphics2D = null;
        super.removeNotify();
        if (this.eventCatcher != null) {
            this.removeComponentListener(this.eventCatcher);
            this.removeFocusListener(this.eventCatcher);
            this.removeKeyListener(this.eventCatcher);
            this.removeMouseListener(this.eventCatcher);
            this.removeMouseMotionListener(this.eventCatcher);
            this.eventCatcher.reset();
        }
        if (this.canvasViewEventCatcher != null) {
            if (this.canvasViewEventCatcher.parentList.size() > 0) {
                int n = this.canvasViewEventCatcher.parentList.size() - 1;
                while (n >= 0) {
                    Component component = (Component)this.canvasViewEventCatcher.parentList.get(n);
                    component.removeComponentListener(this.canvasViewEventCatcher);
                    --n;
                }
                this.canvasViewEventCatcher.parentList.clear();
            }
            this.removeComponentListener(this.canvasViewEventCatcher);
        }
        if (this.parent != null) {
            ((Window)this.parent).removeWindowListener(this.eventCatcher);
            if (VirtualUniverse.mc.isD3D()) {
                ((Window)this.parent).removeComponentListener(this.eventCatcher);
            }
        }
        if (this.parent != null) {
            this.parent.requestFocus();
        }
        if (!this.offScreen) {
            this.added = false;
        }
        if (renderer != null) {
            renderer.userStop = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evaluateActive() {
        VirtualUniverse virtualUniverse;
        Object object = this.evaluateLock;
        synchronized (object) {
            if ((this.visible || this.offScreen) && this.firstPaintCalled) {
                if (!this.active) {
                    this.active = true;
                    if (this.pendingView != null) {
                        this.pendingView.evaluateActive();
                    }
                } else if (this.pendingView != null && !this.pendingView.activeStatus) {
                    this.pendingView.evaluateActive();
                }
            } else if (this.active) {
                this.active = false;
                if (this.view != null) {
                    this.view.evaluateActive();
                }
            }
        }
        if (this.view != null && !this.active && (virtualUniverse = this.view.universe) != null && !virtualUniverse.isSceneGraphLock) {
            virtualUniverse.waitForMC();
        }
    }

    void setFrustumPlanes(Vector4d[] vector4dArray) {
        this.viewFrustum.set(vector4dArray);
    }

    public Screen3D getScreen3D() {
        return this.screen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphicsContext3D getGraphicsContext3D() {
        Object object = this.gfxCreationLock;
        synchronized (object) {
            if (this.graphicsContext3D == null) {
                this.graphicsContext3D = new GraphicsContext3D(this);
            }
        }
        return this.graphicsContext3D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public J3DGraphics2D getGraphics2D() {
        Object object = this.gfxCreationLock;
        synchronized (object) {
            if (this.graphics2D == null) {
                this.graphics2D = new J3DGraphics2DImpl(this);
            }
        }
        return this.graphics2D;
    }

    public void preRender() {
    }

    public void postRender() {
    }

    public void postSwap() {
    }

    public void renderField(int n) {
    }

    public final void stopRenderer() {
        if (this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D14"));
        }
        if (this.isRunning) {
            VirtualUniverse.mc.postRequest(MasterControl.STOP_RENDERER, this);
            this.isRunning = false;
        }
    }

    public final void startRenderer() {
        if (!this.isRunning) {
            VirtualUniverse.mc.postRequest(MasterControl.START_RENDERER, this);
            this.isRunning = true;
            this.redraw();
        }
    }

    public final boolean isRendererRunning() {
        return this.isRunning;
    }

    public boolean isOffScreen() {
        return this.offScreen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffScreenBuffer(ImageComponent2D imageComponent2D) {
        ImageComponent2DRetained imageComponent2DRetained = (ImageComponent2DRetained)imageComponent2D.retained;
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        if (this.offScreenRendering) {
            throw new RestrictedAccessException(J3dI18N.getString("Canvas3D2"));
        }
        if (imageComponent2DRetained.byReference && !(imageComponent2DRetained.bImage[0] instanceof BufferedImage)) {
            throw new IllegalArgumentException(J3dI18N.getString("Canvas3D15"));
        }
        if (imageComponent2DRetained.format == 10) {
            throw new IllegalArgumentException(J3dI18N.getString("Canvas3D16"));
        }
        if (this.offScreenCanvasSize.width != imageComponent2DRetained.width || this.offScreenCanvasSize.height != imageComponent2DRetained.height) {
            if (this.window != 0) {
                this.destroyOffScreenBuffer(this.ctx, this.screen.display, this.window);
                this.removeCtx(true);
                this.window = 0;
            }
            this.offScreenCanvasSize.setSize(imageComponent2DRetained.width, imageComponent2DRetained.height);
            this.setSize(this.offScreenCanvasSize);
            this.window = this.createOffScreenBuffer(this.ctx, this.screen.display, this.vid, this.offScreenCanvasSize.width, this.offScreenCanvasSize.height);
            this.ctx = 0L;
        }
        if (this.ctx != 0L) {
            this.removeCtx(true);
        }
        this.offScreenBuffer = imageComponent2D;
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask |= 8;
        }
    }

    public ImageComponent2D getOffScreenBuffer() {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        return this.offScreenBuffer;
    }

    public void renderOffScreenBuffer() {
        int n;
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        if (this.offScreenBuffer == null) {
            throw new NullPointerException(J3dI18N.getString("Canvas3D10"));
        }
        Dimension dimension = this.screen.getSize();
        if (dimension.width <= 0) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D8"));
        }
        if (dimension.height <= 0) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D9"));
        }
        if (this.screen.getPhysicalScreenWidth() <= 0.0) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D12"));
        }
        if (this.screen.getPhysicalScreenHeight() <= 0.0) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D13"));
        }
        if (this.offScreenRendering) {
            throw new RestrictedAccessException(J3dI18N.getString("Canvas3D2"));
        }
        if (!this.isRunning) {
            throw new RestrictedAccessException(J3dI18N.getString("Canvas3D11"));
        }
        if (!this.active) {
            return;
        }
        if (this.offScreenCanvasLoc.x >= dimension.width || this.offScreenCanvasLoc.y >= dimension.height) {
            return;
        }
        if (this.offScreenCanvasLoc.x < 0) {
            this.offScreenCanvasClippedLoc.x = 0 - this.offScreenCanvasLoc.x;
            this.offScreenCanvasClippedSize.width = this.offScreenCanvasSize.width - this.offScreenCanvasClippedLoc.x;
            if (this.offScreenCanvasClippedSize.width > dimension.width) {
                this.offScreenCanvasClippedSize.width = dimension.width;
            }
        } else {
            this.offScreenCanvasClippedLoc.x = 0;
            this.offScreenCanvasClippedSize.width = this.offScreenCanvasSize.width;
            if (this.offScreenCanvasLoc.x + this.offScreenCanvasClippedSize.width > dimension.width) {
                this.offScreenCanvasClippedSize.width = dimension.width - this.offScreenCanvasLoc.x;
            }
        }
        if ((n = this.offScreenCanvasLoc.y + this.offScreenCanvasSize.height) < 0) {
            return;
        }
        if (n <= dimension.height) {
            this.offScreenCanvasClippedLoc.y = 0;
            this.offScreenCanvasClippedSize.height = this.offScreenCanvasLoc.y < 0 ? n : this.offScreenCanvasSize.height;
        } else if (n > dimension.height) {
            this.offScreenCanvasClippedSize.height = dimension.height - this.offScreenCanvasLoc.y;
            this.offScreenCanvasClippedLoc.y = n - dimension.height;
        }
        this.offScreenRendering = true;
        if (this.view.inCanvasCallback) {
            if (this.screen.renderer == null) {
                this.screen.renderer = (Renderer)Screen3D.deviceRendererMap.get(this.screen.graphicsDevice);
            }
            if (Thread.currentThread() == this.screen.renderer) {
                J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
                j3dMessage.threads = 16;
                j3dMessage.type = 42;
                j3dMessage.universe = this.view.universe;
                j3dMessage.view = this.view;
                j3dMessage.args[0] = this;
                this.screen.renderer.rendererStructure.addMessage(j3dMessage);
                this.screen.renderer.args = new Object[4];
                this.screen.renderer.args[0] = new Integer(2);
                this.screen.renderer.args[1] = this;
                this.screen.renderer.args[2] = this.view;
                this.screen.renderer.args[3] = null;
                this.screen.renderer.doWork(0L);
            } else {
                J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
                j3dMessage.threads = 16;
                j3dMessage.type = 42;
                j3dMessage.universe = this.view.universe;
                j3dMessage.view = this.view;
                j3dMessage.args[0] = this;
                this.screen.renderer.rendererStructure.addMessage(j3dMessage);
                VirtualUniverse.mc.setWorkForRequestRenderer();
            }
        } else if (Thread.currentThread() instanceof BehaviorScheduler) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 16;
            j3dMessage.type = 42;
            j3dMessage.universe = this.view.universe;
            j3dMessage.view = this.view;
            j3dMessage.args[0] = this;
            this.screen.renderer.rendererStructure.addMessage(j3dMessage);
            VirtualUniverse.mc.setWorkForRequestRenderer();
        } else {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 42;
            j3dMessage.universe = this.view.universe;
            j3dMessage.view = this.view;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = this.offScreenBuffer;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    public void waitForOffScreenRendering() {
        while (this.offScreenRendering) {
            MasterControl.threadYield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffScreenLocation(int n, int n2) {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        Object object = this.cvLock;
        synchronized (object) {
            this.offScreenCanvasLoc.setLocation(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffScreenLocation(Point point) {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        Object object = this.cvLock;
        synchronized (object) {
            this.offScreenCanvasLoc.setLocation(point);
        }
    }

    public Point getOffScreenLocation() {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        return new Point(this.offScreenCanvasLoc);
    }

    public Point getOffScreenLocation(Point point) {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        if (point == null) {
            return new Point(this.offScreenCanvasLoc);
        }
        point.setLocation(this.offScreenCanvasLoc);
        return point;
    }

    void endOffScreenRendering() {
        if (((ImageComponent2DRetained)this.offScreenBuffer.retained).isByReference()) {
            ((ImageComponent2DRetained)this.offScreenBuffer.retained).geomLock.getLock();
            ((ImageComponent2DRetained)this.offScreenBuffer.retained).evaluateExtensions(this.extensionsSupported);
            ((ImageComponent2DRetained)this.offScreenBuffer.retained).geomLock.unLock();
        }
        int n = ((ImageComponent2DRetained)this.offScreenBuffer.retained).getEffectiveBytesPerPixel();
        int n2 = ((ImageComponent2DRetained)this.offScreenBuffer.retained).getEffectiveFormat();
        int n3 = this.offScreenCanvasSize.width * this.offScreenCanvasSize.height * n;
        if (this.byteBuffer.length < n3) {
            this.byteBuffer = new byte[n3];
        }
        this.readOffScreenBuffer(this.ctx, n2, this.offScreenCanvasSize.width, this.offScreenCanvasSize.height);
        ((ImageComponent2DRetained)this.offScreenBuffer.retained).retrieveImage(this.byteBuffer, this.offScreenCanvasClippedLoc.x, this.offScreenCanvasClippedLoc.y, this.offScreenCanvasClippedSize.width, this.offScreenCanvasClippedSize.height);
    }

    public void swap() {
        if (this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D14"));
        }
        if (this.isRunning) {
            throw new RestrictedAccessException(J3dI18N.getString("Canvas3D0"));
        }
        if (!this.firstPaintCalled) {
            return;
        }
        if (this.view != null && this.graphicsContext3D != null) {
            if (this.view.universe != null && Thread.currentThread() == this.view.universe.behaviorScheduler) {
                this.graphicsContext3D.sendRenderMessage(false, 2, null, null);
            } else {
                this.graphicsContext3D.sendRenderMessage(true, 2, null, null);
            }
            this.graphicsContext3D.runMonitor(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSwap() {
        block11: {
            if (this.firstPaintCalled && this.useDoubleBuffer) {
                try {
                    if (!this.validCtx || this.ctx == 0L || this.view == null) break block11;
                    DrawingSurfaceObject drawingSurfaceObject = this.drawingSurfaceObject;
                    synchronized (drawingSurfaceObject) {
                        if (this.validCtx) {
                            if (!this.drawingSurfaceObject.renderLock()) {
                                this.graphicsContext3D.runMonitor(2);
                                return;
                            }
                            this.syncRender(this.ctx, true);
                            int n = this.swapBuffers(this.ctx, this.screen.display, this.window);
                            if (n != 0) {
                                this.resetImmediateRendering(n);
                            }
                            this.drawingSurfaceObject.unLock();
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                    this.drawingSurfaceObject.unLock();
                }
            }
        }
        this.view.universe.behaviorStructure.incElapsedFrames();
        if (this.reEvaluateCanvasCmd != 0) {
            this.antialiasingSet = false;
            int n = this.reEvaluateCanvasCmd == 1 ? this.resizeD3DCanvas(this.ctx) : this.toggleFullScreenMode(this.ctx);
            if (n != 0) {
                this.resetImmediateRendering(n);
            }
            this.reEvaluateCanvasCmd = 0;
        }
        this.graphicsContext3D.runMonitor(2);
    }

    final void makeCtxCurrent() {
        this.makeCtxCurrent(this.ctx, this.screen.display, this.window);
    }

    final void makeCtxCurrent(long l) {
        this.makeCtxCurrent(l, this.screen.display, this.window);
    }

    final void makeCtxCurrent(long l, long l2, int n) {
        if (l != this.screen.renderer.currentCtx) {
            if (!this.drawingSurfaceObject.isLocked()) {
                this.drawingSurfaceObject.renderLock();
                Canvas3D.useCtx(l, l2, n);
                this.drawingSurfaceObject.unLock();
            } else {
                Canvas3D.useCtx(l, l2, n);
            }
            this.screen.renderer.currentCtx = l;
        }
    }

    static native void useCtx(long var0, long var2, int var4);

    native void clear(long var1, float var3, float var4, float var5, int var6, int var7, ImageComponent2DRetained var8, int var9, byte[] var10);

    native void textureclear(long var1, int var3, int var4, float var5, float var6, float var7, int var8, int var9, int var10, int var11, ImageComponent2DRetained var12, boolean var13);

    native int swapBuffers(long var1, long var3, int var5);

    native void videoResize(long var1, long var3, int var5, float var6);

    native void videoResizeCompensation(long var1, boolean var3);

    native void setModelViewMatrix(long var1, double[] var3, double[] var4);

    native void setProjectionMatrix(long var1, double[] var3);

    native void setViewport(long var1, int var3, int var4, int var5, int var6);

    native void newDisplayList(long var1, int var3);

    native void endDisplayList(long var1);

    native void callDisplayList(long var1, int var3, boolean var4);

    static native void freeDisplayList(long var0, int var2);

    static native void freeTexture(long var0, int var2);

    native void composite(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, byte[] var10, int var11, int var12);

    native void texturemapping(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, byte[] var14, int var15, int var16);

    native boolean initTexturemapping(long var1, int var3, int var4, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeftManualEyeInImagePlate(Point3d point3d) {
        this.leftManualEyeInImagePlate.set(point3d);
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask |= 4;
        }
        this.redraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRightManualEyeInImagePlate(Point3d point3d) {
        this.rightManualEyeInImagePlate.set(point3d);
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask |= 4;
        }
        this.redraw();
    }

    public void getLeftManualEyeInImagePlate(Point3d point3d) {
        point3d.set(this.leftManualEyeInImagePlate);
    }

    public void getRightManualEyeInImagePlate(Point3d point3d) {
        point3d.set(this.rightManualEyeInImagePlate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLeftEyeInImagePlate(Point3d point3d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                point3d.set(this.canvasViewCache.getLeftEyeInImagePlate());
            }
        } else {
            point3d.set(this.leftManualEyeInImagePlate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRightEyeInImagePlate(Point3d point3d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                point3d.set(this.canvasViewCache.getRightEyeInImagePlate());
            }
        } else {
            point3d.set(this.rightManualEyeInImagePlate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCenterEyeInImagePlate(Point3d point3d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                point3d.set(this.canvasViewCache.getCenterEyeInImagePlate());
            }
        } else {
            Point3d point3d2 = new Point3d();
            point3d2.add(this.leftManualEyeInImagePlate, this.rightManualEyeInImagePlate);
            point3d2.scale(0.5);
            point3d.set(point3d2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getImagePlateToVworld(Transform3D transform3D) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                transform3D.set(this.canvasViewCache.getImagePlateToVworld());
            }
        } else {
            transform3D.setIdentity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPixelLocationInImagePlate(int n, int n2, Point3d point3d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                point3d.x = this.canvasViewCache.getWindowXInImagePlate(n);
                point3d.y = this.canvasViewCache.getWindowYInImagePlate(n2);
                point3d.z = 0.0;
            }
        } else {
            point3d.set(0.0, 0.0, 0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getPixelLocationInImagePlate(double d, double d2, double d3, Point3d point3d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                this.canvasViewCache.getPixelLocationInImagePlate(d, d2, d3, point3d);
            }
        } else {
            point3d.set(0.0, 0.0, 0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPixelLocationInImagePlate(Point2d point2d, Point3d point3d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                point3d.x = this.canvasViewCache.getWindowXInImagePlate(point2d.x);
                point3d.y = this.canvasViewCache.getWindowYInImagePlate(point2d.y);
                point3d.z = 0.0;
            }
        } else {
            point3d.set(0.0, 0.0, 0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPixelLocationFromImagePlate(Point3d point3d, Point2d point2d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                this.canvasViewCache.getPixelLocationFromImagePlate(point3d, point2d);
            }
        } else {
            point2d.set(0.0, 0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getVworldProjection(Transform3D transform3D, Transform3D transform3D2) {
        if (this.canvasViewCache != null) {
            ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)this.view.getViewPlatform().retained;
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                transform3D.mul(this.canvasViewCache.getLeftProjection(), this.canvasViewCache.getLeftVpcToEc());
                transform3D.mul(viewPlatformRetained.getVworldToVpc());
                if (this.useStereo) {
                    transform3D2.mul(this.canvasViewCache.getRightProjection(), this.canvasViewCache.getRightVpcToEc());
                    transform3D2.mul(viewPlatformRetained.getVworldToVpc());
                } else {
                    transform3D2.set(transform3D);
                }
            }
        } else {
            transform3D.setIdentity();
            transform3D2.setIdentity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getInverseVworldProjection(Transform3D transform3D, Transform3D transform3D2) {
        if (this.canvasViewCache != null) {
            ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)this.view.getViewPlatform().retained;
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                transform3D.set(this.canvasViewCache.getLeftCcToVworld());
                if (this.useStereo) {
                    transform3D2.set(this.canvasViewCache.getRightCcToVworld());
                } else {
                    transform3D2.set(transform3D);
                }
            }
        } else {
            transform3D.setIdentity();
            transform3D2.setIdentity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPhysicalWidth() {
        double d = 0.0;
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                d = this.canvasViewCache.getPhysicalWindowWidth();
            }
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPhysicalHeight() {
        double d = 0.0;
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                d = this.canvasViewCache.getPhysicalWindowHeight();
            }
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getVworldToImagePlate(Transform3D transform3D) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                transform3D.set(this.canvasViewCache.getVworldToImagePlate());
            }
        } else {
            transform3D.setIdentity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getLastVworldToImagePlate(Transform3D transform3D) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                transform3D.set(this.canvasViewCache.getLastVworldToImagePlate());
            }
        } else {
            transform3D.setIdentity();
        }
    }

    void setView(View view) {
        this.pendingView = view;
        VirtualUniverse.mc.postRequest(MasterControl.SET_VIEW, this);
        this.evaluateActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeViewCache() {
        Object object = this.cvLock;
        synchronized (object) {
            if (this.view == null) {
                this.canvasViewCache = null;
            } else {
                this.canvasViewCache = new CanvasViewCache(this, this.screen.screenViewCache, this.view.viewCache);
                Object object2 = this.dirtyMaskLock;
                synchronized (object2) {
                    this.cvDirtyMask = 15;
                }
            }
        }
    }

    public View getView() {
        return this.pendingView;
    }

    public boolean getStereoAvailable() {
        return (Boolean)this.queryProperties().get("stereoAvailable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStereoEnable(boolean bl) {
        this.stereoEnable = bl;
        this.useStereo = this.stereoEnable && this.stereoAvailable;
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask |= 1;
        }
        this.redraw();
    }

    public boolean getStereoEnable() {
        return this.stereoEnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMonoscopicViewPolicy(int n) {
        if (this.view != null && this.view.viewPolicy == 1 && this.monoscopicViewPolicy == 2 && !this.useStereo) {
            throw new IllegalStateException(J3dI18N.getString("View31"));
        }
        this.monoscopicViewPolicy = n;
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask |= 2;
        }
        this.redraw();
    }

    public int getMonoscopicViewPolicy() {
        return this.monoscopicViewPolicy;
    }

    public boolean getDoubleBufferAvailable() {
        return (Boolean)this.queryProperties().get("doubleBufferAvailable");
    }

    public void setDoubleBufferEnable(boolean bl) {
        this.doubleBufferEnable = bl;
        boolean bl2 = this.useDoubleBuffer = this.doubleBufferEnable && this.doubleBufferAvailable;
        if (Thread.currentThread() == this.screen.renderer) {
            this.setRenderMode(this.ctx, 2, this.useDoubleBuffer);
        }
        this.redraw();
    }

    public boolean getDoubleBufferEnable() {
        return this.doubleBufferEnable;
    }

    public boolean getSceneAntialiasingAvailable() {
        return (Boolean)this.queryProperties().get("sceneAntialiasingAvailable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map queryProperties() {
        if (this.queryProps == null) {
            boolean bl = false;
            Object object = VirtualUniverse.mc.contextCreationLock;
            synchronized (object) {
                if (this.ctx == 0L) {
                    bl = true;
                }
            }
            if (bl) {
                GraphicsConfigTemplate3D.setQueryProps(this);
            }
            this.createQueryProps();
        }
        return this.queryProps;
    }

    void createQueryContext() {
        this.createQueryContext(this.screen.display, this.window, this.vid, this.offScreen, 10, 10);
    }

    private void createQueryProps() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        int n = 0;
        arrayList.add("doubleBufferAvailable");
        arrayList2.add(new Boolean(this.doubleBufferAvailable));
        arrayList.add("stereoAvailable");
        arrayList2.add(new Boolean(this.stereoAvailable));
        arrayList.add("sceneAntialiasingAvailable");
        arrayList2.add(new Boolean(this.sceneAntialiasingAvailable));
        arrayList.add("sceneAntialiasingNumPasses");
        if (this.sceneAntialiasingAvailable) {
            n = this.sceneAntialiasingMultiSamplesAvailable ? 1 : 8;
        }
        arrayList2.add(new Integer(n));
        arrayList.add("compressedGeometry.majorVersionNumber");
        arrayList2.add(new Integer(1));
        arrayList.add("compressedGeometry.minorVersionNumber");
        arrayList2.add(new Integer(0));
        arrayList.add("compressedGeometry.minorMinorVersionNumber");
        arrayList2.add(new Integer(2));
        arrayList.add("texture3DAvailable");
        arrayList2.add(new Boolean((this.textureExtendedFeatures & 1) != 0));
        arrayList.add("textureColorTableSize");
        arrayList2.add(new Integer(this.textureColorTableSize));
        arrayList.add("textureEnvCombineAvailable");
        arrayList2.add(new Boolean((this.textureExtendedFeatures & 8) != 0));
        arrayList.add("textureCombineDot3Available");
        arrayList2.add(new Boolean((this.textureExtendedFeatures & 0x10) != 0));
        arrayList.add("textureCombineSubtractAvailable");
        arrayList2.add(new Boolean((this.textureExtendedFeatures & 0x20) != 0));
        arrayList.add("textureCubeMapAvailable");
        arrayList2.add(new Boolean((this.textureExtendedFeatures & 0x80) != 0));
        arrayList.add("textureSharpenAvailable");
        arrayList2.add(new Boolean((this.textureExtendedFeatures & 0x100) != 0));
        arrayList.add("textureDetailAvailable");
        arrayList2.add(new Boolean((this.textureExtendedFeatures & 0x200) != 0));
        arrayList.add("textureFilter4Available");
        arrayList2.add(new Boolean((this.textureExtendedFeatures & 0x400) != 0));
        arrayList.add("textureAnisotropicFilterDegreeMax");
        arrayList2.add(new Float(this.anisotropicDegreeMax));
        arrayList.add("textureWidthMax");
        arrayList2.add(new Integer(this.textureWidthMax));
        arrayList.add("textureHeightMax");
        arrayList2.add(new Integer(this.textureHeightMax));
        arrayList.add("textureBoundaryWidthMax");
        arrayList2.add(new Integer(this.textureBoundaryWidthMax));
        arrayList.add("textureLodRangeAvailable");
        arrayList2.add(new Boolean((this.textureExtendedFeatures & 0x1000) != 0));
        arrayList.add("textureLodOffsetAvailable");
        arrayList2.add(new Boolean((this.textureExtendedFeatures & 0x2000) != 0));
        arrayList.add("textureUnitStateMax");
        arrayList2.add(new Integer(this.numTexUnitSupported));
        arrayList.add("native.version");
        if (this.nativeGraphicsVersion == null) {
            this.nativeGraphicsVersion = "";
        }
        arrayList2.add(this.nativeGraphicsVersion);
        this.queryProps = new J3dQueryProps(arrayList.toArray(new String[0]), arrayList2.toArray());
    }

    native void setRenderMode(long var1, int var3, boolean var4);

    native void setDepthBufferWriteEnable(long var1, boolean var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateViewCache(boolean bl, CanvasViewCache canvasViewCache, BoundingBox boundingBox, boolean bl2) {
        Object object = this.cvLock;
        synchronized (object) {
            if (this.firstPaintCalled && this.canvasViewCache != null) {
                this.canvasViewCache.snapshot();
                this.canvasViewCache.computeDerivedData(bl, canvasViewCache, boundingBox, bl2);
            }
        }
    }

    void setDepthBufferWriteEnableOverride(boolean bl) {
        this.depthBufferWriteEnableOverride = bl;
    }

    void setDepthBufferEnableOverride(boolean bl) {
        this.depthBufferEnableOverride = bl;
    }

    void resetTexture(long l, int n) {
        this.resetTextureNative(l, n);
        if (n < 0) {
            n = 0;
        }
        this.texUnitState[n].mirror = null;
        this.texUnitState[n].texture = null;
        if (VirtualUniverse.mc.isD3D()) {
            this.texUnitState[n].texAttrs = null;
            this.texUnitState[n].texGen = null;
        }
    }

    void resetTextureBin() {
        if (this.graphics2D != null && this.graphics2D.objectId != -1) {
            VirtualUniverse.mc.freeTexture2DId(this.graphics2D.objectId);
            this.graphics2D.objectId = -1;
        }
        int n = this.textureIDResourceTable.size() - 1;
        while (n > 0) {
            Object e = this.textureIDResourceTable.get(n);
            if (e != null) {
                if (e instanceof TextureRetained) {
                    TextureRetained textureRetained = (TextureRetained)e;
                    textureRetained.resourceCreationMask &= ~this.canvasBit;
                } else {
                    DetailTextureImage detailTextureImage = (DetailTextureImage)e;
                    int n2 = 0;
                    while (n2 < detailTextureImage.resourceCreationMask.length) {
                        int n3 = n2++;
                        detailTextureImage.resourceCreationMask[n3] = detailTextureImage.resourceCreationMask[n3] & ~this.canvasBit;
                    }
                }
            }
            --n;
        }
    }

    void d3dResize() {
        int n = this.resizeD3DCanvas(this.ctx);
        this.antialiasingSet = false;
        if (n != 0) {
            this.resetRendering(n);
        }
    }

    void d3dToggle() {
        int n = this.toggleFullScreenMode(this.ctx);
        this.antialiasingSet = false;
        if (n != 0) {
            this.resetRendering(n);
        }
    }

    void notifyD3DPeer(int n) {
        if (this.active) {
            if (this.isRunning) {
                if (this.view != null && this.view.active && this.screen.renderer != null) {
                    VirtualUniverse.mc.postRequest(MasterControl.STOP_RENDERER, this);
                    while (this.isRunningStatus) {
                        MasterControl.threadYield();
                    }
                    J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
                    j3dMessage.threads = 16;
                    j3dMessage.type = n == 1 ? 52 : 53;
                    j3dMessage.universe = null;
                    j3dMessage.view = null;
                    j3dMessage.args[0] = this;
                    this.screen.renderer.rendererStructure.addMessage(j3dMessage);
                    VirtualUniverse.mc.postRequest(MasterControl.START_RENDERER, this);
                    VirtualUniverse.mc.sendRunMessage(this.view, 16);
                }
            } else {
                this.reEvaluateCanvasCmd = n;
            }
        }
    }

    void resetRendering(int n) {
        if (n == 2) {
            this.resetTextureBin();
            this.screen.renderer.needToResendTextureDown = true;
        }
        this.reset();
        this.cvDirtyMask |= 0x3F;
        this.needToRebuildDisplayList = true;
        this.ctxTimeStamp = VirtualUniverse.mc.getContextTimeStamp();
    }

    void reset() {
        int n;
        this.byteBuffer = new byte[1];
        this.currentAppear = new AppearanceRetained();
        this.currentMaterial = new MaterialRetained();
        this.viewFrustum = new CachedFrustum();
        this.canvasDirty = 65535;
        this.lightBin = null;
        this.environmentSet = null;
        this.attributeBin = null;
        this.textureBin = null;
        this.renderMolecule = null;
        this.polygonAttributes = null;
        this.lineAttributes = null;
        this.pointAttributes = null;
        this.material = null;
        this.enableLighting = false;
        this.transparency = null;
        this.coloringAttributes = null;
        this.texture = null;
        this.texAttrs = null;
        if (this.texUnitState != null) {
            n = 0;
            while (n < this.texUnitState.length) {
                TextureUnitStateRetained textureUnitStateRetained = this.texUnitState[n];
                if (textureUnitStateRetained != null) {
                    textureUnitStateRetained.texAttrs = null;
                    textureUnitStateRetained.texGen = null;
                }
                ++n;
            }
        }
        this.texCoordGeneration = null;
        this.renderingAttrs = null;
        this.appearance = null;
        this.appHandle = null;
        this.dirtyRenderMoleculeList.clear();
        this.displayListResourceFreeList.clear();
        this.dirtyDlistPerRinfoList.clear();
        this.textureIdResourceFreeList.clear();
        this.lightChanged = true;
        this.modelMatrix = null;
        this.modelClip = null;
        this.fog = null;
        this.texLinearMode = false;
        this.sceneAmbient = new Color3f();
        n = 0;
        while (n < this.frameCount.length) {
            this.frameCount[n] = -1;
            ++n;
        }
        n = 0;
        while (n < this.lights.length) {
            this.lights[n] = null;
            ++n;
        }
        if (this.currentLights != null) {
            n = 0;
            while (n < this.currentLights.length) {
                this.currentLights[n] = null;
                ++n;
            }
        }
        this.enableMask = -1L;
        this.stateUpdateMask = 0;
        this.depthBufferWriteEnableOverride = false;
        this.depthBufferEnableOverride = false;
        this.depthBufferWriteEnable = true;
        this.vfPlanesValid = false;
        this.lightChanged = false;
        n = 0;
        while (n < this.curStateToUpdate.length) {
            this.curStateToUpdate[n] = null;
            ++n;
        }
    }

    void resetImmediateRendering(int n) {
        this.canvasDirty = 65535;
        this.ra = null;
        this.setSceneAmbient(this.ctx, 0.0f, 0.0f, 0.0f);
        this.disableFog(this.ctx);
        this.resetRenderingAttributes(this.ctx, false, false);
        this.resetTexture(this.ctx, -1);
        this.resetTexCoordGeneration(this.ctx);
        this.resetTextureAttributes(this.ctx);
        this.texUnitState[0].texAttrs = null;
        this.texUnitState[0].texGen = null;
        this.resetPolygonAttributes(this.ctx);
        this.resetLineAttributes(this.ctx);
        this.resetPointAttributes(this.ctx);
        this.resetTransparency(this.ctx, 4, 2, false, false);
        this.resetColoringAttributes(this.ctx, 1.0f, 1.0f, 1.0f, 1.0f, false);
        this.updateMaterial(this.ctx, 1.0f, 1.0f, 1.0f, 1.0f);
        this.resetRendering(0);
        this.makeCtxCurrent();
        this.cvDirtyMask |= 0x3F;
        this.needToRebuildDisplayList = true;
        this.ctxTimeStamp = VirtualUniverse.mc.getContextTimeStamp();
        if (n == 2) {
            this.screen.renderer.needToResendTextureDown = true;
        }
    }

    public Dimension getSize() {
        if (!this.fullScreenMode) {
            return super.getSize();
        }
        return new Dimension(this.fullscreenWidth, this.fullscreenHeight);
    }

    public Dimension getSize(Dimension dimension) {
        if (!this.fullScreenMode) {
            return super.getSize(dimension);
        }
        if (dimension == null) {
            return new Dimension(this.fullscreenWidth, this.fullscreenHeight);
        }
        dimension.setSize(this.fullscreenWidth, this.fullscreenHeight);
        return dimension;
    }

    public Point getLocationOnScreen() {
        if (!this.fullScreenMode) {
            try {
                return super.getLocationOnScreen();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
        return new Point();
    }

    public int getX() {
        if (!this.fullScreenMode) {
            return super.getX();
        }
        return 0;
    }

    public int getY() {
        if (!this.fullScreenMode) {
            return super.getY();
        }
        return 0;
    }

    public int getWidth() {
        if (!this.fullScreenMode) {
            return super.getWidth();
        }
        return this.screen.screenSize.width;
    }

    public int getHeight() {
        if (!this.fullScreenMode) {
            return super.getHeight();
        }
        return this.screen.screenSize.height;
    }

    public Point getLocation(Point point) {
        if (!this.fullScreenMode) {
            return super.getLocation(point);
        }
        if (point != null) {
            point.setLocation(0, 0);
            return point;
        }
        return new Point();
    }

    public Point getLocation() {
        if (!this.fullScreenMode) {
            return super.getLocation();
        }
        return new Point();
    }

    public Rectangle getBounds() {
        if (!this.fullScreenMode) {
            return super.getBounds();
        }
        return new Rectangle(0, 0, this.screen.screenSize.width, this.screen.screenSize.height);
    }

    public Rectangle getBounds(Rectangle rectangle) {
        if (!this.fullScreenMode) {
            return super.getBounds(rectangle);
        }
        if (rectangle != null) {
            rectangle.setBounds(0, 0, this.screen.screenSize.width, this.screen.screenSize.height);
            return rectangle;
        }
        return new Rectangle(0, 0, this.screen.screenSize.width, this.screen.screenSize.height);
    }

    void setModelViewMatrix(long l, double[] dArray, Transform3D transform3D) {
        this.setModelViewMatrix(l, dArray, transform3D.mat);
        if (!this.useStereo) {
            this.modelMatrix = transform3D;
        } else if (this.rightStereoPass) {
            this.modelMatrix = transform3D;
        }
    }

    void setDepthBufferWriteEnable(boolean bl) {
        this.depthBufferWriteEnable = bl;
        this.setDepthBufferWriteEnable(this.ctx, bl);
    }

    void setTexUnitStateMap(int n, int n2) {
        this.texUnitStateMap[n2] = n;
    }

    void setNumActiveTexUnit(int n) {
        this.numActiveTexUnit = n;
    }

    int getNumActiveTexUnit() {
        return this.numActiveTexUnit;
    }

    void setLastActiveTexUnit(int n) {
        this.lastActiveTexUnit = n;
    }

    int getLastActiveTexUnit() {
        return this.lastActiveTexUnit;
    }

    void updateTexUnitStateMap() {
        this.updateTexUnitStateMap(this.ctx, this.numActiveTexUnit, this.texUnitStateMap);
    }

    boolean supportGlobalAlpha() {
        return (this.extensionsSupported & 1) != 0;
    }

    boolean supportVideoResize() {
        return (this.extensionsSupported & 0x800) != 0;
    }

    void enableSeparateSpecularColor() {
        if ((this.extensionsSupported & 0x80) != 0 && !VirtualUniverse.mc.disableSeparateSpecularColor) {
            this.updateSeparateSpecularColorEnable(this.ctx, true);
        }
    }

    final void beginScene() {
        this.beginScene(this.ctx);
    }

    final void endScene() {
        this.endScene(this.ctx);
    }

    void removeCtx(boolean bl) {
        if (this.screen != null && this.screen.renderer != null && this.ctx != 0L) {
            VirtualUniverse.mc.postRequest(MasterControl.FREE_CONTEXT, new Object[]{this, new Long(this.screen.display), new Integer(this.window), new Long(this.ctx)});
            if (!bl) {
                while (this.ctxTimeStamp != 0L) {
                    MasterControl.threadYield();
                }
            }
            this.ctx = 0L;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new UnsupportedOperationException(J3dI18N.getString("Canvas3D20"));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException(J3dI18N.getString("Canvas3D20"));
    }

    void setStateIsUpdated(int n) {
        this.stateUpdateMask &= ~(1 << n);
    }

    void setStateToUpdate(int n) {
        this.stateUpdateMask |= 1 << n;
    }

    void setStateToUpdate(int n, Object object) {
        this.stateUpdateMask |= 1 << n;
        this.curStateToUpdate[n] = object;
    }

    void updateEnvState() {
        if ((this.stateUpdateMask & ENV_STATE_MASK) == 0) {
            return;
        }
        if ((this.stateUpdateMask & 1) != 0) {
            ((LightBin)this.curStateToUpdate[0]).updateAttributes(this);
        }
        if ((this.stateUpdateMask & 2) != 0) {
            ((EnvironmentSet)this.curStateToUpdate[1]).updateAttributes(this);
        }
        if ((this.stateUpdateMask & 4) != 0) {
            ((AttributeBin)this.curStateToUpdate[2]).updateAttributes(this);
        }
        this.stateUpdateMask &= ~ENV_STATE_MASK;
    }

    void updateState(int n, int n2) {
        if (this.stateUpdateMask == 0) {
            return;
        }
        this.updateEnvState();
        if ((this.stateUpdateMask & 8) != 0) {
            ((TextureBin)this.curStateToUpdate[3]).updateAttributes(this, n);
        }
        if ((this.stateUpdateMask & 0x10) != 0) {
            ((RenderMolecule)this.curStateToUpdate[4]).updateAttributes(this, n2);
        }
        if ((this.stateUpdateMask & 0x20) != 0) {
            ((RenderMolecule)this.curStateToUpdate[4]).updateTransparencyAttributes(this);
            this.stateUpdateMask &= 0xFFFFFFDF;
        }
        this.stateUpdateMask = 0;
    }

    void addTextureResource(int n, Object object) {
        if (n <= 0) {
            return;
        }
        if (this.useSharedCtx) {
            this.screen.renderer.addTextureResource(n, object);
        } else if (this.textureIDResourceTable.size() <= n) {
            int n2 = this.textureIDResourceTable.size();
            while (n2 < n) {
                this.textureIDResourceTable.add(null);
                ++n2;
            }
            this.textureIDResourceTable.add(object);
        } else {
            this.textureIDResourceTable.set(n, object);
        }
    }

    void freeResourcesInFreeList(long l) {
        int n;
        Iterator iterator2;
        if (this.displayListResourceFreeList.size() > 0) {
            iterator2 = this.displayListResourceFreeList.iterator();
            while (iterator2.hasNext()) {
                n = (Integer)iterator2.next();
                if (n <= 0) continue;
                Canvas3D.freeDisplayList(l, n);
            }
            this.displayListResourceFreeList.clear();
        }
        if (this.textureIdResourceFreeList.size() > 0) {
            iterator2 = this.textureIdResourceFreeList.iterator();
            while (iterator2.hasNext()) {
                n = (Integer)iterator2.next();
                if (n <= 0) continue;
                if (n >= this.textureIDResourceTable.size()) {
                    System.out.println("Error in freeResourcesInFreeList : ResourceIDTableSize = " + this.textureIDResourceTable.size() + " val = " + n);
                } else {
                    this.textureIDResourceTable.set(n, null);
                }
                Canvas3D.freeTexture(l, n);
            }
            this.textureIdResourceFreeList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeContextResources(Renderer renderer, boolean bl, long l) {
        if (renderer == null) {
            return;
        }
        if (bl) {
            if (renderer.objectId > 0) {
                Canvas3D.freeTexture(l, renderer.objectId);
                VirtualUniverse.mc.freeTexture2DId(renderer.objectId);
                renderer.objectId = -1;
            }
            if (this.graphics2D != null && this.graphics2D.objectId != -1) {
                Canvas3D.freeTexture(l, this.graphics2D.objectId);
                VirtualUniverse.mc.freeTexture2DId(this.graphics2D.objectId);
                this.graphics2D.objectId = -1;
            }
        }
        int n = this.textureIDResourceTable.size() - 1;
        while (n > 0) {
            Object e = this.textureIDResourceTable.get(n);
            if (e != null) {
                Canvas3D.freeTexture(l, n);
                if (e instanceof TextureRetained) {
                    TextureRetained textureRetained = (TextureRetained)e;
                    Object object = textureRetained.resourceLock;
                    synchronized (object) {
                        textureRetained.resourceCreationMask &= ~this.canvasBit;
                        if (textureRetained.resourceCreationMask == 0) {
                            textureRetained.freeTextureId(n);
                        }
                    }
                } else if (e instanceof DetailTextureImage) {
                    DetailTextureImage detailTextureImage = (DetailTextureImage)e;
                    detailTextureImage.freeDetailTextureId(n, this.canvasBit);
                }
            }
            --n;
        }
        this.textureIDResourceTable.clear();
        this.freeAllDisplayListResources();
    }

    void freeAllDisplayListResources() {
        if (this.view != null && this.view.renderBin != null) {
            this.view.renderBin.freeAllDisplayListResources(this);
            if (this.useSharedCtx && this.screen != null && this.screen.renderer != null) {
                this.screen.renderer.needToRebuildDisplayList = true;
            }
        }
    }

    static {
        VirtualUniverse.loadLibraries();
        ENV_STATE_MASK = 7;
    }
}

