/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.Shape3DCompileRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.TransformGroupRetained;

class CompileState {
    HashMap knownAppearances = new HashMap();
    int numAppearances = 0;
    int numShared = 0;
    int numShapes = 0;
    HashMap shapeLists = null;
    int numMergeSets = 0;
    int numMergeShapes = 0;
    boolean compileVerbose = false;
    static final int BOUNDS_READ = 1;
    static final int GEOMETRY_READ = 2;
    boolean keepTG = false;
    boolean needNormalsTransform = false;
    TransformGroupRetained staticTransform = null;
    GroupRetained parentGroup = null;
    ArrayList transformGroupChildrenList = null;
    ArrayList staticTransformObjects = new ArrayList(1);
    int numTransformGroups = 0;
    int numStaticTransformGroups = 0;
    int numMergedTransformGroups = 0;
    int numGroups = 0;
    int numMergedGroups = 0;
    int numShapesWSharedGeom = 0;
    int numShapesWStaticTG = 0;
    int numLinks = 0;
    int numSwitches = 0;
    int numOrderedGroups = 0;
    int numMorphs = 0;

    CompileState() {
        try {
            this.compileVerbose = Boolean.getBoolean("javax.media.j3d.compileVerbose");
        }
        catch (AccessControlException accessControlException) {
            this.compileVerbose = false;
        }
        this.initShapeMerge();
    }

    AppearanceRetained getAppearance(AppearanceRetained appearanceRetained) {
        if (appearanceRetained.map == this && appearanceRetained.mapAppearance != null) {
            ++this.numShared;
            return appearanceRetained.mapAppearance;
        }
        AppearanceRetained appearanceRetained2 = (AppearanceRetained)this.knownAppearances.get(appearanceRetained);
        if (appearanceRetained2 != null) {
            ++this.numShared;
        } else {
            this.knownAppearances.put(appearanceRetained, appearanceRetained);
            ++this.numAppearances;
            ++this.numShared;
            appearanceRetained2 = appearanceRetained;
        }
        appearanceRetained.map = this;
        appearanceRetained.mapAppearance = appearanceRetained2;
        return appearanceRetained2;
    }

    private void initShapeMerge() {
        this.shapeLists = new HashMap();
    }

    void addShape(Shape3DRetained shape3DRetained) {
        if (this.parentGroup != null) {
            Vector<Shape3DRetained> vector = (Vector<Shape3DRetained>)this.shapeLists.get(shape3DRetained.appearance);
            if (vector == null) {
                vector = new Vector<Shape3DRetained>();
                this.shapeLists.put(shape3DRetained.appearance, vector);
            }
            GeometryRetained geometryRetained = null;
            int n = 0;
            while (geometryRetained == null && n < shape3DRetained.geometryList.size()) {
                geometryRetained = (GeometryRetained)shape3DRetained.geometryList.get(n);
                ++n;
            }
            if (shape3DRetained.parent instanceof GroupRetained && ((GroupRetained)shape3DRetained.parent).isStaticChildren() && geometryRetained.geoType < 15) {
                vector.add(shape3DRetained);
            }
        }
    }

    void printStats() {
        System.out.println("numTransformGroups= " + this.numTransformGroups);
        System.out.println("numStaticTransformGroups= " + this.numStaticTransformGroups);
        System.out.println("numMergedTransformGroups= " + this.numMergedTransformGroups);
        System.out.println("numGroups= " + this.numGroups);
        System.out.println("numMergedGroups= " + this.numMergedGroups);
        System.out.println("numShapes= " + this.numShapes);
        System.out.println("numShapesWStaticTG= " + this.numShapesWStaticTG);
        System.out.println("numMergeShapes= " + this.numMergeShapes);
        System.out.println("numMergeSets= " + this.numMergeSets);
        System.out.println("numLinks= " + this.numLinks);
        System.out.println("numSwitches= " + this.numSwitches);
        System.out.println("numOrderedGroups= " + this.numOrderedGroups);
        System.out.println("numMorphs= " + this.numMorphs);
    }

    void doShapeMerge() {
        if (this.shapeLists != null) {
            Collection collection = this.shapeLists.values();
            Iterator iterator2 = collection.iterator();
            int n = 0;
            int n2 = 0;
            while (iterator2.hasNext()) {
                Vector vector = (Vector)iterator2.next();
                int n3 = vector.size();
                Object[] objectArray = new Shape3DRetained[n3];
                vector.copyInto(objectArray);
                Shape3DRetained[] shape3DRetainedArray = new Shape3DRetained[n3];
                int n4 = 0;
                while (n4 < n3) {
                    if (objectArray[n4] != null) {
                        GeometryRetained geometryRetained = null;
                        n = 0;
                        while (geometryRetained == null && n < ((Shape3DRetained)objectArray[n4]).geometryList.size()) {
                            geometryRetained = (GeometryRetained)((Shape3DRetained)objectArray[n4]).geometryList.get(n);
                            ++n;
                        }
                        if (geometryRetained != null && geometryRetained instanceof GeometryArrayRetained) {
                            int n5 = 0;
                            Object object = objectArray[n4];
                            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)geometryRetained;
                            shape3DRetainedArray[n5++] = object;
                            n2 = this.getCompileFlags((Shape3DRetained)object);
                            int n6 = n4 + 1;
                            while (n6 < n3) {
                                if (objectArray[n6] != null) {
                                    geometryRetained = null;
                                    n = 0;
                                    while (geometryRetained == null && n < ((Shape3DRetained)objectArray[n6]).geometryList.size()) {
                                        geometryRetained = (GeometryRetained)((Shape3DRetained)objectArray[n6]).geometryList.get(n);
                                        ++n;
                                    }
                                    if (geometryRetained != null && ((Shape3DRetained)objectArray[n6]).isEquivalent((Shape3DRetained)object) && geometryRetained.isEquivalenceClass(geometryArrayRetained) && ((GeometryArrayRetained)geometryRetained).vertexFormat == geometryArrayRetained.vertexFormat) {
                                        shape3DRetainedArray[n5++] = objectArray[n6];
                                        n2 |= this.getCompileFlags((Shape3DRetained)objectArray[n6]);
                                        objectArray[n6] = null;
                                    }
                                }
                                ++n6;
                            }
                            if (n5 > 1) {
                                GroupRetained groupRetained = (GroupRetained)shape3DRetainedArray[0].parent;
                                int n7 = 0;
                                while (n7 < n5) {
                                    Shape3DRetained shape3DRetained = shape3DRetainedArray[n7];
                                    boolean bl = false;
                                    int n8 = groupRetained.numChildren();
                                    int n9 = 0;
                                    while (n9 < n8 && !bl) {
                                        if (groupRetained.getChild((int)n9).retained == shape3DRetained) {
                                            bl = true;
                                            groupRetained.removeChild(n9);
                                        }
                                        ++n9;
                                    }
                                    if (!bl) {
                                        System.out.println("ShapeSet.add(): Can't remove shape from parent, can't find shape!");
                                    }
                                    ++n7;
                                }
                                object = new Shape3DCompileRetained(shape3DRetainedArray, n5, n2);
                                ((SceneGraphObjectRetained)object).setSource(shape3DRetainedArray[0].source);
                                ++this.numMergeSets;
                                this.numMergeShapes += n5;
                                this.parentGroup.addChild((Node)((Shape3DRetained)object).source);
                            }
                        }
                    }
                    ++n4;
                }
            }
        }
        this.shapeLists.clear();
    }

    int getCompileFlags(Shape3DRetained shape3DRetained) {
        int n = 0;
        if (shape3DRetained.allowIntersect() || shape3DRetained.source.getCapability(12) || shape3DRetained.boundsAutoCompute && shape3DRetained.source.getCapability(3)) {
            n |= 2;
        }
        return n;
    }
}

