/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.vecmath.Point3d;

public class CompressedGeometryHeader {
    public static final int POINT_BUFFER = 0;
    public static final int LINE_BUFFER = 1;
    public static final int TRIANGLE_BUFFER = 2;
    public static final int NORMAL_IN_BUFFER = 1;
    public static final int COLOR_IN_BUFFER = 2;
    public static final int ALPHA_IN_BUFFER = 4;
    public int majorVersionNumber;
    public int minorVersionNumber;
    public int minorMinorVersionNumber;
    public int bufferType;
    public int bufferDataPresent;
    public int size;
    public int start;
    public Point3d lowerBound = null;
    public Point3d upperBound = null;

    void copy(CompressedGeometryHeader compressedGeometryHeader) {
        compressedGeometryHeader.majorVersionNumber = this.majorVersionNumber;
        compressedGeometryHeader.minorVersionNumber = this.minorVersionNumber;
        compressedGeometryHeader.minorMinorVersionNumber = this.minorMinorVersionNumber;
        compressedGeometryHeader.bufferType = this.bufferType;
        compressedGeometryHeader.bufferDataPresent = this.bufferDataPresent;
        compressedGeometryHeader.size = this.size;
        compressedGeometryHeader.start = this.start;
        compressedGeometryHeader.lowerBound = this.lowerBound;
        compressedGeometryHeader.upperBound = this.upperBound;
    }

    public String toString() {
        String string2 = "UNKNOWN";
        switch (this.bufferType) {
            case 0: {
                string2 = "POINT_BUFFER";
                break;
            }
            case 1: {
                string2 = "LINE_BUFFER";
                break;
            }
            case 2: {
                string2 = "TRIANGLE_BUFFER";
            }
        }
        String string3 = "";
        if ((this.bufferDataPresent & 1) != 0) {
            string3 = string3 + "NORMALS ";
        }
        if ((this.bufferDataPresent & 2) != 0) {
            string3 = string3 + "COLORS ";
        }
        if ((this.bufferDataPresent & 4) != 0) {
            string3 = string3 + "ALPHA ";
        }
        String string4 = "null";
        if (this.lowerBound != null) {
            string4 = this.lowerBound.toString();
        }
        String string5 = "null";
        if (this.upperBound != null) {
            string5 = this.upperBound.toString();
        }
        return "majorVersionNumber: " + this.majorVersionNumber + "  " + "minorVersionNumber: " + this.minorVersionNumber + "  " + "minorMinorVersionNumber: " + this.minorMinorVersionNumber + "\n" + "bufferType: " + string2 + "  " + "bufferDataPresent: " + string3 + "\n" + "size: " + this.size + "  " + "start: " + this.start + "\n" + "lower bound: " + string4 + "\n" + "upper bound: " + string5 + "  ";
    }
}

