/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Arrays;
import javax.media.j3d.BHLeafInterface;
import javax.media.j3d.BHLeafNode;
import javax.media.j3d.BHNode;
import javax.media.j3d.BHTree;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BehaviorStructure;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.Locale;
import javax.media.j3d.MRSWLock;
import javax.media.j3d.NnuId;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.PickShape;
import javax.media.j3d.RenderBin;
import javax.media.j3d.UnorderList;
import javax.media.j3d.UpdateTargets;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupIndexedList;
import javax.media.j3d.WakeupOnCollisionEntry;
import javax.media.j3d.WakeupOnCollisionExit;
import javax.media.j3d.WakeupOnCollisionMovement;
import javax.vecmath.Vector3d;

class GeometryStructure
extends J3dStructure {
    UpdateTargets targets = null;
    private MRSWLock lock = null;
    private Object visLock = new Object();
    private Object collideListLock = new Object();
    private BHTree[] bhTreeArr = null;
    private int bhTreeCount = 0;
    private int bhTreeMax = 1;
    private int bhTreeBlockSize = 5;
    private BHNode[] bhNodeArr = null;
    private int bhNodeCount = 0;
    private int bhNodeMax;
    private int bhNodeBlockSize = 50;
    private Vector3d localeTrans = new Vector3d();
    WakeupIndexedList collideEntryList;
    WakeupIndexedList collideExitList;
    WakeupIndexedList collideMovementList;
    WakeupIndexedList wakeupOnCollisionEntry;
    WakeupIndexedList wakeupOnCollisionExit;
    WakeupIndexedList wakeupOnCollisionMovement;
    boolean reEvaluateWakeupCollisionGAs;
    private boolean transformMsg = false;
    static /* synthetic */ Class class$javax$media$j3d$WakeupOnCollisionEntry;
    static /* synthetic */ Class class$javax$media$j3d$WakeupOnCollisionExit;
    static /* synthetic */ Class class$javax$media$j3d$WakeupOnCollisionMovement;
    static /* synthetic */ Class class$javax$media$j3d$BHNode;

    GeometryStructure(VirtualUniverse virtualUniverse) {
        super(virtualUniverse, 64);
        this.bhNodeMax = this.bhNodeBlockSize;
        this.bhNodeArr = new BHNode[this.bhNodeMax];
        this.bhTreeArr = new BHTree[this.bhTreeMax];
        this.lock = new MRSWLock();
        this.collideEntryList = new WakeupIndexedList(class$javax$media$j3d$WakeupOnCollisionEntry == null ? (class$javax$media$j3d$WakeupOnCollisionEntry = GeometryStructure.class$("javax.media.j3d.WakeupOnCollisionEntry")) : class$javax$media$j3d$WakeupOnCollisionEntry, 1, virtualUniverse);
        this.collideExitList = new WakeupIndexedList(class$javax$media$j3d$WakeupOnCollisionExit == null ? (class$javax$media$j3d$WakeupOnCollisionExit = GeometryStructure.class$("javax.media.j3d.WakeupOnCollisionExit")) : class$javax$media$j3d$WakeupOnCollisionExit, 1, virtualUniverse);
        this.collideMovementList = new WakeupIndexedList(class$javax$media$j3d$WakeupOnCollisionMovement == null ? (class$javax$media$j3d$WakeupOnCollisionMovement = GeometryStructure.class$("javax.media.j3d.WakeupOnCollisionMovement")) : class$javax$media$j3d$WakeupOnCollisionMovement, 1, virtualUniverse);
        this.wakeupOnCollisionEntry = new WakeupIndexedList(class$javax$media$j3d$WakeupOnCollisionEntry == null ? (class$javax$media$j3d$WakeupOnCollisionEntry = GeometryStructure.class$("javax.media.j3d.WakeupOnCollisionEntry")) : class$javax$media$j3d$WakeupOnCollisionEntry, 0, virtualUniverse);
        this.wakeupOnCollisionExit = new WakeupIndexedList(class$javax$media$j3d$WakeupOnCollisionExit == null ? (class$javax$media$j3d$WakeupOnCollisionExit = GeometryStructure.class$("javax.media.j3d.WakeupOnCollisionExit")) : class$javax$media$j3d$WakeupOnCollisionExit, 0, virtualUniverse);
        this.wakeupOnCollisionMovement = new WakeupIndexedList(class$javax$media$j3d$WakeupOnCollisionMovement == null ? (class$javax$media$j3d$WakeupOnCollisionMovement = GeometryStructure.class$("javax.media.j3d.WakeupOnCollisionMovement")) : class$javax$media$j3d$WakeupOnCollisionMovement, 0, virtualUniverse);
    }

    void processMessages(long l) {
        Object[] objectArray = this.getMessages(l);
        int n = this.getNumMessage();
        if (n > 0) {
            this.reEvaluateWakeupCollisionGAs = false;
            int n2 = 0;
            while (n2 < n) {
                this.lock.writeLock();
                J3dMessage j3dMessage = objectArray[n2];
                switch (j3dMessage.type) {
                    case 3: {
                        this.transformMsg = true;
                        break;
                    }
                    case 27: {
                        this.processSwitchChanged(j3dMessage);
                        if (!this.universe.transformStructure.getLazyUpdate()) break;
                        this.transformMsg = true;
                        break;
                    }
                    case 0: {
                        this.insertNodes((Object[])j3dMessage.args[0]);
                        this.reEvaluateWakeupCollisionGAs = true;
                        break;
                    }
                    case 1: {
                        this.removeNodes(j3dMessage);
                        this.reEvaluateWakeupCollisionGAs = true;
                        break;
                    }
                    case 24: {
                        int n3 = (Integer)j3dMessage.args[1];
                        if (n3 == 1) {
                            j3dMessage.args[0] = j3dMessage.args[2];
                            this.removeNodes(j3dMessage);
                            this.insertNodes((Object[])j3dMessage.args[3]);
                            this.reEvaluateWakeupCollisionGAs = true;
                            break;
                        }
                        if (n3 != 2) break;
                        this.processVisibleChanged(j3dMessage.args[2], (GeometryAtom[])j3dMessage.args[3]);
                        break;
                    }
                    case 26: {
                        this.removeNodes(j3dMessage);
                        this.insertNodes((Object[])j3dMessage.args[1]);
                        break;
                    }
                    case 25: {
                        this.processBoundsChanged((Object[])j3dMessage.args[0], false);
                        break;
                    }
                    case 16: {
                        int n3 = (Integer)j3dMessage.args[1];
                        if (n3 == 1) {
                            this.processBoundsChanged((Object[])j3dMessage.args[3], false);
                            break;
                        }
                        if (n3 != 2) break;
                        this.processVisibleChanged(j3dMessage.args[2], (GeometryAtom[])j3dMessage.args[3]);
                        break;
                    }
                    case 35: 
                    case 37: {
                        this.processBoundsChanged((Object[])j3dMessage.args[0], false);
                        break;
                    }
                    case 17: {
                        this.processBoundsChanged((Object[])j3dMessage.args[0], false);
                        break;
                    }
                    case 10: {
                        this.processVisibleChanged(j3dMessage.args[2], (GeometryAtom[])j3dMessage.args[3]);
                    }
                }
                this.lock.writeUnlock();
                j3dMessage.decRefcount();
                ++n2;
            }
            if (this.transformMsg) {
                this.targets = this.universe.transformStructure.getTargetList();
                this.lock.writeLock();
                this.processTransformChanged(this.targets);
                this.lock.writeUnlock();
                this.transformMsg = false;
                this.targets = null;
            }
            Arrays.fill(objectArray, 0, n, null);
        }
        this.processCollisionDetection();
    }

    private int getBHTreeIndex(Locale locale) {
        int n = 0;
        while (n < this.bhTreeCount) {
            if (this.bhTreeArr[n].locale == locale) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int getOrAddBHTreeIndex(Locale locale) {
        int n = 0;
        while (n < this.bhTreeCount) {
            if (this.bhTreeArr[n].locale == locale) {
                return n;
            }
            ++n;
        }
        if (this.bhTreeCount >= this.bhTreeMax) {
            this.bhTreeMax += this.bhTreeBlockSize;
            BHTree[] bHTreeArray = this.bhTreeArr;
            this.bhTreeArr = new BHTree[this.bhTreeMax];
            System.arraycopy(bHTreeArray, 0, this.bhTreeArr, 0, bHTreeArray.length);
        }
        this.bhTreeArr[this.bhTreeCount] = new BHTree(locale);
        ++this.bhTreeCount;
        return n;
    }

    private void clearBhNodeArr() {
        this.bhNodeCount = 0;
    }

    private void addToBhNodeArr(BHNode bHNode) {
        if (this.bhNodeCount >= this.bhNodeMax) {
            this.bhNodeMax += this.bhNodeBlockSize;
            BHNode[] bHNodeArray = this.bhNodeArr;
            this.bhNodeArr = new BHNode[this.bhNodeMax];
            System.arraycopy(bHNodeArray, 0, this.bhNodeArr, 0, bHNodeArray.length);
        }
        this.bhNodeArr[this.bhNodeCount] = bHNode;
        ++this.bhNodeCount;
    }

    private void processVisibleChanged(Object object, GeometryAtom[] geometryAtomArray) {
        boolean bl = true;
        if (geometryAtomArray == null || geometryAtomArray.length < 1) {
            return;
        }
        int n = this.getBHTreeIndex(geometryAtomArray[0].locale);
        bl = (Boolean)object;
        int n2 = geometryAtomArray.length - 1;
        while (n2 >= 0) {
            geometryAtomArray[n2].visible = bl;
            --n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNodes(Object[] objectArray) {
        BHTree bHTree = null;
        this.clearBhNodeArr();
        int n = 0;
        while (n < objectArray.length) {
            Object object;
            Object object2;
            Object object3 = objectArray[n];
            if (object3 instanceof GeometryAtom) {
                object2 = object3;
                synchronized (object2) {
                    GeometryAtom geometryAtom = (GeometryAtom)object3;
                    if (geometryAtom.source.inBackgroundGroup) {
                        geometryAtom.source.geometryBackground.addBgGeometryAtomList(geometryAtom);
                    }
                    object = (BHLeafNode)VirtualUniverse.mc.getBHNode(2);
                    ((BHLeafNode)object).leafIF = geometryAtom;
                    geometryAtom.bhLeafNode = object;
                    ((BHLeafNode)object).computeBoundingHull();
                    this.addToBhNodeArr((BHNode)object);
                }
            } else if (object3 instanceof GroupRetained) {
                object2 = object3;
                synchronized (object2) {
                    object = (GroupRetained)object3;
                    BHLeafNode bHLeafNode = (BHLeafNode)VirtualUniverse.mc.getBHNode(2);
                    bHLeafNode.leafIF = object;
                    ((GroupRetained)object).bhLeafNode = bHLeafNode;
                    bHLeafNode.computeBoundingHull();
                    this.addToBhNodeArr(bHLeafNode);
                }
            }
            ++n;
        }
        if (this.bhNodeCount < 1) {
            return;
        }
        if (bHTree == null) {
            int n2 = this.getOrAddBHTreeIndex(((BHLeafNode)this.bhNodeArr[0]).getLocale());
            bHTree = this.bhTreeArr[n2];
        }
        bHTree.insert(this.bhNodeArr, this.bhNodeCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNodes(J3dMessage j3dMessage) {
        Object object;
        Object[] objectArray = (Object[])j3dMessage.args[0];
        BHTree bHTree = null;
        this.clearBhNodeArr();
        int n = 0;
        while (n < objectArray.length) {
            NnuId nnuId;
            Object object2 = objectArray[n];
            if (object2 instanceof GeometryAtom) {
                object = object2;
                synchronized (object) {
                    nnuId = (GeometryAtom)object2;
                    if (nnuId.source != null && nnuId.source.inBackgroundGroup) {
                        nnuId.source.geometryBackground.removeBgGeometryAtomList((GeometryAtom)nnuId);
                    }
                    if (nnuId.bhLeafNode != null) {
                        this.addToBhNodeArr(nnuId.bhLeafNode);
                        nnuId.bhLeafNode = null;
                    }
                }
            } else if (object2 instanceof GroupRetained) {
                if (((NodeRetained)object2).nodeType != 20) {
                    object = object2;
                    synchronized (object) {
                        nnuId = (GroupRetained)object2;
                        if (((GroupRetained)nnuId).bhLeafNode != null) {
                            this.addToBhNodeArr(((GroupRetained)nnuId).bhLeafNode);
                            ((GroupRetained)nnuId).bhLeafNode = null;
                        }
                    }
                }
            } else if (object2 instanceof BehaviorRetained) {
                object = object2;
                synchronized (object) {
                    nnuId = (BehaviorRetained)object2;
                    WakeupOnCollisionEntry[] wakeupOnCollisionEntryArray = (WakeupOnCollisionEntry[])this.collideEntryList.toArray();
                    int n2 = this.collideEntryList.arraySize() - 1;
                    while (n2 >= 0) {
                        WakeupOnCollisionEntry wakeupOnCollisionEntry = wakeupOnCollisionEntryArray[n2];
                        if (wakeupOnCollisionEntry.behav == nnuId) {
                            this.collideEntryList.remove(wakeupOnCollisionEntry);
                        }
                        --n2;
                    }
                    WakeupOnCollisionExit[] wakeupOnCollisionExitArray = (WakeupOnCollisionExit[])this.collideExitList.toArray();
                    int n3 = this.collideExitList.arraySize() - 1;
                    while (n3 >= 0) {
                        WakeupOnCollisionExit wakeupOnCollisionExit = wakeupOnCollisionExitArray[n3];
                        if (wakeupOnCollisionExit.behav == nnuId) {
                            this.collideExitList.remove(wakeupOnCollisionExit);
                        }
                        --n3;
                    }
                }
            }
            ++n;
        }
        if (this.bhNodeCount < 1) {
            return;
        }
        if (bHTree == null) {
            int n4 = this.getBHTreeIndex(((BHLeafNode)this.bhNodeArr[0]).getLocale());
            if (n4 < 0) {
                return;
            }
            bHTree = this.bhTreeArr[n4];
        }
        bHTree.delete(this.bhNodeArr, this.bhNodeCount);
        this.wakeupOnCollisionEntry.clearMirror();
        this.wakeupOnCollisionMovement.clearMirror();
        this.wakeupOnCollisionExit.clearMirror();
        object = this.collideListLock;
        synchronized (object) {
            this.collideEntryList.clearMirror();
            this.collideExitList.clearMirror();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBoundsChanged(Object[] objectArray, boolean bl) {
        this.clearBhNodeArr();
        int n = 0;
        while (n < objectArray.length) {
            Object object;
            Object object2;
            Object object3 = objectArray[n];
            if (object3 instanceof GeometryAtom) {
                object2 = object3;
                synchronized (object2) {
                    object = (GeometryAtom)object3;
                    if (((GeometryAtom)object).bhLeafNode != null) {
                        this.addToBhNodeArr(((GeometryAtom)object).bhLeafNode);
                    }
                }
            }
            if (object3 instanceof GroupRetained) {
                object2 = (GroupRetained)object3;
                if (((GroupRetained)object2).nodeType != 18) {
                    object = object3;
                    synchronized (object) {
                        if (((GroupRetained)object2).bhLeafNode != null) {
                            this.addToBhNodeArr(((GroupRetained)object2).bhLeafNode);
                        }
                    }
                }
            }
            ++n;
        }
        if (this.bhNodeCount < 1) {
            return;
        }
        int n2 = this.getBHTreeIndex(((BHLeafNode)this.bhNodeArr[0]).getLocale());
        if (n2 >= 0) {
            this.bhTreeArr[n2].boundsChanged(this.bhNodeArr, this.bhNodeCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTransformChanged(UpdateTargets updateTargets) {
        GeometryAtom geometryAtom;
        NnuId nnuId;
        int n;
        Object[] objectArray;
        int n2;
        Object[] objectArray2;
        int n3;
        this.clearBhNodeArr();
        UnorderList unorderList = updateTargets.targetList[0];
        if (unorderList != null) {
            n3 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            n2 = 0;
            while (n2 < n3) {
                objectArray = (Object[])objectArray2[n2];
                n = 0;
                while (n < objectArray.length) {
                    geometryAtom = nnuId = (GeometryAtom)objectArray[n];
                    synchronized (geometryAtom) {
                        if (nnuId.bhLeafNode != null) {
                            this.addToBhNodeArr(nnuId.bhLeafNode);
                        }
                    }
                    ++n;
                }
                ++n2;
            }
        }
        if ((unorderList = updateTargets.targetList[6]) != null) {
            n3 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            n2 = 0;
            while (n2 < n3) {
                objectArray = (Object[])objectArray2[n2];
                n = 0;
                while (n < objectArray.length) {
                    nnuId = (GroupRetained)objectArray[n];
                    if (((GroupRetained)nnuId).nodeType != 18) {
                        geometryAtom = nnuId;
                        synchronized (geometryAtom) {
                            if (((GroupRetained)nnuId).bhLeafNode != null) {
                                this.addToBhNodeArr(((GroupRetained)nnuId).bhLeafNode);
                            }
                        }
                    }
                    ++n;
                }
                ++n2;
            }
        }
        if (this.bhNodeCount < 1) {
            return;
        }
        int n4 = this.getBHTreeIndex(((BHLeafNode)this.bhNodeArr[0]).getLocale());
        if (n4 >= 0) {
            this.bhTreeArr[n4].boundsChanged(this.bhNodeArr, this.bhNodeCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getVisibleBHTrees(RenderBin renderBin, ArrayList arrayList, BoundingBox boundingBox, Locale locale, long l, boolean bl, int n) {
        boolean bl2 = true;
        this.lock.readLock();
        arrayList.clear();
        if (this.bhTreeCount == 1) {
            Object object = this.visLock;
            synchronized (object) {
                bl2 = this.bhTreeArr[0].getVisibleBHTrees(renderBin, arrayList, boundingBox, l, bl, n, true);
            }
        }
        BoundingBox boundingBox2 = new BoundingBox();
        Object object = this.visLock;
        synchronized (object) {
            int n2 = 0;
            while (n2 < this.bhTreeCount) {
                if (!locale.hiRes.equals(this.bhTreeArr[n2].locale.hiRes)) {
                    this.bhTreeArr[n2].locale.hiRes.difference(locale.hiRes, this.localeTrans);
                    boundingBox2.lower.x = boundingBox.lower.x + this.localeTrans.x;
                    boundingBox2.lower.y = boundingBox.lower.y + this.localeTrans.y;
                    boundingBox2.lower.z = boundingBox.lower.z + this.localeTrans.z;
                    boundingBox2.upper.x = boundingBox.upper.x + this.localeTrans.x;
                    boundingBox2.upper.y = boundingBox.upper.y + this.localeTrans.y;
                    boundingBox2.upper.z = boundingBox.upper.z + this.localeTrans.z;
                } else {
                    boundingBox.copy(boundingBox2);
                }
                if (!this.bhTreeArr[n2].getVisibleBHTrees(renderBin, arrayList, boundingBox2, l, bl, n, false)) {
                    bl2 = false;
                }
                ++n2;
            }
        }
        this.lock.readUnlock();
        return bl2;
    }

    GeometryAtom[] pickAll(Locale locale, PickShape pickShape) {
        UnorderList unorderList = new UnorderList(class$javax$media$j3d$BHNode == null ? (class$javax$media$j3d$BHNode = GeometryStructure.class$("javax.media.j3d.BHNode")) : class$javax$media$j3d$BHNode);
        unorderList.clear();
        this.lock.readLock();
        int n = this.getBHTreeIndex(locale);
        if (n < 0) {
            this.lock.readUnlock();
            return null;
        }
        this.bhTreeArr[n].select(pickShape, unorderList);
        this.lock.readUnlock();
        int n2 = unorderList.size();
        if (n2 < 1) {
            return null;
        }
        BHNode[] bHNodeArray = (BHNode[])unorderList.toArray(false);
        GeometryAtom[] geometryAtomArray = new GeometryAtom[n2];
        n = 0;
        while (n < n2) {
            geometryAtomArray[n] = (GeometryAtom)((BHLeafNode)bHNodeArray[n]).leafIF;
            ++n;
        }
        return geometryAtomArray;
    }

    GeometryAtom pickAny(Locale locale, PickShape pickShape) {
        BHNode bHNode = null;
        this.lock.readLock();
        int n = this.getBHTreeIndex(locale);
        if (n < 0) {
            this.lock.readUnlock();
            return null;
        }
        bHNode = this.bhTreeArr[n].selectAny(pickShape);
        this.lock.readUnlock();
        if (bHNode == null) {
            return null;
        }
        return (GeometryAtom)((BHLeafNode)bHNode).leafIF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWakeupOnCollision(WakeupOnCollisionEntry wakeupOnCollisionEntry) {
        Object object;
        boolean bl = true;
        Object object2 = this.collideListLock;
        synchronized (object2) {
            object = (WakeupOnCollisionEntry[])this.collideEntryList.toArray();
            int n = this.collideEntryList.arraySize() - 1;
            while (n >= 0) {
                WakeupOnCollisionEntry wakeupOnCollisionEntry2 = object[n];
                if (wakeupOnCollisionEntry2.behav == wakeupOnCollisionEntry.behav && wakeupOnCollisionEntry2.geometryAtoms == wakeupOnCollisionEntry.geometryAtoms) {
                    this.collideEntryList.remove(n);
                    bl = false;
                    break;
                }
                --n;
            }
        }
        this.wakeupOnCollisionEntry.add(wakeupOnCollisionEntry);
        wakeupOnCollisionEntry.updateCollisionBounds(false);
        object = this.collide(wakeupOnCollisionEntry.behav.locale, wakeupOnCollisionEntry.accuracyMode, wakeupOnCollisionEntry.geometryAtoms, wakeupOnCollisionEntry.vwcBounds, wakeupOnCollisionEntry.boundingLeaf, wakeupOnCollisionEntry.armingNode, null);
        if (object != null) {
            this.collideEntryList.add(wakeupOnCollisionEntry);
            wakeupOnCollisionEntry.setTarget((BHLeafInterface)object);
        }
        if (object != null && bl) {
            wakeupOnCollisionEntry.setTriggered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWakeupOnCollision(WakeupOnCollisionExit wakeupOnCollisionExit) {
        Object object;
        Object object2;
        boolean bl = true;
        Object object3 = this.collideListLock;
        synchronized (object3) {
            object2 = (WakeupOnCollisionExit[])this.collideExitList.toArray();
            int n = this.collideExitList.arraySize() - 1;
            while (n >= 0) {
                object = object2[n];
                if (((WakeupOnCollisionExit)object).behav == wakeupOnCollisionExit.behav && ((WakeupOnCollisionExit)object).geometryAtoms == wakeupOnCollisionExit.geometryAtoms) {
                    this.collideExitList.remove(n);
                    bl = false;
                    break;
                }
                --n;
            }
        }
        this.wakeupOnCollisionExit.add(wakeupOnCollisionExit);
        wakeupOnCollisionExit.updateCollisionBounds(false);
        object2 = this.collide(wakeupOnCollisionExit.behav.locale, wakeupOnCollisionExit.accuracyMode, wakeupOnCollisionExit.geometryAtoms, wakeupOnCollisionExit.vwcBounds, wakeupOnCollisionExit.boundingLeaf, wakeupOnCollisionExit.armingNode, null);
        if (object2 != null) {
            wakeupOnCollisionExit.setTarget((BHLeafInterface)object2);
            this.collideExitList.add(wakeupOnCollisionExit);
        }
        if (!bl) {
            return;
        }
        object = this.collideListLock;
        synchronized (object) {
            WakeupOnCollisionEntry[] wakeupOnCollisionEntryArray = (WakeupOnCollisionEntry[])this.collideEntryList.toArray();
            int n = this.collideEntryList.arraySize() - 1;
            while (n >= 0) {
                WakeupOnCollisionEntry wakeupOnCollisionEntry = wakeupOnCollisionEntryArray[n];
                if (wakeupOnCollisionEntry.behav == wakeupOnCollisionExit.behav && wakeupOnCollisionEntry.geometryAtoms == wakeupOnCollisionExit.geometryAtoms) {
                    if (object2 != null) break;
                    wakeupOnCollisionExit.setTriggered();
                    break;
                }
                --n;
            }
        }
    }

    void addWakeupOnCollision(WakeupOnCollisionMovement wakeupOnCollisionMovement) {
        this.wakeupOnCollisionMovement.add(wakeupOnCollisionMovement);
        wakeupOnCollisionMovement.updateCollisionBounds(false);
        BHLeafInterface bHLeafInterface = this.collide(wakeupOnCollisionMovement.behav.locale, wakeupOnCollisionMovement.accuracyMode, wakeupOnCollisionMovement.geometryAtoms, wakeupOnCollisionMovement.vwcBounds, wakeupOnCollisionMovement.boundingLeaf, wakeupOnCollisionMovement.armingNode, wakeupOnCollisionMovement);
        if (bHLeafInterface != null) {
            wakeupOnCollisionMovement.setTarget(bHLeafInterface);
            this.collideMovementList.add(wakeupOnCollisionMovement);
        }
    }

    void removeWakeupOnCollision(WakeupOnCollisionEntry wakeupOnCollisionEntry) {
        this.wakeupOnCollisionEntry.remove(wakeupOnCollisionEntry);
    }

    void removeWakeupOnCollision(WakeupOnCollisionExit wakeupOnCollisionExit) {
        this.wakeupOnCollisionExit.remove(wakeupOnCollisionExit);
    }

    void removeWakeupOnCollision(WakeupOnCollisionMovement wakeupOnCollisionMovement) {
        this.wakeupOnCollisionMovement.remove(wakeupOnCollisionMovement);
        this.collideMovementList.remove(wakeupOnCollisionMovement);
    }

    void processCollisionDetection() {
        int n;
        BHLeafInterface bHLeafInterface;
        WakeupOnCollisionEntry[] wakeupOnCollisionEntryArray = (WakeupOnCollisionEntry[])this.wakeupOnCollisionEntry.toArray();
        int n2 = this.wakeupOnCollisionEntry.arraySize() - 1;
        while (n2 >= 0) {
            WakeupOnCollisionEntry wakeupOnCollisionEntry = wakeupOnCollisionEntryArray[n2];
            wakeupOnCollisionEntry.updateCollisionBounds(this.reEvaluateWakeupCollisionGAs);
            bHLeafInterface = this.collide(wakeupOnCollisionEntry.behav.locale, wakeupOnCollisionEntry.accuracyMode, wakeupOnCollisionEntry.geometryAtoms, wakeupOnCollisionEntry.vwcBounds, wakeupOnCollisionEntry.boundingLeaf, wakeupOnCollisionEntry.armingNode, null);
            n = this.collideEntryList.indexOf(wakeupOnCollisionEntry);
            if (bHLeafInterface != null) {
                if (n < 0) {
                    this.collideEntryList.add(wakeupOnCollisionEntry);
                    wakeupOnCollisionEntry.setTarget(bHLeafInterface);
                    wakeupOnCollisionEntry.setTriggered();
                }
            } else if (n >= 0) {
                this.collideEntryList.remove(n);
            }
            --n2;
        }
        WakeupOnCollisionMovement[] wakeupOnCollisionMovementArray = (WakeupOnCollisionMovement[])this.wakeupOnCollisionMovement.toArray();
        n2 = this.wakeupOnCollisionMovement.arraySize() - 1;
        while (n2 >= 0) {
            WakeupOnCollisionMovement wakeupOnCollisionMovement = wakeupOnCollisionMovementArray[n2];
            wakeupOnCollisionMovement.updateCollisionBounds(this.reEvaluateWakeupCollisionGAs);
            bHLeafInterface = this.collide(wakeupOnCollisionMovement.behav.locale, wakeupOnCollisionMovement.accuracyMode, wakeupOnCollisionMovement.geometryAtoms, wakeupOnCollisionMovement.vwcBounds, wakeupOnCollisionMovement.boundingLeaf, wakeupOnCollisionMovement.armingNode, wakeupOnCollisionMovement);
            n = this.collideMovementList.indexOf(wakeupOnCollisionMovement);
            if (bHLeafInterface != null) {
                if (n < 0) {
                    this.collideMovementList.add(wakeupOnCollisionMovement);
                    wakeupOnCollisionMovement.setTarget(bHLeafInterface);
                } else if (!wakeupOnCollisionMovement.duplicateEvent) {
                    wakeupOnCollisionMovement.setTriggered();
                }
            } else if (n >= 0) {
                this.collideMovementList.remove(n);
                wakeupOnCollisionMovement.lastSrcBounds = null;
                wakeupOnCollisionMovement.lastDstBounds = null;
            }
            --n2;
        }
        WakeupOnCollisionExit[] wakeupOnCollisionExitArray = (WakeupOnCollisionExit[])this.wakeupOnCollisionExit.toArray();
        n2 = this.wakeupOnCollisionExit.arraySize() - 1;
        while (n2 >= 0) {
            WakeupOnCollisionExit wakeupOnCollisionExit = wakeupOnCollisionExitArray[n2];
            wakeupOnCollisionExit.updateCollisionBounds(this.reEvaluateWakeupCollisionGAs);
            bHLeafInterface = this.collide(wakeupOnCollisionExit.behav.locale, wakeupOnCollisionExit.accuracyMode, wakeupOnCollisionExit.geometryAtoms, wakeupOnCollisionExit.vwcBounds, wakeupOnCollisionExit.boundingLeaf, wakeupOnCollisionExit.armingNode, null);
            n = this.collideExitList.indexOf(wakeupOnCollisionExit);
            if (bHLeafInterface != null) {
                if (n < 0) {
                    this.collideExitList.add(wakeupOnCollisionExit);
                    wakeupOnCollisionExit.setTarget(bHLeafInterface);
                }
            } else if (n >= 0) {
                this.collideExitList.remove(n);
                wakeupOnCollisionExit.setTriggered();
            }
            --n2;
        }
    }

    void checkDuplicateEvent(WakeupOnCollisionMovement wakeupOnCollisionMovement, Bounds bounds, BHLeafInterface bHLeafInterface) {
        if (wakeupOnCollisionMovement.lastSrcBounds != null && wakeupOnCollisionMovement.lastSrcBounds.equals(bounds)) {
            BoundingBox boundingBox = bHLeafInterface instanceof GeometryAtom ? ((GeometryAtom)bHLeafInterface).source.vwcBounds : ((GroupRetained)bHLeafInterface).collisionVwcBounds;
            if (wakeupOnCollisionMovement.lastDstBounds != null && wakeupOnCollisionMovement.lastDstBounds.equals(boundingBox)) {
                wakeupOnCollisionMovement.duplicateEvent = true;
            } else {
                wakeupOnCollisionMovement.duplicateEvent = false;
                wakeupOnCollisionMovement.lastDstBounds = (Bounds)((Bounds)boundingBox).clone();
            }
        } else {
            wakeupOnCollisionMovement.duplicateEvent = false;
            wakeupOnCollisionMovement.lastSrcBounds = (Bounds)bounds.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BHLeafInterface collide(Locale locale, int n, UnorderList unorderList, Bounds bounds, BoundingLeafRetained boundingLeafRetained, NodeRetained nodeRetained, WakeupCriterion wakeupCriterion) {
        this.lock.readLock();
        int n2 = this.getBHTreeIndex(locale);
        if (n2 < 0) {
            this.lock.readUnlock();
            return null;
        }
        if (unorderList != null) {
            BHTree bHTree = this.bhTreeArr[n2];
            synchronized (bHTree) {
                block25: {
                    block23: {
                        BHLeafInterface bHLeafInterface;
                        block24: {
                            if (bounds == null || !(nodeRetained instanceof GroupRetained)) break block23;
                            bHLeafInterface = this.bhTreeArr[n2].selectAny(bounds, n, (GroupRetained)nodeRetained);
                            if (bHLeafInterface != null) break block24;
                            this.lock.readUnlock();
                            BHLeafInterface bHLeafInterface2 = null;
                            return bHLeafInterface2;
                        }
                        GeometryAtom[] geometryAtomArray = (GeometryAtom[])unorderList.toArray(false);
                        bHLeafInterface = this.bhTreeArr[n2].selectAny(geometryAtomArray, unorderList.arraySize(), n);
                        if (bHLeafInterface != null) {
                            this.lock.readUnlock();
                            if (wakeupCriterion != null) {
                                this.checkDuplicateEvent((WakeupOnCollisionMovement)wakeupCriterion, bounds, bHLeafInterface);
                            }
                            BHLeafInterface bHLeafInterface3 = bHLeafInterface;
                            return bHLeafInterface3;
                        }
                        break block25;
                    }
                    GeometryAtom geometryAtom = (GeometryAtom)unorderList.get(0);
                    BHLeafInterface bHLeafInterface = this.bhTreeArr[n2].selectAny(geometryAtom, n);
                    if (bHLeafInterface == null) break block25;
                    this.lock.readUnlock();
                    if (wakeupCriterion != null) {
                        this.checkDuplicateEvent((WakeupOnCollisionMovement)wakeupCriterion, geometryAtom.source.vwcBounds, bHLeafInterface);
                    }
                    BHLeafInterface bHLeafInterface4 = bHLeafInterface;
                    return bHLeafInterface4;
                }
            }
        }
        if (bounds == null) {
            if (boundingLeafRetained == null) {
                this.lock.readUnlock();
                return null;
            }
            bounds = boundingLeafRetained.transformedRegion;
        }
        if (bounds == null) {
            this.lock.readUnlock();
            return null;
        }
        if (nodeRetained instanceof GroupRetained) {
            BHTree bHTree = this.bhTreeArr[n2];
            synchronized (bHTree) {
                BHLeafInterface bHLeafInterface = this.bhTreeArr[n2].selectAny(bounds, n, (GroupRetained)nodeRetained);
                this.lock.readUnlock();
                if (bHLeafInterface != null && wakeupCriterion != null) {
                    this.checkDuplicateEvent((WakeupOnCollisionMovement)wakeupCriterion, bounds, bHLeafInterface);
                }
                BHLeafInterface bHLeafInterface5 = bHLeafInterface;
                return bHLeafInterface5;
            }
        }
        BHTree bHTree = this.bhTreeArr[n2];
        synchronized (bHTree) {
            BHLeafInterface bHLeafInterface = this.bhTreeArr[n2].selectAny(bounds, n, nodeRetained);
            this.lock.readUnlock();
            if (bHLeafInterface != null && wakeupCriterion != null) {
                this.checkDuplicateEvent((WakeupOnCollisionMovement)wakeupCriterion, bounds, bHLeafInterface);
            }
            BHLeafInterface bHLeafInterface6 = bHLeafInterface;
            return bHLeafInterface6;
        }
        this.lock.readUnlock();
        return null;
    }

    void resetConditionMet() {
        BehaviorStructure.resetConditionMet(this.wakeupOnCollisionEntry);
        BehaviorStructure.resetConditionMet(this.wakeupOnCollisionExit);
        BehaviorStructure.resetConditionMet(this.wakeupOnCollisionMovement);
    }

    private void processSwitchChanged(J3dMessage j3dMessage) {
    }

    void cleanup() {
        this.collideEntryList.clear();
        this.collideExitList.clear();
        this.collideMovementList.clear();
        this.wakeupOnCollisionEntry.clear();
        this.wakeupOnCollisionExit.clear();
        this.wakeupOnCollisionMovement.clear();
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

