/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.AWTError;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Toolkit;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.j3d.BHInternalNode;
import javax.media.j3d.BHLeafNode;
import javax.media.j3d.BHNode;
import javax.media.j3d.BehaviorScheduler;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CompressedGeometryRenderMethod;
import javax.media.j3d.DefaultRenderMethod;
import javax.media.j3d.DisplayListRenderMethod;
import javax.media.j3d.DrawingSurfaceObjectAWT;
import javax.media.j3d.FreeListManager;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.ImageComponentUpdateInfo;
import javax.media.j3d.InputDevice;
import javax.media.j3d.InputDeviceBlockingThread;
import javax.media.j3d.InputDeviceScheduler;
import javax.media.j3d.J3dDebug;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.J3dThread;
import javax.media.j3d.J3dThreadData;
import javax.media.j3d.MasterControlThread;
import javax.media.j3d.MemoryFreeList;
import javax.media.j3d.NativeAPIInfo;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.OrientedShape3DRenderMethod;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.RenderMethod;
import javax.media.j3d.Renderer;
import javax.media.j3d.RenderingAttributesStructure;
import javax.media.j3d.Screen3D;
import javax.media.j3d.StructureUpdateThread;
import javax.media.j3d.Text3DRenderMethod;
import javax.media.j3d.TimerThread;
import javax.media.j3d.Transform3D;
import javax.media.j3d.UnorderList;
import javax.media.j3d.VertexArrayRenderMethod;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;

class MasterControl {
    static final int CHECK_FOR_WORK = 0;
    static final int SET_WORK = 1;
    static final int RUN_THREADS = 2;
    static final int THREAD_DONE = 3;
    static final int WAIT_FOR_ALL = 4;
    static final int SET_WORK_FOR_REQUEST_RENDERER = 5;
    static final int RUN_RENDERER_CLEANUP = 6;
    static final int SLEEP = 7;
    static final int SLEEPING = 0;
    static final int RUNNING = 1;
    static final int WAITING_FOR_THREAD = 2;
    static final int WAITING_FOR_THREADS = 3;
    static final int WAITING_FOR_CPU = 4;
    static final int WAITING_FOR_RENDERER_CLEANUP = 5;
    static final int RENDER_OPENGL_SOLARIS = 0;
    static final int RENDER_OPENGL_WIN32 = 1;
    static final int RENDER_DIRECT3D = 2;
    static final Integer REQUESTRENDER = new Integer(2);
    static final Integer RENDER = new Integer(0);
    static final Integer SWAP = new Integer(1);
    static final Integer ACTIVATE_VIEW = new Integer(1);
    static final Integer DEACTIVATE_VIEW = new Integer(2);
    static final Integer START_VIEW = new Integer(3);
    static final Integer STOP_VIEW = new Integer(4);
    static final Integer REEVALUATE_CANVAS = new Integer(5);
    static final Integer UNREGISTER_VIEW = new Integer(6);
    static final Integer PHYSICAL_ENV_CHANGE = new Integer(7);
    static final Integer INPUTDEVICE_CHANGE = new Integer(8);
    static final Integer EMPTY_UNIVERSE = new Integer(9);
    static final Integer START_RENDERER = new Integer(10);
    static final Integer STOP_RENDERER = new Integer(11);
    static final Integer RENDER_ONCE = new Integer(12);
    static final Integer FREE_CONTEXT = new Integer(13);
    static final Integer FREE_DRAWING_SURFACE = new Integer(14);
    static final Integer FREE_MESSAGE = new Integer(15);
    static final Integer RESET_CANVAS = new Integer(16);
    static final Integer GETBESTCONFIG = new Integer(17);
    static final Integer ISCONFIGSUPPORT = new Integer(18);
    static final Integer SET_GRAPHICSCONFIG_FEATURES = new Integer(19);
    static final Integer SET_QUERYPROPERTIES = new Integer(20);
    static final Integer SET_VIEW = new Integer(21);
    private MasterControlThread mcThread = null;
    private UnorderList views = new UnorderList(1, class$javax$media$j3d$View == null ? (class$javax$media$j3d$View = MasterControl.class$("javax.media.j3d.View")) : class$javax$media$j3d$View);
    private boolean lockGeometry = false;
    private int numActiveViews = 0;
    private ImageComponentUpdateInfo[] imageUpdateInfoList = new ImageComponentUpdateInfo[2];
    private int numFreeImageUpdateInfo = 0;
    private UnorderList activeUniverseList = new UnorderList(class$javax$media$j3d$VirtualUniverse == null ? (class$javax$media$j3d$VirtualUniverse = MasterControl.class$("javax.media.j3d.VirtualUniverse")) : class$javax$media$j3d$VirtualUniverse);
    private UnorderList regUniverseList = new UnorderList(class$javax$media$j3d$VirtualUniverse == null ? (class$javax$media$j3d$VirtualUniverse = MasterControl.class$("javax.media.j3d.VirtualUniverse")) : class$javax$media$j3d$VirtualUniverse);
    private Object timeLock = new Object();
    private long time = 0L;
    private long waitTimestamp = 0L;
    private UnorderList stateWorkThreads = new UnorderList(class$javax$media$j3d$J3dThreadData == null ? (class$javax$media$j3d$J3dThreadData = MasterControl.class$("javax.media.j3d.J3dThreadData")) : class$javax$media$j3d$J3dThreadData);
    private UnorderList renderWorkThreads = new UnorderList(class$javax$media$j3d$J3dThreadData == null ? (class$javax$media$j3d$J3dThreadData = MasterControl.class$("javax.media.j3d.J3dThreadData")) : class$javax$media$j3d$J3dThreadData);
    private UnorderList requestRenderWorkThreads = new UnorderList(class$javax$media$j3d$J3dThreadData == null ? (class$javax$media$j3d$J3dThreadData = MasterControl.class$("javax.media.j3d.J3dThreadData")) : class$javax$media$j3d$J3dThreadData);
    private UnorderList renderThreadData = new UnorderList(class$javax$media$j3d$J3dThreadData == null ? (class$javax$media$j3d$J3dThreadData = MasterControl.class$("javax.media.j3d.J3dThreadData")) : class$javax$media$j3d$J3dThreadData);
    private UnorderList inputDeviceThreads = new UnorderList(1, class$javax$media$j3d$InputDeviceScheduler == null ? (class$javax$media$j3d$InputDeviceScheduler = MasterControl.class$("javax.media.j3d.InputDeviceScheduler")) : class$javax$media$j3d$InputDeviceScheduler);
    private boolean threadListsChanged;
    private int lastTransformStructureThread = 0;
    private int lastStructureUpdateThread = 0;
    private long currentTime;
    TimerThread timerThread;
    volatile boolean running = true;
    private boolean workToDo = false;
    private boolean requestRenderWorkToDo = false;
    private int threadPending = 0;
    private int renderPending = 0;
    private int statePending = 0;
    private boolean renderWaiting = false;
    private boolean stateWaiting = false;
    private int state = 0;
    private long sleepTime = 0L;
    private int cpuLimit;
    private UnorderList mirrorObjects = new UnorderList(class$javax$media$j3d$ObjectUpdate == null ? (class$javax$media$j3d$ObjectUpdate = MasterControl.class$("javax.media.j3d.ObjectUpdate")) : class$javax$media$j3d$ObjectUpdate);
    private RenderingAttributesStructure renderingAttributesStructure = new RenderingAttributesStructure();
    private DefaultRenderMethod defaultRenderMethod = null;
    private Text3DRenderMethod text3DRenderMethod = null;
    private VertexArrayRenderMethod vertexArrayRenderMethod = null;
    private DisplayListRenderMethod displayListRenderMethod = null;
    private CompressedGeometryRenderMethod compressedGeometryRenderMethod = null;
    private OrientedShape3DRenderMethod orientedShape3DRenderMethod = null;
    static long systemStartTime = System.currentTimeMillis();
    private int renderingAPI = 0;
    static boolean isD3DAPI = false;
    static boolean isWin32 = false;
    private NativeAPIInfo nativeAPIInfo = null;
    private int textureIdCount = 0;
    private Object textureIdLock = new Object();
    private long contextTimeStamp = 0L;
    private int canvasBitCount = 0;
    private int rendererCount = 0;
    static boolean jvm13 = false;
    static boolean jvm14AndGreater = false;
    boolean isSharedCtx = false;
    boolean sharedCtxOverride = false;
    boolean useCombiners = false;
    boolean disableCompile = false;
    boolean doCompaction = true;
    boolean disableSeparateSpecularColor = false;
    int textureUnitMax = 100;
    boolean isDisplayList = true;
    boolean buildDisplayListIfPossible = false;
    static Integer REMOVEALLCTXS_CLEANUP = new Integer(1);
    static Integer REMOVECTX_CLEANUP = new Integer(2);
    static Integer REMOVENOTIFY_CLEANUP = new Integer(3);
    static Integer RESETCANVAS_CLEANUP = new Integer(4);
    static Integer FREECONTEXT_CLEANUP = new Integer(5);
    Object[] rendererCleanupArgs = new Object[]{new Integer(3), null, null};
    Object contextCreationLock = new Object();
    boolean doDsiRenderLock = false;
    boolean isJ3dG2dDrawPixel = true;
    boolean isBackgroundTexture = true;
    boolean sharedStereoZBuffer;
    boolean implicitAntialiasing = false;
    boolean isCompliedVertexArray = true;
    boolean isForceNormalized = false;
    Hashtable deviceScreenMap = new Hashtable();
    UnorderList requestObjList = new UnorderList();
    private UnorderList requestTypeList = new UnorderList(class$java$lang$Integer == null ? (class$java$lang$Integer = MasterControl.class$("java.lang.Integer")) : class$java$lang$Integer);
    private UnorderList tempViewList = new UnorderList();
    private UnorderList renderOnceList = new UnorderList();
    private boolean pendingRequest = false;
    private static ThreadGroup rootThreadGroup;
    private static int threadPriority;
    private static Object mcThreadLock;
    private ArrayList timestampUpdateList = new ArrayList(3);
    private UnorderList freeMessageList = new UnorderList(8);
    long awt;
    int maxLights;
    int resendTexTimestamp = 0;
    boolean xineramaDisabled = false;
    static String[] mtype;
    int frameCount = 0;
    private int frameCountCutoff = 100;
    static /* synthetic */ Class class$javax$media$j3d$View;
    static /* synthetic */ Class class$javax$media$j3d$VirtualUniverse;
    static /* synthetic */ Class class$javax$media$j3d$J3dThreadData;
    static /* synthetic */ Class class$javax$media$j3d$InputDeviceScheduler;
    static /* synthetic */ Class class$javax$media$j3d$ObjectUpdate;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$javax$media$j3d$PhysicalEnvironment;

    native long getAWT();

    private native boolean initializeJ3D(boolean var1);

    private native int getNumberOfProcessor();

    private native void setThreadConcurrency(int var1);

    private native int getThreadConcurrency();

    private native int getMaximumLights();

    MasterControl() {
        Boolean bl;
        boolean bl2;
        Integer n;
        Boolean bl3;
        Boolean bl4;
        Boolean bl5;
        if (jvm14AndGreater) {
            this.awt = this.getAWT();
        }
        this.nativeAPIInfo = new NativeAPIInfo();
        this.renderingAPI = this.nativeAPIInfo.getRenderingAPI();
        isD3DAPI = this.renderingAPI == 2;
        boolean bl6 = isWin32 = isD3DAPI || this.renderingAPI == 1;
        if (this.getRenderingAPI() != 2) {
            bl5 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string2 = System.getProperty("j3d.sharedctx");
                    if (string2 == null) {
                        return Boolean.FALSE;
                    }
                    MasterControl.this.sharedCtxOverride = true;
                    return new Boolean(string2);
                }
            });
            this.isSharedCtx = bl5;
            if (this.sharedCtxOverride) {
                if (this.isSharedCtx) {
                    System.err.println("Java 3D: shared contexts enabled");
                } else {
                    System.err.println("Java 3D: shared contexts disabled");
                }
            }
        }
        bl5 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string2 = System.getProperty("j3d.disablecompile");
                if (string2 == null) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        this.disableCompile = bl5;
        if (this.disableCompile) {
            System.err.println("Java 3D: Compile disabled");
        }
        Boolean bl7 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string2 = System.getProperty("j3d.docompaction");
                if (string2 == null) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        this.doCompaction = bl7;
        if (!this.doCompaction) {
            System.err.println("Java 3D: Disabling compaction.");
        }
        Boolean bl8 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string2 = System.getProperty("j3d.usecombiners");
                if (string2 == null) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        this.useCombiners = bl8;
        if (this.useCombiners) {
            System.err.println("Java 3D: Using NV_register_combiners if available");
        }
        Boolean bl9 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string2 = System.getProperty("j3d.disableSeparateSpecular");
                if (string2 == null) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        this.disableSeparateSpecularColor = bl9;
        if (this.disableSeparateSpecularColor) {
            System.err.println("Java 3D: Separate Specular Color disabled if possible");
        }
        final int n2 = this.textureUnitMax;
        Integer n3 = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Integer.getInteger("j3d.textureUnitMax", n2);
            }
        });
        this.textureUnitMax = n3;
        if (this.textureUnitMax != n2) {
            System.err.println("Java 3D: maximum number of texture units = " + this.textureUnitMax);
        }
        Boolean bl10 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string2 = System.getProperty("j3d.displaylist", "true");
                return new Boolean(string2);
            }
        });
        this.isDisplayList = bl10;
        if (!this.isDisplayList) {
            System.err.println("Java 3D: Display List disabled");
        }
        Boolean bl11 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string2 = System.getProperty("j3d.implicitAntialiasing", "false");
                return new Boolean(string2);
            }
        });
        this.implicitAntialiasing = bl11;
        if (this.implicitAntialiasing) {
            System.err.println("Java 3D: Implicit Antialiasing enabled");
        }
        Boolean bl12 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string2 = System.getProperty("j3d.compliedVertexArray", "true");
                return new Boolean(string2);
            }
        });
        this.isCompliedVertexArray = bl12;
        if (!this.isCompliedVertexArray) {
            System.err.println("Java 3D: Complied vertex array disabled");
        }
        Boolean bl13 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string2 = System.getProperty("j3d.forceNormalized", "false");
                return new Boolean(string2);
            }
        });
        this.isForceNormalized = bl13;
        if (this.isForceNormalized) {
            System.err.println("Java 3D: Force Normalized");
        }
        if (!(bl4 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string2 = System.getProperty("j3d.optimizeForSpace", "true");
                return new Boolean(string2);
            }
        })).booleanValue()) {
            System.err.println("Java 3D: Optimize For Space disabled");
        }
        this.buildDisplayListIfPossible = this.isDisplayList && bl4 == false;
        Boolean bl14 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string2 = System.getProperty("j3d.renderLock", "false");
                return new Boolean(string2);
            }
        });
        this.doDsiRenderLock = bl14;
        Boolean bl15 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string2 = isWin32 ? "false" : "true";
                String string3 = System.getProperty("j3d.g2ddrawpixel", string2);
                return new Boolean(string3);
            }
        });
        this.isJ3dG2dDrawPixel = bl15;
        if (!this.isD3D()) {
            bl3 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string2 = isWin32 ? "true" : "false";
                    String string3 = System.getProperty("j3d.backgroundtexture", string2);
                    return new Boolean(string3);
                }
            });
            this.isBackgroundTexture = bl3;
        } else {
            this.isBackgroundTexture = false;
        }
        bl3 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string2 = isWin32 ? "true" : "false";
                String string3 = System.getProperty("j3d.sharedstereozbuffer", string2);
                return new Boolean(string3);
            }
        });
        this.sharedStereoZBuffer = bl3;
        bl3 = null;
        final int n4 = this.getNumberOfProcessor() + 1;
        Integer n5 = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Integer.getInteger("j3d.threadLimit", n4);
            }
        });
        this.cpuLimit = n5;
        if (this.cpuLimit < 1) {
            this.cpuLimit = 1;
        }
        if (J3dDebug.debug || this.cpuLimit != n4) {
            System.err.println("Java 3D: concurrent threadLimit = " + this.cpuLimit);
        }
        int n6 = this.getThreadConcurrency();
        if (J3dDebug.debug) {
            System.err.println("System threadConcurrency = " + n6);
        }
        if (n6 != -1 && n6 < this.cpuLimit + 1) {
            n6 = this.cpuLimit + 1;
            if (J3dDebug.debug) {
                System.err.println("Setting system threadConcurrency to " + n6);
            }
            this.setThreadConcurrency(n6);
        }
        if ((n = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Integer.getInteger("j3d.deviceSampleTime", 0);
            }
        })) > 0) {
            InputDeviceScheduler.samplingTime = n;
            System.err.println("Java 3D: Input device sampling time = " + n + " ms");
        }
        if (!this.initializeJ3D(bl2 = (bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string2 = System.getProperty("j3d.disableXinerama", "false");
                return new Boolean(string2);
            }
        })).booleanValue())) {
            if (this.isGreenThreadUsed()) {
                System.err.print(J3dI18N.getString("MasterControl1"));
            }
            throw new RuntimeException(J3dI18N.getString("MasterControl0"));
        }
        if (this.xineramaDisabled) {
            System.err.println("Java 3D: Xinerama disabled");
        } else if (bl2) {
            System.err.println("Java 3D: could not disable Xinerama");
        }
        this.maxLights = this.getMaximumLights();
        FreeListManager.createFreeLists();
    }

    public static String getProperty(final String string2) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string2);
            }
        });
    }

    boolean isGreenThreadUsed() {
        String string2;
        String string3 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string2 = System.getProperty("java.vm.info");
                return string2;
            }
        });
        return string3.indexOf(string2 = new String("green threads")) != -1;
    }

    static void loadLibraries() {
        Object object;
        try {
            object = Toolkit.getDefaultToolkit();
            object = null;
        }
        catch (AWTError aWTError) {
            // empty catch block
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("J3D");
                return null;
            }
        });
        object = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.version");
            }
        });
        jvm13 = !((String)object).startsWith("1.2");
        boolean bl = jvm14AndGreater = !((String)object).startsWith("1.3") && !((String)object).startsWith("1.2");
        if (jvm14AndGreater) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.loadLibrary("jawt");
                    return null;
                }
            });
        }
    }

    InputDeviceBlockingThread getInputDeviceBlockingThread(final InputDevice inputDevice) {
        return (InputDeviceBlockingThread)AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                ThreadGroup threadGroup = rootThreadGroup;
                synchronized (threadGroup) {
                    InputDeviceBlockingThread inputDeviceBlockingThread = new InputDeviceBlockingThread(rootThreadGroup, inputDevice);
                    inputDeviceBlockingThread.setPriority(threadPriority);
                    InputDeviceBlockingThread inputDeviceBlockingThread2 = inputDeviceBlockingThread;
                    return inputDeviceBlockingThread2;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setThreadPriority(final int n) {
        ThreadGroup threadGroup = rootThreadGroup;
        synchronized (threadGroup) {
            threadPriority = n;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread[] threadArray = new Thread[rootThreadGroup.activeCount()];
                    int n3 = rootThreadGroup.enumerate(threadArray);
                    int n2 = n3 - 1;
                    while (n2 >= 0) {
                        threadArray[n2].setPriority(n);
                        --n2;
                    }
                    return null;
                }
            });
        }
    }

    int getThreadPriority() {
        return threadPriority;
    }

    int getRendererBit() {
        return 1 << this.rendererCount++;
    }

    long getContextTimeStamp() {
        return ++this.contextTimeStamp;
    }

    Integer getDisplayListId() {
        return (Integer)FreeListManager.getObject(4);
    }

    void freeDisplayListId(Integer n) {
        FreeListManager.freeObject(4, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getTexture2DId() {
        MemoryFreeList memoryFreeList = FreeListManager.getFreeList(5);
        Object object = this.textureIdLock;
        synchronized (object) {
            block4: {
                if (memoryFreeList.size() <= 0) break block4;
                int n = (Integer)FreeListManager.getObject(5);
                return n;
            }
            int n = ++this.textureIdCount;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getTexture3DId() {
        MemoryFreeList memoryFreeList = FreeListManager.getFreeList(6);
        Object object = this.textureIdLock;
        synchronized (object) {
            block4: {
                if (memoryFreeList.size <= 0) break block4;
                int n = (Integer)FreeListManager.getObject(6);
                return n;
            }
            int n = ++this.textureIdCount;
            return n;
        }
    }

    void freeTexture2DId(int n) {
        FreeListManager.freeObject(5, new Integer(n));
    }

    void freeTexture3DId(int n) {
        FreeListManager.freeObject(6, new Integer(n));
    }

    int getCanvasBit() {
        MemoryFreeList memoryFreeList = FreeListManager.getFreeList(7);
        if (memoryFreeList.size() > 0) {
            return (Integer)FreeListManager.getObject(7);
        }
        if (this.canvasBitCount > 31) {
            throw new InternalError();
        }
        return 1 << this.canvasBitCount++;
    }

    void freeCanvasBit(int n) {
        FreeListManager.freeObject(7, new Integer(n));
    }

    Transform3D getTransform3D(Transform3D transform3D) {
        Transform3D transform3D2 = (Transform3D)FreeListManager.getObject(2);
        if (transform3D != null) {
            transform3D2.set(transform3D);
        }
        return transform3D2;
    }

    void addToTransformFreeList(Transform3D transform3D) {
        FreeListManager.freeObject(2, transform3D);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ImageComponentUpdateInfo getFreeImageUpdateInfo() {
        ImageComponentUpdateInfo imageComponentUpdateInfo;
        ImageComponentUpdateInfo[] imageComponentUpdateInfoArray = this.imageUpdateInfoList;
        synchronized (imageComponentUpdateInfoArray) {
            if (this.numFreeImageUpdateInfo > 0) {
                --this.numFreeImageUpdateInfo;
                imageComponentUpdateInfo = this.imageUpdateInfoList[this.numFreeImageUpdateInfo];
            } else {
                imageComponentUpdateInfo = new ImageComponentUpdateInfo();
            }
        }
        return imageComponentUpdateInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFreeImageUpdateInfo(ImageComponentUpdateInfo imageComponentUpdateInfo) {
        ImageComponentUpdateInfo[] imageComponentUpdateInfoArray = this.imageUpdateInfoList;
        synchronized (imageComponentUpdateInfoArray) {
            if (this.imageUpdateInfoList.length == this.numFreeImageUpdateInfo) {
                ImageComponentUpdateInfo[] imageComponentUpdateInfoArray2 = new ImageComponentUpdateInfo[this.numFreeImageUpdateInfo * 2];
                System.arraycopy(this.imageUpdateInfoList, 0, imageComponentUpdateInfoArray2, 0, this.numFreeImageUpdateInfo);
                imageComponentUpdateInfoArray2[this.numFreeImageUpdateInfo++] = imageComponentUpdateInfo;
                this.imageUpdateInfoList = imageComponentUpdateInfoArray2;
            } else {
                this.imageUpdateInfoList[this.numFreeImageUpdateInfo++] = imageComponentUpdateInfo;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFreeImageUpdateInfo(ArrayList arrayList) {
        ImageComponentUpdateInfo[] imageComponentUpdateInfoArray = this.imageUpdateInfoList;
        synchronized (imageComponentUpdateInfoArray) {
            int n = this.numFreeImageUpdateInfo + arrayList.size();
            if (this.imageUpdateInfoList.length <= n) {
                ImageComponentUpdateInfo[] imageComponentUpdateInfoArray2 = new ImageComponentUpdateInfo[n * 2];
                System.arraycopy(this.imageUpdateInfoList, 0, imageComponentUpdateInfoArray2, 0, this.numFreeImageUpdateInfo);
                this.imageUpdateInfoList = imageComponentUpdateInfoArray2;
            }
            int n2 = 0;
            while (n2 < arrayList.size()) {
                ImageComponentUpdateInfo imageComponentUpdateInfo = (ImageComponentUpdateInfo)arrayList.get(n2);
                if (imageComponentUpdateInfo != null) {
                    this.imageUpdateInfoList[this.numFreeImageUpdateInfo++] = imageComponentUpdateInfo;
                }
                ++n2;
            }
        }
    }

    Renderer createRenderer(GraphicsConfiguration graphicsConfiguration) {
        final GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        Renderer renderer = (Renderer)Screen3D.deviceRendererMap.get(graphicsDevice);
        if (renderer != null) {
            return renderer;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                ThreadGroup threadGroup = rootThreadGroup;
                synchronized (threadGroup) {
                    Renderer renderer = new Renderer(rootThreadGroup);
                    renderer.initialize();
                    renderer.setPriority(threadPriority);
                    Screen3D.deviceRendererMap.put(graphicsDevice, renderer);
                }
                return null;
            }
        });
        this.threadListsChanged = true;
        return (Renderer)Screen3D.deviceRendererMap.get(graphicsDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postRequest(Integer n, Object object) {
        Object object2 = mcThreadLock;
        synchronized (object2) {
            UnorderList unorderList = this.requestObjList;
            synchronized (unorderList) {
                if (this.mcThread == null) {
                    if (n == ACTIVATE_VIEW || n == GETBESTCONFIG || n == SET_VIEW || n == ISCONFIGSUPPORT || n == SET_QUERYPROPERTIES || n == SET_GRAPHICSCONFIG_FEATURES) {
                        this.createMasterControlThread();
                        this.requestObjList.add(object);
                        this.requestTypeList.add(n);
                        this.pendingRequest = true;
                    } else if (n == EMPTY_UNIVERSE) {
                        this.destroyUniverseThreads((VirtualUniverse)object);
                    } else if (n == STOP_VIEW) {
                        View view = (View)object;
                        view.stopViewCount = -1;
                        view.isRunning = false;
                    } else if (n == STOP_RENDERER) {
                        if (object instanceof Canvas3D) {
                            ((Canvas3D)object).isRunningStatus = false;
                        } else {
                            ((Renderer)object).userStop = true;
                        }
                    } else if (n == UNREGISTER_VIEW) {
                        ((View)object).doneUnregister = true;
                    } else {
                        this.requestObjList.add(object);
                        this.requestTypeList.add(n);
                        this.pendingRequest = true;
                    }
                } else {
                    this.requestObjList.add(object);
                    this.requestTypeList.add(n);
                    this.pendingRequest = true;
                }
            }
        }
        this.setWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean mcThreadDone() {
        Object object = mcThreadLock;
        synchronized (object) {
            UnorderList unorderList = this.requestObjList;
            synchronized (unorderList) {
                if (this.pendingRequest) {
                    this.running = true;
                    this.createMCThreads();
                    return false;
                }
                this.mcThread = null;
                if (this.renderingAttributesStructure.updateThread != null) {
                    this.renderingAttributesStructure.updateThread.finish();
                    this.renderingAttributesStructure.updateThread = null;
                }
                this.renderingAttributesStructure = new RenderingAttributesStructure();
                if (this.timerThread != null) {
                    this.timerThread.finish();
                    this.timerThread = null;
                }
                this.requestObjList.clear();
                this.requestTypeList.clear();
                return true;
            }
        }
    }

    final int getRenderingAPI() {
        return this.renderingAPI;
    }

    final boolean isD3D() {
        return isD3DAPI;
    }

    final long getTime() {
        return this.time++;
    }

    void addBHNodeToFreelists(BHNode bHNode) {
        bHNode.parent = null;
        bHNode.mark = false;
        if (bHNode.nodeType == 1) {
            ((BHInternalNode)bHNode).lChild = null;
            ((BHInternalNode)bHNode).rChild = null;
            FreeListManager.freeObject(3, bHNode);
        } else if (bHNode.nodeType == 2) {
            ((BHLeafNode)bHNode).leafIF = null;
            FreeListManager.freeObject(1, bHNode);
        }
    }

    BHNode getBHNode(int n) {
        if (n == 2) {
            return (BHNode)FreeListManager.getObject(1);
        }
        if (n == 1) {
            return (BHNode)FreeListManager.getObject(3);
        }
        return null;
    }

    final void addMessageToFreelists(J3dMessage j3dMessage) {
        FreeListManager.freeObject(0, j3dMessage);
    }

    final J3dMessage getMessage() {
        return (J3dMessage)FreeListManager.getObject(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMessage(J3dMessage j3dMessage) {
        Object object = this.timeLock;
        synchronized (object) {
            j3dMessage.time = this.getTime();
            this.sendMessage(j3dMessage);
        }
        this.setWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMessage(J3dMessage[] j3dMessageArray) {
        Object object = this.timeLock;
        synchronized (object) {
            long l = this.getTime();
            int n = 0;
            while (n < j3dMessageArray.length) {
                j3dMessageArray[n].time = l;
                this.sendMessage(j3dMessageArray[n]);
                ++n;
            }
        }
        this.setWork();
    }

    void createMasterControlThread() {
        this.running = true;
        this.workToDo = false;
        this.state = 1;
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                ThreadGroup threadGroup = rootThreadGroup;
                synchronized (threadGroup) {
                    MasterControl.this.mcThread = new MasterControlThread(rootThreadGroup);
                    MasterControl.this.mcThread.setPriority(threadPriority);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void sendMessage(J3dMessage var1_1) {
        var2_2 = var1_1;
        synchronized (var2_2) {
            block25: {
                block26: {
                    block23: {
                        block24: {
                            var3_3 = var1_1.universe;
                            var4_4 = var1_1.threads;
                            if ((var4_4 & 1024) != 0) {
                                this.renderingAttributesStructure.addMessage(var1_1);
                            }
                            if (var3_3 != null) {
                                if ((var4_4 & 64) != 0) {
                                    var3_3.geometryStructure.addMessage(var1_1);
                                }
                                if ((var4_4 & 8192) != 0) {
                                    var3_3.transformStructure.addMessage(var1_1);
                                }
                                if ((var4_4 & 256) != 0) {
                                    var3_3.behaviorStructure.addMessage(var1_1);
                                }
                                if ((var4_4 & 512) != 0) {
                                    var3_3.soundStructure.addMessage(var1_1);
                                }
                                if ((var4_4 & 4096) != 0) {
                                    var3_3.renderingEnvironmentStructure.addMessage(var1_1);
                                }
                            }
                            if ((var4_4 & 2) == 0) break block23;
                            if (var1_1.view == null || var1_1.view.soundScheduler == null) break block24;
                            var1_1.view.soundScheduler.addMessage(var1_1);
                            break block23;
                        }
                        var5_5 = this.views;
                        synchronized (var5_5) {
                            var6_6 = (View[])this.views.toArray(false);
                            var7_7 = this.views.arraySize() - 1;
                            if (var3_3 != null) ** GOTO lbl37
                            while (var7_7 >= 0) {
                                var6_6[var7_7--].soundScheduler.addMessage(var1_1);
                            }
                            break block23;
lbl-1000:
                            // 1 sources

                            {
                                if (var6_6[var7_7].universe == var3_3) {
                                    var6_6[var7_7].soundScheduler.addMessage(var1_1);
                                }
                                --var7_7;
lbl37:
                                // 2 sources

                                ** while (var7_7 >= 0)
                            }
lbl38:
                            // 1 sources

                        }
                    }
                    if ((var4_4 & 128) == 0) break block25;
                    if (var1_1.view == null || var1_1.view.renderBin == null) break block26;
                    var1_1.view.renderBin.addMessage(var1_1);
                    break block25;
                }
                var5_5 = this.views;
                synchronized (var5_5) {
                    var6_6 = (View[])this.views.toArray(false);
                    var7_7 = this.views.arraySize() - 1;
                    if (var3_3 != null) ** GOTO lbl60
                    while (var7_7 >= 0) {
                        var6_6[var7_7--].renderBin.addMessage(var1_1);
                    }
                    break block25;
lbl-1000:
                    // 1 sources

                    {
                        if (var6_6[var7_7].universe == var3_3) {
                            var6_6[var7_7].renderBin.addMessage(var1_1);
                        }
                        --var7_7;
lbl60:
                        // 2 sources

                        ** while (var7_7 >= 0)
                    }
lbl61:
                    // 1 sources

                }
            }
            if (var1_1.getRefcount() == 0) {
                var1_1.clear();
                this.addMessageToFreelists(var1_1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRunMessage(int n) {
        Object object = this.timeLock;
        synchronized (object) {
            int n2;
            Object[] objectArray;
            UnorderList unorderList;
            long l = this.getTime();
            if ((n & 4) != 0) {
                unorderList = this.inputDeviceThreads;
                synchronized (unorderList) {
                    objectArray = (InputDeviceScheduler[])this.inputDeviceThreads.toArray(false);
                    n2 = this.inputDeviceThreads.size() - 1;
                    while (n2 >= 0) {
                        if (((InputDeviceScheduler)objectArray[n2]).physicalEnv.activeViewRef > 0) {
                            ((InputDeviceScheduler)objectArray[n2]).getThreadData().lastUpdateTime = l;
                        }
                        --n2;
                    }
                    if (this.timerThread != null) {
                        this.timerThread.addInputDeviceSchedCond();
                    }
                }
            }
            if ((n & 0x10) != 0) {
                unorderList = this.renderThreadData;
                synchronized (unorderList) {
                    objectArray = (J3dThreadData[])this.renderThreadData.toArray(false);
                    n2 = this.renderThreadData.arraySize() - 1;
                    while (n2 >= 0) {
                        Object object2 = objectArray[n2--];
                        if (!((J3dThreadData)object2).view.renderBinReady) continue;
                        ((J3dThreadData)object2).lastUpdateTime = l;
                    }
                }
            }
        }
        this.setWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRunMessage(long l, View view, int n) {
        Object object = this.timeLock;
        synchronized (object) {
            long l2 = this.getTime();
            if ((n & 2) != 0) {
                if (view.soundScheduler != null) {
                    view.soundScheduler.threadData.lastUpdateTime = l2;
                }
                this.timerThread.addSoundSchedCond(l2 + l);
            }
        }
        this.setWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRunMessage(View view, int n) {
        Object object = this.timeLock;
        synchronized (object) {
            long l = this.getTime();
            if ((n & 0x10) != 0) {
                UnorderList unorderList = this.renderThreadData;
                synchronized (unorderList) {
                    J3dThreadData[] j3dThreadDataArray = (J3dThreadData[])this.renderThreadData.toArray(false);
                    int n2 = this.renderThreadData.arraySize() - 1;
                    while (n2 >= 0) {
                        J3dThreadData j3dThreadData = j3dThreadDataArray[n2--];
                        if (j3dThreadData.view != view || !view.renderBinReady) continue;
                        j3dThreadData.lastUpdateTime = l;
                    }
                }
            }
        }
        this.setWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRunMessage(VirtualUniverse virtualUniverse, int n) {
        Object object = this.timeLock;
        synchronized (object) {
            int n2;
            Object[] objectArray;
            UnorderList unorderList;
            long l = this.getTime();
            if ((n & 1) != 0 && virtualUniverse.behaviorScheduler != null) {
                virtualUniverse.behaviorScheduler.getThreadData(null, null).lastUpdateTime = l;
            }
            if ((n & 0x100) != 0) {
                virtualUniverse.behaviorStructure.threadData.lastUpdateTime = l;
            }
            if ((n & 0x40) != 0) {
                virtualUniverse.geometryStructure.threadData.lastUpdateTime = l;
            }
            if ((n & 0x200) != 0) {
                virtualUniverse.soundStructure.threadData.lastUpdateTime = l;
            }
            if ((n & 2) != 0) {
                unorderList = this.views;
                synchronized (unorderList) {
                    objectArray = (View[])this.views.toArray(false);
                    n2 = this.views.arraySize() - 1;
                    while (n2 >= 0) {
                        if (((View)objectArray[n2]).soundScheduler != null && ((View)objectArray[n2]).universe == virtualUniverse) {
                            ((View)objectArray[n2]).soundScheduler.threadData.lastUpdateTime = l;
                        }
                        --n2;
                    }
                }
            }
            if ((n & 0x10) != 0) {
                unorderList = this.renderThreadData;
                synchronized (unorderList) {
                    objectArray = (J3dThreadData[])this.renderThreadData.toArray(false);
                    n2 = this.renderThreadData.arraySize() - 1;
                    while (n2 >= 0) {
                        Object object2 = objectArray[n2--];
                        if (((J3dThreadData)object2).view.universe != virtualUniverse || !((J3dThreadData)object2).view.renderBinReady) continue;
                        ((J3dThreadData)object2).lastUpdateTime = l;
                    }
                }
            }
        }
        this.setWork();
    }

    UnorderList cloneView() {
        return (UnorderList)this.views.clone();
    }

    boolean isRegistered(View view) {
        return this.views.contains(view);
    }

    private void updateTimeValues() {
        int n = 0;
        J3dThreadData j3dThreadData = null;
        J3dThreadData j3dThreadData2 = null;
        long l = this.currentTime;
        this.currentTime = this.getTime();
        J3dThreadData[] j3dThreadDataArray = (J3dThreadData[])this.stateWorkThreads.toArray(false);
        int n2 = this.stateWorkThreads.arraySize();
        while (n < this.lastTransformStructureThread) {
            j3dThreadData2 = j3dThreadDataArray[n++];
            if (j3dThreadData2.lastUpdateTime > j3dThreadData2.lastRunTime && !j3dThreadData2.thread.userStop) {
                j3dThreadData = j3dThreadData2;
                j3dThreadData2.needsRun = true;
                j3dThreadData2.threadOpts = 2;
                j3dThreadData2.lastRunTime = this.currentTime;
                continue;
            }
            j3dThreadData2.needsRun = false;
        }
        if (j3dThreadData != null) {
            j3dThreadData.threadOpts = 1;
            j3dThreadData = null;
        }
        while (n < this.lastStructureUpdateThread) {
            j3dThreadData2 = j3dThreadDataArray[n++];
            if (j3dThreadData2.lastUpdateTime > j3dThreadData2.lastRunTime && !j3dThreadData2.thread.userStop) {
                j3dThreadData = j3dThreadData2;
                j3dThreadData2.needsRun = true;
                j3dThreadData2.threadOpts = 2;
                j3dThreadData2.lastRunTime = this.currentTime;
                continue;
            }
            j3dThreadData2.needsRun = false;
        }
        if (j3dThreadData != null) {
            j3dThreadData.threadOpts = 1;
            j3dThreadData = null;
        }
        while (n < n2) {
            j3dThreadData2 = j3dThreadDataArray[n++];
            if (j3dThreadData2.lastUpdateTime > j3dThreadData2.lastRunTime && !j3dThreadData2.thread.userStop) {
                j3dThreadData = j3dThreadData2;
                j3dThreadData2.needsRun = true;
                j3dThreadData2.threadOpts = 2;
                j3dThreadData2.lastRunTime = this.currentTime;
                continue;
            }
            j3dThreadData2.needsRun = false;
        }
        if (j3dThreadData != null) {
            j3dThreadData.threadOpts = 1;
            j3dThreadData = null;
        }
        j3dThreadDataArray = (J3dThreadData[])this.renderWorkThreads.toArray(false);
        n2 = this.renderWorkThreads.arraySize();
        View view = null;
        J3dThreadData j3dThreadData3 = null;
        ++this.waitTimestamp;
        this.sleepTime = Long.MAX_VALUE;
        boolean bl = false;
        boolean bl2 = false;
        n = 0;
        while (n < n2) {
            j3dThreadData2 = j3dThreadDataArray[n];
            if (j3dThreadData2.canvas == null) {
                ((Object[])j3dThreadData2.threadArgs)[3] = null;
            }
            if (j3dThreadData2.view != view) {
                j3dThreadData2.view.computeCycleTime();
                if (j3dThreadData2.view.sleepTime < this.sleepTime) {
                    this.sleepTime = j3dThreadData2.view.sleepTime;
                }
            }
            if (j3dThreadData2.lastUpdateTime > j3dThreadData2.lastRunTime && !j3dThreadData2.thread.userStop) {
                if (!j3dThreadData2.view.isMinCycleTimeAchieve) {
                    j3dThreadData2.needsRun = false;
                    bl2 = true;
                } else {
                    if (j3dThreadData2.thread.lastWaitTimestamp == this.waitTimestamp) {
                        ++this.waitTimestamp;
                        if (j3dThreadData2.view != view) {
                            view = j3dThreadData2.view;
                            bl = true;
                            j3dThreadData3.threadOpts = 17;
                            ((Object[])j3dThreadData3.threadArgs)[3] = j3dThreadData3.view;
                            j3dThreadData2.threadOpts = 10;
                        } else {
                            j3dThreadData3.threadOpts = (j3dThreadData3.threadOpts & 8) != 0 ? 9 : 1;
                            j3dThreadData2.threadOpts = 2;
                        }
                    } else if (j3dThreadData2.view != view) {
                        view = j3dThreadData2.view;
                        bl = true;
                        if (j3dThreadData3 != null) {
                            j3dThreadData3.threadOpts = 17;
                            ((Object[])j3dThreadData3.threadArgs)[3] = j3dThreadData3.view;
                        }
                        j3dThreadData2.threadOpts = 10;
                    } else {
                        j3dThreadData2.threadOpts = 2;
                    }
                    j3dThreadData2.thread.lastWaitTimestamp = this.waitTimestamp;
                    j3dThreadData2.needsRun = true;
                    j3dThreadData2.lastRunTime = this.currentTime;
                    j3dThreadData3 = j3dThreadData2;
                }
            } else {
                j3dThreadData2.needsRun = false;
            }
            ++n;
        }
        if (j3dThreadData3 != null) {
            j3dThreadData3.threadOpts = 49;
            this.lockGeometry = true;
            ((Object[])j3dThreadData3.threadArgs)[3] = j3dThreadData3.view;
        } else {
            this.lockGeometry = false;
        }
        if (bl2 && !bl) {
            this.sleepTime -= this.currentTime - l;
            if (this.sleepTime > 0L) {
                this.runMonitor(7, null, null, null, null);
            }
            this.setWork();
        }
    }

    private void createUpdateThread(J3dStructure j3dStructure) {
        final J3dStructure j3dStructure2 = j3dStructure;
        if (j3dStructure2.updateThread == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    ThreadGroup threadGroup = rootThreadGroup;
                    synchronized (threadGroup) {
                        j3dStructure2.updateThread = new StructureUpdateThread(rootThreadGroup, j3dStructure2, j3dStructure2.threadType);
                        j3dStructure2.updateThread.setPriority(threadPriority);
                    }
                    return null;
                }
            });
            j3dStructure2.updateThread.initialize();
            j3dStructure2.threadData.thread = j3dStructure2.updateThread;
            j3dStructure2.threadData.lastUpdateTime = Math.max(this.currentTime, j3dStructure2.threadData.lastUpdateTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emptyMessageList(J3dStructure j3dStructure, View view) {
        if (j3dStructure != null) {
            UnorderList unorderList;
            if (view == null) {
                if (j3dStructure.threadData != null) {
                    j3dStructure.threadData.thread = null;
                }
                if (j3dStructure.updateThread != null) {
                    j3dStructure.updateThread.structure = null;
                }
                j3dStructure.updateThread = null;
            }
            boolean bl = false;
            if (view != null && view.universe != null) {
                int n = this.views.size() - 1;
                while (n >= 0) {
                    if (((View)this.views.get((int)n)).universe == view.universe) {
                        bl = true;
                        break;
                    }
                    --n;
                }
            }
            UnorderList unorderList2 = unorderList = j3dStructure.messageList;
            synchronized (unorderList2) {
                int n = unorderList.size();
                if (n > 0) {
                    J3dMessage[] j3dMessageArray = (J3dMessage[])unorderList.toArray(false);
                    int n2 = 0;
                    Object var10_10 = null;
                    while (n2 < n) {
                        J3dMessage j3dMessage = j3dMessageArray[n2];
                        if (view == null || j3dMessage.view == view || j3dMessage.view == null && !bl) {
                            if (j3dMessage.type == 0) break;
                            j3dMessage.decRefcount();
                            unorderList.removeOrdered(n2);
                            --n;
                            continue;
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    private void destroyUpdateThread(J3dStructure j3dStructure) {
        if (j3dStructure.updateThread != null) {
            j3dStructure.updateThread.finish();
            j3dStructure.updateThread.structure = null;
            j3dStructure.updateThread = null;
        }
        j3dStructure.threadData.thread = null;
        j3dStructure.clearMessages();
    }

    private void registerView(View view) {
        final VirtualUniverse virtualUniverse = view.universe;
        if (this.views.contains(view) && this.regUniverseList.contains(virtualUniverse)) {
            return;
        }
        if (this.timerThread == null) {
            this.running = true;
            this.createMCThreads();
        }
        view.assignViewId();
        this.createUpdateThread(virtualUniverse.behaviorStructure);
        this.createUpdateThread(virtualUniverse.geometryStructure);
        this.createUpdateThread(virtualUniverse.soundStructure);
        this.createUpdateThread(virtualUniverse.renderingEnvironmentStructure);
        this.createUpdateThread(virtualUniverse.transformStructure);
        J3dThreadData j3dThreadData = null;
        if (virtualUniverse.behaviorScheduler == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    ThreadGroup threadGroup = rootThreadGroup;
                    synchronized (threadGroup) {
                        virtualUniverse.behaviorScheduler = new BehaviorScheduler(rootThreadGroup, virtualUniverse);
                        virtualUniverse.behaviorScheduler.setPriority(threadPriority);
                    }
                    return null;
                }
            });
            virtualUniverse.behaviorScheduler.initialize();
            virtualUniverse.behaviorScheduler.userStop = view.stopBehavior;
            j3dThreadData = virtualUniverse.behaviorScheduler.getThreadData(null, null);
            j3dThreadData.thread = virtualUniverse.behaviorScheduler;
            j3dThreadData.threadType = 1;
            j3dThreadData.lastUpdateTime = Math.max(this.currentTime, j3dThreadData.lastUpdateTime);
        }
        this.createUpdateThread(view.renderBin);
        this.createUpdateThread(view.soundScheduler);
        if (view.physicalEnvironment != null) {
            view.physicalEnvironment.addUser(view);
        }
        this.evaluatePhysicalEnv(view);
        this.regUniverseList.addUnique(virtualUniverse);
        this.views.addUnique(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterView(View view) {
        int n;
        Object object;
        Enumeration enumeration;
        if (!this.views.remove(view)) {
            view.active = false;
            view.doneUnregister = true;
            return;
        }
        if (view.active) {
            this.viewDeactivate(view);
        }
        view.soundScheduler.updateThread.finish();
        view.renderBin.updateThread.finish();
        view.soundScheduler.updateThread = null;
        view.renderBin.updateThread = null;
        VirtualUniverse virtualUniverse = view.universe;
        Object object2 = this.timeLock;
        synchronized (object2) {
            this.emptyMessageList(view.soundScheduler, view);
            this.emptyMessageList(view.renderBin, view);
            if (virtualUniverse.isEmpty()) {
                this.destroyUniverseThreads(virtualUniverse);
            } else {
                this.emptyMessageList(virtualUniverse.behaviorStructure, view);
                this.emptyMessageList(virtualUniverse.geometryStructure, view);
                this.emptyMessageList(virtualUniverse.soundStructure, view);
                this.emptyMessageList(virtualUniverse.renderingEnvironmentStructure, view);
                this.emptyMessageList(virtualUniverse.transformStructure, view);
            }
        }
        if (view.physicalEnvironment != null) {
            view.physicalEnvironment.removeUser(view);
        }
        UnorderList unorderList = new UnorderList(1, class$javax$media$j3d$PhysicalEnvironment == null ? (class$javax$media$j3d$PhysicalEnvironment = MasterControl.class$("javax.media.j3d.PhysicalEnvironment")) : class$javax$media$j3d$PhysicalEnvironment);
        Enumeration enumeration2 = PhysicalEnvironment.physicalEnvMap.keys();
        while (enumeration2.hasMoreElements()) {
            enumeration = (PhysicalEnvironment)enumeration2.nextElement();
            object = (InputDeviceScheduler)PhysicalEnvironment.physicalEnvMap.get(enumeration);
            n = ((PhysicalEnvironment)((Object)enumeration)).users.size() - 1;
            while (n >= 0) {
                if (this.views.contains((View)((PhysicalEnvironment)((Object)enumeration)).users.get(n))) break;
                --n;
            }
            if (n >= 0) continue;
            ((J3dThread)object).finish();
            ((PhysicalEnvironment)((Object)enumeration)).inputsched = null;
            unorderList.add(enumeration);
        }
        n = unorderList.size() - 1;
        while (n >= 0) {
            PhysicalEnvironment.physicalEnvMap.remove(unorderList.get(n));
            --n;
        }
        this.freeContext(view);
        if (this.views.isEmpty()) {
            Object object3;
            enumeration = Screen3D.deviceRendererMap.elements();
            while (enumeration.hasMoreElements()) {
                object = (Renderer)enumeration.nextElement();
                this.rendererCleanupArgs[2] = REMOVEALLCTXS_CLEANUP;
                this.runMonitor(6, null, null, null, (J3dThread)object);
                object3 = ((Renderer)object).onScreen;
                if (object3 != null && ((Screen3D)object3).renderer != null) {
                    this.rendererCleanupArgs[2] = REMOVEALLCTXS_CLEANUP;
                    this.runMonitor(6, null, null, null, ((Screen3D)object3).renderer);
                    ((Screen3D)object3).renderer = null;
                }
                if ((object3 = ((Renderer)object).offScreen) != null && ((Screen3D)object3).renderer != null) {
                    this.rendererCleanupArgs[2] = REMOVEALLCTXS_CLEANUP;
                    this.runMonitor(6, null, null, null, ((Screen3D)object3).renderer);
                    ((Screen3D)object3).renderer = null;
                }
                ((Renderer)object).onScreen = null;
                ((Renderer)object).offScreen = null;
            }
            object = Screen3D.deviceRendererMap.elements();
            while (object.hasMoreElements()) {
                object3 = (Renderer)object.nextElement();
                ((Renderer)object3).cleanup();
            }
        } else {
            enumeration = Screen3D.deviceRendererMap.elements();
            while (enumeration.hasMoreElements()) {
                object = (Renderer)enumeration.nextElement();
                ((J3dThread)object).cleanupView();
            }
        }
        this.freeMessageList.add(virtualUniverse);
        this.freeMessageList.add(view);
        this.evaluateAllCanvases();
        this.stateWorkThreads.clear();
        this.renderWorkThreads.clear();
        this.requestRenderWorkThreads.clear();
        this.threadListsChanged = true;
        view.doneUnregister = true;
    }

    void createMCThreads() {
        this.createUpdateThread(this.renderingAttributesStructure);
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                ThreadGroup threadGroup = rootThreadGroup;
                synchronized (threadGroup) {
                    MasterControl.this.timerThread = new TimerThread(rootThreadGroup);
                    MasterControl.this.timerThread.setPriority(threadPriority);
                }
                return null;
            }
        });
        this.timerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyUniverseThreads(VirtualUniverse virtualUniverse) {
        if (this.regUniverseList.contains(virtualUniverse)) {
            this.destroyUpdateThread(virtualUniverse.behaviorStructure);
            this.destroyUpdateThread(virtualUniverse.geometryStructure);
            this.destroyUpdateThread(virtualUniverse.soundStructure);
            this.destroyUpdateThread(virtualUniverse.renderingEnvironmentStructure);
            this.destroyUpdateThread(virtualUniverse.transformStructure);
            virtualUniverse.behaviorScheduler.finish();
            virtualUniverse.behaviorScheduler.free();
            virtualUniverse.behaviorScheduler = null;
            virtualUniverse.initMCStructure();
            this.activeUniverseList.remove(virtualUniverse);
            this.regUniverseList.remove(virtualUniverse);
        } else {
            this.emptyMessageList(virtualUniverse.behaviorStructure, null);
            this.emptyMessageList(virtualUniverse.geometryStructure, null);
            this.emptyMessageList(virtualUniverse.soundStructure, null);
            this.emptyMessageList(virtualUniverse.renderingEnvironmentStructure, null);
            this.emptyMessageList(virtualUniverse.transformStructure, null);
        }
        if (this.regUniverseList.isEmpty() && this.views.isEmpty()) {
            if (this.renderingAttributesStructure.updateThread != null) {
                this.renderingAttributesStructure.updateThread.finish();
                this.renderingAttributesStructure.updateThread = null;
            }
            this.renderingAttributesStructure.messageList.clear();
            this.renderingAttributesStructure.objList = new ArrayList();
            this.renderingAttributesStructure = new RenderingAttributesStructure();
            if (this.timerThread != null) {
                this.timerThread.finish();
                this.timerThread = null;
            }
            Hashtable hashtable = VirtualUniverse.mc.deviceScreenMap;
            synchronized (hashtable) {
                this.deviceScreenMap.clear();
            }
            FreeListManager.clearList(0);
            FreeListManager.clearList(1);
            FreeListManager.clearList(3);
            this.mirrorObjects.clear();
            FreeListManager.clearList(7);
            this.canvasBitCount = 0;
            this.renderOnceList.clear();
            this.timestampUpdateList.clear();
            FreeListManager.clearList(2);
            this.defaultRenderMethod = null;
            this.text3DRenderMethod = null;
            this.vertexArrayRenderMethod = null;
            this.displayListRenderMethod = null;
            this.compressedGeometryRenderMethod = null;
            this.orientedShape3DRenderMethod = null;
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateAllCanvases() {
        UnorderList unorderList = this.renderThreadData;
        synchronized (unorderList) {
            this.renderThreadData.clear();
            View[] viewArray = (View[])this.views.toArray(false);
            int n = this.views.size() - 1;
            while (n >= 0) {
                viewArray[n].getCanvasList(true);
                Screen3D[] screen3DArray = viewArray[n].getScreens();
                int n2 = screen3DArray.length - 1;
                while (n2 >= 0) {
                    screen3DArray[n2].canvasCount = 0;
                    --n2;
                }
                --n;
            }
            int n3 = this.views.size() - 1;
            while (n3 >= 0) {
                View view = viewArray[n3];
                Canvas3D[][] canvas3DArray = view.getCanvasList(false);
                if (view.active) {
                    int n4 = canvas3DArray.length - 1;
                    while (n4 >= 0) {
                        boolean bl = false;
                        int n5 = canvas3DArray[n4].length - 1;
                        while (n5 >= 0) {
                            Canvas3D canvas3D = canvas3DArray[n4][n5];
                            final Screen3D screen3D = canvas3D.screen;
                            if (canvas3D.active) {
                                Object object;
                                if (screen3D.canvasCount++ == 0 && screen3D.renderer == null) {
                                    object = (Renderer)Screen3D.deviceRendererMap.get(canvas3D.screen.graphicsDevice);
                                    if (object == null) {
                                        AccessController.doPrivileged(new PrivilegedAction(){

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            public Object run() {
                                                ThreadGroup threadGroup = rootThreadGroup;
                                                synchronized (threadGroup) {
                                                    screen3D.renderer = new Renderer(rootThreadGroup);
                                                    screen3D.renderer.setPriority(threadPriority);
                                                }
                                                return null;
                                            }
                                        });
                                        screen3D.renderer.initialize();
                                        Screen3D.deviceRendererMap.put(screen3D.graphicsDevice, screen3D.renderer);
                                    } else {
                                        screen3D.renderer = object;
                                    }
                                }
                                if (canvas3D.offScreen) {
                                    screen3D.renderer.offScreen = screen3D;
                                } else {
                                    screen3D.renderer.onScreen = screen3D;
                                    if (!bl) {
                                        object = screen3D.renderer.getThreadData(view, null);
                                        this.renderThreadData.add(object);
                                        if (view.renderBinReady) {
                                            ((J3dThreadData)object).lastUpdateTime = Math.max(this.currentTime, ((J3dThreadData)object).lastUpdateTime);
                                        }
                                        bl = true;
                                    }
                                    object = screen3D.renderer.getThreadData(view, canvas3D);
                                    this.renderThreadData.add(object);
                                    if (view.renderBinReady) {
                                        ((J3dThreadData)object).lastUpdateTime = Math.max(this.currentTime, ((J3dThreadData)object).lastUpdateTime);
                                    }
                                }
                            }
                            --n5;
                        }
                        --n4;
                    }
                }
                --n3;
            }
        }
        this.threadListsChanged = true;
    }

    private void evaluatePhysicalEnv(View view) {
        final PhysicalEnvironment physicalEnvironment = view.physicalEnvironment;
        if (physicalEnvironment.inputsched == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    ThreadGroup threadGroup = rootThreadGroup;
                    synchronized (threadGroup) {
                        physicalEnvironment.inputsched = new InputDeviceScheduler(rootThreadGroup, physicalEnvironment);
                        physicalEnvironment.inputsched.setPriority(threadPriority);
                    }
                    return null;
                }
            });
            physicalEnvironment.inputsched.start();
            PhysicalEnvironment.physicalEnvMap.put(physicalEnvironment, physicalEnvironment.inputsched);
        }
        this.threadListsChanged = true;
    }

    private final void addToStateThreads(J3dThreadData j3dThreadData) {
        if (j3dThreadData.thread.active) {
            this.stateWorkThreads.add(j3dThreadData);
        }
    }

    private void assignNewPrimaryView(VirtualUniverse virtualUniverse) {
        View view = virtualUniverse.getCurrentView();
        if (view != null) {
            view.primaryView = false;
        }
        View[] viewArray = (View[])this.views.toArray(false);
        int n = this.views.size();
        int n2 = 0;
        while (n2 < n) {
            View view2 = viewArray[n2];
            if (view2.active && view2.isRunning && virtualUniverse == view2.universe) {
                view2.primaryView = true;
                virtualUniverse.setCurrentView(view2);
                return;
            }
            ++n2;
        }
        virtualUniverse.setCurrentView(null);
    }

    RenderMethod getDefaultRenderMethod() {
        if (this.defaultRenderMethod == null) {
            this.defaultRenderMethod = new DefaultRenderMethod();
        }
        return this.defaultRenderMethod;
    }

    RenderMethod getText3DRenderMethod() {
        if (this.text3DRenderMethod == null) {
            this.text3DRenderMethod = new Text3DRenderMethod();
        }
        return this.text3DRenderMethod;
    }

    RenderMethod getVertexArrayRenderMethod() {
        if (this.vertexArrayRenderMethod == null) {
            this.vertexArrayRenderMethod = new VertexArrayRenderMethod();
        }
        return this.vertexArrayRenderMethod;
    }

    RenderMethod getDisplayListRenderMethod() {
        if (this.displayListRenderMethod == null) {
            this.displayListRenderMethod = new DisplayListRenderMethod();
        }
        return this.displayListRenderMethod;
    }

    RenderMethod getCompressedGeometryRenderMethod() {
        if (this.compressedGeometryRenderMethod == null) {
            this.compressedGeometryRenderMethod = new CompressedGeometryRenderMethod();
        }
        return this.compressedGeometryRenderMethod;
    }

    RenderMethod getOrientedShape3DRenderMethod() {
        if (this.orientedShape3DRenderMethod == null) {
            this.orientedShape3DRenderMethod = new OrientedShape3DRenderMethod();
        }
        return this.orientedShape3DRenderMethod;
    }

    private void viewActivate(View view) {
        VirtualUniverse virtualUniverse = view.universe;
        if (virtualUniverse == null) {
            return;
        }
        if (!this.views.contains(view) || !this.regUniverseList.contains(virtualUniverse)) {
            this.registerView(view);
        } else if (view.active) {
            this.evaluateAllCanvases();
            return;
        }
        if (virtualUniverse.activeViewCount == 0) {
            virtualUniverse.geometryStructure.resetConditionMet();
            virtualUniverse.behaviorStructure.resetConditionMet();
        }
        if (view.isRunning) {
            ++this.numActiveViews;
            ++virtualUniverse.activeViewCount;
            this.renderingAttributesStructure.updateThread.active = true;
            virtualUniverse.transformStructure.updateThread.active = true;
            virtualUniverse.geometryStructure.updateThread.active = true;
            virtualUniverse.soundStructure.updateThread.active = true;
            virtualUniverse.renderingEnvironmentStructure.updateThread.active = true;
        }
        virtualUniverse.behaviorScheduler.active = true;
        virtualUniverse.behaviorStructure.updateThread.active = true;
        this.activeUniverseList.addUnique(virtualUniverse);
        if (view.isRunning) {
            view.soundScheduler.activate();
            view.renderBin.updateThread.active = true;
        }
        view.active = true;
        if (view.physicalEnvironment.activeViewRef++ == 0) {
            view.physicalEnvironment.inputsched.activate();
        }
        if (virtualUniverse.getCurrentView() == null) {
            this.assignNewPrimaryView(virtualUniverse);
        }
        this.evaluateAllCanvases();
        view.inRenderThreadData = true;
        this.threadListsChanged = true;
        view.renderBin.reactivateView = true;
    }

    private void freeContext(View view) {
        Canvas3D[][] canvas3DArray = view.getCanvasList(false);
        int n = canvas3DArray.length - 1;
        while (n >= 0) {
            int n2 = canvas3DArray[n].length - 1;
            while (n2 >= 0) {
                Canvas3D canvas3D = canvas3DArray[n][n2];
                if (!canvas3D.validCanvas && canvas3D.screen != null && canvas3D.screen.renderer != null) {
                    this.rendererCleanupArgs[1] = canvas3D;
                    this.rendererCleanupArgs[2] = FREECONTEXT_CLEANUP;
                    this.runMonitor(6, null, null, null, canvas3D.screen.renderer);
                    this.rendererCleanupArgs[1] = null;
                }
                --n2;
            }
            --n;
        }
    }

    private void viewDeactivate(View view) {
        if (!this.views.contains(view) || !view.active) {
            view.active = false;
            this.evaluateAllCanvases();
            return;
        }
        VirtualUniverse virtualUniverse = view.universe;
        if (view.isRunning) {
            --this.numActiveViews;
            --virtualUniverse.activeViewCount;
        }
        if (this.numActiveViews == 0) {
            this.renderingAttributesStructure.updateThread.active = false;
        }
        if (virtualUniverse.activeViewCount == 0 && virtualUniverse.behaviorScheduler != null) {
            virtualUniverse.behaviorScheduler.deactivate();
            virtualUniverse.transformStructure.updateThread.active = false;
            virtualUniverse.geometryStructure.updateThread.active = false;
            virtualUniverse.behaviorStructure.updateThread.active = false;
            virtualUniverse.soundStructure.updateThread.active = false;
            virtualUniverse.renderingEnvironmentStructure.updateThread.active = false;
            this.activeUniverseList.remove(virtualUniverse);
        }
        view.soundScheduler.deactivate();
        view.renderBin.updateThread.active = false;
        view.active = false;
        if (--view.physicalEnvironment.activeViewRef == 0) {
            view.physicalEnvironment.inputsched.deactivate();
        }
        this.assignNewPrimaryView(virtualUniverse);
        this.evaluateAllCanvases();
        this.freeContext(view);
        view.inRenderThreadData = false;
        this.threadListsChanged = true;
    }

    private void startView(View view) {
        if (!this.views.contains(view) || view.isRunning || !view.active) {
            view.isRunning = true;
            return;
        }
        ++this.numActiveViews;
        this.renderingAttributesStructure.updateThread.active = true;
        VirtualUniverse virtualUniverse = view.universe;
        ++virtualUniverse.activeViewCount;
        virtualUniverse.transformStructure.updateThread.active = true;
        virtualUniverse.geometryStructure.updateThread.active = true;
        virtualUniverse.soundStructure.updateThread.active = true;
        virtualUniverse.renderingEnvironmentStructure.updateThread.active = true;
        view.renderBin.updateThread.active = true;
        view.soundScheduler.activate();
        view.isRunning = true;
        if (virtualUniverse.getCurrentView() == null) {
            this.assignNewPrimaryView(virtualUniverse);
        }
        this.threadListsChanged = true;
    }

    private void stopView(View view) {
        if (!(this.views.contains(view) && view.isRunning && view.active)) {
            view.isRunning = false;
            return;
        }
        if (--this.numActiveViews == 0) {
            this.renderingAttributesStructure.updateThread.active = false;
        }
        VirtualUniverse virtualUniverse = view.universe;
        if (--virtualUniverse.activeViewCount == 0) {
            virtualUniverse.transformStructure.updateThread.active = false;
            virtualUniverse.geometryStructure.updateThread.active = false;
            virtualUniverse.renderingEnvironmentStructure.updateThread.active = false;
            virtualUniverse.soundStructure.updateThread.active = false;
        }
        view.renderBin.updateThread.active = false;
        view.soundScheduler.deactivate();
        view.isRunning = false;
        this.assignNewPrimaryView(virtualUniverse);
        this.threadListsChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInputDeviceScheduler(InputDeviceScheduler inputDeviceScheduler) {
        UnorderList unorderList = this.inputDeviceThreads;
        synchronized (unorderList) {
            this.inputDeviceThreads.add(inputDeviceScheduler);
            if (this.inputDeviceThreads.size() == 1) {
                this.timerThread.addInputDeviceSchedCond();
            }
        }
        this.postRequest(INPUTDEVICE_CHANGE, null);
    }

    void removeInputDeviceScheduler(InputDeviceScheduler inputDeviceScheduler) {
        this.inputDeviceThreads.remove(inputDeviceScheduler);
        this.postRequest(INPUTDEVICE_CHANGE, null);
    }

    void addMirrorObject(ObjectUpdate objectUpdate) {
        this.mirrorObjects.add(objectUpdate);
    }

    void updateMirrorObjects() {
        ObjectUpdate[] objectUpdateArray = (ObjectUpdate[])this.mirrorObjects.toArray(false);
        int n = this.mirrorObjects.arraySize();
        int n2 = 0;
        while (n2 < n) {
            objectUpdateArray[n2].updateObject();
            ++n2;
        }
        this.mirrorObjects.clear();
    }

    private void updateWorkThreads() {
        J3dThreadData j3dThreadData;
        Canvas3D[][] canvas3DArray;
        Object object;
        View[] viewArray;
        this.stateWorkThreads.clear();
        this.renderWorkThreads.clear();
        this.requestRenderWorkThreads.clear();
        if (this.numActiveViews > 0) {
            this.addToStateThreads(this.renderingAttributesStructure.getUpdateThreadData());
        }
        VirtualUniverse[] virtualUniverseArray = (VirtualUniverse[])this.activeUniverseList.toArray(false);
        int n = this.activeUniverseList.arraySize();
        int n2 = n - 1;
        while (n2 >= 0) {
            this.addToStateThreads(virtualUniverseArray[n2].transformStructure.getUpdateThreadData());
            --n2;
        }
        this.lastTransformStructureThread = this.stateWorkThreads.size();
        n2 = n - 1;
        while (n2 >= 0) {
            VirtualUniverse virtualUniverse = virtualUniverseArray[n2];
            this.addToStateThreads(virtualUniverse.geometryStructure.getUpdateThreadData());
            this.addToStateThreads(virtualUniverse.behaviorStructure.getUpdateThreadData());
            this.addToStateThreads(virtualUniverse.renderingEnvironmentStructure.getUpdateThreadData());
            this.addToStateThreads(virtualUniverse.soundStructure.getUpdateThreadData());
            --n2;
        }
        this.lastStructureUpdateThread = this.stateWorkThreads.size();
        n2 = n - 1;
        while (n2 >= 0) {
            this.addToStateThreads(virtualUniverseArray[n2].behaviorScheduler.getThreadData(null, null));
            --n2;
        }
        InputDeviceScheduler[] inputDeviceSchedulerArray = (InputDeviceScheduler[])this.inputDeviceThreads.toArray(true);
        n2 = this.inputDeviceThreads.size() - 1;
        while (n2 >= 0) {
            viewArray = inputDeviceSchedulerArray[n2].getThreadData();
            viewArray.thread.active = true;
            this.addToStateThreads((J3dThreadData)viewArray);
            --n2;
        }
        viewArray = (View[])this.views.toArray(false);
        n2 = this.views.size() - 1;
        while (n2 >= 0) {
            object = viewArray[n2];
            if (((View)object).active && ((View)object).isRunning) {
                int n3;
                this.addToStateThreads(((View)object).renderBin.getUpdateThreadData());
                this.addToStateThreads(((View)object).soundScheduler.getUpdateThreadData());
                canvas3DArray = ((View)object).getCanvasList(false);
                int n4 = ((View)object).getLongestScreenList();
                Object[] objectArray = null;
                int n5 = 0;
                while (n5 < n4) {
                    n3 = 0;
                    while (n3 < canvas3DArray.length) {
                        if (n5 < canvas3DArray[n3].length) {
                            Canvas3D canvas3D = canvas3DArray[n3][n5];
                            if (canvas3D.active && canvas3D.isRunningStatus && !canvas3D.offScreen && canvas3D.screen.renderer != null) {
                                j3dThreadData = canvas3D.screen.renderer.getThreadData((View)object, canvas3D);
                                this.renderWorkThreads.add(j3dThreadData);
                                objectArray = (Object[])j3dThreadData.threadArgs;
                                objectArray[0] = RENDER;
                                objectArray[1] = canvas3D;
                                objectArray[2] = object;
                            }
                        }
                        ++n3;
                    }
                    ++n5;
                }
                n3 = 0;
                while (n3 < canvas3DArray.length) {
                    int n6 = 0;
                    while (n6 < canvas3DArray[n3].length) {
                        Canvas3D canvas3D = canvas3DArray[n3][n6];
                        if (canvas3D.active && canvas3D.isRunningStatus && !canvas3D.offScreen && canvas3D.screen.renderer != null) {
                            j3dThreadData = canvas3D.screen.renderer.getThreadData((View)object, null);
                            this.renderWorkThreads.add(j3dThreadData);
                            objectArray = (Object[])j3dThreadData.threadArgs;
                            objectArray[0] = SWAP;
                            objectArray[1] = object;
                            objectArray[2] = canvas3DArray[n3];
                            break;
                        }
                        ++n6;
                    }
                    ++n3;
                }
            }
            --n2;
        }
        j3dThreadData = null;
        object = Screen3D.deviceRendererMap.elements();
        while (object.hasMoreElements()) {
            canvas3DArray = (Canvas3D[][])object.nextElement();
            j3dThreadData = canvas3DArray.getThreadData(null, null);
            this.requestRenderWorkThreads.add(j3dThreadData);
            j3dThreadData.threadOpts = 2;
            ((Object[])j3dThreadData.threadArgs)[0] = REQUESTRENDER;
        }
        if (j3dThreadData != null) {
            j3dThreadData.threadOpts |= 1;
        }
        this.threadListsChanged = false;
    }

    void dumpWorkThreads() {
        System.err.println("-----------------------------");
        System.err.println("MasterControl/dumpWorkThreads");
        int n = 0;
        int n2 = 0;
        while (n2 < 3) {
            J3dThreadData[] j3dThreadDataArray;
            switch (n2) {
                case 0: {
                    j3dThreadDataArray = (J3dThreadData[])this.stateWorkThreads.toArray(false);
                    n = this.stateWorkThreads.arraySize();
                    break;
                }
                case 1: {
                    j3dThreadDataArray = (J3dThreadData[])this.renderWorkThreads.toArray(false);
                    n = this.renderWorkThreads.arraySize();
                    break;
                }
                default: {
                    j3dThreadDataArray = (J3dThreadData[])this.requestRenderWorkThreads.toArray(false);
                    n = this.requestRenderWorkThreads.arraySize();
                }
            }
            int n3 = 0;
            while (n3 < n) {
                J3dThreadData j3dThreadData = j3dThreadDataArray[n3];
                System.err.println("Thread " + n3 + ": " + j3dThreadData.thread);
                System.err.println("\tOps: " + j3dThreadData.threadOpts);
                if (j3dThreadData.threadArgs != null) {
                    Object[] objectArray = (Object[])j3dThreadData.threadArgs;
                    System.err.print("\tArgs: ");
                    int n4 = 0;
                    while (n4 < objectArray.length) {
                        System.err.print(objectArray[n4] + " ");
                        ++n4;
                    }
                }
                System.err.println("");
                ++n3;
            }
            ++n2;
        }
        System.err.println("-----------------------------");
    }

    final void setWork() {
        this.runMonitor(1, null, null, null, null);
    }

    final void setWorkForRequestRenderer() {
        this.runMonitor(5, null, null, null, null);
    }

    void sendRenderMessage(GraphicsConfiguration graphicsConfiguration, Object object, Integer n) {
        Renderer renderer = this.createRenderer(graphicsConfiguration);
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 16;
        j3dMessage.type = 44;
        j3dMessage.universe = null;
        j3dMessage.view = null;
        j3dMessage.args[0] = null;
        j3dMessage.args[1] = object;
        j3dMessage.args[2] = n;
        renderer.rendererStructure.addMessage(j3dMessage);
        VirtualUniverse.mc.setWorkForRequestRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWork() {
        Object object;
        this.runMonitor(0, null, null, null, null);
        if (this.pendingRequest) {
            object = this.timeLock;
            synchronized (object) {
                UnorderList unorderList = this.requestObjList;
                synchronized (unorderList) {
                    this.handlePendingRequest();
                }
            }
        }
        if (!this.running) {
            return;
        }
        if (this.threadListsChanged) {
            this.updateWorkThreads();
        }
        object = this.timeLock;
        synchronized (object) {
            this.updateTimeValues();
        }
        View[] viewArray = (View[])this.views.toArray(false);
        int n = this.views.size() - 1;
        while (n >= 0) {
            if (viewArray[n].active) {
                viewArray[n].updateViewCache();
                if (viewArray[n].viewCache.vcDirtyMask != 0 && !viewArray[n].renderBin.orientedRAs.isEmpty() || viewArray[n].renderBin.cachedDirtyOrientedRAs != null && !viewArray[n].renderBin.cachedDirtyOrientedRAs.isEmpty()) {
                    viewArray[n].renderBin.updateOrientedRAs();
                }
            }
            --n;
        }
        this.runMonitor(2, this.stateWorkThreads, this.renderWorkThreads, this.requestRenderWorkThreads, null);
        if (this.renderOnceList.size() > 0) {
            this.clearRenderOnceList();
        }
        this.manageMemory();
    }

    private void handlePendingRequest() {
        Object object;
        Object object2;
        boolean bl = false;
        Object[] objectArray = this.requestObjList.toArray(false);
        Integer[] integerArray = (Integer[])this.requestTypeList.toArray(false);
        int n = this.requestObjList.size();
        int n2 = 0;
        while (n2 < n) {
            Integer n3 = integerArray[n2];
            object2 = objectArray[n2];
            if (n3 == RESET_CANVAS) {
                object = (Canvas3D)object2;
                if (((Canvas3D)object).screen != null && ((Canvas3D)object).screen.renderer != null) {
                    this.rendererCleanupArgs[1] = object2;
                    this.rendererCleanupArgs[2] = RESETCANVAS_CLEANUP;
                    this.runMonitor(6, null, null, null, ((Canvas3D)object).screen.renderer);
                    this.rendererCleanupArgs[1] = null;
                }
                ((Canvas3D)object).reset();
                ((Canvas3D)object).view = null;
                ((Canvas3D)object).computeViewCache();
            } else if (n3 == ACTIVATE_VIEW) {
                this.viewActivate((View)object2);
            } else if (n3 == DEACTIVATE_VIEW) {
                this.viewDeactivate((View)object2);
            } else if (n3 == REEVALUATE_CANVAS) {
                this.evaluateAllCanvases();
            } else if (n3 == INPUTDEVICE_CHANGE) {
                this.inputDeviceThreads.clearMirror();
                this.threadListsChanged = true;
            } else if (n3 == START_VIEW) {
                this.startView((View)object2);
            } else if (n3 == STOP_VIEW) {
                object = (View)object2;
                if (++((View)object).stopViewCount > 4) {
                    ((View)object).stopViewCount = -1;
                    this.stopView((View)object);
                } else {
                    this.tempViewList.add(object);
                }
            } else if (n3 == UNREGISTER_VIEW) {
                this.unregisterView((View)object2);
            } else if (n3 == PHYSICAL_ENV_CHANGE) {
                this.evaluatePhysicalEnv((View)object2);
            } else if (n3 == EMPTY_UNIVERSE) {
                if (this.views.isEmpty()) {
                    this.destroyUniverseThreads((VirtualUniverse)object2);
                    this.threadListsChanged = true;
                }
            } else if (n3 == START_RENDERER) {
                ((Canvas3D)object2).isRunningStatus = true;
                this.threadListsChanged = true;
            } else if (n3 == STOP_RENDERER) {
                if (object2 instanceof Canvas3D) {
                    ((Canvas3D)object2).isRunningStatus = false;
                } else {
                    ((Renderer)object2).userStop = true;
                }
                this.threadListsChanged = true;
            } else if (n3 == RENDER_ONCE) {
                object = (View)object2;
                this.startView((View)object);
                this.renderOnceList.add(object);
                this.sendRunMessage((View)object, 128);
                this.threadListsChanged = true;
                bl = true;
            } else if (n3 == FREE_CONTEXT) {
                object = (Canvas3D)((Object[])object2)[0];
                if (((Canvas3D)object).screen != null && ((Canvas3D)object).screen.renderer != null) {
                    this.rendererCleanupArgs[1] = object2;
                    this.rendererCleanupArgs[2] = REMOVECTX_CLEANUP;
                    this.runMonitor(6, null, null, null, ((Canvas3D)object).screen.renderer);
                    this.rendererCleanupArgs[1] = null;
                }
                bl = true;
            } else if (n3 == FREE_DRAWING_SURFACE) {
                DrawingSurfaceObjectAWT.freeDrawingSurface(object2);
            } else if (n3 == GETBESTCONFIG) {
                object = ((GraphicsConfiguration[])((GraphicsConfigTemplate3D)object2).testCfg)[0];
                this.sendRenderMessage((GraphicsConfiguration)object, object2, n3);
                bl = true;
            } else if (n3 == ISCONFIGSUPPORT) {
                object = (GraphicsConfiguration)((GraphicsConfigTemplate3D)object2).testCfg;
                this.sendRenderMessage((GraphicsConfiguration)object, object2, n3);
                bl = true;
            } else if (n3 == SET_GRAPHICSCONFIG_FEATURES || n3 == SET_QUERYPROPERTIES) {
                object = ((Canvas3D)object2).graphicsConfiguration;
                this.sendRenderMessage((GraphicsConfiguration)object, object2, n3);
                bl = true;
            } else if (n3 == SET_VIEW) {
                object = (Canvas3D)object2;
                ((Canvas3D)object).view = ((Canvas3D)object).pendingView;
                ((Canvas3D)object).computeViewCache();
            }
            ++n2;
        }
        int n4 = 0;
        while (n4 < n) {
            object2 = integerArray[n4];
            if (object2 == FREE_MESSAGE) {
                if (objectArray[n4] instanceof VirtualUniverse) {
                    object = (VirtualUniverse)objectArray[n4];
                    if (!this.regUniverseList.contains(object)) {
                        this.emptyMessageList(((VirtualUniverse)object).behaviorStructure, null);
                        this.emptyMessageList(((VirtualUniverse)object).geometryStructure, null);
                        this.emptyMessageList(((VirtualUniverse)object).soundStructure, null);
                        this.emptyMessageList(((VirtualUniverse)object).renderingEnvironmentStructure, null);
                    }
                } else if (objectArray[n4] instanceof View && !this.views.contains(object = (View)objectArray[n4])) {
                    this.emptyMessageList(((View)object).soundScheduler, (View)object);
                    this.emptyMessageList(((View)object).renderBin, (View)object);
                    if (((View)object).resetUnivCount == ((View)object).universeCount) {
                        ((View)object).reset();
                        ((View)object).universe = null;
                        if (!this.running) {
                            // empty if block
                        }
                    }
                }
            }
            ++n4;
        }
        this.requestObjList.clear();
        this.requestTypeList.clear();
        n = this.tempViewList.size();
        if (n > 0) {
            int n5;
            if (this.running) {
                n5 = 0;
                while (n5 < n) {
                    this.requestTypeList.add(STOP_VIEW);
                    this.requestObjList.add(this.tempViewList.get(n5));
                    ++n5;
                }
                this.setWork();
            } else {
                n5 = 0;
                while (n5 < n) {
                    object = (View)this.tempViewList.get(n5);
                    ((View)object).stopViewCount = -1;
                    ((View)object).isRunning = false;
                    ++n5;
                }
            }
            this.tempViewList.clear();
            this.pendingRequest = true;
        } else {
            this.pendingRequest = bl || this.requestObjList.size() > 0;
        }
        n = this.freeMessageList.size();
        if (n > 0) {
            int n6 = 0;
            while (n6 < n) {
                this.requestTypeList.add(FREE_MESSAGE);
                this.requestObjList.add(this.freeMessageList.get(n6));
                ++n6;
            }
            this.pendingRequest = true;
            this.freeMessageList.clear();
        }
        if (!this.running && this.renderOnceList.size() > 0) {
            this.clearRenderOnceList();
        }
        if (this.pendingRequest) {
            this.setWork();
        }
        if (bl) {
            this.running = true;
        }
    }

    private void clearRenderOnceList() {
        int n = this.renderOnceList.size() - 1;
        while (n >= 0) {
            View view = (View)this.renderOnceList.get(n);
            view.renderOnceFinish = true;
            this.stopView(view);
            --n;
        }
        this.renderOnceList.clear();
        this.threadListsChanged = true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void runMonitor(int var1_1, UnorderList var2_2, UnorderList var3_3, UnorderList var4_4, J3dThread var5_5) {
        switch (var1_1) {
            case 2: {
                var6_6 = 0;
                var7_7 = 0;
                var8_8 = 0;
                var12_9 = (J3dThreadData[])var3_3.toArray(false);
                var13_10 = (J3dThreadData[])var2_2.toArray(false);
                var14_11 = (J3dThreadData[])var4_4.toArray(false);
                var15_12 = var3_3.arraySize();
                var16_13 = var2_2.arraySize();
                var17_14 = var4_4.arraySize();
                var10_15 = false;
                var18_16 = (View[])this.views.toArray(false);
                if (this.lockGeometry) {
                    var20_17 = this.views.arraySize() - 1;
                    while (var20_17 >= 0) {
                        var19_18 = var18_16[var20_17];
                        var19_18.renderBin.lockGeometry();
                        --var20_17;
                    }
                }
                ** GOTO lbl194
            }
            case 3: {
                if (this.state == 5) {
                    this.notify();
                    this.state = 1;
                    return;
                }
                --this.threadPending;
                if (var5_5.type == 16) {
                    var21_27 = (View)var5_5.args[3];
                    if (var21_27 != null) {
                        var21_27.stopTime = System.currentTimeMillis();
                    }
                    if (--this.renderPending == 0) {
                        this.renderWaiting = false;
                    }
                } else if (--this.statePending == 0) {
                    this.stateWaiting = false;
                }
                if (this.state != 4) {
                    if (this.state != 3) return;
                }
                this.notify();
                return;
            }
            case 4: {
                while (true) {
                    if (this.threadPending == 0) {
                        return;
                    }
                    this.state = 3;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var21_28) {
                        System.err.println(var21_28);
                    }
                }
            }
            case 0: {
                if (!this.workToDo) {
                    this.state = 0;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var21_29) {
                        System.err.println(var21_29);
                    }
                    this.state = 1;
                }
                this.workToDo = false;
                return;
            }
            case 1: {
                this.workToDo = true;
                if (this.state != 0) return;
                this.notify();
                return;
            }
            case 5: {
                this.requestRenderWorkToDo = true;
                if (this.state != 4 && this.state != 3) {
                    if (this.state != 0) return;
                }
                this.workToDo = true;
                this.notify();
                return;
            }
            case 6: {
                var5_5.runMonitor(2, this.currentTime, this.rendererCleanupArgs);
                this.state = 5;
                try {
                    this.wait();
                    return;
                }
                catch (InterruptedException var21_30) {
                    System.err.println(var21_30);
                    return;
                }
            }
            case 7: {
                this.state = 0;
                try {
                    this.wait(this.sleepTime);
                    return;
                }
                catch (InterruptedException var21_31) {
                    System.err.println(var21_31);
                    return;
                }
            }
        }
        return;
        {
            var11_20 = var12_9[var7_7++];
            if (var11_20.needsRun) {
                if ((var11_20.threadOpts & 8) != 0) {
                    var9_19 = (View)((Object[])var11_20.threadArgs)[2];
                    ++var9_19.frameNumber;
                    var9_19.startTime = System.currentTimeMillis();
                }
                ++this.renderPending;
                if (this.cpuLimit == 1) {
                    var11_20.thread.args = (Object[])var11_20.threadArgs;
                    var11_20.thread.doWork(this.currentTime);
                } else {
                    ++this.threadPending;
                    var11_20.thread.runMonitor(2, this.currentTime, (Object[])var11_20.threadArgs);
                }
                if ((var11_20.threadOpts & 16) != 0) {
                    var9_19 = (View)((Object[])var11_20.threadArgs)[3];
                    this.timestampUpdateList.add(var9_19);
                }
                if ((var11_20.threadOpts & 32) != 0) {
                    var20_17 = 0;
                    while (var20_17 < this.views.arraySize()) {
                        var19_18 = var18_16[var20_17];
                        var19_18.renderBin.releaseGeometry();
                        ++var20_17;
                    }
                }
                if (this.cpuLimit != 1 && (var11_20.threadOpts & 1) != 0) {
                    this.renderWaiting = true;
                }
                if (this.cpuLimit != 1 && this.cpuLimit <= this.threadPending) {
                    this.state = 4;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var21_21) {
                        System.err.println(var21_21);
                    }
                    this.state = 1;
                }
            }
            do {
                if (!this.renderWaiting && var7_7 != var15_12) continue block28;
                while (!this.stateWaiting && var6_6 != var16_13) {
                    var11_20 = var13_10[var6_6++];
                    if (!var11_20.needsRun) continue;
                    ++this.statePending;
                    if (this.cpuLimit == 1) {
                        var11_20.thread.args = (Object[])var11_20.threadArgs;
                        var11_20.thread.doWork(this.currentTime);
                    } else {
                        ++this.threadPending;
                        var11_20.thread.runMonitor(2, this.currentTime, (Object[])var11_20.threadArgs);
                    }
                    if (this.cpuLimit != 1 && (var11_20.threadOpts & 1) != 0) {
                        this.stateWaiting = true;
                    }
                    if (this.cpuLimit == 1 || this.cpuLimit > this.threadPending) continue;
                    if (var7_7 != var15_12) break;
                    this.state = 4;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var21_23) {
                        System.err.println(var21_23);
                    }
                    this.state = 1;
                }
                if (!this.renderWaiting && var7_7 == var15_12) {
                    var8_8 = 0;
                    while (!this.renderWaiting && var8_8 != var17_14) {
                        var11_20 = var14_11[var8_8++];
                        ++this.renderPending;
                        if (this.cpuLimit == 1) {
                            var11_20.thread.args = (Object[])var11_20.threadArgs;
                            var11_20.thread.doWork(this.currentTime);
                        } else {
                            ++this.threadPending;
                            var11_20.thread.runMonitor(2, this.currentTime, (Object[])var11_20.threadArgs);
                        }
                        if (this.cpuLimit != 1 && (var11_20.threadOpts & 1) != 0) {
                            this.renderWaiting = true;
                        }
                        if (this.cpuLimit == 1 || this.cpuLimit > this.threadPending) continue;
                        this.state = 4;
                        try {
                            this.wait();
                        }
                        catch (InterruptedException var21_24) {
                            System.err.println(var21_24);
                        }
                        this.state = 1;
                    }
                }
                if (this.cpuLimit != 1 && (this.renderWaiting != false && var6_6 == var16_13 || this.stateWaiting != false && var7_7 == var15_12 || this.renderWaiting && this.stateWaiting)) {
                    if (!this.requestRenderWorkToDo) {
                        this.state = 3;
                        try {
                            this.wait();
                        }
                        catch (InterruptedException var21_25) {
                            System.err.println(var21_25);
                        }
                        this.state = 1;
                    }
                    this.requestRenderWorkToDo = false;
                }
                if (var6_6 != var16_13 || var7_7 != var15_12 || var8_8 != var17_14 || this.threadPending != 0) continue;
                var21_26 = this.timestampUpdateList.size() - 1;
                while (var21_26 >= 0) {
                    var22_32 = (View)this.timestampUpdateList.get(var21_26);
                    var22_32.setFrameTimingValues();
                    var22_32.universe.behaviorStructure.incElapsedFrames();
                    --var21_26;
                }
                this.timestampUpdateList.clear();
                this.updateMirrorObjects();
                return;
lbl194:
                // 2 sources

            } while (!var10_15);
        }
    }

    static void dumpThreads(int n) {
        if ((n & 1) != 0) {
            System.out.println("  BEHAVIOR_SCHEDULER");
        }
        if ((n & 2) != 0) {
            System.out.println("  SOUND_SCHEDULER");
        }
        if ((n & 4) != 0) {
            System.out.println("  INPUT_DEVICE_SCHEDULER");
        }
        if ((n & 0x10) != 0) {
            System.out.println("  RENDER_THREAD");
        }
        if ((n & 0x40) != 0) {
            System.out.println("  UPDATE_GEOMETRY");
        }
        if ((n & 0x80) != 0) {
            System.out.println("  UPDATE_RENDER");
        }
        if ((n & 0x100) != 0) {
            System.out.println("  UPDATE_BEHAVIOR");
        }
        if ((n & 0x200) != 0) {
            System.out.println("  UPDATE_SOUND");
        }
        if ((n & 0x400) != 0) {
            System.out.println("  UPDATE_RENDERING_ATTRIBUTES");
        }
        if ((n & 0x1000) != 0) {
            System.out.println("  UPDATE_RENDERING_ENVIRONMENT");
        }
        if ((n & 0x2000) != 0) {
            System.out.println("  UPDATE_TRANSFORM");
        }
    }

    static void dumpmsg(J3dMessage j3dMessage) {
        System.out.println(mtype[j3dMessage.type]);
        MasterControl.dumpThreads(j3dMessage.threads);
    }

    private void manageMemory() {
        if (++this.frameCount > this.frameCountCutoff) {
            FreeListManager.manageLists();
            this.frameCount = 0;
        }
    }

    static final void threadYield() {
        try {
            Thread.yield();
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        mcThreadLock = new Object();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup;
                Thread thread2 = Thread.currentThread();
                threadPriority = thread2.getPriority();
                rootThreadGroup = thread2.getThreadGroup();
                while ((threadGroup = rootThreadGroup.getParent()) != null) {
                    rootThreadGroup = threadGroup;
                }
                rootThreadGroup = new ThreadGroup(rootThreadGroup, "Java3D");
                return null;
            }
        });
        mtype = new String[]{"-INSERT_NODES                   ", "-REMOVE_NODES                   ", "-RUN                            ", "-TRANSFORM_CHANGED              ", "-UPDATE_VIEW                    ", "-STOP_THREAD                    ", "-COLORINGATTRIBUTES_CHANGED     ", "-LINEATTRIBUTES_CHANGED         ", "-POINTATTRIBUTES_CHANGED        ", "-POLYGONATTRIBUTES_CHANGED      ", "-RENDERINGATTRIBUTES_CHANGED    ", "-TEXTUREATTRIBUTES_CHANGED      ", "-TRANSPARENCYATTRIBUTES_CHANGED ", "-MATERIAL_CHANGED               ", "-TEXCOORDGENERATION_CHANGED     ", "-TEXTURE_CHANGED                ", "-MORPH_CHANGED                  ", "-GEOMETRY_CHANGED               ", "-APPEARANCE_CHANGED             ", "-LIGHT_CHANGED                  ", "-BACKGROUND_CHANGED             ", "-CLIP_CHANGED                   ", "-FOG_CHANGED                    ", "-BOUNDINGLEAF_CHANGED           ", "-SHAPE3D_CHANGED                ", "-TEXT3D_TRANSFORM_CHANGED       ", "-TEXT3D_DATA_CHANGED            ", "-SWITCH_CHANGED                 ", "-COND_MET                       ", "-BEHAVIOR_ENABLE                ", "-BEHAVIOR_DISABLE               ", "-INSERT_RENDERATOMS             ", "-ORDERED_GROUP_INSERTED         ", "-ORDERED_GROUP_REMOVED          ", "-COLLISION_BOUND_CHANGED        ", "-REGION_BOUND_CHANGED           ", "-MODELCLIP_CHANGED              ", "-BOUNDS_AUTO_COMPUTE_CHANGED    ", "-SOUND_ATTRIB_CHANGED           ", "-AURALATTRIBUTES_CHANGED        ", "-SOUNDSCAPE_CHANGED             ", "-ALTERNATEAPPEARANCE_CHANGED    ", "-RENDER_OFFSCREEN               ", "-RENDER_RETAINED                ", "-RENDER_IMMEDIATE               ", "-SOUND_STATE_CHANGED            ", "-ORIENTEDSHAPE3D_CHANGED        ", "-TEXTURE_UNIT_STATE_CHANGED     ", "-UPDATE_VIEWPLATFORM            ", "-BEHAVIOR_ACTIVATE              ", "-GEOMETRYARRAY_CHANGED          ", "-MEDIA_CONTAINER_CHANGED        ", "-RESIZE_CANVAS                  ", "-TOGGLE_CANVAS                  ", "-IMAGE_COMPONENT_CHANGED        ", "-SCHEDULING_INTERVAL_CHANGED    ", "-VIEWSPECIFICGROUP_CHANGED      ", "-VIEWSPECIFICGROUP_INIT         ", "-VIEWSPECIFICGROUP_CLEAR        ", "-ORDERED_GROUP_TABLE_CHANGED"};
    }
}

