/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.io.InputStream;
import java.net.URL;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.SoundException;
import javax.media.j3d.VirtualUniverse;

class MediaContainerRetained
extends NodeComponentRetained {
    boolean cached = true;
    URL url = null;
    String urlString = null;
    InputStream inputStream = null;

    MediaContainerRetained() {
    }

    void setCacheEnable(boolean bl) {
        this.cached = bl;
    }

    boolean getCacheEnable() {
        return this.cached;
    }

    void setURLObject(URL uRL) {
        this.setURLObject(uRL, true);
    }

    void setURLObject(URL uRL, boolean bl) {
        if (uRL != null) {
            if (this.urlString != null || this.inputStream != null) {
                throw new IllegalArgumentException(J3dI18N.getString("MediaContainer5"));
            }
            try {
                InputStream inputStream2 = uRL.openStream();
                inputStream2.close();
            }
            catch (Exception exception) {
                throw new SoundException(J3dI18N.getString("MediaContainer0"));
            }
        }
        this.url = uRL;
        if (bl) {
            this.dispatchMessage();
        }
    }

    void setURLString(String string2) {
        this.setURLString(string2, true);
    }

    void setURLString(String string2, boolean bl) {
        if (string2 != null) {
            if (this.url != null || this.inputStream != null) {
                throw new IllegalArgumentException(J3dI18N.getString("MediaContainer5"));
            }
            try {
                URL uRL = new URL(string2);
                InputStream inputStream2 = uRL.openStream();
                inputStream2.close();
            }
            catch (Exception exception) {
                throw new SoundException(J3dI18N.getString("MediaContainer0"));
            }
        }
        this.urlString = string2;
        if (bl) {
            this.dispatchMessage();
        }
    }

    void setInputStream(InputStream inputStream2) {
        this.setInputStream(inputStream2, true);
    }

    void setInputStream(InputStream inputStream2, boolean bl) {
        if (inputStream2 != null && (this.url != null || this.urlString != null)) {
            throw new IllegalArgumentException(J3dI18N.getString("MediaContainer5"));
        }
        this.inputStream = inputStream2;
        if (bl) {
            this.dispatchMessage();
        }
    }

    String getURLString() {
        return this.urlString;
    }

    URL getURLObject() {
        return this.url;
    }

    InputStream getInputStream() {
        return this.inputStream;
    }

    void dispatchMessage() {
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 2;
        j3dMessage.type = 51;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(1);
        j3dMessage.args[2] = new Integer(this.users.size());
        j3dMessage.args[3] = this.users;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }
}

