/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.PickShape;
import javax.media.j3d.Picking;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3DCompileRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.Text3DRetained;
import javax.vecmath.Point4d;

class Picking {
    Picking() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SceneGraphPath[] pickAll(Locale locale, PickShape pickShape) {
        if (locale == null) {
            return null;
        }
        GeometryAtom[] geometryAtomArray = locale.universe.geometryStructure.pickAll(locale, pickShape);
        if (geometryAtomArray == null || geometryAtomArray.length == 0) {
            return null;
        }
        Object object = locale.universe.sceneGraphLock;
        synchronized (object) {
            SceneGraphPath[] sceneGraphPathArray = Picking.getSceneGraphPath(null, null, geometryAtomArray, locale);
            return sceneGraphPathArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SceneGraphPath[] pickAll(BranchGroup branchGroup, PickShape pickShape) {
        if (branchGroup == null) {
            return null;
        }
        BranchGroupRetained branchGroupRetained = (BranchGroupRetained)branchGroup.retained;
        if (branchGroupRetained.inSharedGroup) {
            throw new RestrictedAccessException(J3dI18N.getString("Picking0"));
        }
        Locale locale = branchGroupRetained.locale;
        GeometryAtom[] geometryAtomArray = locale.universe.geometryStructure.pickAll(locale, pickShape);
        if (geometryAtomArray == null || geometryAtomArray.length == 0) {
            return null;
        }
        Object object = branchGroupRetained.universe.sceneGraphLock;
        synchronized (object) {
            SceneGraphPath[] sceneGraphPathArray = Picking.getSceneGraphPath(Picking.initSceneGraphPath(branchGroupRetained), branchGroupRetained, geometryAtomArray, locale);
            return sceneGraphPathArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SceneGraphPath[] pickAllSorted(Locale locale, PickShape pickShape) {
        if (locale == null) {
            return null;
        }
        GeometryAtom[] geometryAtomArray = locale.universe.geometryStructure.pickAll(locale, pickShape);
        if (geometryAtomArray == null || geometryAtomArray.length == 0) {
            return null;
        }
        Picking.sortGeomAtoms(geometryAtomArray, pickShape);
        Object object = locale.universe.sceneGraphLock;
        synchronized (object) {
            SceneGraphPath[] sceneGraphPathArray = Picking.getSceneGraphPath(null, null, geometryAtomArray, locale);
            return sceneGraphPathArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SceneGraphPath[] pickAllSorted(BranchGroup branchGroup, PickShape pickShape) {
        if (branchGroup == null) {
            return null;
        }
        BranchGroupRetained branchGroupRetained = (BranchGroupRetained)branchGroup.retained;
        if (branchGroupRetained.inSharedGroup) {
            throw new RestrictedAccessException(J3dI18N.getString("Picking0"));
        }
        Locale locale = branchGroupRetained.locale;
        GeometryAtom[] geometryAtomArray = locale.universe.geometryStructure.pickAll(locale, pickShape);
        if (geometryAtomArray == null || geometryAtomArray.length == 0) {
            return null;
        }
        Picking.sortGeomAtoms(geometryAtomArray, pickShape);
        Object object = branchGroupRetained.universe.sceneGraphLock;
        synchronized (object) {
            SceneGraphPath[] sceneGraphPathArray = Picking.getSceneGraphPath(Picking.initSceneGraphPath(branchGroupRetained), branchGroupRetained, geometryAtomArray, locale);
            return sceneGraphPathArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SceneGraphPath pickClosest(Locale locale, PickShape pickShape) {
        if (locale == null) {
            return null;
        }
        GeometryAtom[] geometryAtomArray = locale.universe.geometryStructure.pickAll(locale, pickShape);
        if (geometryAtomArray == null || geometryAtomArray.length == 0) {
            return null;
        }
        GeometryAtom geometryAtom = Picking.selectClosest(geometryAtomArray, pickShape);
        Object object = locale.universe.sceneGraphLock;
        synchronized (object) {
            SceneGraphPath sceneGraphPath = Picking.getSceneGraphPath(null, null, geometryAtom, locale);
            return sceneGraphPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SceneGraphPath pickClosest(BranchGroup branchGroup, PickShape pickShape) {
        if (branchGroup == null) {
            return null;
        }
        BranchGroupRetained branchGroupRetained = (BranchGroupRetained)branchGroup.retained;
        if (branchGroupRetained.inSharedGroup) {
            throw new RestrictedAccessException(J3dI18N.getString("Picking0"));
        }
        Locale locale = branchGroupRetained.locale;
        GeometryAtom[] geometryAtomArray = locale.universe.geometryStructure.pickAll(locale, pickShape);
        if (geometryAtomArray == null || geometryAtomArray.length == 0) {
            return null;
        }
        Picking.sortGeomAtoms(geometryAtomArray, pickShape);
        Object object = branchGroupRetained.universe.sceneGraphLock;
        synchronized (object) {
            SceneGraphPath sceneGraphPath = Picking.getFirstSceneGraphPath(Picking.initSceneGraphPath(branchGroupRetained), branchGroupRetained, geometryAtomArray, locale);
            return sceneGraphPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SceneGraphPath pickAny(Locale locale, PickShape pickShape) {
        if (locale == null) {
            return null;
        }
        GeometryAtom geometryAtom = locale.universe.geometryStructure.pickAny(locale, pickShape);
        if (geometryAtom == null) {
            return null;
        }
        Object object = locale.universe.sceneGraphLock;
        synchronized (object) {
            SceneGraphPath sceneGraphPath = Picking.getSceneGraphPath(null, null, geometryAtom, locale);
            return sceneGraphPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SceneGraphPath pickAny(BranchGroup branchGroup, PickShape pickShape) {
        if (branchGroup == null) {
            return null;
        }
        BranchGroupRetained branchGroupRetained = (BranchGroupRetained)branchGroup.retained;
        if (branchGroupRetained.inSharedGroup) {
            throw new RestrictedAccessException(J3dI18N.getString("Picking0"));
        }
        Locale locale = branchGroupRetained.locale;
        GeometryAtom[] geometryAtomArray = locale.universe.geometryStructure.pickAll(locale, pickShape);
        if (geometryAtomArray == null || geometryAtomArray.length == 0) {
            return null;
        }
        Object object = branchGroupRetained.universe.sceneGraphLock;
        synchronized (object) {
            SceneGraphPath sceneGraphPath = Picking.getFirstSceneGraphPath(Picking.initSceneGraphPath(branchGroupRetained), branchGroupRetained, geometryAtomArray, locale);
            return sceneGraphPath;
        }
    }

    private static ArrayList initSceneGraphPath(NodeRetained nodeRetained) {
        ArrayList<NodeRetained> arrayList = new ArrayList<NodeRetained>(5);
        do {
            if (!nodeRetained.source.getCapability(1)) continue;
            arrayList.add(nodeRetained);
        } while ((nodeRetained = nodeRetained.parent) != null);
        return arrayList;
    }

    private static SceneGraphPath[] getSceneGraphPath(ArrayList arrayList, BranchGroupRetained branchGroupRetained, GeometryAtom[] geometryAtomArray, Locale locale) {
        Object object;
        ArrayList<Object> arrayList2 = new ArrayList<Object>(5);
        ArrayList<NodeRetained> arrayList3 = null;
        if (geometryAtomArray == null) {
            return null;
        }
        int n = 0;
        while (n < geometryAtomArray.length) {
            block12: {
                int n2;
                Object object2;
                Cloneable cloneable2;
                NodeRetained nodeRetained;
                GeometryAtom geometryAtom;
                block13: {
                    block15: {
                        block14: {
                            geometryAtom = geometryAtomArray[n];
                            object = geometryAtom.source;
                            if (!Picking.inside(((Shape3DRetained)object).branchGroupPath, branchGroupRetained) || (nodeRetained = ((Shape3DRetained)object).sourceNode) == null) break block12;
                            if (!(nodeRetained instanceof Shape3DRetained)) break block13;
                            cloneable2 = (Shape3DRetained)nodeRetained;
                            object2 = null;
                            int n3 = 0;
                            while (n3 < cloneable2.geometryList.size()) {
                                object2 = (GeometryRetained)cloneable2.geometryList.get(n3);
                                if (object2 != null) break;
                                ++n3;
                            }
                            if (object2 == null) break block12;
                            if (!(object2 instanceof Text3DRetained)) break block13;
                            if (arrayList3 != null) break block14;
                            arrayList3 = new ArrayList<NodeRetained>(3);
                            break block15;
                        }
                        n2 = arrayList3.size();
                        boolean bl = false;
                        int n4 = 0;
                        while (n4 < n2) {
                            if (arrayList3.get(n4) == nodeRetained) {
                                bl = true;
                                break;
                            }
                            ++n4;
                        }
                        if (bl) break block12;
                    }
                    arrayList3.add(nodeRetained);
                }
                if ((cloneable2 = Picking.retrievePath(nodeRetained, branchGroupRetained, geometryAtom.source.key)) != null) {
                    if (nodeRetained instanceof Shape3DCompileRetained) {
                        object2 = (Shape3DCompileRetained)nodeRetained;
                        Node[] nodeArray = Picking.mergePath((ArrayList)cloneable2, arrayList);
                        n2 = 0;
                        while (n2 < ((Shape3DCompileRetained)object2).srcList.length) {
                            SceneGraphPath sceneGraphPath = new SceneGraphPath(locale, nodeArray, (Node)((Shape3DCompileRetained)object2).srcList[n2]);
                            sceneGraphPath.setTransform(((NodeRetained)object).getCurrentLocalToVworld(0));
                            arrayList2.add(sceneGraphPath);
                            ++n2;
                        }
                    } else {
                        object2 = new SceneGraphPath(locale, Picking.mergePath((ArrayList)cloneable2, arrayList), (Node)nodeRetained.source);
                        ((SceneGraphPath)object2).setTransform(((NodeRetained)object).getCurrentLocalToVworld(0));
                        arrayList2.add(object2);
                    }
                }
            }
            ++n;
        }
        object = new SceneGraphPath[arrayList2.size()];
        return arrayList2.toArray((T[])object);
    }

    private static SceneGraphPath getSceneGraphPath(ArrayList arrayList, BranchGroupRetained branchGroupRetained, GeometryAtom geometryAtom, Locale locale) {
        if (geometryAtom == null) {
            return null;
        }
        Shape3DRetained shape3DRetained = geometryAtom.source;
        NodeRetained nodeRetained = shape3DRetained.sourceNode;
        if (nodeRetained == null) {
            return null;
        }
        if (!Picking.inside(shape3DRetained.branchGroupPath, branchGroupRetained)) {
            return null;
        }
        ArrayList arrayList2 = Picking.retrievePath(nodeRetained, branchGroupRetained, shape3DRetained.key);
        if (arrayList2 == null) {
            return null;
        }
        SceneGraphPath sceneGraphPath = new SceneGraphPath(locale, Picking.mergePath(arrayList2, arrayList), (Node)nodeRetained.source);
        sceneGraphPath.setTransform(shape3DRetained.getCurrentLocalToVworld(0));
        return sceneGraphPath;
    }

    private static boolean inside(BranchGroupRetained[] branchGroupRetainedArray, BranchGroupRetained branchGroupRetained) {
        if (branchGroupRetained == null || branchGroupRetainedArray == null) {
            return true;
        }
        int n = 0;
        while (n < branchGroupRetainedArray.length) {
            if (branchGroupRetainedArray[n] == branchGroupRetained) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static SceneGraphPath getFirstSceneGraphPath(ArrayList arrayList, BranchGroupRetained branchGroupRetained, GeometryAtom[] geometryAtomArray, Locale locale) {
        if (geometryAtomArray == null) {
            return null;
        }
        int n = 0;
        while (n < geometryAtomArray.length) {
            ArrayList arrayList2;
            Shape3DRetained shape3DRetained = geometryAtomArray[n].source;
            NodeRetained nodeRetained = shape3DRetained.sourceNode;
            if (nodeRetained != null && Picking.inside(shape3DRetained.branchGroupPath, branchGroupRetained) && (arrayList2 = Picking.retrievePath(nodeRetained, branchGroupRetained, geometryAtomArray[n].source.key)) != null) {
                SceneGraphPath sceneGraphPath = new SceneGraphPath(locale, Picking.mergePath(arrayList2, arrayList), (Node)nodeRetained.source);
                sceneGraphPath.setTransform(shape3DRetained.getCurrentLocalToVworld(0));
                return sceneGraphPath;
            }
            ++n;
        }
        return null;
    }

    private static ArrayList retrievePath(NodeRetained nodeRetained, NodeRetained nodeRetained2, HashKey hashKey) {
        ArrayList<NodeRetained> arrayList = new ArrayList<NodeRetained>(5);
        NodeRetained nodeRetained3 = nodeRetained;
        if (nodeRetained3.inSharedGroup) {
            hashKey = new HashKey(hashKey);
        }
        do {
            if (nodeRetained3 == nodeRetained2) {
                return arrayList;
            }
            if (nodeRetained3.source.getCapability(1)) {
                arrayList.add(nodeRetained3);
            }
            if (!(nodeRetained3 instanceof SharedGroupRetained)) continue;
            String string2 = hashKey.getLastNodeId();
            Vector vector = ((SharedGroupRetained)nodeRetained3).parents;
            int n = vector.size();
            NodeRetained nodeRetained4 = nodeRetained3;
            int n2 = 0;
            while (n2 < n) {
                NodeRetained nodeRetained5 = (NodeRetained)vector.elementAt(n2);
                if (nodeRetained5.nodeId.equals(string2)) {
                    nodeRetained3 = nodeRetained5;
                    arrayList.add(nodeRetained3);
                    break;
                }
                ++n2;
            }
            if (nodeRetained3 != nodeRetained4) continue;
            return null;
        } while ((nodeRetained3 = nodeRetained3.parent) != null);
        if (nodeRetained2 == null) {
            return arrayList;
        }
        return null;
    }

    private static Node[] mergePath(ArrayList arrayList, ArrayList arrayList2) {
        int n = arrayList.size();
        int n2 = arrayList2 == null ? n : n + arrayList2.size();
        Node[] nodeArray = new Node[n2];
        int n3 = n2 - 1;
        int n4 = 0;
        while (n4 < n) {
            nodeArray[n3 - n4] = (Node)((NodeRetained)arrayList.get((int)n4)).source;
            ++n4;
        }
        int n5 = 0;
        while (n4 < n2) {
            nodeArray[n3 - n4] = (Node)((NodeRetained)arrayList2.get((int)n5)).source;
            ++n4;
            ++n5;
        }
        return nodeArray;
    }

    private static GeometryAtom selectClosest(GeometryAtom[] geometryAtomArray, PickShape pickShape) {
        Point4d point4d = new Point4d();
        GeometryAtom geometryAtom = geometryAtomArray[0];
        pickShape.intersect(geometryAtom.source.vwcBounds, point4d);
        double d = point4d.w;
        int n = 1;
        while (n < geometryAtomArray.length) {
            pickShape.intersect(geometryAtomArray[n].source.vwcBounds, point4d);
            if (point4d.w < d) {
                d = point4d.w;
                geometryAtom = geometryAtomArray[n];
            }
            ++n;
        }
        return geometryAtom;
    }

    private static void sortGeomAtoms(GeometryAtom[] geometryAtomArray, PickShape pickShape) {
        double[] dArray = new double[geometryAtomArray.length];
        Point4d point4d = new Point4d();
        int n = 0;
        while (n < geometryAtomArray.length) {
            pickShape.intersect(geometryAtomArray[n].source.vwcBounds, point4d);
            dArray[n] = point4d.w;
            ++n;
        }
        class Sort {
            GeometryAtom[] atoms;
            private final /* synthetic */ double[] val$distance;

            Sort(double[] dArray, GeometryAtom[] geometryAtomArray) {
                this.val$distance = dArray;
                this.atoms = geometryAtomArray;
            }

            void sorting() {
                if (this.atoms.length < 7) {
                    this.insertSort();
                } else {
                    this.quicksort(0, this.atoms.length - 1);
                }
            }

            final void insertSort() {
                int n = 0;
                while (n < this.atoms.length) {
                    int n2 = n;
                    while (n2 > 0 && this.val$distance[n2 - 1] > this.val$distance[n2]) {
                        double d = this.val$distance[n2];
                        this.val$distance[n2] = this.val$distance[n2 - 1];
                        this.val$distance[n2 - 1] = d;
                        GeometryAtom geometryAtom = this.atoms[n2];
                        this.atoms[n2] = this.atoms[n2 - 1];
                        this.atoms[n2 - 1] = geometryAtom;
                        --n2;
                    }
                    ++n;
                }
            }

            final void quicksort(int n, int n2) {
                int n3 = n;
                int n4 = n2;
                double d = this.val$distance[(n + n2) / 2];
                while (true) {
                    if (this.val$distance[n3] < d) {
                        ++n3;
                        continue;
                    }
                    while (d < this.val$distance[n4]) {
                        --n4;
                    }
                    if (n3 <= n4) {
                        double d2 = this.val$distance[n3];
                        this.val$distance[n3] = this.val$distance[n4];
                        this.val$distance[n4] = d2;
                        GeometryAtom geometryAtom = this.atoms[n3];
                        this.atoms[n3] = this.atoms[n4];
                        this.atoms[n4] = geometryAtom;
                        ++n3;
                        --n4;
                    }
                    if (n3 > n4) break;
                }
                if (n < n4) {
                    this.quicksort(n, n4);
                }
                if (n < n2) {
                    this.quicksort(n3, n2);
                }
            }
        }
        new Sort(dArray, geometryAtomArray).sorting();
    }
}

