/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.media.j3d.Appearance;
import javax.media.j3d.AuralAttributes;
import javax.media.j3d.Background;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CanvasViewCache;
import javax.media.j3d.DetailTextureImage;
import javax.media.j3d.Fog;
import javax.media.j3d.FreeListManager;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.HiResCoord;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dThread;
import javax.media.j3d.Light;
import javax.media.j3d.MasterControl;
import javax.media.j3d.ModelClip;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Raster;
import javax.media.j3d.RendererStructure;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Sound;
import javax.media.j3d.TextureRetained;
import javax.media.j3d.TextureUnitStateRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;

class Renderer
extends J3dThread {
    int objectId = -1;
    static final int WAIT = 0;
    static final int NOTIFY_AND_WAIT = 1;
    static final int NOTIFY = 2;
    static final int DECAL_NONE = 0;
    static final int DECAL_1ST_CHILD = 1;
    static final int DECAL_NTH_CHILD = 2;
    static final int NUM_ACCUMULATION_SAMPLES = 8;
    static final float[] ACCUM_SAMPLES_X = new float[]{-0.54818f, 0.56438f, 0.39462f, -0.54498f, -0.8379f, -0.39263f, 0.32254f, 0.84216f};
    static final float[] ACCUM_SAMPLES_Y = new float[]{0.55331f, -0.53495f, 0.4154f, -0.52829f, 0.82102f, -0.27383f, 0.09133f, -0.84399f};
    static final float accumValue = 0.125f;
    static final int RENDER = 0;
    static final int SWAP = 1;
    static final int REQUESTRENDER = 2;
    static final int REQUESTCLEANUP = 3;
    RendererStructure rendererStructure = new RendererStructure();
    Transform3D bgVworldToVpc = new Transform3D();
    long lasttime;
    long currtime;
    float numframes = 0.0f;
    static final boolean doTiming = false;
    private static int numInstances = 0;
    private int instanceNum = -1;
    boolean sharedStereoZBuffer;
    long sharedCtx = 0L;
    long sharedCtxTimeStamp = 0L;
    long display;
    int window;
    long currentCtx = -1L;
    int rendererBit = 0;
    ArrayList dirtyRenderMoleculeList = new ArrayList();
    ArrayList dirtyRenderAtomList = new ArrayList();
    ArrayList dirtyDlistPerRinfoList = new ArrayList();
    ArrayList textureIdResourceFreeList = new ArrayList();
    ArrayList displayListResourceFreeList = new ArrayList();
    ArrayList textureReloadList = new ArrayList();
    CanvasViewCache copyOfCvCache = new CanvasViewCache(null, null, null);
    J3dMessage[] renderMessage;
    Screen3D onScreen;
    Screen3D offScreen;
    double[] accumLeftProjMat = new double[16];
    double[] accumRightProjMat = new double[16];
    double[] accumInfLeftProjMat = new double[16];
    double[] accumInfRightProjMat = new double[16];
    J3dMessage[] m;
    int nmesg = 0;
    ArrayList listOfCtxs = new ArrayList();
    ArrayList listOfCanvases = new ArrayList();
    boolean needToRebuildDisplayList = false;
    boolean needToResendTextureDown = false;
    boolean dirtyDisplayList = false;
    ArrayList textureIDResourceTable = new ArrayList(5);

    native void D3DCleanUp();

    private synchronized int newInstanceNum() {
        return ++numInstances;
    }

    int getInstanceNum() {
        if (this.instanceNum == -1) {
            this.instanceNum = this.newInstanceNum();
        }
        return this.instanceNum;
    }

    Renderer(ThreadGroup threadGroup) {
        super(threadGroup);
        this.setName("J3D-Renderer-" + this.getInstanceNum());
        this.type = 16;
        this.rendererBit = VirtualUniverse.mc.getRendererBit();
        this.renderMessage = new J3dMessage[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void doWork(long var1_1) {
        block200: {
            var4_2 = null;
            var6_3 = null;
            var8_4 = null;
            var13_5 = 1;
            var19_6 = false;
            var20_7 = 0.0;
            var22_8 = 0.0;
            var24_9 = 1.0;
            var26_10 = 1.0;
            var28_11 = 0.0;
            var30_12 = 0.0;
            var32_13 = 0.0;
            var34_14 = 0.0;
            var36_15 = 0.0;
            var38_16 = 0.0;
            var40_17 = 0.0;
            var42_18 = 0.0;
            var46_19 = false;
            var47_20 = null;
            var44_21 = (Integer)this.args[0];
            try {
                block201: {
                    if (var44_21 == 1) {
                        var48_22 = (Object[])this.args[2];
                        var8_4 = (View)this.args[3];
                        var16_26 = 0;
                        while (var16_26 < var48_22.length) {
                            block199: {
                                var5_28 = (Canvas3D)var48_22[var16_26];
                                if (var5_28.isRunning) {
                                    try {
                                        if (!var5_28.validCanvas || !var5_28.active || var5_28.ctx == 0L || var5_28.view == null || !var5_28.imageReady) break block199;
                                        if (var5_28.useDoubleBuffer) {
                                            var49_32 = var5_28.drawingSurfaceObject;
                                            synchronized (var49_32) {
                                                if (var5_28.validCtx) {
                                                    if (VirtualUniverse.mc.doDsiRenderLock) {
                                                        if (!var5_28.drawingSurfaceObject.renderLock()) {
                                                            break block199;
                                                        }
                                                        var5_28.makeCtxCurrent();
                                                        var5_28.syncRender(var5_28.ctx, true);
                                                        var45_31 = var5_28.swapBuffers(var5_28.ctx, var5_28.screen.display, var5_28.window);
                                                        if (var45_31 != 0) {
                                                            var5_28.resetRendering(var45_31);
                                                        }
                                                        var5_28.drawingSurfaceObject.unLock();
                                                    } else {
                                                        var5_28.makeCtxCurrent();
                                                        var5_28.syncRender(var5_28.ctx, true);
                                                        var45_31 = var5_28.swapBuffers(var5_28.ctx, var5_28.screen.display, var5_28.window);
                                                        if (var45_31 != 0) {
                                                            var5_28.resetRendering(var45_31);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        var5_28.view.inCanvasCallback = true;
                                        try {
                                            var5_28.postSwap();
                                        }
                                        catch (RuntimeException var49_33) {
                                            System.err.println("Exception occurred during Canvas3D callback:");
                                            var49_33.printStackTrace();
                                        }
                                        var5_28.imageReady = false;
                                        var5_28.view.inCanvasCallback = false;
                                        if (!var5_28.ctxChanged) {
                                            var5_28.canvasDirty = 7743;
                                            var5_28.modelMatrix = null;
                                            var5_28.ra = null;
                                        } else {
                                            var5_28.ctxChanged = false;
                                        }
                                    }
                                    catch (NullPointerException var49_34) {
                                        if (!VirtualUniverse.mc.doDsiRenderLock) break block199;
                                        var5_28.drawingSurfaceObject.unLock();
                                    }
                                }
                            }
                            ++var16_26;
                        }
                        if (var8_4 != null && var8_4.viewCache.getDoHeadTracking()) {
                            VirtualUniverse.mc.sendRunMessage(var8_4, 16);
                        }
                        break block200;
                    }
                    if (var44_21 == 3) {
                        var48_23 = (Integer)this.args[2];
                        if (var48_23 == MasterControl.REMOVEALLCTXS_CLEANUP) {
                            this.removeAllCtxs();
                        } else if (var48_23 == MasterControl.FREECONTEXT_CLEANUP) {
                            var5_29 = (Canvas3D)this.args[1];
                            this.removeCtx(var5_29, var5_29.screen.display, var5_29.window, var5_29.ctx, true, true);
                        } else if (var48_23 == MasterControl.RESETCANVAS_CLEANUP) {
                            var5_30 = (Canvas3D)this.args[1];
                            if (var5_30.ctx != 0L) {
                                var5_30.makeCtxCurrent();
                            }
                            var5_30.freeContextResources(var5_30.screen.renderer, true, var5_30.ctx);
                        } else if (var48_23 == MasterControl.REMOVECTX_CLEANUP) {
                            var49_35 = (Object[])this.args[1];
                            var50_38 = (Canvas3D)var49_35[0];
                            this.removeCtx(var50_38, (Long)var49_35[1], (Integer)var49_35[2], (Long)var49_35[3], false, var50_38.offScreen == false);
                        }
                        return;
                    }
                    this.nmesg = 0;
                    var49_36 = 0;
                    if (var44_21 != 0) break block201;
                    this.m = this.renderMessage;
                    this.m[0] = VirtualUniverse.mc.getMessage();
                    this.m[0].type = 43;
                    this.m[0].incRefcount();
                    this.m[0].args[0] = this.args[1];
                    var49_36 = 1;
                    ** GOTO lbl604
                }
                this.m = this.rendererStructure.getMessages();
                var49_36 = this.rendererStructure.getNumMessage();
                if (var49_36 > 0) ** GOTO lbl604
                return;
lbl-1000:
                // 1 sources

                {
                    var7_42 = this.m[this.nmesg].args[0];
                    if (var7_42 == null) {
                        var50_39 = this.m[this.nmesg].args[1];
                        if (var50_39 instanceof Canvas3D) {
                            var51_48 = (Integer)this.m[this.nmesg].args[2];
                            var52_52 = (Canvas3D)var50_39;
                            if (var51_48 == MasterControl.SET_GRAPHICSCONFIG_FEATURES) {
                                var53_55 = var52_52.graphicsConfiguration;
                                var54_58 = GraphicsConfigTemplate3D.nativeTemplate;
                                if (var52_52.offScreen) {
                                    var52_52.doubleBufferAvailable = false;
                                    var52_52.stereoAvailable = false;
                                } else {
                                    var52_52.doubleBufferAvailable = var54_58.hasDoubleBuffer((GraphicsConfiguration)var53_55);
                                    var52_52.stereoAvailable = var54_58.hasStereo((GraphicsConfiguration)var53_55);
                                }
                                var52_52.sceneAntialiasingMultiSamplesAvailable = var54_58.hasSceneAntialiasingMultiSamples((GraphicsConfiguration)var53_55);
                                var52_52.sceneAntialiasingAvailable = var52_52.sceneAntialiasingMultiSamplesAvailable != false ? true : var54_58.hasSceneAntialiasingAccum((GraphicsConfiguration)var53_55);
                                GraphicsConfigTemplate3D.runMonitor(2);
                            } else if (var51_48 == MasterControl.SET_QUERYPROPERTIES) {
                                var52_52.createQueryContext();
                                GraphicsConfigTemplate3D.runMonitor(2);
                                this.currentCtx = -1L;
                            }
                        } else if (var50_39 instanceof Integer) {
                            this.freeTextureID((Integer)var50_39, (String)this.m[this.nmesg].args[2]);
                        } else if (var50_39 instanceof GeometryArrayRetained) {
                            ((GeometryArrayRetained)var50_39).freeD3DArray(false);
                        } else if (var50_39 instanceof GraphicsConfigTemplate3D) {
                            var51_49 = (GraphicsConfigTemplate3D)var50_39;
                            var52_52 = (Integer)this.m[this.nmesg].args[2];
                            if (var52_52 == MasterControl.GETBESTCONFIG) {
                                var51_49.testCfg = GraphicsConfigTemplate3D.nativeTemplate.getBestConfiguration(var51_49, (GraphicsConfiguration[])var51_49.testCfg);
                            } else if (var52_52 == MasterControl.ISCONFIGSUPPORT) {
                                var51_49.testCfg = GraphicsConfigTemplate3D.nativeTemplate.isGraphicsConfigSupported(var51_49, (GraphicsConfiguration)var51_49.testCfg) != false ? Boolean.TRUE : Boolean.FALSE;
                            }
                            GraphicsConfigTemplate3D.runMonitor(2);
                        }
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    var6_3 = (Canvas3D)var7_42;
                    var48_24 = this.m[this.nmesg].type;
                    if (var6_3.view == null || !var6_3.firstPaintCalled) {
                        if (var48_24 == 42) {
                            var6_3.offScreenRendering = false;
                        }
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (!var6_3.validCanvas && var48_24 != 42) {
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (var48_24 == 52) {
                        var6_3.d3dResize();
                        VirtualUniverse.mc.sendRunMessage(var6_3.view, 16);
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (var48_24 == 53) {
                        var6_3.d3dToggle();
                        VirtualUniverse.mc.sendRunMessage(var6_3.view, 16);
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (var48_24 == 44) {
                        var50_40 = (Integer)this.m[this.nmesg].args[1];
                        if (this.needToResendTextureDown) {
                            ++VirtualUniverse.mc.resendTexTimestamp;
                            this.needToResendTextureDown = false;
                        }
                        if (var6_3.ctx != 0L) {
                            var6_3.beginScene();
                        }
                        switch (var50_40) {
                            case 0: {
                                var6_3.graphicsContext3D.doClear();
                                break;
                            }
                            case 1: {
                                var6_3.graphicsContext3D.doDraw((Geometry)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 2: {
                                var6_3.doSwap();
                                break;
                            }
                            case 3: {
                                var6_3.graphicsContext3D.doReadRaster((Raster)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 4: {
                                var6_3.graphicsContext3D.doSetAppearance((Appearance)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 5: {
                                var6_3.graphicsContext3D.doSetBackground((Background)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 6: {
                                var6_3.graphicsContext3D.doSetFog((Fog)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 7: {
                                var6_3.graphicsContext3D.doSetLight((Light)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                break;
                            }
                            case 8: {
                                var6_3.graphicsContext3D.doInsertLight((Light)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                break;
                            }
                            case 9: {
                                var6_3.graphicsContext3D.doRemoveLight((Integer)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 10: {
                                var6_3.graphicsContext3D.doAddLight((Light)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 11: {
                                var6_3.graphicsContext3D.doSetHiRes((HiResCoord)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 12: {
                                var47_20 = (Transform3D)this.m[this.nmesg].args[2];
                                var6_3.graphicsContext3D.doSetModelTransform(var47_20);
                                FreeListManager.freeObject(2, var47_20);
                                break;
                            }
                            case 13: {
                                var47_20 = (Transform3D)this.m[this.nmesg].args[2];
                                var6_3.graphicsContext3D.doMultiplyModelTransform(var47_20);
                                FreeListManager.freeObject(2, var47_20);
                                break;
                            }
                            case 14: {
                                var6_3.graphicsContext3D.doSetSound((Sound)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                break;
                            }
                            case 15: {
                                var6_3.graphicsContext3D.doInsertSound((Sound)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                break;
                            }
                            case 16: {
                                var6_3.graphicsContext3D.doRemoveSound((Integer)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 17: {
                                var6_3.graphicsContext3D.doAddSound((Sound)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 18: {
                                var6_3.graphicsContext3D.doSetAuralAttributes((AuralAttributes)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 19: {
                                var6_3.graphicsContext3D.doSetBufferOverride((Boolean)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 20: {
                                var6_3.graphicsContext3D.doSetFrontBufferRendering((Boolean)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 21: {
                                var6_3.graphicsContext3D.doSetStereoMode((Integer)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 22: {
                                var6_3.graphicsContext3D.doFlush((Boolean)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 23: {
                                var6_3.graphics2D.doFlush();
                                break;
                            }
                            case 24: {
                                var51_50 = this.m[this.nmesg].args;
                                var6_3.graphics2D.doDrawAndFlushImage((BufferedImage)var51_50[2], ((Point)var51_50[3]).x, ((Point)var51_50[3]).y, (ImageObserver)var51_50[4]);
                                break;
                            }
                            case 25: {
                                var6_3.graphicsContext3D.doSetModelClip((ModelClip)this.m[this.nmesg].args[2]);
                                break;
                            }
                        }
                        if (var6_3.ctx != 0L) {
                            var6_3.endScene();
                        }
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    this.m[this.nmesg++].decRefcount();
                    var50_41 = null;
                    if (var48_24 == 42) {
                        if (var6_3.window == 0 || !var6_3.active) {
                            var6_3.offScreenRendering = false;
                            continue;
                        }
                        var50_41 = (ImageComponent2DRetained)var6_3.offScreenBuffer.retained;
                        if (var50_41.isByReference()) {
                            var50_41.geomLock.getLock();
                            var50_41.evaluateExtensions(var6_3.extensionsSupported);
                        }
                    } else if (!var6_3.active) continue;
                    var51_51 = false;
                    var4_2 = var6_3.view.renderBin;
                    if (var6_3.useSharedCtx && this.sharedCtx == 0L) {
                        this.display = var6_3.screen.display;
                        if (!var6_3.drawingSurfaceObject.renderLock()) {
                            if (var50_41 == null || !var50_41.isByReference()) break;
                            var50_41.geomLock.unLock();
                            break;
                        }
                        var52_52 = VirtualUniverse.mc.contextCreationLock;
                        synchronized (var52_52) {
                            this.sharedCtx = var6_3.createContext(var6_3.screen.display, var6_3.window, var6_3.vid, var6_3.visInfo, 0L, true, var6_3.offScreen);
                            if (this.sharedCtx == 0L) {
                                var6_3.drawingSurfaceObject.unLock();
                                if (var50_41 != null && var50_41.isByReference()) {
                                    var50_41.geomLock.unLock();
                                }
                                break;
                            }
                            this.sharedCtxTimeStamp = VirtualUniverse.mc.getContextTimeStamp();
                            this.needToRebuildDisplayList = true;
                        }
                        var6_3.drawingSurfaceObject.unLock();
                    }
                    if (var6_3.ctx == 0L) {
                        this.display = var6_3.screen.display;
                        if (!var6_3.drawingSurfaceObject.renderLock()) {
                            if (var50_41 == null || !var50_41.isByReference()) break;
                            var50_41.geomLock.unLock();
                            break;
                        }
                        var52_52 = VirtualUniverse.mc.contextCreationLock;
                        synchronized (var52_52) {
                            var6_3.ctx = var6_3.createContext(var6_3.screen.display, var6_3.window, var6_3.vid, var6_3.visInfo, this.sharedCtx, false, var6_3.offScreen);
                            if (var6_3.ctx == 0L) {
                                var6_3.drawingSurfaceObject.unLock();
                                if (var50_41 != null && var50_41.isByReference()) {
                                    var50_41.geomLock.unLock();
                                }
                                break;
                            }
                            if (var6_3.graphics2D != null) {
                                var6_3.graphics2D.init();
                            }
                            var6_3.ctxTimeStamp = VirtualUniverse.mc.getContextTimeStamp();
                            this.listOfCtxs.add(new Long(var6_3.ctx));
                            this.listOfCanvases.add(var6_3);
                            if (var4_2.nodeComponentList.size() > 0) {
                                var16_27 = 0;
                                while (var16_27 < var4_2.nodeComponentList.size()) {
                                    var53_55 = (NodeComponentRetained)var4_2.nodeComponentList.get(var16_27);
                                    var53_55.evaluateExtensions(var6_3.extensionsSupported);
                                    ++var16_27;
                                }
                            }
                            if (var6_3.multiTexAccelerated) {
                                var6_3.numTexUnitSupported = var6_3.getTextureUnitCount(var6_3.ctx);
                                if (VirtualUniverse.mc.textureUnitMax < var6_3.numTexUnitSupported) {
                                    var6_3.numTexUnitSupported = VirtualUniverse.mc.textureUnitMax;
                                }
                            }
                            var6_3.enableSeparateSpecularColor();
                        }
                        if (var6_3.texUnitState == null) {
                            var6_3.texUnitState = new TextureUnitStateRetained[var6_3.numTexCoordSupported];
                            var53_56 = 0;
                            while (var53_56 < var6_3.numTexCoordSupported) {
                                var6_3.texUnitState[var53_56] = new TextureUnitStateRetained();
                                var6_3.texUnitState[var53_56].texture = null;
                                var6_3.texUnitState[var53_56].mirror = null;
                                ++var53_56;
                            }
                        }
                        if (var6_3.texUnitStateMap == null) {
                            var6_3.texUnitStateMap = new int[var6_3.numTexCoordSupported];
                        }
                        var6_3.resetImmediateRendering(0);
                        var6_3.drawingSurfaceObject.contextValidated();
                        if (!var6_3.useSharedCtx) {
                            var6_3.needToRebuildDisplayList = true;
                        }
                        var6_3.drawingSurfaceObject.unLock();
                    } else if (var6_3.isRunning) {
                        var6_3.makeCtxCurrent();
                    }
                    if (var4_2 != null) {
                        if (VirtualUniverse.mc.doDsiRenderLock && !var6_3.drawingSurfaceObject.renderLock()) {
                            if (var50_41 == null || !var50_41.isByReference()) break;
                            var50_41.geomLock.unLock();
                            break;
                        }
                        if (this.needToResendTextureDown) {
                            ++VirtualUniverse.mc.resendTexTimestamp;
                            this.needToResendTextureDown = false;
                        }
                        if (var6_3.useSharedCtx) {
                            this.freeResourcesInFreeList(var6_3);
                        } else {
                            var6_3.freeResourcesInFreeList(var6_3.ctx);
                        }
                        v0 = var51_51 = (var6_3.cvDirtyMask & 32) != 0;
                        if (VirtualUniverse.mc.doDsiRenderLock) {
                            var6_3.drawingSurfaceObject.unLock();
                        }
                        var6_3.updateViewCache(false, this.copyOfCvCache, null, var4_2.geometryBackground != null);
                        if (VirtualUniverse.mc.doDsiRenderLock && !var6_3.drawingSurfaceObject.renderLock()) {
                            if (var50_41 == null || !var50_41.isByReference()) break;
                            var50_41.geomLock.unLock();
                            break;
                        }
                        var6_3.setViewport(var6_3.ctx, 0, 0, this.copyOfCvCache.getCanvasWidth(), this.copyOfCvCache.getCanvasHeight());
                        if (var6_3.useSharedCtx) {
                            if (this.needToRebuildDisplayList) {
                                var4_2.updateAllRenderMolecule(this, var6_3);
                                this.needToRebuildDisplayList = false;
                            }
                            if (this.dirtyDisplayList) {
                                var4_2.updateDirtyDisplayLists(var6_3, this.dirtyRenderMoleculeList, this.dirtyDlistPerRinfoList, this.dirtyRenderAtomList, true);
                                this.dirtyDisplayList = false;
                            }
                            if ((var52_53 = this.textureReloadList.size()) > 0) {
                                var17_47 = var52_53 - 1;
                                while (var17_47 >= 0) {
                                    ((TextureRetained)this.textureReloadList.get(var17_47)).reloadTextureSharedContext(var6_3);
                                    --var17_47;
                                }
                                this.textureReloadList.clear();
                            }
                        } else {
                            if (var6_3.needToRebuildDisplayList) {
                                var4_2.updateAllRenderMolecule(var6_3);
                                var6_3.needToRebuildDisplayList = false;
                            }
                            if (var6_3.dirtyDisplayList) {
                                var4_2.updateDirtyDisplayLists(var6_3, var6_3.dirtyRenderMoleculeList, var6_3.dirtyDlistPerRinfoList, var6_3.dirtyRenderAtomList, false);
                                var6_3.dirtyDisplayList = false;
                            }
                        }
                        if (var6_3.view.localEyeLightingEnable != var6_3.ctxEyeLightingEnable) {
                            var6_3.ctxUpdateEyeLightingEnable(var6_3.ctx, var6_3.view.localEyeLightingEnable);
                            var6_3.ctxEyeLightingEnable = var6_3.view.localEyeLightingEnable;
                        }
                        if (var52_54 = this.copyOfCvCache.getUseStereo()) {
                            var11_44 = 2;
                            var10_43 = 0;
                            this.sharedStereoZBuffer = VirtualUniverse.mc.sharedStereoZBuffer;
                        } else {
                            var11_44 = 1;
                            var10_43 = 2;
                            this.sharedStereoZBuffer = false;
                        }
                        if (var6_3.view.getSceneAntialiasingEnable() && var6_3.sceneAntialiasingAvailable) {
                            if (!VirtualUniverse.mc.isD3D() && (var6_3.extensionsSupported & 512) == 0 || !var6_3.sceneAntialiasingMultiSamplesAvailable) {
                                var19_6 = true;
                                var13_5 = 8;
                                System.arraycopy(this.copyOfCvCache.getLeftProjection().mat, 0, this.accumLeftProjMat, 0, 16);
                                var24_9 = var6_3.canvasViewCache.getPhysicalWindowWidth() / (double)var6_3.canvasViewCache.getCanvasWidth() * var6_3.view.fieldOfView;
                                var26_10 = var6_3.canvasViewCache.getPhysicalWindowHeight() / (double)var6_3.canvasViewCache.getCanvasHeight() * var6_3.view.fieldOfView;
                                var28_11 = this.accumLeftProjMat[3];
                                var30_12 = this.accumLeftProjMat[7];
                                if (var52_54) {
                                    System.arraycopy(this.copyOfCvCache.getRightProjection().mat, 0, this.accumRightProjMat, 0, 16);
                                    var32_13 = this.accumRightProjMat[3];
                                    var34_14 = this.accumRightProjMat[7];
                                }
                                if (var4_2.geometryBackground != null) {
                                    System.arraycopy(this.copyOfCvCache.getInfLeftProjection().mat, 0, this.accumInfLeftProjMat, 0, 16);
                                    var36_15 = this.accumInfLeftProjMat[3];
                                    var38_16 = this.accumInfLeftProjMat[7];
                                    if (var52_54) {
                                        System.arraycopy(this.copyOfCvCache.getInfRightProjection().mat, 0, this.accumInfRightProjMat, 0, 16);
                                        var40_17 = this.accumInfRightProjMat[3];
                                        var42_18 = this.accumInfRightProjMat[7];
                                    }
                                }
                            } else if (!var6_3.antialiasingSet) {
                                var6_3.setFullSceneAntialiasing(var6_3.ctx, true);
                                var6_3.antialiasingSet = true;
                            }
                        } else if (var6_3.antialiasingSet) {
                            var6_3.setFullSceneAntialiasing(var6_3.ctx, false);
                            var6_3.antialiasingSet = false;
                        }
                        if (var4_2.geometryBackground != null) {
                            var4_2.updateInfVworldToVpc();
                        }
                        var6_3.setRenderMode(var6_3.ctx, 2, var6_3.useDoubleBuffer);
                        if (var6_3.supportVideoResize()) {
                            if (var6_3.view.dvrResizeCompensation != var6_3.cachedDvrResizeCompensation) {
                                var6_3.videoResizeCompensation(var6_3.ctx, var6_3.view.dvrResizeCompensation);
                                var6_3.cachedDvrResizeCompensation = var6_3.view.dvrResizeCompensation;
                            }
                            if (var6_3.view.dvrFactor != var6_3.cachedDvrFactor) {
                                var6_3.videoResize(var6_3.ctx, var6_3.screen.display, var6_3.window, var6_3.view.dvrFactor);
                                var6_3.cachedDvrFactor = var6_3.view.dvrFactor;
                            }
                        }
                        var6_3.beginScene();
                        var53_57 = this.copyOfCvCache.getCanvasWidth();
                        var54_59 = this.copyOfCvCache.getCanvasHeight();
                        if (!var19_6 && !this.sharedStereoZBuffer) {
                            var55_60 = var4_2.background;
                            if (!VirtualUniverse.mc.isBackgroundTexture) {
                                var6_3.clear(var6_3.ctx, var55_60.color.x, var55_60.color.y, var55_60.color.z, var53_57, var54_59, var55_60.image, var55_60.imageScaleMode, var55_60.image != null ? var55_60.image.imageYdown[0] : null);
                            } else {
                                if (var55_60.texImage != null && this.objectId == -1) {
                                    this.objectId = VirtualUniverse.mc.getTexture2DId();
                                }
                                var6_3.textureclear(var6_3.ctx, var55_60.xmax, var55_60.ymax, var55_60.color.x, var55_60.color.y, var55_60.color.z, var53_57, var54_59, this.objectId, var55_60.imageScaleMode, var55_60.texImage, var51_51);
                            }
                        }
                        if (VirtualUniverse.mc.doDsiRenderLock) {
                            var6_3.drawingSurfaceObject.unLock();
                        }
                        var6_3.view.inCanvasCallback = true;
                        try {
                            var6_3.preRender();
                        }
                        catch (RuntimeException var55_62) {
                            System.err.println("Exception occurred during Canvas3D callback:");
                            var55_62.printStackTrace();
                        }
                        var6_3.view.inCanvasCallback = false;
                        if (VirtualUniverse.mc.doDsiRenderLock && !var6_3.drawingSurfaceObject.renderLock()) {
                            if (var50_41 == null || !var50_41.isByReference()) break;
                            var50_41.geomLock.unLock();
                            break;
                        }
                        var14_45 = 0;
                        while (var14_45 < var11_44) {
                            if (var19_6) {
                                var6_3.clearAccum(var6_3.ctx);
                            }
                            var6_3.setRenderMode(var6_3.ctx, var10_43, var6_3.useDoubleBuffer);
                            var15_46 = 0;
                            while (var15_46 < var13_5) {
                                if (var19_6) {
                                    var20_7 = (double)Renderer.ACCUM_SAMPLES_X[var15_46] * var24_9;
                                    var22_8 = (double)Renderer.ACCUM_SAMPLES_Y[var15_46] * var26_10;
                                    this.accumLeftProjMat[3] = var28_11 + this.accumLeftProjMat[0] * var20_7 + this.accumLeftProjMat[1] * var22_8;
                                    this.accumLeftProjMat[7] = var30_12 + this.accumLeftProjMat[4] * var20_7 + this.accumLeftProjMat[5] * var22_8;
                                    if (var52_54) {
                                        this.accumRightProjMat[3] = var32_13 + this.accumRightProjMat[0] * var20_7 + this.accumRightProjMat[1] * var22_8;
                                        this.accumRightProjMat[7] = var34_14 + this.accumRightProjMat[4] * var20_7 + this.accumRightProjMat[5] * var22_8;
                                    }
                                    if (var4_2.geometryBackground != null) {
                                        this.accumInfLeftProjMat[3] = var36_15 + this.accumInfLeftProjMat[0] * var20_7 + this.accumInfLeftProjMat[1] * var22_8;
                                        this.accumInfLeftProjMat[7] = var38_16 + this.accumInfLeftProjMat[4] * var20_7 + this.accumInfLeftProjMat[5] * var22_8;
                                        if (var52_54) {
                                            this.accumInfRightProjMat[3] = var40_17 + this.accumInfRightProjMat[0] * var20_7 + this.accumInfRightProjMat[1] * var22_8;
                                            this.accumInfRightProjMat[7] = var42_18 + this.accumInfRightProjMat[4] * var20_7 + this.accumInfRightProjMat[5] * var22_8;
                                        }
                                    }
                                }
                                if (var19_6 || this.sharedStereoZBuffer) {
                                    var55_60 = var4_2.background;
                                    if (!VirtualUniverse.mc.isBackgroundTexture) {
                                        var6_3.clear(var6_3.ctx, var55_60.color.x, var55_60.color.y, var55_60.color.z, var53_57, var54_59, var55_60.image, var55_60.imageScaleMode, var55_60.image != null ? var55_60.image.imageYdown[0] : null);
                                    } else {
                                        if (var55_60.texImage != null && this.objectId == -1) {
                                            this.objectId = VirtualUniverse.mc.getTexture2DId();
                                        }
                                        var6_3.textureclear(var6_3.ctx, var55_60.xmax, var55_60.ymax, var55_60.color.x, var55_60.color.y, var55_60.color.z, var53_57, var54_59, this.objectId, var55_60.imageScaleMode, var55_60.texImage, var51_51);
                                    }
                                }
                                if (var4_2.geometryBackground != null) {
                                    if (var14_45 == 0) {
                                        var6_3.vpcToEc = this.copyOfCvCache.getInfLeftVpcToEc();
                                        if (var19_6) {
                                            var6_3.setProjectionMatrix(var6_3.ctx, this.accumInfLeftProjMat);
                                        } else {
                                            var6_3.setProjectionMatrix(var6_3.ctx, this.copyOfCvCache.getInfLeftProjection().mat);
                                        }
                                    } else {
                                        var6_3.vpcToEc = this.copyOfCvCache.getInfRightVpcToEc();
                                        if (var19_6) {
                                            var6_3.setProjectionMatrix(var6_3.ctx, this.accumInfRightProjMat);
                                        } else {
                                            var6_3.setProjectionMatrix(var6_3.ctx, this.copyOfCvCache.getInfRightProjection().mat);
                                        }
                                    }
                                    var6_3.vworldToEc.mul(var6_3.vpcToEc, this.copyOfCvCache.getInfVworldToVpc());
                                    var4_2.renderBackground(var6_3);
                                }
                                if (var14_45 == 0) {
                                    var6_3.vpcToEc = this.copyOfCvCache.getLeftVpcToEc();
                                    if (var19_6) {
                                        var6_3.setProjectionMatrix(var6_3.ctx, this.accumLeftProjMat);
                                    } else {
                                        var6_3.setProjectionMatrix(var6_3.ctx, this.copyOfCvCache.getLeftProjection().mat);
                                    }
                                } else {
                                    var6_3.vpcToEc = this.copyOfCvCache.getRightVpcToEc();
                                    if (var19_6) {
                                        var6_3.setProjectionMatrix(var6_3.ctx, this.accumRightProjMat);
                                    } else {
                                        var6_3.setProjectionMatrix(var6_3.ctx, this.copyOfCvCache.getRightProjection().mat);
                                    }
                                }
                                var6_3.vworldToEc.mul(var6_3.vpcToEc, this.copyOfCvCache.getVworldToVpc());
                                var55_60 = this.copyOfCvCache;
                                synchronized (var55_60) {
                                    if (var14_45 == 0) {
                                        var6_3.setFrustumPlanes(this.copyOfCvCache.getLeftFrustumPlanesInVworld());
                                    } else {
                                        var6_3.setFrustumPlanes(this.copyOfCvCache.getRightFrustumPlanesInVworld());
                                    }
                                }
                                var4_2.renderOpaque(var6_3);
                                var4_2.renderOrdered(var6_3);
                                if (VirtualUniverse.mc.doDsiRenderLock) {
                                    var6_3.drawingSurfaceObject.unLock();
                                }
                                var6_3.view.inCanvasCallback = true;
                                try {
                                    var6_3.renderField(var10_43);
                                }
                                catch (RuntimeException var57_65) {
                                    System.err.println("Exception occurred during Canvas3D callback:");
                                    var57_65.printStackTrace();
                                }
                                var6_3.view.inCanvasCallback = false;
                                if (VirtualUniverse.mc.doDsiRenderLock && !var6_3.drawingSurfaceObject.renderLock()) {
                                    if (var50_41 == null || !var50_41.isByReference()) break block55;
                                    var50_41.geomLock.unLock();
                                    break block55;
                                }
                                var4_2.renderTransparent(var6_3);
                                if (var19_6) {
                                    var6_3.accum(var6_3.ctx, 0.125f);
                                }
                                ++var15_46;
                            }
                            if (var19_6) {
                                var6_3.accumReturn(var6_3.ctx);
                            }
                            if (var52_54) {
                                var10_43 = 1;
                                var6_3.rightStereoPass = true;
                            }
                            ++var14_45;
                        }
                        var6_3.imageReady = true;
                        var6_3.rightStereoPass = false;
                        var6_3.setRenderMode(var6_3.ctx, 2, var6_3.useDoubleBuffer);
                        if (VirtualUniverse.mc.doDsiRenderLock) {
                            var6_3.drawingSurfaceObject.unLock();
                        }
                        var6_3.view.inCanvasCallback = true;
                        try {
                            var6_3.postRender();
                        }
                        catch (RuntimeException var55_63) {
                            System.err.println("Exception occurred during Canvas3D callback:");
                            var55_63.printStackTrace();
                        }
                        var6_3.view.inCanvasCallback = false;
                        if (var6_3.offScreenRendering) {
                            var6_3.syncRender(var6_3.ctx, true);
                            var6_3.endOffScreenRendering();
                            var6_3.view.inCanvasCallback = true;
                            try {
                                var6_3.postSwap();
                            }
                            catch (RuntimeException var55_64) {
                                System.err.println("Exception occurred during Canvas 3D callback:");
                                var55_64.printStackTrace();
                            }
                            if (var50_41.isByReference()) {
                                var50_41.geomLock.unLock();
                            }
                            var6_3.offScreenRendering = false;
                            var6_3.view.inCanvasCallback = false;
                        }
                        var6_3.endScene();
                        continue;
                    }
                    if (var50_41 == null || !var50_41.isByReference()) continue;
                    var50_41.geomLock.unLock();
lbl604:
                    // 13 sources

                    ** while (this.nmesg < var49_36)
                }
lbl605:
                // 15 sources

                if (var44_21 == 0) {
                    this.m[0] = null;
                } else {
                    Arrays.fill(this.m, 0, var49_36, null);
                }
            }
            catch (NullPointerException var48_25) {
                var48_25.printStackTrace();
                if (var6_3 == null) break block200;
                if (var6_3.ctx != 0L) {
                    var6_3.endScene();
                }
                var6_3.drawingSurfaceObject.unLock();
            }
        }
    }

    void shutdown() {
        this.removeAllCtxs();
        if (VirtualUniverse.mc.isD3D()) {
            this.D3DCleanUp();
        }
    }

    void cleanup() {
        super.cleanup();
        this.renderMessage = new J3dMessage[1];
        this.rendererStructure = new RendererStructure();
        this.bgVworldToVpc = new Transform3D();
        this.numframes = 0.0f;
        this.sharedCtx = 0L;
        this.sharedCtxTimeStamp = 0L;
        this.dirtyRenderMoleculeList.clear();
        this.dirtyRenderAtomList.clear();
        this.dirtyDlistPerRinfoList.clear();
        this.textureIdResourceFreeList.clear();
        this.displayListResourceFreeList.clear();
        this.copyOfCvCache = new CanvasViewCache(null, null, null);
        this.onScreen = null;
        this.offScreen = null;
        this.m = null;
        this.nmesg = 0;
        this.lasttime = 0L;
        this.currtime = 0L;
        this.display = 0L;
    }

    final void makeCtxCurrent(long l, long l2, int n) {
        if (l != this.currentCtx) {
            Canvas3D.useCtx(l, l2, n);
            this.currentCtx = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCtx(Canvas3D canvas3D, long l, int n, long l2, boolean bl, boolean bl2) {
        Object object = VirtualUniverse.mc.contextCreationLock;
        synchronized (object) {
            if (l2 != 0L) {
                int n2 = this.listOfCtxs.indexOf(new Long(l2));
                if (n2 >= 0) {
                    this.listOfCtxs.remove(n2);
                    this.listOfCanvases.remove(n2);
                    if ((MasterControl.isWin32 || l != 0L) && n != 0 && canvas3D.added && canvas3D.drawingSurfaceObject.renderLock()) {
                        if (this.sharedCtx != 0L) {
                            if (this.listOfCtxs.isEmpty()) {
                                this.makeCtxCurrent(this.sharedCtx, l, n);
                                this.freeResourcesInFreeList(null);
                                this.freeContextResources();
                                Canvas3D.destroyContext(l, n, this.sharedCtx);
                                this.currentCtx = -1L;
                            } else {
                                this.freeResourcesInFreeList(canvas3D);
                            }
                            canvas3D.makeCtxCurrent(l2, l, n);
                        } else {
                            canvas3D.makeCtxCurrent(l2, l, n);
                            canvas3D.freeResourcesInFreeList(l2);
                        }
                        canvas3D.freeContextResources(this, bl2, l2);
                        Canvas3D.destroyContext(l, n, l2);
                        this.currentCtx = -1L;
                        canvas3D.drawingSurfaceObject.unLock();
                    }
                }
                if (bl) {
                    canvas3D.ctx = 0L;
                }
                if (this.sharedCtx != 0L && this.listOfCtxs.isEmpty()) {
                    this.sharedCtx = 0L;
                    this.sharedCtxTimeStamp = 0L;
                }
                canvas3D.ctxTimeStamp = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllCtxs() {
        Object object = VirtualUniverse.mc.contextCreationLock;
        synchronized (object) {
            int n = this.listOfCanvases.size() - 1;
            while (n >= 0) {
                Canvas3D canvas3D = (Canvas3D)this.listOfCanvases.get(n);
                if (canvas3D.screen != null && canvas3D.ctx != 0L && (MasterControl.isWin32 || this.display != 0L) && canvas3D.window != 0 && canvas3D.added && canvas3D.drawingSurfaceObject.renderLock()) {
                    if (n == 0 && this.sharedCtx != 0L) {
                        this.makeCtxCurrent(this.sharedCtx, this.display, this.window);
                        this.freeResourcesInFreeList(null);
                        this.freeContextResources();
                        Canvas3D.destroyContext(this.display, this.window, this.sharedCtx);
                        this.currentCtx = -1L;
                    }
                    canvas3D.makeCtxCurrent();
                    canvas3D.freeResourcesInFreeList(canvas3D.ctx);
                    canvas3D.freeContextResources(this, true, canvas3D.ctx);
                    Canvas3D.destroyContext(canvas3D.screen.display, canvas3D.window, canvas3D.ctx);
                    this.currentCtx = -1L;
                    canvas3D.drawingSurfaceObject.unLock();
                }
                canvas3D.ctx = 0L;
                canvas3D.ctxTimeStamp = 0L;
                --n;
            }
            if (this.sharedCtx != 0L) {
                this.sharedCtx = 0L;
                this.sharedCtxTimeStamp = 0L;
            }
            this.listOfCanvases.clear();
            this.listOfCtxs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeTextureID(int n, String string2) {
        Object object;
        Object object2 = null;
        int n2 = this.listOfCtxs.size() - 1;
        while (n2 >= 0) {
            object = (Canvas3D)this.listOfCanvases.get(n2);
            if (((Canvas3D)object).ctx == this.currentCtx) {
                object2 = object;
                break;
            }
            --n2;
        }
        if (object2 == null) {
            return;
        }
        object = VirtualUniverse.mc.contextCreationLock;
        synchronized (object) {
            if (this.sharedCtx != 0L) {
                ((Canvas3D)object2).makeCtxCurrent(this.sharedCtx);
                Canvas3D.freeTexture(this.sharedCtx, n);
            } else {
                int n3 = this.listOfCtxs.size() - 1;
                while (n3 >= 0) {
                    Canvas3D canvas3D = (Canvas3D)this.listOfCanvases.get(n3);
                    canvas3D.makeCtxCurrent();
                    Canvas3D.freeTexture(canvas3D.ctx, n);
                    --n3;
                }
            }
            ((Canvas3D)object2).makeCtxCurrent();
        }
        if (string2.equals("2D")) {
            VirtualUniverse.mc.freeTexture2DId(n);
        } else if (string2.equals("3D")) {
            VirtualUniverse.mc.freeTexture3DId(n);
        }
    }

    void freeResourcesInFreeList(Canvas3D canvas3D) {
        boolean bl;
        boolean bl2 = this.textureIdResourceFreeList.size() > 0;
        boolean bl3 = bl = this.displayListResourceFreeList.size() > 0;
        if (bl2 || bl) {
            int n;
            Iterator iterator2;
            if (canvas3D != null) {
                canvas3D.makeCtxCurrent(this.sharedCtx);
            }
            if (bl) {
                iterator2 = this.displayListResourceFreeList.iterator();
                while (iterator2.hasNext()) {
                    n = (Integer)iterator2.next();
                    if (n <= 0) continue;
                    Canvas3D.freeDisplayList(this.sharedCtx, n);
                }
                this.displayListResourceFreeList.clear();
            }
            if (bl2) {
                iterator2 = this.textureIdResourceFreeList.iterator();
                while (iterator2.hasNext()) {
                    n = (Integer)iterator2.next();
                    if (n <= 0) continue;
                    if (n >= this.textureIDResourceTable.size()) {
                        System.out.println("Error in freeResourcesInFreeList : ResourceIDTableSize = " + this.textureIDResourceTable.size() + " val = " + n);
                    } else {
                        this.textureIDResourceTable.set(n, null);
                    }
                    Canvas3D.freeTexture(this.sharedCtx, n);
                }
                this.textureIdResourceFreeList.clear();
            }
            if (canvas3D != null) {
                canvas3D.makeCtxCurrent(canvas3D.ctx);
            }
        }
    }

    final void addTextureResource(int n, Object object) {
        if (this.textureIDResourceTable.size() <= n) {
            int n2 = this.textureIDResourceTable.size();
            while (n2 < n) {
                this.textureIDResourceTable.add(null);
                ++n2;
            }
            this.textureIDResourceTable.add(object);
        } else {
            this.textureIDResourceTable.set(n, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeContextResources() {
        int n = this.textureIDResourceTable.size() - 1;
        while (n > 0) {
            Object e = this.textureIDResourceTable.get(n);
            if (e != null) {
                Canvas3D.freeTexture(this.sharedCtx, n);
                if (e instanceof TextureRetained) {
                    TextureRetained textureRetained = (TextureRetained)e;
                    Object object = textureRetained.resourceLock;
                    synchronized (object) {
                        textureRetained.resourceCreationMask &= ~this.rendererBit;
                        if (textureRetained.resourceCreationMask == 0) {
                            textureRetained.freeTextureId(n);
                        }
                    }
                } else if (e instanceof DetailTextureImage) {
                    DetailTextureImage detailTextureImage = (DetailTextureImage)e;
                    detailTextureImage.freeDetailTextureId(n, this.rendererBit);
                }
            }
            --n;
        }
        this.textureIDResourceTable.clear();
    }
}

