/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.CachedTargets;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Font3D;
import javax.media.j3d.FreeListManager;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NnuId;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.PickShape;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.TargetsInterface;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

class Text3DRetained
extends GeometryRetained {
    Font3D font3D = null;
    String string = null;
    Point3f position = new Point3f(0.0f, 0.0f, 0.0f);
    int alignment = 1;
    int path = 1;
    float charSpacing = 0.0f;
    int numChars = 0;
    static final int targetThreads = 8384;
    Transform3D[] charTransforms = new Transform3D[0];
    GeometryArrayRetained[] geometryList = new GeometryArrayRetained[0];
    GlyphVector[] glyphVecs = new GlyphVector[0];
    Point3d lower = new Point3d();
    Point3d upper = new Point3d();
    ArrayList newGeometryAtomList = new ArrayList();
    ArrayList oldGeometryAtomList = new ArrayList();
    Transform3D vpcToEc;
    Transform3D drawTransform;

    Text3DRetained() {
        this.geoType = 16;
    }

    synchronized void computeBoundingBox() {
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Vector3f vector3f = new Vector3f(this.position);
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        point3d.set(vector3f);
        point3d2.set(vector3f);
        if (this.numChars != 0) {
            Rectangle2D rectangle2D;
            if (this.path == 1 || this.path == 2) {
                n = 0;
                n2 = this.numChars + 1;
            } else if (this.path == 0 || this.path == 3) {
                n = 1;
                n2 = this.numChars;
                rectangle2D = this.glyphVecs[0].getVisualBounds();
                point3d2.x += rectangle2D.getWidth();
                point3d2.y += rectangle2D.getHeight();
            }
            int n3 = 1;
            while (n3 < n2) {
                d = this.glyphVecs[n].getLogicalBounds().getWidth();
                rectangle2D = this.glyphVecs[n].getVisualBounds();
                d += (double)this.charSpacing;
                d2 = rectangle2D.getHeight();
                switch (this.path) {
                    case 1: {
                        point3d2.x += d;
                        if (!(point3d2.y < d2 + (double)vector3f.y)) break;
                        point3d2.y = (double)vector3f.y + d2;
                        break;
                    }
                    case 0: {
                        point3d.x -= d;
                        if (!(point3d2.y < d2 + (double)vector3f.y)) break;
                        point3d2.y = (double)vector3f.y + d2;
                        break;
                    }
                    case 2: {
                        point3d2.y += d2;
                        if (!(point3d2.x < rectangle2D.getWidth() + (double)vector3f.x)) break;
                        point3d2.x = (double)vector3f.x + rectangle2D.getWidth();
                        break;
                    }
                    case 3: {
                        point3d.y -= d2;
                        if (!(point3d2.x < rectangle2D.getWidth() + (double)vector3f.x)) break;
                        point3d2.x = (double)vector3f.x + rectangle2D.getWidth();
                    }
                }
                ++n3;
                ++n;
            }
            if (this.alignment != 1) {
                double d3 = point3d2.x - point3d.x;
                double d4 = point3d2.y - point3d.y;
                if (this.alignment == 0) {
                    d3 *= 0.5;
                    d4 *= 0.5;
                }
                switch (this.path) {
                    case 1: {
                        point3d.x -= d3;
                        point3d2.x -= d3;
                        break;
                    }
                    case 0: {
                        point3d.x += d3;
                        point3d2.x += d3;
                        break;
                    }
                    case 2: {
                        point3d.y -= d4;
                        point3d2.y -= d4;
                        break;
                    }
                    case 3: {
                        point3d.y += d4;
                        point3d2.y += d4;
                    }
                }
            }
        }
        point3d.z = 0.0;
        point3d2.z = this.font3D == null || this.font3D.fontExtrusion == null ? point3d.z : point3d.z + (double)this.font3D.fontExtrusion.length;
    }

    void update() {
    }

    final Font3D getFont3D() {
        return this.font3D;
    }

    final void setFont3D(Font3D font3D) {
        this.geomLock.getLock();
        this.font3D = font3D;
        this.updateCharacterData();
        this.geomLock.unLock();
        this.sendDataChangedMessage();
    }

    final String getString() {
        return this.string;
    }

    final void setString(String string2) {
        this.geomLock.getLock();
        this.string = string2;
        this.numChars = string2 == null ? 0 : string2.length();
        this.updateCharacterData();
        this.geomLock.unLock();
        this.sendDataChangedMessage();
    }

    final void getPosition(Point3f point3f) {
        point3f.set(this.position);
    }

    final void setPosition(Point3f point3f) {
        this.geomLock.getLock();
        this.position.set(point3f);
        this.updateTransformData();
        this.geomLock.unLock();
        this.sendTransformChangedMessage();
    }

    final int getAlignment() {
        return this.alignment;
    }

    final void setAlignment(int n) {
        this.geomLock.getLock();
        this.alignment = n;
        this.updateTransformData();
        this.geomLock.unLock();
        this.sendTransformChangedMessage();
    }

    final int getPath() {
        return this.path;
    }

    final void setPath(int n) {
        this.path = n;
        this.updateTransformData();
        this.sendTransformChangedMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void getBoundingBox(BoundingBox boundingBox) {
        Text3DRetained text3DRetained = this;
        synchronized (text3DRetained) {
            boundingBox.setLower(this.lower);
            boundingBox.setUpper(this.upper);
        }
    }

    final float getCharacterSpacing() {
        return this.charSpacing;
    }

    final void setCharacterSpacing(float f) {
        this.geomLock.getLock();
        this.charSpacing = f;
        this.updateTransformData();
        this.geomLock.unLock();
        this.sendTransformChangedMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendDataChangedMessage() {
        ArrayList<TargetsInterface> arrayList = new ArrayList<TargetsInterface>();
        ArrayList<CachedTargets[]> arrayList2 = new ArrayList<CachedTargets[]>();
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                ArrayList arrayList3 = this.universeList;
                synchronized (arrayList3) {
                    int n = this.universeList.size();
                    J3dMessage[] j3dMessageArray = new J3dMessage[n];
                    int n2 = 0;
                    while (n2 < n) {
                        SceneGraphObjectRetained sceneGraphObjectRetained;
                        SceneGraphObjectRetained sceneGraphObjectRetained2;
                        int n3;
                        int n4;
                        Object object2;
                        Object object3;
                        j3dMessageArray[n2] = VirtualUniverse.mc.getMessage();
                        j3dMessageArray[n2].type = 26;
                        j3dMessageArray[n2].threads = 8384;
                        ArrayList arrayList4 = (ArrayList)this.userLists.get(n2);
                        this.newGeometryAtomList.clear();
                        this.oldGeometryAtomList.clear();
                        int n5 = 0;
                        while (n5 < arrayList4.size()) {
                            GeometryRetained geometryRetained;
                            Shape3DRetained shape3DRetained = (Shape3DRetained)arrayList4.get(n5);
                            if (shape3DRetained.boundsAutoCompute) {
                                shape3DRetained.getCombineBounds((BoundingBox)shape3DRetained.bounds);
                            }
                            int n6 = shape3DRetained.geometryList.size();
                            object3 = Shape3DRetained.getGeomAtom(shape3DRetained);
                            object2 = new GeometryAtom();
                            int n7 = 0;
                            n4 = 0;
                            while (n4 < n6) {
                                GeometryRetained geometryRetained2 = (GeometryRetained)shape3DRetained.geometryList.get(n4);
                                if (geometryRetained2 != null) {
                                    geometryRetained = (Text3DRetained)geometryRetained2;
                                    n7 += geometryRetained.numChars;
                                } else {
                                    ++n7;
                                }
                                ++n4;
                            }
                            object2.geometryArray = new GeometryRetained[n7];
                            object2.lastLocalTransformArray = new Transform3D[n7];
                            n7 = 0;
                            object2.locale = shape3DRetained.locale;
                            object2.visible = shape3DRetained.visible;
                            object2.source = shape3DRetained;
                            n3 = 0;
                            geometryRetained = null;
                            while (n3 < n6) {
                                geometryRetained = (GeometryRetained)shape3DRetained.geometryList.get(n3);
                                if (geometryRetained != null) {
                                    object2.geoType = geometryRetained.geoType;
                                    object2.alphaEditable = shape3DRetained.isAlphaEditable(geometryRetained);
                                    break;
                                }
                                ++n3;
                            }
                            while (n3 < n6) {
                                geometryRetained = (GeometryRetained)shape3DRetained.geometryList.get(n3);
                                if (geometryRetained == null) {
                                    object2.geometryArray[n3] = null;
                                } else {
                                    sceneGraphObjectRetained2 = geometryRetained;
                                    n4 = 0;
                                    while (n4 < ((Text3DRetained)sceneGraphObjectRetained2).numChars) {
                                        sceneGraphObjectRetained = ((Text3DRetained)sceneGraphObjectRetained2).geometryList[n4];
                                        if (sceneGraphObjectRetained != null) {
                                            object2.geometryArray[n7] = sceneGraphObjectRetained;
                                            object2.lastLocalTransformArray[n7] = ((Text3DRetained)sceneGraphObjectRetained2).charTransforms[n4];
                                        } else {
                                            object2.geometryArray[n7] = null;
                                            object2.lastLocalTransformArray[n7] = null;
                                        }
                                        ++n4;
                                        ++n7;
                                    }
                                }
                                ++n3;
                            }
                            this.oldGeometryAtomList.add(object3);
                            this.newGeometryAtomList.add(object2);
                            Shape3DRetained.setGeomAtom(shape3DRetained, (GeometryAtom)object2);
                            ++n5;
                        }
                        object3 = this.oldGeometryAtomList.toArray();
                        object2 = this.newGeometryAtomList.toArray();
                        ArrayList arrayList5 = this.getUniqueSource(arrayList4);
                        n3 = arrayList5.size();
                        n5 = 0;
                        while (n5 < n3) {
                            CachedTargets[] cachedTargetsArray = null;
                            sceneGraphObjectRetained = (Shape3DRetained)arrayList5.get(n5);
                            int n8 = sceneGraphObjectRetained.mirrorShape3D.size();
                            TargetsInterface targetsInterface = ((GroupRetained)sceneGraphObjectRetained.parent).getClosestTargetsInterface(0);
                            if (targetsInterface != null) {
                                cachedTargetsArray = new CachedTargets[n8];
                                n4 = 0;
                                while (n4 < n8) {
                                    CachedTargets cachedTargets;
                                    sceneGraphObjectRetained2 = (Shape3DRetained)sceneGraphObjectRetained.mirrorShape3D.get(n4);
                                    GeometryAtom geometryAtom = Shape3DRetained.getGeomAtom(sceneGraphObjectRetained2);
                                    int n9 = 0;
                                    while (n9 < ((Object[])object2).length) {
                                        if (geometryAtom == object2[n9]) break;
                                        ++n9;
                                    }
                                    if (n9 == ((Object[])object2).length) {
                                        System.out.println("Text3DRetained : Problem !!! Can't find matching geomAtom");
                                    }
                                    if ((cachedTargets = targetsInterface.getCachedTargets(0, n4, -1)) != null) {
                                        cachedTargetsArray[n4] = new CachedTargets();
                                        cachedTargetsArray[n4].copy(cachedTargets);
                                        cachedTargetsArray[n4].replace((NnuId)object3[n9], (NnuId)object2[n9], 0);
                                    } else {
                                        cachedTargetsArray[n4] = null;
                                    }
                                    ++n4;
                                }
                                targetsInterface.resetCachedTargets(0, cachedTargetsArray, -1);
                                arrayList.add(targetsInterface);
                                arrayList2.add(cachedTargetsArray);
                            }
                            ++n5;
                        }
                        j3dMessageArray[n2].args[0] = object3;
                        j3dMessageArray[n2].args[1] = object2;
                        j3dMessageArray[n2].universe = (VirtualUniverse)this.universeList.get(n2);
                        if (arrayList.size() > 0) {
                            j3dMessageArray[n2].args[2] = arrayList.toArray();
                            j3dMessageArray[n2].args[3] = arrayList2.toArray();
                        }
                        arrayList.clear();
                        arrayList2.clear();
                        ++n2;
                    }
                    VirtualUniverse.mc.processMessage(j3dMessageArray);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendTransformChangedMessage() {
        ArrayList<GeometryAtom> arrayList = new ArrayList<GeometryAtom>();
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                ArrayList arrayList2 = this.universeList;
                synchronized (arrayList2) {
                    int n = this.universeList.size();
                    J3dMessage[] j3dMessageArray = new J3dMessage[n];
                    int n2 = 0;
                    while (n2 < n) {
                        j3dMessageArray[n2] = VirtualUniverse.mc.getMessage();
                        j3dMessageArray[n2].type = 25;
                        j3dMessageArray[n2].threads = 8384;
                        ArrayList arrayList3 = (ArrayList)this.userLists.get(n2);
                        int n3 = 0;
                        while (n3 < arrayList3.size()) {
                            Shape3DRetained shape3DRetained = (Shape3DRetained)arrayList3.get(n3);
                            int n4 = 0;
                            while (n4 < shape3DRetained.geometryList.size()) {
                                GeometryRetained geometryRetained = (GeometryRetained)shape3DRetained.geometryList.get(n4);
                                if (geometryRetained == this) break;
                                ++n4;
                            }
                            if (n4 < shape3DRetained.geometryList.size()) {
                                arrayList.add(Shape3DRetained.getGeomAtom(shape3DRetained));
                            }
                            ++n3;
                        }
                        j3dMessageArray[n2].args[0] = arrayList.toArray();
                        j3dMessageArray[n2].args[1] = this.charTransforms;
                        j3dMessageArray[n2].universe = (VirtualUniverse)this.universeList.get(n2);
                        ++n2;
                    }
                    VirtualUniverse.mc.processMessage(j3dMessageArray);
                }
            }
        }
    }

    final void updateCharacterData() {
        char[] cArray = new char[1];
        if (this.geometryList.length != this.numChars) {
            this.geometryList = new GeometryArrayRetained[this.numChars];
            this.glyphVecs = new GlyphVector[this.numChars];
        }
        if (this.font3D != null) {
            int n = 0;
            while (n < this.numChars) {
                cArray[0] = this.string.charAt(n);
                this.glyphVecs[n] = this.font3D.font.createGlyphVector(this.font3D.frc, cArray);
                this.geometryList[n] = this.font3D.triangulateGlyphs(this.glyphVecs[n], cArray[0]);
                ++n;
            }
        }
        this.updateTransformData();
    }

    final void updateTransformData() {
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        Vector3f vector3f = new Vector3f(this.position);
        this.lower.set(vector3f);
        this.upper.set(vector3f);
        this.charTransforms = new Transform3D[this.numChars];
        int n3 = 0;
        while (n3 < this.numChars) {
            this.charTransforms[n3] = VirtualUniverse.mc.getTransform3D(null);
            ++n3;
        }
        if (this.numChars != 0) {
            Rectangle2D rectangle2D;
            this.charTransforms[0].set(vector3f);
            if (this.path == 1 || this.path == 2) {
                n = 0;
                n2 = this.numChars + 1;
            } else if (this.path == 0 || this.path == 3) {
                n = 1;
                n2 = this.numChars;
                rectangle2D = this.glyphVecs[0].getVisualBounds();
                this.upper.x += rectangle2D.getWidth();
                this.upper.y += rectangle2D.getHeight();
            }
            n3 = 1;
            while (n3 < n2) {
                d = this.glyphVecs[n].getLogicalBounds().getWidth();
                rectangle2D = this.glyphVecs[n].getVisualBounds();
                d += (double)this.charSpacing;
                d2 = rectangle2D.getHeight();
                switch (this.path) {
                    case 1: {
                        vector3f.x = (float)((double)vector3f.x + d);
                        this.upper.x += d;
                        if (!(this.upper.y < d2 + (double)vector3f.y)) break;
                        this.upper.y = (double)vector3f.y + d2;
                        break;
                    }
                    case 0: {
                        vector3f.x = (float)((double)vector3f.x - d);
                        this.lower.x -= d;
                        if (!(this.upper.y < d2 + (double)vector3f.y)) break;
                        this.upper.y = (double)vector3f.y + d2;
                        break;
                    }
                    case 2: {
                        vector3f.y = (float)((double)vector3f.y + d2);
                        this.upper.y += d2;
                        if (!(this.upper.x < rectangle2D.getWidth() + (double)vector3f.x)) break;
                        this.upper.x = (double)vector3f.x + rectangle2D.getWidth();
                        break;
                    }
                    case 3: {
                        vector3f.y = (float)((double)vector3f.y - d2);
                        this.lower.y -= d2;
                        if (!(this.upper.x < rectangle2D.getWidth() + (double)vector3f.x)) break;
                        this.upper.x = (double)vector3f.x + rectangle2D.getWidth();
                    }
                }
                if (n3 < this.numChars) {
                    this.charTransforms[n3].set(vector3f);
                }
                ++n3;
                ++n;
            }
            if (this.alignment != 1) {
                double d3 = this.upper.x - this.lower.x;
                double d4 = this.upper.y - this.lower.y;
                if (this.alignment == 0) {
                    d3 *= 0.5;
                    d4 *= 0.5;
                }
                switch (this.path) {
                    case 1: {
                        n3 = 0;
                        while (n3 < this.numChars) {
                            this.charTransforms[n3].mat[3] = this.charTransforms[n3].mat[3] - d3;
                            ++n3;
                        }
                        this.lower.x -= d3;
                        this.upper.x -= d3;
                        break;
                    }
                    case 0: {
                        n3 = 0;
                        while (n3 < this.numChars) {
                            this.charTransforms[n3].mat[3] = this.charTransforms[n3].mat[3] + d3;
                            ++n3;
                        }
                        this.lower.x += d3;
                        this.upper.x += d3;
                        break;
                    }
                    case 2: {
                        n3 = 0;
                        while (n3 < this.numChars) {
                            this.charTransforms[n3].mat[7] = this.charTransforms[n3].mat[7] - d4;
                            ++n3;
                        }
                        this.lower.y -= d4;
                        this.upper.y -= d4;
                        break;
                    }
                    case 3: {
                        n3 = 0;
                        while (n3 < this.numChars) {
                            this.charTransforms[n3].mat[7] = this.charTransforms[n3].mat[7] + d4;
                            ++n3;
                        }
                        this.lower.y += d4;
                        this.upper.y += d4;
                    }
                }
            }
        }
        this.lower.z = 0.0;
        this.upper.z = this.font3D == null || this.font3D.fontExtrusion == null ? this.lower.z : this.lower.z + (double)this.font3D.fontExtrusion.length;
        this.getBoundingBox(this.geoBounds);
    }

    void setLive(boolean bl, int n) {
        this.updateCharacterData();
        super.doSetLive(bl, n);
        super.markAsLive();
    }

    boolean intersect(PickShape pickShape, double[] dArray, Point3d point3d) {
        Transform3D transform3D = VirtualUniverse.mc.getTransform3D(null);
        GeometryArrayRetained geometryArrayRetained = null;
        int n = -1;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = Double.MAX_VALUE;
        int n2 = 0;
        while (n2 < this.numChars) {
            geometryArrayRetained = this.geometryList[n2];
            if (geometryArrayRetained != null) {
                transform3D.invert(this.charTransforms[n2]);
                PickShape pickShape2 = pickShape.transform(transform3D);
                if (geometryArrayRetained.intersect(pickShape2, dArray, point3d)) {
                    if (dArray == null) {
                        return true;
                    }
                    if (dArray[0] < d4) {
                        n = n2;
                        d4 = dArray[0];
                        d = point3d.x;
                        d2 = point3d.y;
                        d3 = point3d.z;
                    }
                }
            }
            ++n2;
        }
        FreeListManager.freeObject(2, transform3D);
        if (n >= 0) {
            point3d.x = d;
            point3d.y = d2;
            point3d.z = d3;
            dArray[0] = d4;
            this.charTransforms[n].transform(point3d);
            return true;
        }
        return false;
    }

    boolean intersect(Point3d[] point3dArray) {
        Transform3D transform3D = VirtualUniverse.mc.getTransform3D(null);
        boolean bl = false;
        Point3d[] point3dArray2 = new Point3d[point3dArray.length];
        int n = point3dArray.length - 1;
        while (n >= 0) {
            point3dArray2[n] = new Point3d();
            --n;
        }
        int n2 = this.numChars - 1;
        while (n2 >= 0) {
            GeometryArrayRetained geometryArrayRetained = this.geometryList[n2];
            if (geometryArrayRetained != null) {
                transform3D.invert(this.charTransforms[n2]);
                int n3 = point3dArray.length - 1;
                while (n3 >= 0) {
                    transform3D.transform(point3dArray[n3], point3dArray2[n3]);
                    --n3;
                }
                if (geometryArrayRetained.intersect(point3dArray2)) {
                    bl = true;
                    break;
                }
            }
            --n2;
        }
        FreeListManager.freeObject(2, transform3D);
        return bl;
    }

    boolean intersect(Transform3D transform3D, GeometryRetained geometryRetained) {
        int n = this.numChars - 1;
        while (n >= 0) {
            GeometryArrayRetained geometryArrayRetained = this.geometryList[n];
            if (geometryArrayRetained != null && geometryArrayRetained.intersect(transform3D, geometryRetained)) {
                return true;
            }
            --n;
        }
        return false;
    }

    boolean intersect(Bounds bounds) {
        int n = this.numChars - 1;
        while (n >= 0) {
            GeometryArrayRetained geometryArrayRetained = this.geometryList[n];
            if (geometryArrayRetained != null && geometryArrayRetained.intersect(bounds)) {
                return true;
            }
            --n;
        }
        return false;
    }

    void setModelViewMatrix(Transform3D transform3D, Transform3D transform3D2) {
        this.vpcToEc = transform3D;
        this.drawTransform = transform3D2;
    }

    void execute(Canvas3D canvas3D, RenderAtom renderAtom, boolean bl, boolean bl2, float f, boolean bl3, int n, boolean bl4, int n2) {
        Transform3D transform3D = VirtualUniverse.mc.getTransform3D(null);
        int n3 = 0;
        while (n3 < this.geometryList.length) {
            transform3D.set(this.drawTransform);
            transform3D.mul(this.charTransforms[n3]);
            canvas3D.setModelViewMatrix(canvas3D.ctx, this.vpcToEc.mat, transform3D);
            this.geometryList[n3].execute(canvas3D, renderAtom, bl, bl2, f, bl3, n, bl4, n2);
            ++n3;
        }
        FreeListManager.freeObject(2, transform3D);
    }

    int getClassType() {
        return 6;
    }

    ArrayList getUniqueSource(ArrayList arrayList) {
        ArrayList<NodeRetained> arrayList2 = new ArrayList<NodeRetained>();
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            NodeRetained nodeRetained = ((Shape3DRetained)arrayList.get((int)n2)).sourceNode;
            int n3 = arrayList2.indexOf(nodeRetained);
            if (n3 == -1) {
                arrayList2.add(nodeRetained);
            }
            ++n2;
        }
        return arrayList2;
    }
}

