/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Arrays;
import javax.media.j3d.Bounds;
import javax.media.j3d.CachedTargets;
import javax.media.j3d.FreeListManager;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.Locale;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.SwitchState;
import javax.media.j3d.TargetsInterface;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupData;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.UnorderList;
import javax.media.j3d.UpdateTargets;
import javax.media.j3d.VirtualUniverse;

class TransformStructure
extends J3dStructure
implements ObjectUpdate {
    UnorderList traverseList = new UnorderList(class$javax$media$j3d$TransformGroupRetained == null ? (class$javax$media$j3d$TransformGroupRetained = TransformStructure.class$("javax.media.j3d.TransformGroupRetained")) : class$javax$media$j3d$TransformGroupRetained);
    UnorderList transformList = new UnorderList(class$javax$media$j3d$Transform3D == null ? (class$javax$media$j3d$Transform3D = TransformStructure.class$("javax.media.j3d.Transform3D")) : class$javax$media$j3d$Transform3D);
    ArrayList objectList = new ArrayList();
    ArrayList blUsers = new ArrayList();
    UpdateTargets targets = new UpdateTargets();
    ArrayList collisionObjectList = new ArrayList();
    HashKey key = new HashKey(250);
    ArrayList dirtyTransformGroups = new ArrayList();
    ArrayList keySet = new ArrayList();
    Locale locale = null;
    Transform3D currentTrans = new Transform3D();
    TransformGroupRetained[] tgs;
    Transform3D[] t3ds;
    UnorderList activeTraverseList = new UnorderList(class$javax$media$j3d$TransformGroupRetained == null ? (class$javax$media$j3d$TransformGroupRetained = TransformStructure.class$("javax.media.j3d.TransformGroupRetained")) : class$javax$media$j3d$TransformGroupRetained);
    ArrayList switchDirtyTgList = new ArrayList(1);
    boolean lazyUpdate = false;
    ArrayList switchChangedList = new ArrayList();
    boolean inUpdateObjectList = false;
    static /* synthetic */ Class class$javax$media$j3d$TransformGroupRetained;
    static /* synthetic */ Class class$javax$media$j3d$Transform3D;

    TransformStructure(VirtualUniverse virtualUniverse) {
        super(virtualUniverse, 8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMessages(long l) {
        Object[] objectArray = this.getMessages(l);
        int n = this.getNumMessage();
        if (n <= 0) {
            return;
        }
        this.targets.clearNodes();
        this.objectList.clear();
        this.blUsers.clear();
        this.inUpdateObjectList = false;
        Object object = this.universe.sceneGraphLock;
        synchronized (object) {
            J3dMessage j3dMessage;
            int n2 = n - 1;
            while (n2 >= 0) {
                int n3;
                j3dMessage = objectArray[n2];
                if (j3dMessage.type == 3 && (n3 = this.traverseList.indexOf(j3dMessage.args[1])) == -1) {
                    this.traverseList.add(j3dMessage.args[1]);
                    this.transformList.add(j3dMessage.args[2]);
                }
                --n2;
            }
            n2 = 0;
            while (n2 < n) {
                j3dMessage = objectArray[n2];
                switch (j3dMessage.type) {
                    case 0: {
                        this.objectList.add(j3dMessage.args[0]);
                        if (j3dMessage.args[1] == null) break;
                        Object object2 = (TargetsInterface)j3dMessage.args[1];
                        object2.updateCachedTargets(0, (CachedTargets[])j3dMessage.args[2]);
                        break;
                    }
                    case 1: {
                        this.removeNodes(j3dMessage);
                        break;
                    }
                    case 27: {
                        this.processSwitchChanged(j3dMessage);
                        break;
                    }
                    case 24: {
                        this.objectList.add(j3dMessage.args[3]);
                        if (j3dMessage.args[4] == null) break;
                        Object object2 = (TargetsInterface)j3dMessage.args[4];
                        object2.updateCachedTargets(0, (CachedTargets[])j3dMessage.args[5]);
                        break;
                    }
                    case 17: {
                        this.objectList.add(j3dMessage.args[0]);
                        break;
                    }
                    case 16: {
                        this.objectList.add(j3dMessage.args[3]);
                        break;
                    }
                    case 26: {
                        this.objectList.add(j3dMessage.args[1]);
                        Object object2 = (Object[])j3dMessage.args[2];
                        if (object2 == null) break;
                        Object[] objectArray2 = (Object[])j3dMessage.args[3];
                        int n4 = 0;
                        while (n4 < ((Object)object2).length) {
                            TargetsInterface targetsInterface = (TargetsInterface)object2[n4];
                            targetsInterface.updateCachedTargets(0, (CachedTargets[])objectArray2[n4]);
                            ++n4;
                        }
                        break;
                    }
                    case 25: {
                        this.objectList.add(j3dMessage.args[0]);
                        break;
                    }
                    case 37: {
                        this.processBoundsAutoComputeChanged(j3dMessage);
                        break;
                    }
                    case 35: {
                        this.processRegionBoundChanged(j3dMessage);
                        break;
                    }
                    case 34: {
                        this.processCollisionBoundChanged(j3dMessage);
                    }
                }
                j3dMessage.decRefcount();
                ++n2;
            }
            this.processCurrentLocalToVworld();
            if (this.objectList.size() > 0) {
                this.processGeometryAtomVwcBounds();
            }
            this.processVwcBounds();
        }
        Arrays.fill(objectArray, 0, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processCurrentLocalToVworld() {
        int n;
        this.lazyUpdate = false;
        int n2 = this.transformList.size();
        int n3 = this.switchDirtyTgList.size();
        if (n2 <= 0 && n3 <= 0) {
            return;
        }
        if (n2 > 0) {
            this.tgs = (TransformGroupRetained[])this.traverseList.toArray(false);
            this.t3ds = (Transform3D[])this.transformList.toArray(false);
            n = 0;
            while (n < n2) {
                TransformGroupRetained transformGroupRetained = this.tgs[n];
                transformGroupRetained.currentTransform.set(this.t3ds[n]);
                FreeListManager.freeObject(2, this.t3ds[n]);
                TransformGroupRetained transformGroupRetained2 = transformGroupRetained;
                synchronized (transformGroupRetained2) {
                    if (transformGroupRetained.perPathData != null) {
                        TransformGroupData transformGroupData;
                        if (!transformGroupRetained.inSharedGroup) {
                            transformGroupData = transformGroupRetained.perPathData[0];
                            if (!transformGroupData.switchState.inSwitch) {
                                this.activeTraverseList.add(transformGroupRetained);
                                transformGroupData.markedDirty = true;
                                transformGroupData.switchDirty = false;
                            } else if (transformGroupData.switchState.currentSwitchOn) {
                                this.activeTraverseList.add(transformGroupRetained);
                                transformGroupData.switchDirty = false;
                                transformGroupData.markedDirty = true;
                            } else {
                                transformGroupData.switchDirty = true;
                                transformGroupData.markedDirty = false;
                            }
                        } else {
                            int n4 = transformGroupRetained.perPathData.length;
                            boolean bl = false;
                            int n5 = 0;
                            while (n5 < n4) {
                                transformGroupData = transformGroupRetained.perPathData[n5];
                                if (!transformGroupData.switchState.inSwitch) {
                                    if (!bl) {
                                        bl = true;
                                        this.activeTraverseList.add(transformGroupRetained);
                                    }
                                    transformGroupData.markedDirty = true;
                                    transformGroupData.switchDirty = false;
                                } else if (transformGroupData.switchState.currentSwitchOn) {
                                    if (!bl) {
                                        bl = true;
                                        this.activeTraverseList.add(transformGroupRetained);
                                    }
                                    transformGroupData.switchDirty = false;
                                    transformGroupData.markedDirty = true;
                                } else {
                                    transformGroupData.switchDirty = true;
                                    transformGroupData.markedDirty = false;
                                }
                                ++n5;
                            }
                        }
                    }
                }
                ++n;
            }
        }
        if (n3 > 0) {
            int n6 = this.switchDirtyTgList.size();
            n = 0;
            while (n < n6) {
                this.activeTraverseList.add(this.switchDirtyTgList.get(n));
                ++n;
            }
            this.switchDirtyTgList.clear();
            this.lazyUpdate = true;
        }
        this.tgs = (TransformGroupRetained[])this.activeTraverseList.toArray(false);
        n2 = this.activeTraverseList.size();
        if (n2 > 0) {
            this.sortTransformGroups(n2);
            n = 0;
            while (n < n2) {
                this.tgs[n].processChildLocalToVworld(this.dirtyTransformGroups, this.keySet, this.targets, this.blUsers);
                ++n;
            }
            if (!this.inUpdateObjectList) {
                VirtualUniverse.mc.addMirrorObject(this);
                this.inUpdateObjectList = true;
            }
        }
        this.transformList.clear();
        this.traverseList.clear();
        this.activeTraverseList.clear();
    }

    private void sortTransformGroups(int n) {
        if (n < 7) {
            this.insertSort(n);
        } else {
            this.quicksort(0, n - 1);
        }
    }

    private void insertSort(int n) {
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            while (n3 > 0 && this.tgs[n3 - 1].maxTransformLevel > this.tgs[n3].maxTransformLevel) {
                TransformGroupRetained transformGroupRetained = this.tgs[n3];
                this.tgs[n3] = this.tgs[n3 - 1];
                this.tgs[n3 - 1] = transformGroupRetained;
                --n3;
            }
            ++n2;
        }
    }

    private void quicksort(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        double d = this.tgs[(n + n2) / 2].maxTransformLevel;
        while (true) {
            if ((double)this.tgs[n3].maxTransformLevel < d) {
                ++n3;
                continue;
            }
            while (d < (double)this.tgs[n4].maxTransformLevel) {
                --n4;
            }
            if (n3 <= n4) {
                TransformGroupRetained transformGroupRetained = this.tgs[n3];
                this.tgs[n3] = this.tgs[n4];
                this.tgs[n4] = transformGroupRetained;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            this.quicksort(n, n4);
        }
        if (n < n2) {
            this.quicksort(n3, n2);
        }
    }

    public void updateObject() {
        this.processLastLocalToVworld();
        this.processLastSwitchOn();
    }

    void processLastSwitchOn() {
        int n = this.switchChangedList.size();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                SwitchState switchState = (SwitchState)this.switchChangedList.get(n2);
                switchState.updateLastSwitchOn();
                ++n2;
            }
            this.switchChangedList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processLastLocalToVworld() {
        int n = this.dirtyTransformGroups.size();
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            TransformGroupRetained transformGroupRetained;
            TransformGroupRetained transformGroupRetained2 = transformGroupRetained = (TransformGroupRetained)this.dirtyTransformGroups.get(n2);
            synchronized (transformGroupRetained2) {
                if (transformGroupRetained.childLocalToVworld != null) {
                    if (transformGroupRetained.inSharedGroup) {
                        HashKey hashKey = (HashKey)this.keySet.get(n3++);
                        int n4 = 0;
                        while (n4 < transformGroupRetained.localToVworldKeys.length) {
                            if (transformGroupRetained.localToVworldKeys[n4].equals((Object)hashKey)) break;
                            ++n4;
                        }
                        if (n4 < transformGroupRetained.localToVworldKeys.length) {
                            transformGroupRetained.childLocalToVworldIndex[n4][0] = transformGroupRetained.childLocalToVworldIndex[n4][1];
                        }
                    } else {
                        transformGroupRetained.childLocalToVworldIndex[0][0] = transformGroupRetained.childLocalToVworldIndex[0][1];
                    }
                }
            }
            ++n2;
        }
        this.dirtyTransformGroups.clear();
        this.keySet.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processGeometryAtomVwcBounds() {
        Object object;
        Shape3DRetained shape3DRetained;
        GeometryAtom geometryAtom;
        int n = this.objectList.size();
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray = (Object[])this.objectList.get(n2);
            int n3 = 0;
            while (n3 < objectArray.length) {
                Object object2 = objectArray[n3];
                synchronized (object2) {
                    if (objectArray[n3] instanceof GeometryAtom) {
                        geometryAtom = (GeometryAtom)objectArray[n3];
                        shape3DRetained = geometryAtom.source;
                        object = shape3DRetained.bounds;
                        synchronized (object) {
                            shape3DRetained.vwcBounds.transform(shape3DRetained.bounds, shape3DRetained.getCurrentLocalToVworld(0));
                        }
                        if (shape3DRetained.collisionBound != null) {
                            shape3DRetained.collisionVwcBound.transform(shape3DRetained.collisionBound, shape3DRetained.getCurrentLocalToVworld(0));
                        }
                        geometryAtom.centroidIsDirty = true;
                    } else if (objectArray[n3] instanceof GroupRetained) {
                        object = (GroupRetained)objectArray[n3];
                        Bounds bounds = ((GroupRetained)object).sourceNode.collisionBound != null ? ((GroupRetained)object).sourceNode.collisionBound : ((GroupRetained)object).sourceNode.getEffectiveBounds();
                        ((GroupRetained)object).collisionVwcBounds.transform(bounds, ((NodeRetained)object).getCurrentLocalToVworld());
                    }
                }
                ++n3;
            }
            ++n2;
        }
        int n4 = 0;
        while (n4 < this.collisionObjectList.size()) {
            Object[] objectArray = (Object[])this.collisionObjectList.get(n4);
            int n5 = 0;
            while (n5 < objectArray.length) {
                object = objectArray[n5];
                synchronized (object) {
                    if (objectArray[n5] instanceof GeometryAtom) {
                        geometryAtom = (GeometryAtom)objectArray[n5];
                        shape3DRetained = geometryAtom.source;
                        if (shape3DRetained.collisionVwcBound != null) {
                            shape3DRetained.collisionVwcBound.transform(shape3DRetained.collisionBound, shape3DRetained.getCurrentLocalToVworld(0));
                        }
                    }
                }
                ++n5;
            }
            ++n4;
        }
        this.collisionObjectList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processVwcBounds() {
        Bounds bounds;
        Shape3DRetained shape3DRetained;
        GeometryAtom geometryAtom;
        Object object;
        int n;
        Object[] objectArray;
        int n2;
        Object[] objectArray2;
        int n3;
        UnorderList unorderList = this.targets.targetList[0];
        if (unorderList != null) {
            n3 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            n2 = 0;
            while (n2 < n3) {
                objectArray = (Object[])objectArray2[n2];
                n = 0;
                while (n < objectArray.length) {
                    object = objectArray[n];
                    synchronized (object) {
                        geometryAtom = (GeometryAtom)objectArray[n];
                        shape3DRetained = geometryAtom.source;
                        bounds = shape3DRetained.bounds;
                        synchronized (bounds) {
                            shape3DRetained.vwcBounds.transform(shape3DRetained.bounds, shape3DRetained.getCurrentLocalToVworld(0));
                        }
                        if (shape3DRetained.collisionBound != null) {
                            shape3DRetained.collisionVwcBound.transform(shape3DRetained.collisionBound, shape3DRetained.getCurrentLocalToVworld(0));
                        }
                        geometryAtom.centroidIsDirty = true;
                    }
                    ++n;
                }
                ++n2;
            }
        }
        if ((unorderList = this.targets.targetList[6]) != null) {
            n3 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            n2 = 0;
            while (n2 < n3) {
                objectArray = (Object[])objectArray2[n2];
                n = 0;
                while (n < objectArray.length) {
                    object = (GroupRetained)objectArray[n];
                    bounds = ((GroupRetained)object).sourceNode.collisionBound != null ? ((GroupRetained)object).sourceNode.collisionBound : ((GroupRetained)object).sourceNode.getEffectiveBounds();
                    ((GroupRetained)object).collisionVwcBounds.transform(bounds, ((NodeRetained)object).getCurrentLocalToVworld());
                    ++n;
                }
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < this.collisionObjectList.size()) {
            objectArray = (Object[])this.collisionObjectList.get(n2);
            n = 0;
            while (n < objectArray.length) {
                object = objectArray[n];
                synchronized (object) {
                    if (objectArray[n] instanceof GeometryAtom) {
                        geometryAtom = (GeometryAtom)objectArray[n];
                        shape3DRetained = geometryAtom.source;
                        if (shape3DRetained.collisionVwcBound != null) {
                            shape3DRetained.collisionVwcBound.transform(shape3DRetained.collisionBound, shape3DRetained.getCurrentLocalToVworld(0));
                        }
                    }
                }
                ++n;
            }
            ++n2;
        }
        this.collisionObjectList.clear();
    }

    void processRegionBoundChanged(J3dMessage j3dMessage) {
        this.processBoundsChanged((Object[])j3dMessage.args[0], (Bounds)j3dMessage.args[1]);
    }

    void processBoundsChanged(Object[] objectArray, Bounds bounds) {
        int n = 0;
        while (n < objectArray.length) {
            GeometryAtom geometryAtom = (GeometryAtom)objectArray[n];
            Shape3DRetained shape3DRetained = geometryAtom.source;
            shape3DRetained.bounds = bounds;
            if (shape3DRetained.collisionBound == null) {
                shape3DRetained.collisionVwcBound = shape3DRetained.vwcBounds;
            }
            ++n;
        }
        this.objectList.add(objectArray);
    }

    void processCollisionBoundChanged(J3dMessage j3dMessage) {
        Bounds bounds = (Bounds)j3dMessage.args[1];
        if (j3dMessage.args[0] instanceof GroupRetained) {
            GroupRetained groupRetained = (GroupRetained)j3dMessage.args[0];
            if (groupRetained.mirrorGroup != null) {
                this.objectList.add(groupRetained.mirrorGroup);
            }
        } else {
            Object[] objectArray = (Object[])j3dMessage.args[0];
            int n = 0;
            while (n < objectArray.length) {
                GeometryAtom geometryAtom = (GeometryAtom)objectArray[n];
                Shape3DRetained shape3DRetained = geometryAtom.source;
                shape3DRetained.collisionBound = bounds;
                shape3DRetained.collisionVwcBound = shape3DRetained.collisionBound != null ? (Bounds)shape3DRetained.collisionBound.clone() : shape3DRetained.vwcBounds;
                ++n;
            }
            this.collisionObjectList.add(objectArray);
        }
    }

    void processBoundsAutoComputeChanged(J3dMessage j3dMessage) {
        this.processBoundsChanged((Object[])j3dMessage.args[0], (Bounds)j3dMessage.args[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processSwitchChanged(J3dMessage j3dMessage) {
        ArrayList arrayList = (ArrayList)j3dMessage.args[2];
        int n = arrayList.size();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                SwitchState switchState = (SwitchState)arrayList.get(n2);
                switchState.updateCurrentSwitchOn();
                ++n2;
            }
            UpdateTargets updateTargets = (UpdateTargets)j3dMessage.args[0];
            UnorderList unorderList = updateTargets.targetList[6];
            if (unorderList != null) {
                Object[] objectArray = unorderList.toArray(false);
                int n3 = unorderList.size();
                int n4 = 0;
                while (n4 < n3) {
                    Object[] objectArray2 = (Object[])objectArray[n4];
                    int n5 = 0;
                    while (n5 < objectArray2.length) {
                        TransformGroupRetained transformGroupRetained;
                        boolean bl = false;
                        TransformGroupRetained transformGroupRetained2 = transformGroupRetained = (TransformGroupRetained)objectArray2[n5];
                        synchronized (transformGroupRetained2) {
                            if (transformGroupRetained.perPathData != null) {
                                int n6 = transformGroupRetained.perPathData.length;
                                int n7 = 0;
                                while (n7 < n6) {
                                    TransformGroupData transformGroupData = transformGroupRetained.perPathData[n7];
                                    if (transformGroupData.switchState.currentSwitchOn && transformGroupData.switchDirty) {
                                        if (!bl) {
                                            this.switchDirtyTgList.add(transformGroupRetained);
                                            bl = true;
                                        }
                                        transformGroupData.switchDirty = false;
                                        transformGroupData.markedDirty = true;
                                    }
                                    ++n7;
                                }
                            }
                        }
                        ++n5;
                    }
                    ++n4;
                }
            }
            this.switchChangedList.addAll(arrayList);
            if (!this.inUpdateObjectList) {
                VirtualUniverse.mc.addMirrorObject(this);
                this.inUpdateObjectList = true;
            }
        }
    }

    UpdateTargets getTargetList() {
        return this.targets;
    }

    ArrayList getBlUsers() {
        return this.blUsers;
    }

    boolean getLazyUpdate() {
        return this.lazyUpdate;
    }

    void removeNodes(J3dMessage j3dMessage) {
        if (j3dMessage.args[1] != null) {
            TargetsInterface targetsInterface = (TargetsInterface)j3dMessage.args[1];
            targetsInterface.updateCachedTargets(0, (CachedTargets[])j3dMessage.args[2]);
        }
    }

    void cleanup() {
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

