/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import javax.media.j3d.BehaviorScheduler;
import javax.media.j3d.BehaviorStructure;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GeometryStructure;
import javax.media.j3d.ImplementationVersion;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dQueryProps;
import javax.media.j3d.Locale;
import javax.media.j3d.MasterControl;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.RenderingEnvironmentStructure;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.SoundStructure;
import javax.media.j3d.TransformStructure;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatformRetained;

public class VirtualUniverse {
    private static final String J3D_VENDOR = "Sun Microsystems, Inc.";
    private static final String J3D_SPECIFICATION_VERSION = "1.3";
    private static final String J3D_SPECIFICATION_VENDOR = "Sun Microsystems, Inc.";
    static MasterControl mc = null;
    Object sceneGraphLock = new Object();
    Object behaviorLock = new Object();
    Vector listOfLocales = new Vector();
    ArrayList viewPlatforms = new ArrayList();
    Object[] viewPlatformList = null;
    boolean vpChanged = false;
    Vector backgrounds = new Vector();
    Vector clips = new Vector();
    Vector sounds = new Vector();
    Vector soundscapes = new Vector();
    BehaviorScheduler behaviorScheduler = null;
    GeometryStructure geometryStructure = null;
    TransformStructure transformStructure = null;
    BehaviorStructure behaviorStructure = null;
    SoundStructure soundStructure = null;
    RenderingEnvironmentStructure renderingEnvironmentStructure = null;
    int renderingEnvironmentStructureRefCount = 0;
    long nodeIdCount = 0L;
    int viewIdCount = 0;
    Vector nodeIdFreeList = new Vector();
    ArrayList viewIdFreeList = new ArrayList();
    int numNodes = 0;
    SetLiveState setLiveState;
    ObjectUpdate[] updateObjects = new ObjectUpdate[16];
    int updateObjectsLen = 0;
    ArrayList dirtyGeomList = new ArrayList();
    View currentView;
    boolean inBehavior = false;
    boolean enableComponent = false;
    boolean enableFocus = false;
    boolean enableKey = false;
    boolean enableMouse = false;
    boolean enableMouseMotion = false;
    int activeViewCount = 0;
    static ThreadGroup rootThreadGroup;
    static Object mcLock;
    private static J3dQueryProps properties;
    View regViewWaiting = null;
    View unRegViewWaiting = null;
    boolean isSceneGraphLock = false;
    private Object waitLock = new Object();

    public VirtualUniverse() {
        this.setLiveState = new SetLiveState(this);
        this.initMCStructure();
    }

    void initMCStructure() {
        if (this.geometryStructure != null) {
            this.geometryStructure.cleanup();
        }
        this.geometryStructure = new GeometryStructure(this);
        if (this.transformStructure != null) {
            this.transformStructure.cleanup();
        }
        this.transformStructure = new TransformStructure(this);
        if (this.behaviorStructure != null) {
            this.behaviorStructure.cleanup();
        }
        this.behaviorStructure = new BehaviorStructure(this);
        if (this.soundStructure != null) {
            this.soundStructure.cleanup();
        }
        this.soundStructure = new SoundStructure(this);
        if (this.renderingEnvironmentStructure != null) {
            this.renderingEnvironmentStructure.cleanup();
        }
        this.renderingEnvironmentStructure = new RenderingEnvironmentStructure(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createMC() {
        Object object = mcLock;
        synchronized (object) {
            if (mc == null) {
                mc = new MasterControl();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void destroyMC() {
        Object object = mcLock;
        synchronized (object) {
            mc = null;
        }
    }

    static void loadLibraries() {
    }

    void addLocale(Locale locale) {
        this.listOfLocales.addElement(locale);
    }

    public void removeLocale(Locale locale) {
        if (locale.getVirtualUniverse() != this) {
            throw new IllegalArgumentException(J3dI18N.getString("VirtualUniverse0"));
        }
        this.listOfLocales.removeElement(locale);
        locale.removeFromUniverse();
        if (this.isEmpty()) {
            mc.postRequest(MasterControl.EMPTY_UNIVERSE, this);
        }
        this.setLiveState.reset(null);
    }

    public void removeAllLocales() {
        int n = this.listOfLocales.size() - 1;
        while (n > 0) {
            ((Locale)this.listOfLocales.get(n)).removeFromUniverse();
            --n;
        }
        if (n >= 0) {
            Locale locale = (Locale)this.listOfLocales.get(0);
            this.listOfLocales.clear();
            locale.removeFromUniverse();
        }
        mc.postRequest(MasterControl.EMPTY_UNIVERSE, this);
        this.setLiveState.reset(null);
    }

    public Enumeration getAllLocales() {
        return this.listOfLocales.elements();
    }

    public int numLocales() {
        return this.listOfLocales.size();
    }

    public static void setJ3DThreadPriority(int n) {
        if (n > 10) {
            n = 10;
        } else if (n < 1) {
            n = 1;
        }
        mc.setThreadPriority(n);
    }

    public static int getJ3DThreadPriority() {
        return mc.getThreadPriority();
    }

    public static final Map getProperties() {
        if (properties == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList.add("j3d.version");
            arrayList2.add(ImplementationVersion.getJ3dVersion());
            arrayList.add("j3d.vendor");
            arrayList2.add("Sun Microsystems, Inc.");
            arrayList.add("j3d.specification.version");
            arrayList2.add(J3D_SPECIFICATION_VERSION);
            arrayList.add("j3d.specification.vendor");
            arrayList2.add("Sun Microsystems, Inc.");
            arrayList.add("j3d.renderer");
            arrayList2.add(mc.isD3D() ? "DirectX" : "OpenGL");
            properties = new J3dQueryProps(arrayList.toArray(new String[0]), arrayList2.toArray());
        }
        return properties;
    }

    String getNodeId() {
        String string2;
        if (this.nodeIdFreeList.size() == 0) {
            string2 = Long.toString(this.nodeIdCount);
            ++this.nodeIdCount;
        } else {
            string2 = (String)this.nodeIdFreeList.lastElement();
            this.nodeIdFreeList.removeElement(string2);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer getViewId() {
        Integer n;
        ArrayList arrayList = this.viewIdFreeList;
        synchronized (arrayList) {
            int n2 = this.viewIdFreeList.size();
            n = n2 == 0 ? new Integer(this.viewIdCount++) : (Integer)this.viewIdFreeList.remove(n2 - 1);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addViewIdToFreeList(Integer n) {
        ArrayList arrayList = this.viewIdFreeList;
        synchronized (arrayList) {
            this.viewIdFreeList.add(n);
        }
    }

    void addViewPlatform(ViewPlatformRetained viewPlatformRetained) {
        this.vpChanged = true;
        this.viewPlatforms.add(viewPlatformRetained);
    }

    void removeViewPlatform(ViewPlatformRetained viewPlatformRetained) {
        this.vpChanged = true;
        this.viewPlatforms.remove(this.viewPlatforms.indexOf(viewPlatformRetained));
    }

    synchronized Object[] getViewPlatformList() {
        if (this.vpChanged) {
            this.viewPlatformList = this.viewPlatforms.toArray();
            this.vpChanged = false;
        }
        return this.viewPlatformList;
    }

    void checkForEnableEvents() {
        this.enableComponentEvents();
        if (this.enableFocus) {
            this.enableFocusEvents();
        }
        if (this.enableKey) {
            this.enableKeyEvents();
        }
        if (this.enableMouse) {
            this.enableMouseEvents();
        }
        if (this.enableMouseMotion) {
            this.enableMouseMotionEvents();
        }
    }

    void enableComponentEvents() {
        Object[] objectArray = this.getViewPlatformList();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[n];
                View[] viewArray = viewPlatformRetained.getViewList();
                int n2 = viewArray.length - 1;
                while (n2 >= 0) {
                    Enumeration enumeration = viewArray[n2].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.enableComponentEvents();
                    }
                    --n2;
                }
                ++n;
            }
        }
    }

    void disableFocusEvents() {
        Object[] objectArray = this.getViewPlatformList();
        this.enableFocus = false;
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[n];
                View[] viewArray = viewPlatformRetained.getViewList();
                int n2 = viewArray.length - 1;
                while (n2 >= 0) {
                    Enumeration enumeration = viewArray[n2].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.disableFocusEvents();
                    }
                    --n2;
                }
                ++n;
            }
        }
    }

    void enableFocusEvents() {
        Object[] objectArray = this.getViewPlatformList();
        this.enableFocus = true;
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[n];
                View[] viewArray = viewPlatformRetained.getViewList();
                int n2 = viewArray.length - 1;
                while (n2 >= 0) {
                    Enumeration enumeration = viewArray[n2].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.enableFocusEvents();
                    }
                    --n2;
                }
                ++n;
            }
        }
    }

    void disableKeyEvents() {
        Object[] objectArray = this.getViewPlatformList();
        this.enableKey = false;
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[n];
                View[] viewArray = viewPlatformRetained.getViewList();
                int n2 = viewArray.length - 1;
                while (n2 >= 0) {
                    Enumeration enumeration = viewArray[n2].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.disableKeyEvents();
                    }
                    --n2;
                }
                ++n;
            }
        }
    }

    void enableKeyEvents() {
        Object[] objectArray = this.getViewPlatformList();
        this.enableKey = true;
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[n];
                View[] viewArray = viewPlatformRetained.getViewList();
                int n2 = viewArray.length - 1;
                while (n2 >= 0) {
                    Enumeration enumeration = viewArray[n2].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.enableKeyEvents();
                    }
                    --n2;
                }
                ++n;
            }
        }
    }

    void disableMouseEvents() {
        Object[] objectArray = this.getViewPlatformList();
        this.enableMouse = false;
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[n];
                View[] viewArray = viewPlatformRetained.getViewList();
                int n2 = viewArray.length - 1;
                while (n2 >= 0) {
                    Enumeration enumeration = viewArray[n2].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.disableMouseEvents();
                    }
                    --n2;
                }
                ++n;
            }
        }
    }

    void enableMouseEvents() {
        Object[] objectArray = this.getViewPlatformList();
        this.enableMouse = true;
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[n];
                View[] viewArray = viewPlatformRetained.getViewList();
                int n2 = viewArray.length - 1;
                while (n2 >= 0) {
                    Enumeration enumeration = viewArray[n2].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.enableMouseEvents();
                    }
                    --n2;
                }
                ++n;
            }
        }
    }

    void disableMouseMotionEvents() {
        Object[] objectArray = this.getViewPlatformList();
        this.enableMouseMotion = false;
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[n];
                View[] viewArray = viewPlatformRetained.getViewList();
                int n2 = viewArray.length - 1;
                while (n2 >= 0) {
                    Enumeration enumeration = viewArray[n2].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.disableMouseMotionEvents();
                    }
                    --n2;
                }
                ++n;
            }
        }
    }

    void enableMouseMotionEvents() {
        Object[] objectArray = this.getViewPlatformList();
        this.enableMouseMotion = true;
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[n];
                View[] viewArray = viewPlatformRetained.getViewList();
                int n2 = viewArray.length - 1;
                while (n2 >= 0) {
                    Enumeration enumeration = viewArray[n2].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.enableMouseMotionEvents();
                    }
                    --n2;
                }
                ++n;
            }
        }
    }

    final void setCurrentView(View view) {
        this.currentView = view;
    }

    final View getCurrentView() {
        return this.currentView;
    }

    static ThreadGroup getRootThreadGroup() {
        return rootThreadGroup;
    }

    boolean isEmpty() {
        Enumeration enumeration = this.listOfLocales.elements();
        while (enumeration.hasMoreElements()) {
            Locale locale = (Locale)enumeration.nextElement();
            if (locale.branchGroups.isEmpty()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetWaitMCFlag() {
        Object object = this.waitLock;
        synchronized (object) {
            this.regViewWaiting = null;
            this.unRegViewWaiting = null;
            this.isSceneGraphLock = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForMC() {
        Object object = this.waitLock;
        synchronized (object) {
            if (this.unRegViewWaiting != null && (this.regViewWaiting == null || this.regViewWaiting != this.unRegViewWaiting)) {
                while (!this.unRegViewWaiting.doneUnregister) {
                    MasterControl.threadYield();
                }
                this.unRegViewWaiting.doneUnregister = false;
                this.unRegViewWaiting = null;
            }
            if (this.regViewWaiting != null) {
                while (!mc.isRegistered(this.regViewWaiting)) {
                    MasterControl.threadYield();
                }
                this.regViewWaiting = null;
            }
            this.isSceneGraphLock = false;
        }
    }

    static {
        mcLock = new Object();
        properties = null;
        MasterControl.loadLibraries();
        VirtualUniverse.createMC();
    }
}

