/*
 * Decompiled with CFR 0.152.
 */
package lzma.sdk.rangecoder;

import java.io.IOException;
import lzma.sdk.rangecoder.Decoder;

public class BitTreeDecoder {
    private final short[] Models;
    private final int NumBitLevels;

    public BitTreeDecoder(int numBitLevels) {
        this.NumBitLevels = numBitLevels;
        this.Models = new short[1 << numBitLevels];
    }

    public void init() {
        Decoder.initBitModels(this.Models);
    }

    public int decode(Decoder rangeDecoder) throws IOException {
        int m4 = 1;
        for (int bitIndex = this.NumBitLevels; bitIndex != 0; --bitIndex) {
            m4 = (m4 << 1) + rangeDecoder.decodeBit(this.Models, m4);
        }
        return m4 - (1 << this.NumBitLevels);
    }

    public int reverseDecode(Decoder rangeDecoder) throws IOException {
        int m4 = 1;
        int symbol = 0;
        for (int bitIndex = 0; bitIndex < this.NumBitLevels; ++bitIndex) {
            int bit = rangeDecoder.decodeBit(this.Models, m4);
            m4 <<= 1;
            m4 += bit;
            symbol |= bit << bitIndex;
        }
        return symbol;
    }

    public static int reverseDecode(short[] Models, int startIndex, Decoder rangeDecoder, int NumBitLevels) throws IOException {
        int m4 = 1;
        int symbol = 0;
        for (int bitIndex = 0; bitIndex < NumBitLevels; ++bitIndex) {
            int bit = rangeDecoder.decodeBit(Models, startIndex + m4);
            m4 <<= 1;
            m4 += bit;
            symbol |= bit << bitIndex;
        }
        return symbol;
    }
}

