/*
 * Decompiled with CFR 0.152.
 */
package lzma.sdk.rangecoder;

import java.io.IOException;
import lzma.sdk.rangecoder.Decoder;
import lzma.sdk.rangecoder.Encoder;

public class BitTreeEncoder {
    private final short[] Models;
    private final int NumBitLevels;

    public BitTreeEncoder(int numBitLevels) {
        this.NumBitLevels = numBitLevels;
        this.Models = new short[1 << numBitLevels];
    }

    public void init() {
        Decoder.initBitModels(this.Models);
    }

    public void encode(Encoder rangeEncoder, int symbol) throws IOException {
        int m4 = 1;
        int bitIndex = this.NumBitLevels;
        while (bitIndex != 0) {
            int bit = symbol >>> --bitIndex & 1;
            rangeEncoder.encode(this.Models, m4, bit);
            m4 = m4 << 1 | bit;
        }
    }

    public void reverseEncode(Encoder rangeEncoder, int symbol) throws IOException {
        int m4 = 1;
        for (int i = 0; i < this.NumBitLevels; ++i) {
            int bit = symbol & 1;
            rangeEncoder.encode(this.Models, m4, bit);
            m4 = m4 << 1 | bit;
            symbol >>= 1;
        }
    }

    public int getPrice(int symbol) {
        int price = 0;
        int m4 = 1;
        int bitIndex = this.NumBitLevels;
        while (bitIndex != 0) {
            int bit = symbol >>> --bitIndex & 1;
            price += Encoder.getPrice(this.Models[m4], bit);
            m4 = (m4 << 1) + bit;
        }
        return price;
    }

    public int reverseGetPrice(int symbol) {
        int price = 0;
        int m4 = 1;
        for (int i = this.NumBitLevels; i != 0; --i) {
            int bit = symbol & 1;
            symbol >>>= 1;
            price += Encoder.getPrice(this.Models[m4], bit);
            m4 = m4 << 1 | bit;
        }
        return price;
    }

    public static int reverseGetPrice(short[] Models, int startIndex, int NumBitLevels, int symbol) {
        int price = 0;
        int m4 = 1;
        for (int i = NumBitLevels; i != 0; --i) {
            int bit = symbol & 1;
            symbol >>>= 1;
            price += Encoder.getPrice(Models[startIndex + m4], bit);
            m4 = m4 << 1 | bit;
        }
        return price;
    }

    public static void reverseEncode(short[] Models, int startIndex, Encoder rangeEncoder, int NumBitLevels, int symbol) throws IOException {
        int m4 = 1;
        for (int i = 0; i < NumBitLevels; ++i) {
            int bit = symbol & 1;
            rangeEncoder.encode(Models, startIndex + m4, bit);
            m4 = m4 << 1 | bit;
            symbol >>= 1;
        }
    }
}

