/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client;

import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.runelite.client.RuneLiteProperties;
import net.runelite.client.RuntimeConfig;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeConfigLoader
implements Supplier<RuntimeConfig> {
    private static final Logger log = LoggerFactory.getLogger(RuntimeConfigLoader.class);
    private final OkHttpClient okHttpClient;
    private final CompletableFuture<RuntimeConfig> configFuture;

    public RuntimeConfigLoader(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
        this.configFuture = this.fetch();
    }

    @Nullable
    public RuntimeConfig tryGet() {
        try {
            return this.configFuture.get(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return null;
        }
    }

    @Override
    public RuntimeConfig get() {
        try {
            return this.configFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    private CompletableFuture<RuntimeConfig> fetch() {
        final CompletableFuture<RuntimeConfig> future = new CompletableFuture<RuntimeConfig>();
        String prop = System.getProperty("runelite.rtconf");
        if (!Strings.isNullOrEmpty(prop)) {
            try {
                log.info("Using local runtime config");
                String strConf = new String(Files.readAllBytes(Paths.get(prop, new String[0])), StandardCharsets.UTF_8);
                RuntimeConfig conf = RuneLiteAPI.GSON.fromJson(strConf, RuntimeConfig.class);
                future.complete(conf);
                return future;
            }
            catch (IOException e) {
                log.error("Failed to load override runtime config", e);
                future.completeExceptionally(e);
                return future;
            }
        }
        Request request = new Request.Builder().url(RuneLiteProperties.getRuneLiteConfig()).build();
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                log.error("Failed to fetch runtime config from server", e);
                future.completeExceptionally(e);
            }

            @Override
            public void onResponse(Call call, Response response) {
                try {
                    String responseBody = response.body().string();
                    response.close();
                    if (responseBody.trim().startsWith("{")) {
                        RuntimeConfig config = RuneLiteAPI.GSON.fromJson(responseBody, RuntimeConfig.class);
                        future.complete(config);
                    } else {
                        future.completeExceptionally(new IOException("Invalid runtime config format"));
                    }
                }
                catch (Throwable ex) {
                    future.completeExceptionally(ex);
                }
            }
        });
        return future;
    }
}

