/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.hiscore;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.hiscore.HiscoreClient;
import net.runelite.client.hiscore.HiscoreEndpoint;
import net.runelite.client.hiscore.HiscoreLoader;
import net.runelite.client.hiscore.HiscoreResult;
import okhttp3.OkHttpClient;

@Singleton
public class HiscoreManager {
    static final HiscoreResult EMPTY = new HiscoreResult();
    static final HiscoreResult NONE = new HiscoreResult();
    private final LoadingCache<HiscoreKey, HiscoreResult> hiscoreCache;
    private final HiscoreClient hiscoreClient;

    @Inject
    private HiscoreManager(ScheduledExecutorService executor, OkHttpClient okHttpClient) {
        this.hiscoreClient = new HiscoreClient(okHttpClient);
        this.hiscoreCache = CacheBuilder.newBuilder().maximumSize(128L).expireAfterWrite(1L, TimeUnit.HOURS).build(new HiscoreLoader(executor, this.hiscoreClient));
    }

    public HiscoreResult lookup(String username, HiscoreEndpoint endpoint) throws IOException {
        HiscoreKey hiscoreKey = new HiscoreKey(username, endpoint);
        HiscoreResult hiscoreResult = (HiscoreResult)this.hiscoreCache.getIfPresent(hiscoreKey);
        if (hiscoreResult != null && hiscoreResult != EMPTY) {
            return hiscoreResult == NONE ? null : hiscoreResult;
        }
        hiscoreResult = this.hiscoreClient.lookup(username, endpoint);
        if (hiscoreResult == null) {
            this.hiscoreCache.put(hiscoreKey, NONE);
            return null;
        }
        this.hiscoreCache.put(hiscoreKey, hiscoreResult);
        return hiscoreResult;
    }

    public HiscoreResult lookupAsync(String username, HiscoreEndpoint endpoint) {
        HiscoreKey hiscoreKey = new HiscoreKey(username, endpoint);
        HiscoreResult hiscoreResult = (HiscoreResult)this.hiscoreCache.getIfPresent(hiscoreKey);
        if (hiscoreResult != null && hiscoreResult != EMPTY) {
            return hiscoreResult == NONE ? null : hiscoreResult;
        }
        this.hiscoreCache.refresh(hiscoreKey);
        return null;
    }

    static class HiscoreKey {
        String username;
        HiscoreEndpoint type;

        public HiscoreKey(String username, HiscoreEndpoint type2) {
            this.username = username;
            this.type = type2;
        }

        public String getUsername() {
            return this.username;
        }

        public HiscoreEndpoint getType() {
            return this.type;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setType(HiscoreEndpoint type2) {
            this.type = type2;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HiscoreKey)) {
                return false;
            }
            HiscoreKey other = (HiscoreKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            HiscoreEndpoint this$type = this.getType();
            HiscoreEndpoint other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HiscoreKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            String $username = this.getUsername();
            result2 = result2 * 59 + ($username == null ? 43 : $username.hashCode());
            HiscoreEndpoint $type = this.getType();
            result2 = result2 * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result2;
        }

        public String toString() {
            return "HiscoreManager.HiscoreKey(username=" + this.getUsername() + ", type=" + String.valueOf((Object)this.getType()) + ")";
        }
    }
}

