/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.gpu;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.api.Texture;
import net.runelite.api.TextureProvider;
import net.runelite.client.plugins.gpu.TextureUtil;

public class TextureViewerPanel
extends JPanel {
    private static final int TEX_SIZE = 128;

    public TextureViewerPanel(TextureProvider textureProvider) {
        this.setLayout(new GridLayout(0, 6, 8, 8));
        this.setBackground(Color.DARK_GRAY);
        Texture[] textures = textureProvider.getTextures();
        for (int id = 0; id < textures.length; ++id) {
            int[] pixels;
            Texture tex = textures[id];
            if (tex == null || (pixels = textureProvider.load(id)) == null || pixels.length != 16384) continue;
            BufferedImage img = TextureUtil.textureToImage(pixels, 128, 128);
            this.add(this.makeTextureCell(id, img));
        }
    }

    private JPanel makeTextureCell(int id, Image img) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Color.BLACK);
        JLabel imgLabel = new JLabel(new ImageIcon(img));
        imgLabel.setHorizontalAlignment(0);
        JLabel text = new JLabel("ID: " + id);
        text.setForeground(Color.WHITE);
        text.setHorizontalAlignment(0);
        panel.add((Component)imgLabel, "Center");
        panel.add((Component)text, "South");
        return panel;
    }
}

