/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.grounditems;

import java.util.HashSet;
import java.util.Set;

public class GroundItemFilters {
    private static final Set<String> hiddenNames = new HashSet<String>();
    private static final Set<Integer> hiddenIds = new HashSet<Integer>();
    private static final Set<String> hiNames = new HashSet<String>();
    private static final Set<Integer> hiIds = new HashSet<Integer>();
    private static volatile boolean showOnlyHi = false;

    public static void setHiddenNames(Set<String> names) {
        hiddenNames.clear();
        if (names != null) {
            for (String n : names) {
                if (n == null || n.trim().isEmpty()) continue;
                hiddenNames.add(n.toLowerCase().trim());
            }
        }
    }

    public static void setHiddenIds(Set<Integer> ids) {
        hiddenIds.clear();
        if (ids != null) {
            hiddenIds.addAll(ids);
        }
    }

    public static boolean shouldHide(int id, String name) {
        if (hiddenIds.contains(id)) {
            return true;
        }
        return name != null && hiddenNames.contains(name.toLowerCase().trim());
    }

    public static void setHighlightNames(Set<String> names) {
        hiNames.clear();
        if (names != null) {
            for (String n : names) {
                if (n == null || n.trim().isEmpty()) continue;
                hiNames.add(n.toLowerCase().trim());
            }
        }
    }

    public static void setHighlightIds(Set<Integer> ids) {
        hiIds.clear();
        if (ids != null) {
            hiIds.addAll(ids);
        }
    }

    public static boolean isHighlighted(int id, String name) {
        if (hiIds.contains(id)) {
            return true;
        }
        return name != null && hiNames.contains(name.toLowerCase().trim());
    }

    public static void setShowOnlyHighlighted(boolean v) {
        showOnlyHi = v;
    }

    public static boolean isShowOnlyHighlighted() {
        return showOnlyHi;
    }

    public static String debug() {
        return "hideNames=" + String.valueOf(hiddenNames) + ", hideIds=" + String.valueOf(hiddenIds) + ", hiNames=" + String.valueOf(hiNames) + ", hiIds=" + String.valueOf(hiIds) + ", showOnly=" + showOnlyHi;
    }
}

