/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.grounditems;

import com.google.common.base.Splitter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemLayer;
import net.runelite.api.Node;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.TileItem;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.grounditems.GroundItemsConfig;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

public class GroundItemsOverlay
extends Overlay {
    private final Client client;
    private final GroundItemsConfig config;
    private final ItemManager itemManager;
    private static final Pattern SPLIT = Pattern.compile("[,\\n;]");
    private final Set<String> hiNames = new HashSet<String>();
    private final Set<String> hoNames = new HashSet<String>();
    private final Set<Integer> hiIds = new HashSet<Integer>();
    private final Set<Integer> hoIds = new HashSet<Integer>();
    private String lastHi = "";
    private String lastHo = "";

    @Inject
    public GroundItemsOverlay(Client client, GroundItemsConfig config, ItemManager itemManager) {
        this.client = client;
        this.config = config;
        this.itemManager = itemManager;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.rebuildLists();
    }

    private static String norm(String s2) {
        return s2 == null ? "" : s2.trim().toLowerCase();
    }

    void rebuildLists() {
        String t2;
        String ho;
        String hi = this.config.highlightList() == null ? "" : this.config.highlightList();
        String string2 = ho = this.config.hiddenList() == null ? "" : this.config.hiddenList();
        if (hi.equals(this.lastHi) && ho.equals(this.lastHo)) {
            return;
        }
        this.lastHi = hi;
        this.lastHo = ho;
        this.hiNames.clear();
        this.hoNames.clear();
        this.hiIds.clear();
        this.hoIds.clear();
        for (String s2 : Splitter.on(SPLIT).trimResults().omitEmptyStrings().split(hi)) {
            t2 = GroundItemsOverlay.norm(s2);
            try {
                this.hiIds.add(Integer.parseInt(t2));
            }
            catch (NumberFormatException ignored) {
                this.hiNames.add(t2);
            }
        }
        for (String s2 : Splitter.on(SPLIT).trimResults().omitEmptyStrings().split(ho)) {
            t2 = GroundItemsOverlay.norm(s2);
            try {
                this.hoIds.add(Integer.parseInt(t2));
            }
            catch (NumberFormatException ignored) {
                this.hoNames.add(t2);
            }
        }
    }

    private String itemName(int id) {
        try {
            ItemComposition ic;
            if (this.itemManager != null && (ic = this.itemManager.getItemComposition(id)) != null) {
                return ic.getName();
            }
            ic = this.client.getItemDefinition(id);
            return ic != null ? ic.getName() : "Item " + id;
        }
        catch (Exception e) {
            return "Item " + id;
        }
    }

    private boolean isHidden(int id, String nameLower) {
        return this.hoIds.contains(id) || this.hoNames.contains(nameLower);
    }

    private boolean isHighlighted(int id, String nameLower) {
        return this.hiIds.contains(id) || this.hiNames.contains(nameLower);
    }

    @Override
    public Dimension render(Graphics2D g2) {
        if (!this.config.enabled()) {
            return null;
        }
        this.rebuildLists();
        Scene scene = this.client.getScene();
        if (scene == null) {
            return null;
        }
        int plane = this.client.getPlane();
        Tile[][][] tiles = scene.getTiles();
        if (tiles == null) {
            return null;
        }
        for (int x = 0; x < 104; ++x) {
            for (int y = 0; y < 104; ++y) {
                ItemLayer layer;
                Tile tile = tiles[plane][x][y];
                if (tile == null || (layer = tile.getItemLayer()) == null) continue;
                for (Node node = layer.getBottom(); node != null; node = node.getNext()) {
                    Polygon poly;
                    LocalPoint lp;
                    String name;
                    String lower;
                    TileItem ti;
                    int id;
                    if (!(node instanceof TileItem) || (id = (ti = (TileItem)node).getId()) == 526 || this.isHidden(id, lower = GroundItemsOverlay.norm(name = this.itemName(id)))) continue;
                    boolean hl = this.isHighlighted(id, lower);
                    if (this.config.showOnlyHighlighted() && !hl || (lp = tile.getLocalLocation()) == null) continue;
                    Color col = hl ? Color.MAGENTA : Color.WHITE;
                    Point textLoc = Perspective.getCanvasTextLocation(this.client, g2, lp, name, 0);
                    if (textLoc != null) {
                        String text = name + " x" + ti.getQuantity();
                        g2.setColor(Color.BLACK);
                        g2.drawString(text, textLoc.getX() + 1, textLoc.getY() + 1);
                        g2.setColor(col);
                        g2.drawString(text, textLoc.getX(), textLoc.getY());
                    }
                    if (!this.config.tileHighlight() || (poly = Perspective.getCanvasTilePoly(this.client, lp)) == null) continue;
                    g2.setColor(new Color(col.getRed(), col.getGreen(), col.getBlue(), 40));
                    g2.fillPolygon(poly);
                    g2.setColor(col);
                    g2.drawPolygon(poly);
                }
            }
        }
        return null;
    }
}

