/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.grounditems;

import com.google.inject.Provides;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.grounditems.GroundItemFilters;
import net.runelite.client.plugins.grounditems.GroundItemsConfig;
import net.runelite.client.plugins.grounditems.GroundItemsOverlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Ground Items (Eldoria)", description="RuneLite-style ground items: toggle, highlight/hidden lists, tile highlight", tags={"items", "ground", "overlay", "eldoria"})
public class GroundItemsPlugin
extends Plugin {
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private GroundItemsOverlay overlay;
    @Inject
    private GroundItemsConfig config;
    private static final Pattern SPLIT = Pattern.compile("[,\\n;]");
    private static volatile GroundItemsPlugin INSTANCE;

    public static Color getHighlightColor() {
        return INSTANCE != null && GroundItemsPlugin.INSTANCE.config != null ? GroundItemsPlugin.INSTANCE.config.highlightColor() : Color.MAGENTA;
    }

    @Override
    protected void startUp() {
        INSTANCE = this;
        this.overlayManager.add(this.overlay);
        this.overlay.rebuildLists();
        this.pushFiltersFromConfig();
    }

    @Override
    protected void shutDown() {
        this.overlayManager.remove(this.overlay);
        INSTANCE = null;
        GroundItemFilters.setHiddenNames(new HashSet<String>());
        GroundItemFilters.setHiddenIds(new HashSet<Integer>());
        GroundItemFilters.setHighlightNames(new HashSet<String>());
        GroundItemFilters.setHighlightIds(new HashSet<Integer>());
        GroundItemFilters.setShowOnlyHighlighted(false);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        if ("eldoria-grounditems".equals(e.getGroup())) {
            this.overlay.rebuildLists();
            this.pushFiltersFromConfig();
        }
    }

    private void pushFiltersFromConfig() {
        HashSet<String> hideNames = new HashSet<String>();
        HashSet<Integer> hideIds = new HashSet<Integer>();
        this.parseList(this.config.hiddenList(), hideNames, hideIds);
        GroundItemFilters.setHiddenNames(hideNames);
        GroundItemFilters.setHiddenIds(hideIds);
        HashSet<String> hiNames = new HashSet<String>();
        HashSet<Integer> hiIds = new HashSet<Integer>();
        this.parseList(this.config.highlightList(), hiNames, hiIds);
        GroundItemFilters.setHighlightNames(hiNames);
        GroundItemFilters.setHighlightIds(hiIds);
        GroundItemFilters.setShowOnlyHighlighted(this.config.showOnlyHighlighted());
    }

    private void parseList(String raw, Set<String> names, Set<Integer> ids) {
        if (raw == null) {
            return;
        }
        for (String part : SPLIT.split(raw)) {
            String t2 = part.trim();
            if (t2.isEmpty()) continue;
            try {
                ids.add(Integer.parseInt(t2));
            }
            catch (NumberFormatException ex) {
                names.add(t2.toLowerCase());
            }
        }
    }

    @Provides
    GroundItemsConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(GroundItemsConfig.class);
    }
}

