/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd;

import com.google.gson.Gson;
import com.google.inject.Provides;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.swing.SwingUtilities;
import net.runelite.api.BufferProvider;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Model;
import net.runelite.api.Perspective;
import net.runelite.api.Renderable;
import net.runelite.api.Scene;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Texture;
import net.runelite.api.TextureProvider;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.hooks.DrawCallbacks;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginInstantiationException;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.plugins.entityhider.EntityHiderPlugin;
import net.runelite.client.plugins.hd.HdPluginConfig;
import net.runelite.client.plugins.hd.config.AntiAliasingMode;
import net.runelite.client.plugins.hd.config.FogDepthMode;
import net.runelite.client.plugins.hd.config.ParallaxMappingMode;
import net.runelite.client.plugins.hd.config.ShadowMode;
import net.runelite.client.plugins.hd.config.UIScalingMode;
import net.runelite.client.plugins.hd.data.WaterType;
import net.runelite.client.plugins.hd.data.materials.Material;
import net.runelite.client.plugins.hd.model.ModelHasher;
import net.runelite.client.plugins.hd.model.ModelPusher;
import net.runelite.client.plugins.hd.model.TempModelInfo;
import net.runelite.client.plugins.hd.opengl.compute.ComputeMode;
import net.runelite.client.plugins.hd.opengl.compute.OpenCLManager;
import net.runelite.client.plugins.hd.opengl.shader.Shader;
import net.runelite.client.plugins.hd.opengl.shader.ShaderException;
import net.runelite.client.plugins.hd.opengl.shader.Template;
import net.runelite.client.plugins.hd.scene.EnvironmentManager;
import net.runelite.client.plugins.hd.scene.LightManager;
import net.runelite.client.plugins.hd.scene.ModelOverrideManager;
import net.runelite.client.plugins.hd.scene.ProceduralGenerator;
import net.runelite.client.plugins.hd.scene.SceneContext;
import net.runelite.client.plugins.hd.scene.SceneUploader;
import net.runelite.client.plugins.hd.scene.TextureManager;
import net.runelite.client.plugins.hd.scene.lights.SceneLight;
import net.runelite.client.plugins.hd.scene.model_overrides.ModelOverride;
import net.runelite.client.plugins.hd.scene.model_overrides.ObjectType;
import net.runelite.client.plugins.hd.utils.DeveloperTools;
import net.runelite.client.plugins.hd.utils.FileWatcher;
import net.runelite.client.plugins.hd.utils.HDUtils;
import net.runelite.client.plugins.hd.utils.Mat4;
import net.runelite.client.plugins.hd.utils.PopupUtils;
import net.runelite.client.plugins.hd.utils.Props;
import net.runelite.client.plugins.hd.utils.ResourcePath;
import net.runelite.client.plugins.hd.utils.buffer.GLBuffer;
import net.runelite.client.plugins.hd.utils.buffer.GpuIntBuffer;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.OSType;
import net.runelite.rlawt.AWTContext;
import org.jocl.CL;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLUtil;
import org.lwjgl.system.Callback;
import org.lwjgl.system.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="117 HD", description="GPU renderer with a suite of graphical enhancements", tags={"hd", "high", "detail", "graphics", "shaders", "textures", "gpu", "shadows", "lights"}, conflicts={"GPU"}, enabledByDefault=false)
@PluginDependency(value=EntityHiderPlugin.class)
public class HdPlugin
extends Plugin
implements DrawCallbacks {
    private static final Logger log = LoggerFactory.getLogger(HdPlugin.class);
    public static final String DISCORD_URL = "https://discord.gg/EVpDNJTKG4";
    public static final String RUNELITE_URL = "https://runelite.net";
    public static final int TEXTURE_UNIT_UI = 33984;
    public static final int TEXTURE_UNIT_GAME = 33985;
    public static final int TEXTURE_UNIT_SHADOW_MAP = 33986;
    public static final int MAX_TRIANGLE = 6144;
    public static final int SMALL_TRIANGLE_COUNT = 512;
    public static final int MAX_DISTANCE = 90;
    public static final int MAX_FOG_DEPTH = 100;
    public static final int SCALAR_BYTES = 4;
    public static final int VERTEX_SIZE = 4;
    public static final int UV_SIZE = 4;
    public static final int NORMAL_SIZE = 4;
    private static final int[] eightIntWrite = new int[8];
    @Inject
    private Client client;
    @Inject
    private ClientUI clientUI;
    @Inject
    private ClientThread clientThread;
    @Inject
    private EventBus eventBus;
    @Inject
    private DrawManager drawManager;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private OpenCLManager openCLManager;
    @Inject
    private TextureManager textureManager;
    @Inject
    private LightManager lightManager;
    @Inject
    private EnvironmentManager environmentManager;
    @Inject
    private ModelOverrideManager modelOverrideManager;
    @Inject
    private ProceduralGenerator proceduralGenerator;
    @Inject
    private SceneUploader sceneUploader;
    @Inject
    private ModelPusher modelPusher;
    @Inject
    private ModelHasher modelHasher;
    @Inject
    @Named(value="developerMode")
    private boolean developerMode;
    @Inject
    private DeveloperTools developerTools;
    @Inject
    private HdPluginConfig config;
    @Inject
    private Gson rlGson;
    private Gson gson;
    private Canvas canvas;
    private AWTContext awtContext;
    private GLCapabilities glCaps;
    private Callback debugCallback;
    private ComputeMode computeMode = ComputeMode.OPENGL;
    private static final String LINUX_VERSION_HEADER = "#version 420\n#extension GL_ARB_compute_shader : require\n#extension GL_ARB_shader_storage_buffer_object : require\n#extension GL_ARB_explicit_attrib_location : require\n";
    private static final String WINDOWS_VERSION_HEADER = "#version 430\n";
    private static final Shader PROGRAM = new Shader().add(35633, "vert.glsl").add(36313, "geom.glsl").add(35632, "frag.glsl");
    private static final Shader SHADOW_PROGRAM_FAST = new Shader().add(35633, "shadow_vert.glsl").add(35632, "shadow_frag.glsl");
    private static final Shader SHADOW_PROGRAM_DETAILED = new Shader().add(35633, "shadow_vert.glsl").add(36313, "shadow_geom.glsl").add(35632, "shadow_frag.glsl");
    private static final Shader COMPUTE_PROGRAM = new Shader().add(37305, "comp.glsl");
    private static final Shader SMALL_COMPUTE_PROGRAM = new Shader().add(37305, "comp_small.glsl");
    private static final Shader UNORDERED_COMPUTE_PROGRAM = new Shader().add(37305, "comp_unordered.glsl");
    private static final Shader UI_PROGRAM = new Shader().add(35633, "vertui.glsl").add(35632, "fragui.glsl");
    private static final ResourcePath SHADER_PATH = Props.getPathOrDefault("rlhd.shader-path", () -> ResourcePath.path(HdPlugin.class, new String[0])).chroot();
    private int glProgram;
    private int glLargeComputeProgram;
    private int glSmallComputeProgram;
    private int glUnorderedComputeProgram;
    private int glUiProgram;
    private int glShadowProgram;
    private int vaoHandle;
    private int interfaceTexture;
    private int interfacePbo;
    private int vaoUiHandle;
    private int vboUiHandle;
    private int fboSceneHandle;
    private int rboSceneHandle;
    private int fboShadowMap;
    private int texShadowMap;
    private final GLBuffer hStagingBufferVertices = new GLBuffer();
    private final GLBuffer hStagingBufferUvs = new GLBuffer();
    private final GLBuffer hStagingBufferNormals = new GLBuffer();
    private final GLBuffer hModelBufferUnordered = new GLBuffer();
    private final GLBuffer hModelBufferSmall = new GLBuffer();
    private final GLBuffer hModelBufferLarge = new GLBuffer();
    private final GLBuffer hRenderBufferVertices = new GLBuffer();
    private final GLBuffer hRenderBufferUvs = new GLBuffer();
    private final GLBuffer hRenderBufferNormals = new GLBuffer();
    private final GLBuffer hUniformBufferCamera = new GLBuffer();
    private final GLBuffer hUniformBufferMaterials = new GLBuffer();
    private final GLBuffer hUniformBufferWaterTypes = new GLBuffer();
    private final GLBuffer hUniformBufferLights = new GLBuffer();
    private ByteBuffer uniformBufferLights;
    private SceneContext sceneContext;
    private SceneContext nextSceneContext;
    private GpuIntBuffer modelBufferUnordered;
    private GpuIntBuffer modelBufferSmall;
    private GpuIntBuffer modelBufferLarge;
    private int numModelsUnordered;
    private int numModelsSmall;
    private int numModelsLarge;
    private int dynamicOffsetVertices;
    private int dynamicOffsetUvs;
    private int renderBufferOffset;
    private int lastCanvasWidth;
    private int lastCanvasHeight;
    private int lastStretchedCanvasWidth;
    private int lastStretchedCanvasHeight;
    private AntiAliasingMode lastAntiAliasingMode;
    private int yaw;
    private int pitch;
    private int viewportOffsetX;
    private int viewportOffsetY;
    private int uniColorBlindnessIntensity;
    private int uniUiColorBlindnessIntensity;
    private int uniUseFog;
    private int uniFogColor;
    private int uniFogDepth;
    private int uniDrawDistance;
    private int uniWaterColorLight;
    private int uniWaterColorMid;
    private int uniWaterColorDark;
    private int uniAmbientStrength;
    private int uniAmbientColor;
    private int uniLightStrength;
    private int uniLightColor;
    private int uniUnderglowStrength;
    private int uniUnderglowColor;
    private int uniGroundFogStart;
    private int uniGroundFogEnd;
    private int uniGroundFogOpacity;
    private int uniLightningBrightness;
    private int uniSaturation;
    private int uniContrast;
    private int uniLightDirection;
    private int uniShadowMaxBias;
    private int uniShadowsEnabled;
    private int uniUnderwaterEnvironment;
    private int uniUnderwaterCaustics;
    private int uniUnderwaterCausticsColor;
    private int uniUnderwaterCausticsStrength;
    private int uniShadowLightProjectionMatrix;
    private int uniShadowElapsedTime;
    private int uniPointLightsCount;
    private int uniProjectionMatrix;
    private int uniLightProjectionMatrix;
    private int uniShadowMap;
    private int uniUiTexture;
    private int uniTexSourceDimensions;
    private int uniTexTargetDimensions;
    private int uniUiAlphaOverlay;
    private int uniTextureArray;
    private int uniElapsedTime;
    private int uniBlockCameraComputeSmall;
    private int uniBlockCameraComputeLarge;
    private int uniBlockCamera;
    private int uniBlockMaterials;
    private int uniBlockWaterTypes;
    private int uniBlockPointLights;
    private long lastFrameTime = System.currentTimeMillis();
    private float elapsedTime;
    private int gameTicksUntilSceneReload = 0;
    public boolean configGroundTextures = false;
    public boolean configGroundBlending = false;
    public boolean configModelTextures = true;
    public boolean configTzhaarHD = true;
    public boolean configProjectileLights = true;
    public boolean configNpcLights = true;
    public boolean configHideBakedEffects = false;
    public boolean configHdInfernalTexture = true;
    public boolean configWinterTheme = true;
    public boolean configReduceOverExposure = false;
    public boolean configEnableModelBatching = false;
    public boolean configEnableModelCaching = false;
    public int configMaxDynamicLights;
    public boolean configShadowsEnabled = false;
    public boolean configExpandShadowDraw = false;
    public ShadowMode configShadowMode = ShadowMode.OFF;
    public int[] camTarget = new int[3];
    private boolean running;
    private boolean hasLoggedIn;
    private boolean lwjglInitted;
    private boolean isInGauntlet = false;
    private final Map<Integer, TempModelInfo> frameModelInfoMap = new HashMap<Integer, TempModelInfo>();

    @Nullable
    public SceneContext getSceneContext() {
        return this.sceneContext;
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (!this.isInGauntlet) {
            return;
        }
        if (event.getMessage().equals("You light the nodes in the corridor to help guide the way.")) {
            this.reloadSceneNextGameTick();
        }
    }

    @Provides
    HdPluginConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(HdPluginConfig.class);
    }

    @Override
    protected void startUp() {
        this.gson = this.rlGson.newBuilder().setLenient().create();
        this.configGroundTextures = this.config.groundTextures();
        this.configGroundBlending = this.config.groundBlending();
        this.configModelTextures = this.config.objectTextures();
        this.configTzhaarHD = this.config.tzhaarHD();
        this.configProjectileLights = this.config.projectileLights();
        this.configNpcLights = this.config.npcLights();
        this.configShadowsEnabled = this.config.shadowMode() != ShadowMode.OFF;
        this.configExpandShadowDraw = this.config.expandShadowDraw();
        this.configHideBakedEffects = this.config.hideBakedEffects();
        this.configHdInfernalTexture = this.config.hdInfernalTexture();
        this.configWinterTheme = this.config.winterTheme();
        this.configReduceOverExposure = this.config.enableLegacyGreyColors();
        this.configEnableModelBatching = this.config.enableModelBatching();
        this.configEnableModelCaching = this.config.enableModelCaching();
        this.configMaxDynamicLights = this.config.maxDynamicLights().getValue();
        this.clientThread.invoke(() -> {
            try {
                boolean isUnsupportedGpu;
                this.renderBufferOffset = 0;
                this.rboSceneHandle = 0;
                this.fboSceneHandle = 0;
                this.fboShadowMap = 0;
                this.numModelsLarge = 0;
                this.numModelsSmall = 0;
                this.numModelsUnordered = 0;
                this.elapsedTime = 0.0f;
                AWTContext.loadNatives();
                this.canvas = this.client.getCanvas();
                Object object = this.canvas.getTreeLock();
                synchronized (object) {
                    if (!this.canvas.isValid()) {
                        return false;
                    }
                    this.awtContext = new AWTContext(this.canvas);
                    this.awtContext.configurePixelFormat(0, 0, 0);
                }
                this.awtContext.createGLContext();
                this.canvas.setIgnoreRepaint(true);
                this.computeMode = OSType.getOSType() == OSType.MacOS ? ComputeMode.OPENCL : ComputeMode.OPENGL;
                Configuration.SHARED_LIBRARY_EXTRACT_DIRECTORY.set("lwjgl-rl-" + System.getProperty("os.arch", "unknown"));
                this.glCaps = GL.createCapabilities();
                String glRenderer = GL43C.glGetString(7937);
                String arch = System.getProperty("sun.arch.data.model", "Unknown");
                if (glRenderer == null) {
                    glRenderer = "Unknown";
                }
                log.info("Using device: {}", (Object)glRenderer);
                log.info("Using driver: {}", (Object)GL43C.glGetString(7938));
                log.info("Client is {}-bit", (Object)arch);
                boolean isGenericGpu = glRenderer.equals("GDI Generic");
                boolean bl = isGenericGpu || (this.computeMode == ComputeMode.OPENGL ? !this.glCaps.OpenGL43 : !this.glCaps.OpenGL31) ? true : (isUnsupportedGpu = false);
                if (isUnsupportedGpu) {
                    log.error("The GPU is lacking OpenGL {} support. Stopping the plugin...", (Object)(this.computeMode == ComputeMode.OPENGL ? "4.3" : "3.1"));
                    PopupUtils.displayPopupMessage(this.client, "117HD Error", (String)(isGenericGpu ? "117HD was unable to access your GPU." : "Your GPU is currently not supported by 117HD.<br><br>GPU name: " + glRenderer) + "<br><br>If your system actually has a supported GPU, try the following steps:<br>" + (!arch.equals("32") ? "" : "&nbsp;\u2022 Install the 64-bit version of RuneLite from <a href=\"https://runelite.net\">the official website</a>.<br>") + "&nbsp;\u2022 If you're on a desktop PC, make sure your monitor is plugged into the graphics card<br>&nbsp;&nbsp;&nbsp;&nbsp;instead of the motherboard's display output.<br>&nbsp;\u2022 Reinstall the drivers for your graphics card and restart your system.<br><br>If you're still seeing this error after following the steps above, please join our <a href=\"https://discord.gg/EVpDNJTKG4\">Discord</a><br>server, and drag and drop your client log file into one of our support channels.", new String[]{"Open log folder", "Ok, let me try that..."}, i -> {
                        if (i == 0) {
                            LinkBrowser.open(RuneLite.LOGS_DIR.toString());
                        }
                    });
                    this.stopPlugin();
                    return true;
                }
                this.lwjglInitted = true;
                this.checkGLErrors();
                if (log.isDebugEnabled() && this.glCaps.glDebugMessageControl != 0L) {
                    this.debugCallback = GLUtil.setupDebugMessageCallback();
                    if (this.debugCallback != null) {
                        GL43C.glDebugMessageControl(33350, 33361, 4352, 131185, false);
                        GL43C.glDebugMessageControl(33350, 33360, 4352, 131154, false);
                    }
                }
                this.modelBufferUnordered = new GpuIntBuffer();
                this.modelBufferSmall = new GpuIntBuffer();
                this.modelBufferLarge = new GpuIntBuffer();
                this.initShaderHotswapping();
                if (this.developerMode) {
                    this.developerTools.activate();
                }
                this.lastFrameTime = System.currentTimeMillis();
                this.setupSyncMode();
                this.initVao();
                this.initBuffers();
                this.initPrograms();
                this.initInterfaceTexture();
                this.initShadowMapFbo();
                this.client.setDrawCallbacks(this);
                this.client.setGpu(true);
                this.client.setTexturesInventoryAnimated(this.config.itemInventoryAnimations());
                this.textureManager.startUp();
                this.client.resizeCanvas();
                this.lastCanvasHeight = 0;
                this.lastCanvasWidth = 0;
                this.lastStretchedCanvasHeight = 0;
                this.lastStretchedCanvasWidth = 0;
                this.lastAntiAliasingMode = null;
                this.modelPusher.startUp();
                this.modelOverrideManager.startUp();
                this.lightManager.startUp();
                this.environmentManager.startUp();
                this.eventBus.register(this.lightManager);
                this.running = true;
                if (this.client.getGameState() == GameState.LOGGED_IN) {
                    this.uploadScene();
                }
                this.checkGLErrors();
                this.clientThread.invokeLater(this::displayUpdateMessage);
            }
            catch (Throwable err) {
                log.error("Error while starting 117HD", err);
                this.stopPlugin();
            }
            return true;
        });
    }

    @Override
    protected void shutDown() {
        this.running = false;
        FileWatcher.destroy();
        this.developerTools.deactivate();
        this.clientThread.invoke(() -> {
            this.eventBus.unregister(this.lightManager);
            this.client.setGpu(false);
            this.client.setDrawCallbacks(null);
            this.client.setUnlockedFps(false);
            this.modelPusher.shutDown();
            if (this.lwjglInitted) {
                this.textureManager.shutDown();
                this.shutdownBuffers();
                this.shutdownInterfaceTexture();
                this.shutdownPrograms();
                this.shutdownVao();
                this.shutdownAAFbo();
                this.shutdownShadowMapFbo();
            }
            if (this.awtContext != null) {
                this.awtContext.destroy();
            }
            this.awtContext = null;
            if (this.debugCallback != null) {
                this.debugCallback.free();
            }
            this.debugCallback = null;
            if (this.sceneContext != null) {
                this.sceneContext.destroy();
            }
            this.sceneContext = null;
            if (this.nextSceneContext != null) {
                this.nextSceneContext.destroy();
            }
            this.nextSceneContext = null;
            if (this.modelBufferSmall != null) {
                this.modelBufferSmall.destroy();
            }
            this.modelBufferSmall = null;
            if (this.modelBufferLarge != null) {
                this.modelBufferLarge.destroy();
            }
            this.modelBufferLarge = null;
            if (this.modelBufferUnordered != null) {
                this.modelBufferUnordered.destroy();
            }
            this.modelBufferUnordered = null;
            this.client.resizeCanvas();
        });
    }

    public void stopPlugin() {
        SwingUtilities.invokeLater(() -> {
            try {
                this.pluginManager.setPluginEnabled(this, false);
                this.pluginManager.stopPlugin(this);
            }
            catch (PluginInstantiationException ex) {
                log.error("Error while stopping 117HD", ex);
            }
        });
        this.shutDown();
    }

    private String generateFetchCases(String array, int from, int to) {
        int length = to - from;
        if (length <= 1) {
            return array + "[" + from + "]";
        }
        int middle = from + length / 2;
        return "i < " + middle + " ? " + this.generateFetchCases(array, from, middle) + " : " + this.generateFetchCases(array, middle, to);
    }

    private String generateGetter(String type2, int arrayLength) {
        boolean isAppleM1;
        StringBuilder include = new StringBuilder();
        boolean bl = isAppleM1 = OSType.getOSType() == OSType.MacOS && System.getProperty("os.arch").equals("aarch64");
        if (this.config.macosIntelWorkaround() && !isAppleM1) {
            include.append(type2).append(" ").append("get").append(type2).append("(int i) { return ").append(this.generateFetchCases(type2 + "Array", 0, arrayLength)).append("; }\n");
        } else {
            include.append("#define get").append(type2).append("(i) ").append(type2).append("Array[i]\n");
        }
        return include.toString();
    }

    private void initPrograms() throws ShaderException {
        this.configShadowMode = this.config.shadowMode();
        this.configShadowsEnabled = this.configShadowMode != ShadowMode.OFF;
        String versionHeader = OSType.getOSType() == OSType.Linux ? LINUX_VERSION_HEADER : WINDOWS_VERSION_HEADER;
        Template template = new Template().add(key -> {
            switch (key) {
                case "version_header": {
                    return versionHeader;
                }
                case "UI_SCALING_MODE": {
                    return String.format("#define %s %d", key, this.config.uiScalingMode().getMode());
                }
                case "COLOR_BLINDNESS": {
                    return String.format("#define %s %d", key, this.config.colorBlindness().ordinal());
                }
                case "MATERIAL_CONSTANTS": {
                    StringBuilder include = new StringBuilder();
                    for (Material m4 : Material.values()) {
                        include.append("#define MAT_").append(m4.name().toUpperCase()).append(" getMaterial(").append(m4.ordinal()).append(")\n");
                    }
                    return include.toString();
                }
                case "MATERIAL_COUNT": {
                    return String.format("#define %s %d", key, Material.values().length);
                }
                case "MATERIAL_GETTER": {
                    return this.generateGetter("Material", Material.values().length);
                }
                case "WATER_TYPE_COUNT": {
                    return String.format("#define %s %d", key, WaterType.values().length);
                }
                case "WATER_TYPE_GETTER": {
                    return this.generateGetter("WaterType", WaterType.values().length);
                }
                case "LIGHT_COUNT": {
                    return String.format("#define %s %d", key, Math.max(1, this.configMaxDynamicLights));
                }
                case "LIGHT_GETTER": {
                    return this.generateGetter("PointLight", this.configMaxDynamicLights);
                }
                case "PARALLAX_MAPPING": {
                    return String.format("#define %s %d", key, ParallaxMappingMode.OFF.ordinal());
                }
                case "SHADOW_MODE": {
                    return String.format("#define %s %d", key, this.configShadowMode.ordinal());
                }
                case "SHADOW_TRANSPARENCY": {
                    return String.format("#define %s %d", key, this.config.enableShadowTransparency() ? 1 : 0);
                }
                case "VANILLA_COLOR_BANDING": {
                    return String.format("#define %s %d", key, this.config.vanillaColorBanding() ? 1 : 0);
                }
            }
            return null;
        });
        template.add(key -> {
            try {
                return SHADER_PATH.resolve((String)key).loadString();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
        this.glProgram = PROGRAM.compile(template);
        this.glUiProgram = UI_PROGRAM.compile(template);
        switch (this.configShadowMode) {
            case FAST: {
                this.glShadowProgram = SHADOW_PROGRAM_FAST.compile(template);
                break;
            }
            case DETAILED: {
                this.glShadowProgram = SHADOW_PROGRAM_DETAILED.compile(template);
            }
        }
        if (this.computeMode == ComputeMode.OPENCL) {
            this.openCLManager.init(this.awtContext);
        } else {
            this.glLargeComputeProgram = COMPUTE_PROGRAM.compile(template);
            this.glSmallComputeProgram = SMALL_COMPUTE_PROGRAM.compile(template);
            this.glUnorderedComputeProgram = UNORDERED_COMPUTE_PROGRAM.compile(template);
        }
        this.initUniforms();
        GL43C.glUseProgram(this.glProgram);
        GL43C.glUniform1i(this.uniTextureArray, 1);
        GL43C.glUniform1i(this.uniShadowMap, 2);
        GL43C.glValidateProgram(this.glProgram);
        if (GL43C.glGetProgrami(this.glProgram, 35715) == 0) {
            String err = GL43C.glGetProgramInfoLog(this.glProgram);
            throw new ShaderException(err);
        }
        GL43C.glUseProgram(this.glUiProgram);
        GL43C.glUniform1i(this.uniUiTexture, 0);
        GL43C.glUseProgram(0);
    }

    private void initUniforms() {
        this.uniProjectionMatrix = GL43C.glGetUniformLocation(this.glProgram, "projectionMatrix");
        this.uniLightProjectionMatrix = GL43C.glGetUniformLocation(this.glProgram, "lightProjectionMatrix");
        this.uniShadowMap = GL43C.glGetUniformLocation(this.glProgram, "shadowMap");
        this.uniSaturation = GL43C.glGetUniformLocation(this.glProgram, "saturation");
        this.uniContrast = GL43C.glGetUniformLocation(this.glProgram, "contrast");
        this.uniUseFog = GL43C.glGetUniformLocation(this.glProgram, "useFog");
        this.uniFogColor = GL43C.glGetUniformLocation(this.glProgram, "fogColor");
        this.uniFogDepth = GL43C.glGetUniformLocation(this.glProgram, "fogDepth");
        this.uniWaterColorLight = GL43C.glGetUniformLocation(this.glProgram, "waterColorLight");
        this.uniWaterColorMid = GL43C.glGetUniformLocation(this.glProgram, "waterColorMid");
        this.uniWaterColorDark = GL43C.glGetUniformLocation(this.glProgram, "waterColorDark");
        this.uniDrawDistance = GL43C.glGetUniformLocation(this.glProgram, "drawDistance");
        this.uniAmbientStrength = GL43C.glGetUniformLocation(this.glProgram, "ambientStrength");
        this.uniAmbientColor = GL43C.glGetUniformLocation(this.glProgram, "ambientColor");
        this.uniLightStrength = GL43C.glGetUniformLocation(this.glProgram, "lightStrength");
        this.uniLightColor = GL43C.glGetUniformLocation(this.glProgram, "lightColor");
        this.uniUnderglowStrength = GL43C.glGetUniformLocation(this.glProgram, "underglowStrength");
        this.uniUnderglowColor = GL43C.glGetUniformLocation(this.glProgram, "underglowColor");
        this.uniGroundFogStart = GL43C.glGetUniformLocation(this.glProgram, "groundFogStart");
        this.uniGroundFogEnd = GL43C.glGetUniformLocation(this.glProgram, "groundFogEnd");
        this.uniGroundFogOpacity = GL43C.glGetUniformLocation(this.glProgram, "groundFogOpacity");
        this.uniLightningBrightness = GL43C.glGetUniformLocation(this.glProgram, "lightningBrightness");
        this.uniPointLightsCount = GL43C.glGetUniformLocation(this.glProgram, "pointLightsCount");
        this.uniColorBlindnessIntensity = GL43C.glGetUniformLocation(this.glProgram, "colorBlindnessIntensity");
        this.uniLightDirection = GL43C.glGetUniformLocation(this.glProgram, "lightDirection");
        this.uniShadowMaxBias = GL43C.glGetUniformLocation(this.glProgram, "shadowMaxBias");
        this.uniShadowsEnabled = GL43C.glGetUniformLocation(this.glProgram, "shadowsEnabled");
        this.uniUnderwaterEnvironment = GL43C.glGetUniformLocation(this.glProgram, "underwaterEnvironment");
        this.uniUnderwaterCaustics = GL43C.glGetUniformLocation(this.glProgram, "underwaterCaustics");
        this.uniUnderwaterCausticsColor = GL43C.glGetUniformLocation(this.glProgram, "underwaterCausticsColor");
        this.uniUnderwaterCausticsStrength = GL43C.glGetUniformLocation(this.glProgram, "underwaterCausticsStrength");
        this.uniTextureArray = GL43C.glGetUniformLocation(this.glProgram, "textureArray");
        this.uniElapsedTime = GL43C.glGetUniformLocation(this.glProgram, "elapsedTime");
        this.uniUiTexture = GL43C.glGetUniformLocation(this.glUiProgram, "uiTexture");
        this.uniTexTargetDimensions = GL43C.glGetUniformLocation(this.glUiProgram, "targetDimensions");
        this.uniTexSourceDimensions = GL43C.glGetUniformLocation(this.glUiProgram, "sourceDimensions");
        this.uniUiColorBlindnessIntensity = GL43C.glGetUniformLocation(this.glUiProgram, "colorBlindnessIntensity");
        this.uniUiAlphaOverlay = GL43C.glGetUniformLocation(this.glUiProgram, "alphaOverlay");
        if (this.computeMode == ComputeMode.OPENGL) {
            this.uniBlockCameraComputeSmall = GL43C.glGetUniformBlockIndex(this.glSmallComputeProgram, "CameraUniforms");
            this.uniBlockCameraComputeLarge = GL43C.glGetUniformBlockIndex(this.glLargeComputeProgram, "CameraUniforms");
        }
        this.uniBlockCamera = GL43C.glGetUniformBlockIndex(this.glProgram, "CameraUniforms");
        this.uniBlockMaterials = GL43C.glGetUniformBlockIndex(this.glProgram, "MaterialUniforms");
        this.uniBlockWaterTypes = GL43C.glGetUniformBlockIndex(this.glProgram, "WaterTypeUniforms");
        this.uniBlockPointLights = GL43C.glGetUniformBlockIndex(this.glProgram, "PointLightUniforms");
        switch (this.configShadowMode) {
            case DETAILED: {
                int uniShadowBlockMaterials = GL43C.glGetUniformBlockIndex(this.glShadowProgram, "MaterialUniforms");
                int uniShadowTextureArray = GL43C.glGetUniformLocation(this.glShadowProgram, "textureArray");
                GL43C.glUseProgram(this.glShadowProgram);
                GL43C.glUniform1i(uniShadowTextureArray, 1);
                GL43C.glUniformBlockBinding(this.glShadowProgram, uniShadowBlockMaterials, 1);
                this.uniShadowElapsedTime = GL43C.glGetUniformLocation(this.glShadowProgram, "elapsedTime");
            }
            case FAST: {
                this.uniShadowLightProjectionMatrix = GL43C.glGetUniformLocation(this.glShadowProgram, "lightProjectionMatrix");
            }
        }
        this.initCameraUniformBuffer();
        this.initLightsUniformBuffer();
    }

    private void shutdownPrograms() {
        this.openCLManager.cleanup();
        if (this.glProgram != 0) {
            GL43C.glDeleteProgram(this.glProgram);
            this.glProgram = 0;
        }
        if (this.glLargeComputeProgram != 0) {
            GL43C.glDeleteProgram(this.glLargeComputeProgram);
            this.glLargeComputeProgram = 0;
        }
        if (this.glSmallComputeProgram != 0) {
            GL43C.glDeleteProgram(this.glSmallComputeProgram);
            this.glSmallComputeProgram = 0;
        }
        if (this.glUnorderedComputeProgram != 0) {
            GL43C.glDeleteProgram(this.glUnorderedComputeProgram);
            this.glUnorderedComputeProgram = 0;
        }
        if (this.glUiProgram != 0) {
            GL43C.glDeleteProgram(this.glUiProgram);
            this.glUiProgram = 0;
        }
        if (this.glShadowProgram != 0) {
            GL43C.glDeleteProgram(this.glShadowProgram);
            this.glShadowProgram = 0;
        }
    }

    public void recompilePrograms() {
        try {
            this.shutdownPrograms();
            this.shutdownVao();
            this.initVao();
            this.initPrograms();
        }
        catch (ShaderException ex) {
            log.error("Failed to recompile shader program", ex);
            this.stopPlugin();
        }
    }

    private void initVao() {
        this.vaoHandle = GL43C.glGenVertexArrays();
        this.vaoUiHandle = GL43C.glGenVertexArrays();
        this.vboUiHandle = GL43C.glGenBuffers();
        GL43C.glBindVertexArray(this.vaoUiHandle);
        FloatBuffer vboUiBuf = BufferUtils.createFloatBuffer(20);
        vboUiBuf.put(new float[]{1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, 0.0f, 0.0f});
        vboUiBuf.rewind();
        GL43C.glBindBuffer(34962, this.vboUiHandle);
        GL43C.glBufferData(34962, vboUiBuf, 35044);
        GL43C.glVertexAttribPointer(0, 3, 5126, false, 20, 0L);
        GL43C.glEnableVertexAttribArray(0);
        GL43C.glVertexAttribPointer(1, 2, 5126, false, 20, 12L);
        GL43C.glEnableVertexAttribArray(1);
        GL43C.glBindBuffer(34962, 0);
    }

    private void shutdownVao() {
        if (this.vaoHandle != 0) {
            GL43C.glDeleteVertexArrays(this.vaoHandle);
            this.vaoHandle = 0;
        }
        if (this.vboUiHandle != 0) {
            GL43C.glDeleteBuffers(this.vboUiHandle);
            this.vboUiHandle = 0;
        }
        if (this.vaoUiHandle != 0) {
            GL43C.glDeleteVertexArrays(this.vaoUiHandle);
            this.vaoUiHandle = 0;
        }
    }

    private void initBuffers() {
        this.initGlBuffer(this.hUniformBufferCamera);
        this.initGlBuffer(this.hUniformBufferMaterials);
        this.initGlBuffer(this.hUniformBufferWaterTypes);
        this.initGlBuffer(this.hUniformBufferLights);
        this.initGlBuffer(this.hStagingBufferVertices);
        this.initGlBuffer(this.hStagingBufferUvs);
        this.initGlBuffer(this.hStagingBufferNormals);
        this.initGlBuffer(this.hModelBufferLarge);
        this.initGlBuffer(this.hModelBufferSmall);
        this.initGlBuffer(this.hModelBufferUnordered);
        this.initGlBuffer(this.hRenderBufferVertices);
        this.initGlBuffer(this.hRenderBufferUvs);
        this.initGlBuffer(this.hRenderBufferNormals);
    }

    private void initGlBuffer(GLBuffer glBuffer) {
        glBuffer.glBufferId = GL43C.glGenBuffers();
    }

    private void shutdownBuffers() {
        this.destroyGlBuffer(this.hUniformBufferCamera);
        this.destroyGlBuffer(this.hUniformBufferMaterials);
        this.destroyGlBuffer(this.hUniformBufferWaterTypes);
        this.destroyGlBuffer(this.hUniformBufferLights);
        this.destroyGlBuffer(this.hStagingBufferVertices);
        this.destroyGlBuffer(this.hStagingBufferUvs);
        this.destroyGlBuffer(this.hStagingBufferNormals);
        this.destroyGlBuffer(this.hModelBufferLarge);
        this.destroyGlBuffer(this.hModelBufferSmall);
        this.destroyGlBuffer(this.hModelBufferUnordered);
        this.destroyGlBuffer(this.hRenderBufferVertices);
        this.destroyGlBuffer(this.hRenderBufferUvs);
        this.destroyGlBuffer(this.hRenderBufferNormals);
    }

    private void destroyGlBuffer(GLBuffer glBuffer) {
        if (glBuffer.glBufferId != 0) {
            GL43C.glDeleteBuffers(glBuffer.glBufferId);
            glBuffer.glBufferId = 0;
        }
        glBuffer.size = -1L;
        if (glBuffer.cl_mem != null) {
            CL.clReleaseMemObject(glBuffer.cl_mem);
            glBuffer.cl_mem = null;
        }
    }

    private void initInterfaceTexture() {
        this.interfacePbo = GL43C.glGenBuffers();
        this.interfaceTexture = GL43C.glGenTextures();
        GL43C.glBindTexture(3553, this.interfaceTexture);
        GL43C.glTexParameteri(3553, 10242, 33071);
        GL43C.glTexParameteri(3553, 10243, 33071);
        GL43C.glTexParameteri(3553, 10241, 9729);
        GL43C.glTexParameteri(3553, 10240, 9729);
        GL43C.glBindTexture(3553, 0);
    }

    private void shutdownInterfaceTexture() {
        if (this.interfacePbo != 0) {
            GL43C.glDeleteBuffers(this.interfacePbo);
            this.interfacePbo = 0;
        }
        if (this.interfaceTexture != 0) {
            GL43C.glDeleteTextures(this.interfaceTexture);
            this.interfaceTexture = 0;
        }
    }

    private void initCameraUniformBuffer() {
        IntBuffer uniformBuf = BufferUtils.createIntBuffer(8200);
        uniformBuf.put(new int[8]);
        int[] pad = new int[2];
        for (int i = 0; i < 2048; ++i) {
            uniformBuf.put(Perspective.SINE[i]);
            uniformBuf.put(Perspective.COSINE[i]);
            uniformBuf.put(pad);
        }
        uniformBuf.flip();
        this.updateBuffer(this.hUniformBufferCamera, 35345, uniformBuf, 35048, 4L);
        GL43C.glBindBuffer(35345, 0);
    }

    public void updateMaterialUniformBuffer(float[] textureAnimations) {
        ByteBuffer buffer = BufferUtils.createByteBuffer(Material.values().length * 20 * 4);
        for (Material material : Material.values()) {
            material = this.textureManager.getEffectiveMaterial(material);
            int index = this.textureManager.getTextureIndex(material);
            float scrollSpeedX = material.scrollSpeed[0];
            float scrollSpeedY = material.scrollSpeed[1];
            if (index != -1) {
                scrollSpeedX += textureAnimations[index * 2];
                scrollSpeedY += textureAnimations[index * 2 + 1];
            }
            buffer.putInt(index).putInt(this.textureManager.getTextureIndex(material.normalMap)).putInt(this.textureManager.getTextureIndex(material.displacementMap)).putInt(this.textureManager.getTextureIndex(material.roughnessMap)).putInt(this.textureManager.getTextureIndex(material.ambientOcclusionMap)).putInt(this.textureManager.getTextureIndex(material.flowMap)).putInt(material.overrideBaseColor ? 1 : 0).putInt(material.unlit ? 1 : 0).putFloat(material.brightness).putFloat(material.displacementScale).putFloat(material.specularStrength).putFloat(material.specularGloss).putFloat(material.flowMapStrength).putFloat(0.0f).putFloat(material.flowMapDuration[0]).putFloat(material.flowMapDuration[1]).putFloat(scrollSpeedX).putFloat(scrollSpeedY).putFloat(material.textureScale[0]).putFloat(material.textureScale[1]);
        }
        buffer.flip();
        this.updateBuffer(this.hUniformBufferMaterials, 35345, buffer, 35044, 4L);
        GL43C.glBindBuffer(35345, 0);
    }

    public void updateWaterTypeUniformBuffer() {
        ByteBuffer buffer = BufferUtils.createByteBuffer(WaterType.values().length * 28 * 4);
        for (WaterType type2 : WaterType.values()) {
            buffer.putInt(type2.flat ? 1 : 0).putFloat(type2.specularStrength).putFloat(type2.specularGloss).putFloat(type2.normalStrength).putFloat(type2.baseOpacity).putInt(type2.hasFoam ? 1 : 0).putFloat(type2.duration).putFloat(type2.fresnelAmount).putFloat(type2.surfaceColor[0]).putFloat(type2.surfaceColor[1]).putFloat(type2.surfaceColor[2]).putFloat(0.0f).putFloat(type2.foamColor[0]).putFloat(type2.foamColor[1]).putFloat(type2.foamColor[2]).putFloat(0.0f).putFloat(type2.depthColor[0]).putFloat(type2.depthColor[1]).putFloat(type2.depthColor[2]).putFloat(0.0f).putFloat(type2.causticsStrength).putInt(this.textureManager.getTextureIndex(type2.normalMap)).putInt(this.textureManager.getTextureIndex(Material.WATER_FOAM)).putInt(this.textureManager.getTextureIndex(Material.WATER_FLOW_MAP)).putInt(this.textureManager.getTextureIndex(Material.UNDERWATER_FLOW_MAP)).putFloat(0.0f).putFloat(0.0f).putFloat(0.0f);
        }
        buffer.flip();
        this.updateBuffer(this.hUniformBufferWaterTypes, 35345, buffer, 35044, 4L);
    }

    private void initLightsUniformBuffer() {
        this.uniformBufferLights = BufferUtils.createByteBuffer(Math.max(1, this.configMaxDynamicLights) * 8 * 4);
        this.updateBuffer(this.hUniformBufferLights, 35345, this.uniformBufferLights, 35040, 4L);
    }

    private void initAAFbo(int width, int height, int aaSamples) {
        if (OSType.getOSType() != OSType.MacOS) {
            GraphicsConfiguration graphicsConfiguration = this.clientUI.getGraphicsConfiguration();
            AffineTransform transform = graphicsConfiguration.getDefaultTransform();
            width = this.getScaledValue(transform.getScaleX(), width);
            height = this.getScaledValue(transform.getScaleY(), height);
        }
        this.fboSceneHandle = GL43C.glGenFramebuffers();
        GL43C.glBindFramebuffer(36160, this.fboSceneHandle);
        this.rboSceneHandle = GL43C.glGenRenderbuffers();
        GL43C.glBindRenderbuffer(36161, this.rboSceneHandle);
        GL43C.glRenderbufferStorageMultisample(36161, aaSamples, 6408, width, height);
        GL43C.glFramebufferRenderbuffer(36160, 36064, 36161, this.rboSceneHandle);
        GL43C.glBindFramebuffer(36160, this.awtContext.getFramebuffer(false));
        GL43C.glBindRenderbuffer(36161, 0);
    }

    private void shutdownAAFbo() {
        if (this.fboSceneHandle != 0) {
            GL43C.glDeleteFramebuffers(this.fboSceneHandle);
            this.fboSceneHandle = 0;
        }
        if (this.rboSceneHandle != 0) {
            GL43C.glDeleteRenderbuffers(this.rboSceneHandle);
            this.rboSceneHandle = 0;
        }
    }

    private void initShadowMapFbo() {
        GL43C.glActiveTexture(33986);
        if (this.configShadowsEnabled) {
            this.fboShadowMap = GL43C.glGenFramebuffers();
            GL43C.glBindFramebuffer(36160, this.fboShadowMap);
            this.texShadowMap = GL43C.glGenTextures();
            GL43C.glBindTexture(3553, this.texShadowMap);
            int shadowRes = this.config.shadowResolution().getValue();
            int maxResolution = GL43C.glGetInteger(3379);
            if (maxResolution < shadowRes) {
                log.info("Capping shadow resolution from {} to {}", (Object)shadowRes, (Object)maxResolution);
                shadowRes = maxResolution;
            }
            GL43C.glTexImage2D(3553, 0, 33190, shadowRes, shadowRes, 0, 6402, 5126, 0L);
            GL43C.glTexParameteri(3553, 10241, 9728);
            GL43C.glTexParameteri(3553, 10240, 9728);
            GL43C.glTexParameteri(3553, 10242, 33069);
            GL43C.glTexParameteri(3553, 10243, 33069);
            float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            GL43C.glTexParameterfv(3553, 4100, color);
            GL43C.glFramebufferTexture2D(36160, 36096, 3553, this.texShadowMap, 0);
            GL43C.glDrawBuffer(0);
            GL43C.glReadBuffer(0);
            GL43C.glBindFramebuffer(36160, this.awtContext.getFramebuffer(false));
        } else {
            this.initDummyShadowMap();
        }
        GL43C.glActiveTexture(33984);
    }

    private void initDummyShadowMap() {
        this.texShadowMap = GL43C.glGenTextures();
        GL43C.glBindTexture(3553, this.texShadowMap);
        GL43C.glTexImage2D(3553, 0, 6402, 1, 1, 0, 6402, 5126, 0L);
        GL43C.glTexParameteri(3553, 10241, 9728);
        GL43C.glTexParameteri(3553, 10240, 9728);
        GL43C.glTexParameteri(3553, 10242, 33069);
        GL43C.glTexParameteri(3553, 10243, 33069);
        GL43C.glBindTexture(3553, 0);
    }

    private void shutdownShadowMapFbo() {
        if (this.texShadowMap != 0) {
            GL43C.glDeleteTextures(this.texShadowMap);
            this.texShadowMap = 0;
        }
        if (this.fboShadowMap != 0) {
            GL43C.glDeleteFramebuffers(this.fboShadowMap);
            this.fboShadowMap = 0;
        }
    }

    @Override
    public void drawScene(int cameraX, int cameraY, int cameraZ, int cameraPitch, int cameraYaw, int plane) {
        Scene scene = this.client.getScene();
        if (this.sceneContext == null || this.sceneContext.scene != scene) {
            log.error("Scene being drawn is not the current scene context", new Throwable());
            this.stopPlugin();
            return;
        }
        scene.setDrawDistance(this.getDrawDistance());
        this.yaw = this.client.getCameraYaw();
        this.pitch = this.client.getCameraPitch();
        this.viewportOffsetX = this.client.getViewportXOffset();
        this.viewportOffsetY = this.client.getViewportYOffset();
        if (this.client.getGameState() != GameState.LOADING) {
            this.camTarget = this.getCameraFocalPoint();
        }
        WorldPoint targetWorldPosition = this.sceneContext.localToWorld(new LocalPoint(this.camTarget[0], this.camTarget[1]), this.client.getPlane());
        this.environmentManager.update(this.sceneContext, targetWorldPosition);
        this.lightManager.update(this.sceneContext);
        this.renderBufferOffset = 0;
        this.sceneContext.stagingBufferVertices.clear();
        this.sceneContext.stagingBufferVertices.ensureCapacity(32);
        IntBuffer uniformBuf = this.sceneContext.stagingBufferVertices.getBuffer();
        uniformBuf.put(this.yaw).put(this.pitch).put(this.client.getCenterX()).put(this.client.getCenterY()).put(this.client.getScale()).put(cameraX).put(cameraY).put(cameraZ);
        uniformBuf.flip();
        GL43C.glBindBuffer(35345, this.hUniformBufferCamera.glBufferId);
        GL43C.glBufferSubData(35345, 0L, uniformBuf);
        GL43C.glBindBuffer(35345, 0);
        GL43C.glBindBufferBase(35345, 0, this.hUniformBufferCamera.glBufferId);
        uniformBuf.clear();
        GL43C.glBindBufferBase(35345, 1, this.hUniformBufferMaterials.glBufferId);
        GL43C.glBindBufferBase(35345, 2, this.hUniformBufferWaterTypes.glBufferId);
        this.uniformBufferLights.clear();
        ArrayList<SceneLight> visibleLights = this.lightManager.getVisibleLights(this.getDrawDistance(), this.configMaxDynamicLights);
        this.sceneContext.visibleLightCount = visibleLights.size();
        for (SceneLight light : visibleLights) {
            this.uniformBufferLights.putInt(light.x);
            this.uniformBufferLights.putInt(light.y);
            this.uniformBufferLights.putInt(light.z);
            this.uniformBufferLights.putFloat(light.currentSize);
            this.uniformBufferLights.putFloat(light.currentColor[0]);
            this.uniformBufferLights.putFloat(light.currentColor[1]);
            this.uniformBufferLights.putFloat(light.currentColor[2]);
            this.uniformBufferLights.putFloat(light.currentStrength);
        }
        this.uniformBufferLights.flip();
        if (this.configMaxDynamicLights > 0) {
            GL43C.glBindBuffer(35345, this.hUniformBufferLights.glBufferId);
            GL43C.glBufferSubData(35345, 0L, this.uniformBufferLights);
            GL43C.glBindBuffer(35345, 0);
        }
        this.uniformBufferLights.clear();
        GL43C.glBindBufferBase(35345, 3, this.hUniformBufferLights.glBufferId);
    }

    @Override
    public void postDrawScene() {
        if (!this.running) {
            return;
        }
        this.sceneContext.stagingBufferVertices.flip();
        this.sceneContext.stagingBufferUvs.flip();
        this.sceneContext.stagingBufferNormals.flip();
        this.updateBuffer(this.hStagingBufferVertices, 34962, this.dynamicOffsetVertices * 4, this.sceneContext.stagingBufferVertices.getBuffer(), 35040, 4L);
        this.updateBuffer(this.hStagingBufferUvs, 34962, this.dynamicOffsetUvs * 4, this.sceneContext.stagingBufferUvs.getBuffer(), 35040, 4L);
        this.updateBuffer(this.hStagingBufferNormals, 34962, this.dynamicOffsetVertices * 4, this.sceneContext.stagingBufferNormals.getBuffer(), 35040, 4L);
        this.sceneContext.stagingBufferVertices.clear();
        this.sceneContext.stagingBufferUvs.clear();
        this.sceneContext.stagingBufferNormals.clear();
        this.modelBufferUnordered.flip();
        this.modelBufferSmall.flip();
        this.modelBufferLarge.flip();
        this.updateBuffer(this.hModelBufferLarge, 34962, this.modelBufferLarge.getBuffer(), 35040, 4L);
        this.updateBuffer(this.hModelBufferSmall, 34962, this.modelBufferSmall.getBuffer(), 35040, 4L);
        this.updateBuffer(this.hModelBufferUnordered, 34962, this.modelBufferUnordered.getBuffer(), 35040, 4L);
        this.modelBufferUnordered.clear();
        this.modelBufferSmall.clear();
        this.modelBufferLarge.clear();
        this.updateBuffer(this.hRenderBufferVertices, 34962, (long)this.renderBufferOffset * 16L, 35040, 2L);
        this.updateBuffer(this.hRenderBufferUvs, 34962, (long)this.renderBufferOffset * 16L, 35040, 2L);
        this.updateBuffer(this.hRenderBufferNormals, 34962, (long)this.renderBufferOffset * 16L, 35040, 2L);
        if (this.computeMode == ComputeMode.OPENCL) {
            this.openCLManager.compute(this.hUniformBufferCamera, this.numModelsUnordered, this.numModelsSmall, this.numModelsLarge, this.hModelBufferUnordered, this.hModelBufferSmall, this.hModelBufferLarge, this.hStagingBufferVertices, this.hStagingBufferUvs, this.hStagingBufferNormals, this.hRenderBufferVertices, this.hRenderBufferUvs, this.hRenderBufferNormals);
        } else {
            GL43C.glUniformBlockBinding(this.glSmallComputeProgram, this.uniBlockCameraComputeSmall, 0);
            GL43C.glUniformBlockBinding(this.glLargeComputeProgram, this.uniBlockCameraComputeLarge, 0);
            GL43C.glBindBufferBase(37074, 1, this.hStagingBufferVertices.glBufferId);
            GL43C.glBindBufferBase(37074, 2, this.hStagingBufferUvs.glBufferId);
            GL43C.glBindBufferBase(37074, 3, this.hStagingBufferNormals.glBufferId);
            GL43C.glBindBufferBase(37074, 4, this.hRenderBufferVertices.glBufferId);
            GL43C.glBindBufferBase(37074, 5, this.hRenderBufferUvs.glBufferId);
            GL43C.glBindBufferBase(37074, 6, this.hRenderBufferNormals.glBufferId);
            GL43C.glUseProgram(this.glUnorderedComputeProgram);
            GL43C.glBindBufferBase(37074, 0, this.hModelBufferUnordered.glBufferId);
            GL43C.glDispatchCompute(this.numModelsUnordered, 1, 1);
            GL43C.glUseProgram(this.glSmallComputeProgram);
            GL43C.glBindBufferBase(37074, 0, this.hModelBufferSmall.glBufferId);
            GL43C.glDispatchCompute(this.numModelsSmall, 1, 1);
            GL43C.glUseProgram(this.glLargeComputeProgram);
            GL43C.glBindBufferBase(37074, 0, this.hModelBufferLarge.glBufferId);
            GL43C.glDispatchCompute(this.numModelsLarge, 1, 1);
        }
        this.checkGLErrors();
        this.numModelsLarge = 0;
        this.numModelsSmall = 0;
        this.numModelsUnordered = 0;
    }

    @Override
    public void drawScenePaint(int orientation, int pitchSin, int pitchCos, int yawSin, int yawCos, int x, int y, int z, SceneTilePaint paint, int tileZ, int tileX, int tileY, int zoom, int centerX, int centerY) {
        if (paint.getBufferLen() > 0) {
            int localX = tileX * 128;
            boolean localY = false;
            int localZ = tileY * 128;
            GpuIntBuffer b = this.modelBufferUnordered;
            b.ensureCapacity(16);
            IntBuffer buffer = b.getBuffer();
            int bufferLength = paint.getBufferLen();
            boolean underwaterTerrain = (bufferLength & 1) == 1;
            bufferLength >>= 1;
            if (underwaterTerrain) {
                ++this.numModelsUnordered;
                buffer.put(paint.getBufferOffset() + (bufferLength /= 2));
                buffer.put(paint.getUvBufferOffset() + bufferLength);
                buffer.put(bufferLength / 3);
                buffer.put(this.renderBufferOffset);
                buffer.put(0);
                buffer.put(localX).put(0).put(localZ);
                this.renderBufferOffset += bufferLength;
            }
            ++this.numModelsUnordered;
            buffer.put(paint.getBufferOffset());
            buffer.put(paint.getUvBufferOffset());
            buffer.put(bufferLength / 3);
            buffer.put(this.renderBufferOffset);
            buffer.put(0);
            buffer.put(localX).put(0).put(localZ);
            this.renderBufferOffset += bufferLength;
        }
    }

    public void initShaderHotswapping() {
        SHADER_PATH.watch("\\.(glsl|cl)$", path -> {
            log.info("Reloading shader: {}", path);
            this.clientThread.invoke(this::recompilePrograms);
        });
    }

    @Override
    public void drawSceneModel(int orientation, int pitchSin, int pitchCos, int yawSin, int yawCos, int x, int y, int z, SceneTileModel model, int tileZ, int tileX, int tileY, int zoom, int centerX, int centerY) {
        if (model.getBufferLen() > 0) {
            int localX = tileX * 128;
            boolean localY = false;
            int localZ = tileY * 128;
            GpuIntBuffer b = this.modelBufferUnordered;
            b.ensureCapacity(16);
            IntBuffer buffer = b.getBuffer();
            int bufferLength = model.getBufferLen();
            boolean underwaterTerrain = (bufferLength & 1) == 1;
            bufferLength >>= 1;
            if (underwaterTerrain) {
                ++this.numModelsUnordered;
                buffer.put(model.getBufferOffset() + (bufferLength /= 2));
                buffer.put(model.getUvBufferOffset() + bufferLength);
                buffer.put(bufferLength / 3);
                buffer.put(this.renderBufferOffset);
                buffer.put(0);
                buffer.put(localX).put(0).put(localZ);
                this.renderBufferOffset += bufferLength;
            }
            ++this.numModelsUnordered;
            buffer.put(model.getBufferOffset());
            buffer.put(model.getUvBufferOffset());
            buffer.put(bufferLength / 3);
            buffer.put(this.renderBufferOffset);
            buffer.put(0);
            buffer.put(localX).put(0).put(localZ);
            this.renderBufferOffset += bufferLength;
        }
    }

    private void prepareInterfaceTexture(int canvasWidth, int canvasHeight) {
        if (canvasWidth != this.lastCanvasWidth || canvasHeight != this.lastCanvasHeight) {
            this.lastCanvasWidth = canvasWidth;
            this.lastCanvasHeight = canvasHeight;
            GL43C.glBindBuffer(35052, this.interfacePbo);
            GL43C.glBufferData(35052, (long)(canvasWidth * canvasHeight) * 4L, 35040);
            GL43C.glBindBuffer(35052, 0);
            GL43C.glBindTexture(3553, this.interfaceTexture);
            GL43C.glTexImage2D(3553, 0, 6408, canvasWidth, canvasHeight, 0, 32993, 5121, 0L);
            GL43C.glBindTexture(3553, 0);
        }
        BufferProvider bufferProvider = this.client.getBufferProvider();
        int[] pixels = bufferProvider.getPixels();
        int width = bufferProvider.getWidth();
        int height = bufferProvider.getHeight();
        GL43C.glBindBuffer(35052, this.interfacePbo);
        ByteBuffer mappedBuffer = GL43C.glMapBuffer(35052, 35001);
        if (mappedBuffer == null) {
            log.error("Unable to map interface PBO. Skipping UI...");
        } else {
            mappedBuffer.asIntBuffer().put(pixels, 0, width * height);
            GL43C.glUnmapBuffer(35052);
            GL43C.glBindTexture(3553, this.interfaceTexture);
            GL43C.glTexSubImage2D(3553, 0, 0, 0, width, height, 32993, 33639, 0L);
        }
        GL43C.glBindBuffer(35052, 0);
        GL43C.glBindTexture(3553, 0);
    }

    @Override
    public void draw(int overlayColor) {
        if (System.currentTimeMillis() - this.lastFrameTime > 60000L) {
            log.debug("resetting the plugin after probable OS suspend");
            this.shutDown();
            this.startUp();
            return;
        }
        long frameDeltaTime = System.currentTimeMillis() - this.lastFrameTime;
        if (Math.abs(frameDeltaTime) > 10000L) {
            frameDeltaTime = 16L;
        }
        this.elapsedTime += (float)frameDeltaTime / 1000.0f;
        this.lastFrameTime = System.currentTimeMillis();
        int canvasHeight = this.client.getCanvasHeight();
        int canvasWidth = this.client.getCanvasWidth();
        try {
            this.prepareInterfaceTexture(canvasWidth, canvasHeight);
        }
        catch (Exception ex) {
            log.warn("prepareInterfaceTexture exception", ex);
            this.shutDown();
            this.startUp();
            return;
        }
        GL43C.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        GL43C.glClear(16384);
        TextureProvider textureProvider = this.client.getTextureProvider();
        if (textureProvider != null && this.client.getGameState().getState() >= GameState.LOADING.getState()) {
            int i;
            boolean aaEnabled;
            this.textureManager.ensureTexturesLoaded(textureProvider);
            int viewportHeight = this.client.getViewportHeight();
            int viewportWidth = this.client.getViewportWidth();
            int renderWidthOff = this.viewportOffsetX;
            int renderHeightOff = this.viewportOffsetY;
            int renderCanvasHeight = canvasHeight;
            int renderViewportHeight = viewportHeight;
            int renderViewportWidth = viewportWidth;
            if (this.client.isStretchedEnabled()) {
                Dimension dim = this.client.getStretchedDimensions();
                renderCanvasHeight = dim.height;
                double scaleFactorY = dim.getHeight() / (double)canvasHeight;
                double scaleFactorX = dim.getWidth() / (double)canvasWidth;
                boolean padding = true;
                renderViewportHeight = (int)Math.ceil(scaleFactorY * (double)renderViewportHeight) + 2;
                renderViewportWidth = (int)Math.ceil(scaleFactorX * (double)renderViewportWidth) + 2;
                renderHeightOff = (int)Math.floor(scaleFactorY * (double)renderHeightOff) - 1;
                renderWidthOff = (int)Math.floor(scaleFactorX * (double)renderWidthOff) - 1;
            }
            if (this.computeMode == ComputeMode.OPENCL) {
                this.openCLManager.finish();
            } else {
                GL43C.glMemoryBarrier(8192);
            }
            int vertexBuffer = this.hRenderBufferVertices.glBufferId;
            int uvBuffer = this.hRenderBufferUvs.glBufferId;
            int normalBuffer = this.hRenderBufferNormals.glBufferId;
            float[] lightProjectionMatrix = Mat4.identity();
            float lightPitch = this.environmentManager.currentLightPitch;
            float lightYaw = this.environmentManager.currentLightYaw;
            if (this.configShadowsEnabled && this.fboShadowMap != 0 && this.environmentManager.currentDirectionalStrength > 0.0f) {
                GL43C.glViewport(0, 0, this.config.shadowResolution().getValue(), this.config.shadowResolution().getValue());
                GL43C.glBindFramebuffer(36160, this.fboShadowMap);
                GL43C.glClearDepthf(1.0f);
                GL43C.glClear(256);
                GL43C.glDepthFunc(515);
                GL43C.glUseProgram(this.glShadowProgram);
                int camX = this.camTarget[0];
                int camY = this.camTarget[1];
                int camZ = this.camTarget[2];
                int drawDistanceSceneUnits = Math.min(this.config.shadowDistance().getValue(), this.getDrawDistance()) * 128 / 2;
                int east = Math.min(camX + drawDistanceSceneUnits, 13312);
                int west = Math.max(camX - drawDistanceSceneUnits, 0);
                int north = Math.min(camY + drawDistanceSceneUnits, 13312);
                int south = Math.max(camY - drawDistanceSceneUnits, 0);
                int width = east - west;
                int height = north - south;
                int near = 10000;
                int maxDrawDistance = 90;
                float maxScale = 0.7f;
                float minScale = 0.4f;
                float scaleMultiplier = 1.0f - (float)this.getDrawDistance() / 63.0f;
                float scale = HDUtils.lerp(0.7f, 0.4f, scaleMultiplier);
                Mat4.mul(lightProjectionMatrix, Mat4.scale(scale, scale, scale));
                Mat4.mul(lightProjectionMatrix, Mat4.ortho(width, height, 10000.0f));
                Mat4.mul(lightProjectionMatrix, Mat4.rotateX((float)Math.toRadians(lightPitch)));
                Mat4.mul(lightProjectionMatrix, Mat4.rotateY((float)(-Math.toRadians(lightYaw))));
                Mat4.mul(lightProjectionMatrix, Mat4.translate(-((float)width / 2.0f + (float)west), -camZ, -((float)height / 2.0f + (float)south)));
                GL43C.glUniformMatrix4fv(this.uniShadowLightProjectionMatrix, false, lightProjectionMatrix);
                if (this.configShadowMode == ShadowMode.DETAILED) {
                    GL43C.glUniform1f(this.uniShadowElapsedTime, this.elapsedTime);
                }
                GL43C.glEnable(2884);
                GL43C.glEnable(2929);
                GL43C.glBindVertexArray(this.vaoHandle);
                GL43C.glEnableVertexAttribArray(0);
                GL43C.glBindBuffer(34962, vertexBuffer);
                GL43C.glVertexAttribIPointer(0, 4, 5124, 0, 0L);
                GL43C.glEnableVertexAttribArray(1);
                GL43C.glBindBuffer(34962, uvBuffer);
                GL43C.glVertexAttribPointer(1, 4, 5126, false, 0, 0L);
                GL43C.glDrawArrays(4, 0, this.renderBufferOffset);
                GL43C.glDisable(2884);
                GL43C.glDisable(2929);
                GL43C.glBindFramebuffer(36160, this.awtContext.getFramebuffer(false));
                GL43C.glUseProgram(0);
            }
            this.glDpiAwareViewport(renderWidthOff, renderCanvasHeight - renderViewportHeight - renderHeightOff, renderViewportWidth, renderViewportHeight);
            GL43C.glUseProgram(this.glProgram);
            AntiAliasingMode antiAliasingMode = this.config.antiAliasingMode();
            boolean bl = aaEnabled = antiAliasingMode != AntiAliasingMode.DISABLED;
            if (aaEnabled) {
                int stretchedCanvasHeight;
                GL43C.glEnable(32925);
                Dimension stretchedDimensions = this.client.getStretchedDimensions();
                int stretchedCanvasWidth = this.client.isStretchedEnabled() ? stretchedDimensions.width : canvasWidth;
                int n = stretchedCanvasHeight = this.client.isStretchedEnabled() ? stretchedDimensions.height : canvasHeight;
                if (this.lastStretchedCanvasWidth != stretchedCanvasWidth || this.lastStretchedCanvasHeight != stretchedCanvasHeight || this.lastAntiAliasingMode != antiAliasingMode) {
                    this.shutdownAAFbo();
                    GL43C.glBindFramebuffer(36160, this.awtContext.getFramebuffer(false));
                    int forcedAASamples = GL43C.glGetInteger(32937);
                    int maxSamples = GL43C.glGetInteger(36183);
                    int samples = forcedAASamples != 0 ? forcedAASamples : Math.min(antiAliasingMode.getSamples(), maxSamples);
                    log.debug("AA samples: {}, max samples: {}, forced samples: {}", samples, maxSamples, forcedAASamples);
                    this.initAAFbo(stretchedCanvasWidth, stretchedCanvasHeight, samples);
                    this.lastStretchedCanvasWidth = stretchedCanvasWidth;
                    this.lastStretchedCanvasHeight = stretchedCanvasHeight;
                }
                GL43C.glBindFramebuffer(36009, this.fboSceneHandle);
            } else {
                GL43C.glDisable(32925);
                this.shutdownAAFbo();
            }
            this.lastAntiAliasingMode = antiAliasingMode;
            float[] fogColor = this.hasLoggedIn ? this.environmentManager.getFogColor() : EnvironmentManager.BLACK_COLOR;
            for (int i2 = 0; i2 < fogColor.length; ++i2) {
                fogColor[i2] = HDUtils.linearToSrgb(fogColor[i2]);
            }
            GL43C.glClearColor(fogColor[0], fogColor[1], fogColor[2], 1.0f);
            GL43C.glClear(16384);
            int drawDistance = this.getDrawDistance();
            int fogDepth = this.config.fogDepth();
            fogDepth *= 10;
            if (this.config.fogDepthMode() == FogDepthMode.DYNAMIC) {
                fogDepth = this.environmentManager.currentFogDepth;
            } else if (this.config.fogDepthMode() == FogDepthMode.NONE) {
                fogDepth = 0;
            }
            GL43C.glUniform1i(this.uniUseFog, fogDepth > 0 ? 1 : 0);
            GL43C.glUniform1i(this.uniFogDepth, fogDepth);
            GL43C.glUniform4f(this.uniFogColor, fogColor[0], fogColor[1], fogColor[2], 1.0f);
            GL43C.glUniform1i(this.uniDrawDistance, drawDistance * 128);
            GL43C.glUniform1f(this.uniColorBlindnessIntensity, (float)this.config.colorBlindnessIntensity() / 100.0f);
            float[] waterColor = this.environmentManager.currentWaterColor;
            float[] waterColorHSB = Color.RGBtoHSB((int)(waterColor[0] * 255.0f), (int)(waterColor[1] * 255.0f), (int)(waterColor[2] * 255.0f), null);
            float lightBrightnessMultiplier = 0.8f;
            float midBrightnessMultiplier = 0.45f;
            float darkBrightnessMultiplier = 0.05f;
            float[] waterColorLight = new Color(Color.HSBtoRGB(waterColorHSB[0], waterColorHSB[1], waterColorHSB[2] * lightBrightnessMultiplier)).getRGBColorComponents(null);
            float[] waterColorMid = new Color(Color.HSBtoRGB(waterColorHSB[0], waterColorHSB[1], waterColorHSB[2] * midBrightnessMultiplier)).getRGBColorComponents(null);
            float[] waterColorDark = new Color(Color.HSBtoRGB(waterColorHSB[0], waterColorHSB[1], waterColorHSB[2] * darkBrightnessMultiplier)).getRGBColorComponents(null);
            for (i = 0; i < waterColorLight.length; ++i) {
                waterColorLight[i] = HDUtils.linearToSrgb(waterColorLight[i]);
            }
            for (i = 0; i < waterColorMid.length; ++i) {
                waterColorMid[i] = HDUtils.linearToSrgb(waterColorMid[i]);
            }
            for (i = 0; i < waterColorDark.length; ++i) {
                waterColorDark[i] = HDUtils.linearToSrgb(waterColorDark[i]);
            }
            GL43C.glUniform3f(this.uniWaterColorLight, waterColorLight[0], waterColorLight[1], waterColorLight[2]);
            GL43C.glUniform3f(this.uniWaterColorMid, waterColorMid[0], waterColorMid[1], waterColorMid[2]);
            GL43C.glUniform3f(this.uniWaterColorDark, waterColorDark[0], waterColorDark[1], waterColorDark[2]);
            float ambientStrength = this.environmentManager.currentAmbientStrength;
            ambientStrength = (float)((double)ambientStrength * ((double)this.config.brightness() / 20.0));
            GL43C.glUniform1f(this.uniAmbientStrength, ambientStrength);
            float[] ambientColor = this.environmentManager.currentAmbientColor;
            GL43C.glUniform3f(this.uniAmbientColor, ambientColor[0], ambientColor[1], ambientColor[2]);
            float lightStrength = this.environmentManager.currentDirectionalStrength;
            lightStrength = (float)((double)lightStrength * ((double)this.config.brightness() / 20.0));
            GL43C.glUniform1f(this.uniLightStrength, lightStrength);
            float[] lightColor = this.environmentManager.currentDirectionalColor;
            GL43C.glUniform3f(this.uniLightColor, lightColor[0], lightColor[1], lightColor[2]);
            float underglowStrength = this.environmentManager.currentUnderglowStrength;
            GL43C.glUniform1f(this.uniUnderglowStrength, underglowStrength);
            float[] underglowColor = this.environmentManager.currentUnderglowColor;
            GL43C.glUniform3f(this.uniUnderglowColor, underglowColor[0], underglowColor[1], underglowColor[2]);
            float groundFogStart = this.environmentManager.currentGroundFogStart;
            GL43C.glUniform1f(this.uniGroundFogStart, groundFogStart);
            float groundFogEnd = this.environmentManager.currentGroundFogEnd;
            GL43C.glUniform1f(this.uniGroundFogEnd, groundFogEnd);
            float groundFogOpacity = this.environmentManager.currentGroundFogOpacity;
            groundFogOpacity = this.config.groundFog() ? groundFogOpacity : 0.0f;
            GL43C.glUniform1f(this.uniGroundFogOpacity, groundFogOpacity);
            GL43C.glUniform1f(this.uniLightningBrightness, this.environmentManager.getLightningBrightness());
            GL43C.glUniform1i(this.uniPointLightsCount, this.sceneContext == null ? 0 : this.sceneContext.visibleLightCount);
            GL43C.glUniform1f(this.uniSaturation, (float)this.config.saturation() / 100.0f);
            GL43C.glUniform1f(this.uniContrast, (float)this.config.contrast() / 100.0f);
            GL43C.glUniform1i(this.uniUnderwaterEnvironment, this.environmentManager.isUnderwater() ? 1 : 0);
            GL43C.glUniform1i(this.uniUnderwaterCaustics, this.config.underwaterCaustics() ? 1 : 0);
            GL43C.glUniform3fv(this.uniUnderwaterCausticsColor, this.environmentManager.currentUnderwaterCausticsColor);
            GL43C.glUniform1f(this.uniUnderwaterCausticsStrength, this.environmentManager.currentUnderwaterCausticsStrength);
            double lightPitchRadians = Math.toRadians(lightPitch);
            double lightYawRadians = Math.toRadians(lightYaw);
            GL43C.glUniform3f(this.uniLightDirection, (float)(Math.cos(lightPitchRadians) * -Math.sin(lightYawRadians)), (float)(-Math.sin(lightPitchRadians)), (float)(Math.cos(lightPitchRadians) * -Math.cos(lightYawRadians)));
            float shadowPixelsPerTile = (float)this.config.shadowResolution().getValue() / (float)this.config.shadowDistance().getValue();
            float maxBias = 26.0f * (float)Math.pow(0.925f, 0.4f * shadowPixelsPerTile - 10.0f) + 13.0f;
            GL43C.glUniform1f(this.uniShadowMaxBias, maxBias / 10000.0f);
            GL43C.glUniform1i(this.uniShadowsEnabled, this.configShadowsEnabled ? 1 : 0);
            float[] projectionMatrix = Mat4.scale(this.client.getScale(), this.client.getScale(), 1.0f);
            Mat4.mul(projectionMatrix, Mat4.projection(viewportWidth, viewportHeight, 50.0f));
            Mat4.mul(projectionMatrix, Mat4.rotateX((float)(-(Math.PI - (double)this.pitch * 0.0030679615757712823))));
            Mat4.mul(projectionMatrix, Mat4.rotateY((float)((double)this.yaw * 0.0030679615757712823)));
            Mat4.mul(projectionMatrix, Mat4.translate(-this.client.getCameraX2(), -this.client.getCameraY2(), -this.client.getCameraZ2()));
            GL43C.glUniformMatrix4fv(this.uniProjectionMatrix, false, projectionMatrix);
            GL43C.glUniformMatrix4fv(this.uniLightProjectionMatrix, false, lightProjectionMatrix);
            GL43C.glUniformBlockBinding(this.glProgram, this.uniBlockCamera, 0);
            GL43C.glUniformBlockBinding(this.glProgram, this.uniBlockMaterials, 1);
            GL43C.glUniformBlockBinding(this.glProgram, this.uniBlockWaterTypes, 2);
            GL43C.glUniformBlockBinding(this.glProgram, this.uniBlockPointLights, 3);
            GL43C.glUniform1f(this.uniElapsedTime, this.elapsedTime);
            GL43C.glEnable(2884);
            GL43C.glCullFace(1029);
            GL43C.glEnable(3042);
            GL43C.glBlendFuncSeparate(770, 771, 1, 1);
            GL43C.glBindVertexArray(this.vaoHandle);
            GL43C.glEnableVertexAttribArray(0);
            GL43C.glBindBuffer(34962, vertexBuffer);
            GL43C.glVertexAttribIPointer(0, 4, 5124, 0, 0L);
            GL43C.glEnableVertexAttribArray(1);
            GL43C.glBindBuffer(34962, uvBuffer);
            GL43C.glVertexAttribPointer(1, 4, 5126, false, 0, 0L);
            GL43C.glEnableVertexAttribArray(2);
            GL43C.glBindBuffer(34962, normalBuffer);
            GL43C.glVertexAttribPointer(2, 4, 5126, false, 0, 0L);
            GL43C.glDrawArrays(4, 0, this.renderBufferOffset);
            GL43C.glDisable(3042);
            GL43C.glDisable(2884);
            GL43C.glUseProgram(0);
            if (aaEnabled) {
                int width = this.lastStretchedCanvasWidth;
                int height = this.lastStretchedCanvasHeight;
                if (OSType.getOSType() != OSType.MacOS) {
                    GraphicsConfiguration graphicsConfiguration = this.clientUI.getGraphicsConfiguration();
                    AffineTransform transform = graphicsConfiguration.getDefaultTransform();
                    width = this.getScaledValue(transform.getScaleX(), width);
                    height = this.getScaledValue(transform.getScaleY(), height);
                }
                GL43C.glBindFramebuffer(36008, this.fboSceneHandle);
                GL43C.glBindFramebuffer(36009, this.awtContext.getFramebuffer(false));
                GL43C.glBlitFramebuffer(0, 0, width, height, 0, 0, width, height, 16384, 9728);
                GL43C.glBindFramebuffer(36008, this.awtContext.getFramebuffer(false));
            }
            this.frameModelInfoMap.clear();
        }
        this.drawUi(overlayColor, canvasHeight, canvasWidth);
        try {
            this.awtContext.swapBuffers();
            this.drawManager.processDrawComplete(this::screenshot);
        }
        catch (Exception ex) {
            log.error("Unable to swap buffers:", ex);
        }
        GL43C.glBindFramebuffer(36160, this.awtContext.getFramebuffer(false));
        this.checkGLErrors();
    }

    private void drawUi(int overlayColor, int canvasHeight, int canvasWidth) {
        GL43C.glEnable(3042);
        GL43C.glBlendFunc(1, 771);
        GL43C.glBindTexture(3553, this.interfaceTexture);
        GL43C.glUseProgram(this.glUiProgram);
        GL43C.glUniform2i(this.uniTexSourceDimensions, canvasWidth, canvasHeight);
        GL43C.glUniform1f(this.uniUiColorBlindnessIntensity, (float)this.config.colorBlindnessIntensity() / 100.0f);
        GL43C.glUniform4f(this.uniUiAlphaOverlay, (float)(overlayColor >> 16 & 0xFF) / 255.0f, (float)(overlayColor >> 8 & 0xFF) / 255.0f, (float)(overlayColor & 0xFF) / 255.0f, (float)(overlayColor >>> 24) / 255.0f);
        if (this.client.isStretchedEnabled()) {
            Dimension dim = this.client.getStretchedDimensions();
            this.glDpiAwareViewport(0, 0, dim.width, dim.height);
            GL43C.glUniform2i(this.uniTexTargetDimensions, dim.width, dim.height);
        } else {
            this.glDpiAwareViewport(0, 0, canvasWidth, canvasHeight);
            GL43C.glUniform2i(this.uniTexTargetDimensions, canvasWidth, canvasHeight);
        }
        if (this.client.isStretchedEnabled()) {
            int function = this.config.uiScalingMode() == UIScalingMode.LINEAR ? 9729 : 9728;
            GL43C.glTexParameteri(3553, 10241, function);
            GL43C.glTexParameteri(3553, 10240, function);
        }
        GL43C.glBindVertexArray(this.vaoUiHandle);
        GL43C.glDrawArrays(6, 0, 4);
        GL43C.glBindTexture(3553, 0);
        GL43C.glBindVertexArray(0);
        GL43C.glUseProgram(0);
        GL43C.glBlendFunc(770, 771);
        GL43C.glDisable(3042);
    }

    private Image screenshot() {
        int width = this.client.getCanvasWidth();
        int height = this.client.getCanvasHeight();
        if (this.client.isStretchedEnabled()) {
            Dimension dim = this.client.getStretchedDimensions();
            width = dim.width;
            height = dim.height;
        }
        if (OSType.getOSType() != OSType.MacOS) {
            GraphicsConfiguration graphicsConfiguration = this.clientUI.getGraphicsConfiguration();
            AffineTransform t2 = graphicsConfiguration.getDefaultTransform();
            width = this.getScaledValue(t2.getScaleX(), width);
            height = this.getScaledValue(t2.getScaleY(), height);
        }
        ByteBuffer buffer = BufferUtils.createByteBuffer(width * height * 4);
        GL43C.glReadBuffer(this.awtContext.getBufferMode());
        GL43C.glReadPixels(0, 0, width, height, 6408, 5121, buffer);
        BufferedImage image = new BufferedImage(width, height, 1);
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int r = buffer.get() & 0xFF;
                int g2 = buffer.get() & 0xFF;
                int b = buffer.get() & 0xFF;
                buffer.get();
                pixels[(height - y - 1) * width + x] = r << 16 | g2 << 8 | b;
            }
        }
        return image;
    }

    @Override
    public void animate(Texture texture, int diff) {
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (!this.running) {
            return;
        }
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN) {
            this.renderBufferOffset = 0;
            this.hasLoggedIn = false;
            this.modelPusher.clearModelCache();
        }
    }

    public void uploadScene() {
        assert (this.client.isClientThread()) : "Loading a scene is unsafe while the client can simultaneously initiate a scene load";
        Scene scene = this.client.getScene();
        this.loadScene(scene);
        this.swapScene(scene);
    }

    @Override
    public void loadScene(Scene scene) {
        if (this.nextSceneContext != null) {
            SceneContext handle = this.nextSceneContext;
            this.nextSceneContext = null;
            handle.destroy();
        }
        this.nextSceneContext = new SceneContext(scene, this.sceneContext);
        this.proceduralGenerator.generateSceneData(this.nextSceneContext);
        this.environmentManager.loadSceneEnvironments(this.nextSceneContext);
        this.lightManager.loadSceneLights(this.nextSceneContext);
        this.sceneUploader.upload(this.nextSceneContext);
    }

    @Override
    public void swapScene(Scene scene) {
        if (this.nextSceneContext == null) {
            log.error("No new scene to swap to", new Throwable());
            this.stopPlugin();
            return;
        }
        if (this.sceneContext != null) {
            for (SceneLight light : this.sceneContext.lights) {
                if (light.npc == null && light.projectile == null) continue;
                this.nextSceneContext.lights.add(light);
            }
            this.sceneContext.destroy();
        }
        this.sceneContext = this.nextSceneContext;
        this.nextSceneContext = null;
        this.dynamicOffsetVertices = this.sceneContext.getVertexOffset();
        this.dynamicOffsetUvs = this.sceneContext.getUvOffset();
        this.sceneContext.stagingBufferVertices.flip();
        this.sceneContext.stagingBufferUvs.flip();
        this.sceneContext.stagingBufferNormals.flip();
        this.updateBuffer(this.hStagingBufferVertices, 34962, this.sceneContext.stagingBufferVertices.getBuffer(), 35040, 4L);
        this.updateBuffer(this.hStagingBufferUvs, 34962, this.sceneContext.stagingBufferUvs.getBuffer(), 35040, 4L);
        this.updateBuffer(this.hStagingBufferNormals, 34962, this.sceneContext.stagingBufferNormals.getBuffer(), 35040, 4L);
        this.sceneContext.stagingBufferVertices.clear();
        this.sceneContext.stagingBufferUvs.clear();
        this.sceneContext.stagingBufferNormals.clear();
    }

    public void reloadSceneNextGameTick() {
        this.reloadSceneIn(1);
    }

    public void reloadSceneIn(int gameTicks) {
        assert (gameTicks > 0) : "A value <= 0 will not reload the scene";
        if (gameTicks > this.gameTicksUntilSceneReload) {
            this.gameTicksUntilSceneReload = gameTicks;
        }
    }

    public void abortSceneReload() {
        this.gameTicksUntilSceneReload = 0;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        String key;
        if (!event.getGroup().equals("hd")) {
            return;
        }
        switch (key = event.getKey()) {
            case "inventoryAnimationsHD": {
                this.client.setTexturesInventoryAnimated(this.config.itemInventoryAnimations());
                break;
            }
            case "shadowMode": 
            case "enableShadowTransparency": {
                this.clientThread.invoke(() -> {
                    this.modelPusher.clearModelCache();
                    this.recompilePrograms();
                    this.shutdownShadowMapFbo();
                    this.initShadowMapFbo();
                });
                break;
            }
            case "shadowResolution": {
                this.clientThread.invoke(() -> {
                    this.shutdownShadowMapFbo();
                    this.initShadowMapFbo();
                });
                break;
            }
            case "textureResolution": 
            case "hdInfernalTexture": 
            case "winterTheme0": {
                this.configHdInfernalTexture = this.config.hdInfernalTexture();
                this.textureManager.freeTextures();
            }
            case "hideBakedEffects": 
            case "groundBlending": 
            case "groundTextures": 
            case "objectTextures": 
            case "tzhaarHD": 
            case "reduceOverExposure": {
                this.configHideBakedEffects = this.config.hideBakedEffects();
                this.configGroundBlending = this.config.groundBlending();
                this.configGroundTextures = this.config.groundTextures();
                this.configModelTextures = this.config.objectTextures();
                this.configTzhaarHD = this.config.tzhaarHD();
                this.configWinterTheme = this.config.winterTheme();
                this.configReduceOverExposure = this.config.enableLegacyGreyColors();
                this.clientThread.invoke(() -> {
                    this.modelPusher.clearModelCache();
                    this.uploadScene();
                });
                break;
            }
            case "projectileLights": {
                this.configProjectileLights = this.config.projectileLights();
                break;
            }
            case "npcLights": {
                this.configNpcLights = this.config.npcLights();
                break;
            }
            case "expandShadowDraw": {
                this.configExpandShadowDraw = this.config.expandShadowDraw();
                break;
            }
            case "maxDynamicLights": {
                this.clientThread.invoke(() -> {
                    this.configMaxDynamicLights = this.config.maxDynamicLights().getValue();
                    this.recompilePrograms();
                });
                break;
            }
            case "anisotropicFilteringLevel": {
                this.textureManager.freeTextures();
                break;
            }
            case "uiScalingMode": 
            case "colorBlindMode": 
            case "parallaxMappingMode": 
            case "macosIntelWorkaround": 
            case "vanillaColorBanding": {
                this.clientThread.invoke(this::recompilePrograms);
                break;
            }
            case "unlockFps": 
            case "vsyncMode": 
            case "fpsTarget": {
                log.debug("Rebuilding sync mode");
                this.clientThread.invoke(this::setupSyncMode);
                break;
            }
            case "useModelCaching": 
            case "modelCacheSizeMiB": {
                this.configEnableModelCaching = this.config.enableModelCaching();
                this.clientThread.invoke(() -> {
                    this.modelPusher.shutDown();
                    this.modelPusher.startUp();
                });
                break;
            }
            case "useModelBatching": {
                this.configEnableModelBatching = this.config.enableModelBatching();
            }
        }
    }

    private void setupSyncMode() {
        int swapInterval;
        boolean unlockFps = this.config.unlockFps();
        this.client.setUnlockedFps(unlockFps);
        HdPluginConfig.SyncMode syncMode = unlockFps ? this.config.syncMode() : HdPluginConfig.SyncMode.OFF;
        switch (syncMode) {
            case ON: {
                swapInterval = 1;
                break;
            }
            case ADAPTIVE: {
                swapInterval = -1;
                break;
            }
            default: {
                swapInterval = 0;
            }
        }
        int actualSwapInterval = this.awtContext.setSwapInterval(swapInterval);
        if (actualSwapInterval != swapInterval) {
            log.info("unsupported swap interval {}, got {}", (Object)swapInterval, (Object)actualSwapInterval);
        }
        this.client.setUnlockedFpsTarget(actualSwapInterval == 0 ? this.config.fpsTarget() : 0);
        this.checkGLErrors();
    }

    private boolean isOutsideViewport(Model model, int pitchSin, int pitchCos, int yawSin, int yawCos, int x, int y, int z) {
        int yheight;
        int ybottom;
        int ry;
        int var20;
        int var17;
        int rx;
        int var16;
        model.calculateBoundsCylinder();
        int XYZMag = model.getXYZMag();
        int bottomY = model.getBottomY();
        int zoom = this.configShadowsEnabled && this.configExpandShadowDraw ? this.client.get3dZoom() / 2 : this.client.get3dZoom();
        int modelHeight = model.getModelHeight();
        int Rasterizer3D_clipMidX2 = this.client.getRasterizer3D_clipMidX2();
        int Rasterizer3D_clipNegativeMidX = this.client.getRasterizer3D_clipNegativeMidX();
        int Rasterizer3D_clipNegativeMidY = this.client.getRasterizer3D_clipNegativeMidY();
        int Rasterizer3D_clipMidY2 = this.client.getRasterizer3D_clipMidY2();
        int var11 = yawCos * z - yawSin * x >> 16;
        int var12 = pitchSin * y + pitchCos * var11 >> 16;
        int var13 = pitchCos * XYZMag >> 16;
        int depth = var12 + var13;
        if (depth > 50 && (var16 = ((rx = z * yawSin + yawCos * x >> 16) - XYZMag) * zoom) / depth < Rasterizer3D_clipMidX2 && (var17 = (rx + XYZMag) * zoom) / depth > Rasterizer3D_clipNegativeMidX && (var20 = ((ry = pitchCos * y - var11 * pitchSin >> 16) + (ybottom = (pitchCos * bottomY >> 16) + (yheight = pitchSin * XYZMag >> 16))) * zoom) / depth > Rasterizer3D_clipNegativeMidY) {
            int ytop = (pitchCos * modelHeight >> 16) + yheight;
            int var22 = (ry - ytop) * zoom;
            return var22 / depth >= Rasterizer3D_clipMidY2;
        }
        return true;
    }

    @Override
    public void draw(Renderable renderable, int orientation, int pitchSin, int pitchCos, int yawSin, int yawCos, int x, int y, int z, long hash) {
        Model model;
        if (this.modelOverrideManager.shouldHideModel(hash, x, z)) {
            return;
        }
        Model model2 = model = renderable instanceof Model ? (Model)renderable : renderable.getModel();
        if (model == null || model.getFaceCount() == 0) {
            return;
        }
        assert (this.sceneContext != null);
        if (model.getSceneId() == this.sceneContext.id) {
            model.calculateBoundsCylinder();
            if (this.isOutsideViewport(model, pitchSin, pitchCos, yawSin, yawCos, x, y, z)) {
                return;
            }
            if ((model.getBufferOffset() & 3) == 3) {
                return;
            }
            this.client.checkClickbox(model, orientation, pitchSin, pitchCos, yawSin, yawCos, x, y, z, hash);
            int faceCount = Math.min(6144, model.getFaceCount());
            int uvOffset = model.getUvBufferOffset();
            HdPlugin.eightIntWrite[0] = model.getBufferOffset() >> 2;
            HdPlugin.eightIntWrite[1] = uvOffset;
            HdPlugin.eightIntWrite[2] = faceCount;
            HdPlugin.eightIntWrite[3] = this.renderBufferOffset;
            HdPlugin.eightIntWrite[4] = model.getRadius() << 12 | orientation;
            HdPlugin.eightIntWrite[5] = x + this.client.getCameraX2();
            HdPlugin.eightIntWrite[6] = y + this.client.getCameraY2();
            HdPlugin.eightIntWrite[7] = z + this.client.getCameraZ2();
            this.bufferForTriangles(faceCount).ensureCapacity(8).put(eightIntWrite);
            this.renderBufferOffset += faceCount * 3;
        } else {
            if (model != renderable) {
                renderable.setModelHeight(model.getModelHeight());
            }
            model.calculateBoundsCylinder();
            if (this.isOutsideViewport(model, pitchSin, pitchCos, yawSin, yawCos, x, y, z)) {
                return;
            }
            if ((model.getBufferOffset() & 3) == 3) {
                return;
            }
            this.client.checkClickbox(model, orientation, pitchSin, pitchCos, yawSin, yawCos, x, y, z, hash);
            HdPlugin.eightIntWrite[3] = this.renderBufferOffset;
            HdPlugin.eightIntWrite[4] = model.getRadius() << 12 | orientation;
            HdPlugin.eightIntWrite[5] = x + this.client.getCameraX2();
            HdPlugin.eightIntWrite[6] = y + this.client.getCameraY2();
            HdPlugin.eightIntWrite[7] = z + this.client.getCameraZ2();
            TempModelInfo tempModelInfo = null;
            int batchHash = 0;
            if (this.configEnableModelBatching || this.configEnableModelCaching) {
                this.modelHasher.setModel(model);
                if (this.configEnableModelBatching) {
                    batchHash = this.modelHasher.calculateBatchHash();
                    tempModelInfo = this.frameModelInfoMap.get(batchHash);
                }
            }
            if (tempModelInfo != null && tempModelInfo.getFaceCount() == model.getFaceCount()) {
                HdPlugin.eightIntWrite[0] = tempModelInfo.getTempOffset();
                HdPlugin.eightIntWrite[1] = tempModelInfo.getTempUvOffset();
                HdPlugin.eightIntWrite[2] = tempModelInfo.getFaceCount();
                this.bufferForTriangles(tempModelInfo.getFaceCount()).ensureCapacity(8).put(eightIntWrite);
                this.renderBufferOffset += tempModelInfo.getFaceCount() * 3;
            } else {
                int vertexOffset = this.dynamicOffsetVertices + this.sceneContext.getVertexOffset();
                int uvOffset = this.dynamicOffsetUvs + this.sceneContext.getUvOffset();
                ModelOverride modelOverride = this.modelOverrideManager.getOverride(hash);
                this.modelPusher.pushModel(this.sceneContext, null, hash, model, modelOverride, ObjectType.NONE, 0, true);
                int faceCount = this.sceneContext.modelPusherResults[0] / 3;
                if (this.sceneContext.modelPusherResults[1] <= 0) {
                    uvOffset = -1;
                }
                HdPlugin.eightIntWrite[0] = vertexOffset;
                HdPlugin.eightIntWrite[1] = uvOffset;
                HdPlugin.eightIntWrite[2] = faceCount;
                this.bufferForTriangles(faceCount).ensureCapacity(8).put(eightIntWrite);
                this.renderBufferOffset += this.sceneContext.modelPusherResults[0];
                if (this.configEnableModelBatching) {
                    tempModelInfo = new TempModelInfo();
                    tempModelInfo.setTempOffset(vertexOffset).setTempUvOffset(uvOffset).setFaceCount(faceCount);
                    this.frameModelInfoMap.put(batchHash, tempModelInfo);
                }
            }
        }
    }

    @Override
    public boolean drawFace(Model model, int face) {
        return false;
    }

    private GpuIntBuffer bufferForTriangles(int triangles) {
        if (triangles <= 512) {
            ++this.numModelsSmall;
            return this.modelBufferSmall;
        }
        ++this.numModelsLarge;
        return this.modelBufferLarge;
    }

    private int getScaledValue(double scale, int value) {
        return (int)((double)value * scale + 0.5);
    }

    private void glDpiAwareViewport(int x, int y, int width, int height) {
        if (OSType.getOSType() == OSType.MacOS) {
            GL43C.glViewport(x, y, width, height);
        } else {
            GraphicsConfiguration graphicsConfiguration = this.clientUI.getGraphicsConfiguration();
            if (graphicsConfiguration == null) {
                return;
            }
            AffineTransform t2 = graphicsConfiguration.getDefaultTransform();
            GL43C.glViewport(this.getScaledValue(t2.getScaleX(), x), this.getScaledValue(t2.getScaleY(), y), this.getScaledValue(t2.getScaleX(), width), this.getScaledValue(t2.getScaleY(), height));
        }
    }

    private int getDrawDistance() {
        return HDUtils.clamp(this.config.drawDistance(), 0, 90);
    }

    public int[] getCameraFocalPoint() {
        int camX = this.client.getOculusOrbFocalPointX();
        int camY = this.client.getOculusOrbFocalPointY();
        int camPitch = this.client.getCameraPitch();
        int minCamPitch = 128;
        int maxCamPitch = 512;
        int camPitchDiff = 384;
        float camHeight = (float)(camPitch - 128) / (float)camPitchDiff;
        int camHeightDiff = 2200;
        int camZ = (int)((float)this.client.getCameraZ() + camHeight * 2200.0f);
        return new int[]{camX, camY, camZ};
    }

    private void updateBuffer(@Nonnull GLBuffer glBuffer, int target, @Nonnull ByteBuffer data2, int usage, long clFlags) {
        GL43C.glBindBuffer(target, glBuffer.glBufferId);
        long size = data2.remaining();
        if (size > glBuffer.size) {
            size = HDUtils.ceilPow2(size);
            log.debug("Buffer resize: {} {} -> {}", glBuffer, glBuffer.size, size);
            glBuffer.size = size;
            GL43C.glBufferData(target, size, usage);
            this.recreateCLBuffer(glBuffer, clFlags);
        }
        GL43C.glBufferSubData(target, 0L, data2);
    }

    private void updateBuffer(@Nonnull GLBuffer glBuffer, int target, @Nonnull IntBuffer data2, int usage, long clFlags) {
        this.updateBuffer(glBuffer, target, 0, data2, usage, clFlags);
    }

    private void updateBuffer(@Nonnull GLBuffer glBuffer, int target, int offset, @Nonnull IntBuffer data2, int usage, long clFlags) {
        long size = 4L * (long)(offset + data2.remaining());
        if (size > glBuffer.size) {
            size = HDUtils.ceilPow2(size);
            log.debug("Buffer resize: {} {} -> {}", glBuffer, glBuffer.size, size);
            if (offset > 0) {
                int oldBuffer = glBuffer.glBufferId;
                glBuffer.glBufferId = GL43C.glGenBuffers();
                GL43C.glBindBuffer(target, glBuffer.glBufferId);
                GL43C.glBufferData(target, size, usage);
                GL43C.glBindBuffer(36662, oldBuffer);
                GL43C.glCopyBufferSubData(36662, target, 0L, 0L, (long)offset * 4L);
                GL43C.glDeleteBuffers(oldBuffer);
            } else {
                GL43C.glBindBuffer(target, glBuffer.glBufferId);
                GL43C.glBufferData(target, size, usage);
            }
            glBuffer.size = size;
            this.recreateCLBuffer(glBuffer, clFlags);
        } else {
            GL43C.glBindBuffer(target, glBuffer.glBufferId);
        }
        GL43C.glBufferSubData(target, (long)offset * 4L, data2);
    }

    private void updateBuffer(@Nonnull GLBuffer glBuffer, int target, @Nonnull FloatBuffer data2, int usage, long clFlags) {
        this.updateBuffer(glBuffer, target, 0, data2, usage, clFlags);
    }

    private void updateBuffer(@Nonnull GLBuffer glBuffer, int target, int offset, @Nonnull FloatBuffer data2, int usage, long clFlags) {
        long size = 4L * (long)(offset + data2.remaining());
        if (size > glBuffer.size) {
            size = HDUtils.ceilPow2(size);
            log.debug("Buffer resize: {} {} -> {}", glBuffer, glBuffer.size, size);
            if (offset > 0) {
                int oldBuffer = glBuffer.glBufferId;
                glBuffer.glBufferId = GL43C.glGenBuffers();
                GL43C.glBindBuffer(target, glBuffer.glBufferId);
                GL43C.glBufferData(target, size, usage);
                GL43C.glBindBuffer(36662, oldBuffer);
                GL43C.glCopyBufferSubData(36662, target, 0L, 0L, (long)offset * 4L);
                GL43C.glDeleteBuffers(oldBuffer);
            } else {
                GL43C.glBindBuffer(target, glBuffer.glBufferId);
                GL43C.glBufferData(target, size, usage);
            }
            glBuffer.size = size;
            this.recreateCLBuffer(glBuffer, clFlags);
        } else {
            GL43C.glBindBuffer(target, glBuffer.glBufferId);
        }
        GL43C.glBufferSubData(target, (long)offset * 4L, data2);
    }

    private void updateBuffer(@Nonnull GLBuffer glBuffer, int target, long size, int usage, long clFlags) {
        if (size > glBuffer.size) {
            size = HDUtils.ceilPow2(size);
            log.debug("Buffer resize: {} {} -> {}", glBuffer, glBuffer.size, size);
            glBuffer.size = size;
            GL43C.glBindBuffer(target, glBuffer.glBufferId);
            GL43C.glBufferData(target, size, usage);
            this.recreateCLBuffer(glBuffer, clFlags);
        }
    }

    private void recreateCLBuffer(GLBuffer glBuffer, long clFlags) {
        if (this.computeMode == ComputeMode.OPENCL) {
            if (glBuffer.cl_mem != null) {
                CL.clReleaseMemObject(glBuffer.cl_mem);
            }
            if (glBuffer.size == 0L) {
                glBuffer.cl_mem = null;
            } else {
                assert (glBuffer.size > 0L) : "Size -1 should not reach this point";
                glBuffer.cl_mem = CL.clCreateFromGLBuffer(this.openCLManager.context, clFlags, glBuffer.glBufferId, null);
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.gameTicksUntilSceneReload > 0 && --this.gameTicksUntilSceneReload == 0) {
            this.uploadScene();
        }
        if (!this.hasLoggedIn && this.client.getGameState() == GameState.LOGGED_IN) {
            this.hasLoggedIn = true;
        }
    }

    private void checkGLErrors() {
        if (!log.isDebugEnabled()) {
            return;
        }
        int err;
        while ((err = GL43C.glGetError()) != 0) {
            String errStr;
            switch (err) {
                case 1280: {
                    errStr = "INVALID_ENUM";
                    break;
                }
                case 1281: {
                    errStr = "INVALID_VALUE";
                    break;
                }
                case 1282: {
                    errStr = "INVALID_OPERATION";
                    break;
                }
                case 1286: {
                    errStr = "INVALID_FRAMEBUFFER_OPERATION";
                    break;
                }
                default: {
                    errStr = String.valueOf(err);
                }
            }
            log.debug("glGetError:", new Exception(errStr));
        }
        return;
    }

    private void displayUpdateMessage() {
        int messageId = 1;
        if (this.config.getPluginUpdateMessage() >= messageId) {
            return;
        }
    }

    public Gson getGson() {
        return this.gson;
    }

    public HdPlugin setInGauntlet(boolean isInGauntlet) {
        this.isInGauntlet = isInGauntlet;
        return this;
    }
}

