/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.model;

import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Model;
import net.runelite.client.plugins.hd.data.materials.UvType;
import net.runelite.client.plugins.hd.scene.model_overrides.ModelOverride;

@Singleton
public class ModelHasher {
    private Model model;
    private int faceCount;
    private int faceColorsOneHash;
    private int faceColorsTwoHash;
    private int faceColorsThreeHash;
    private int faceTransparenciesHash;
    private int faceTexturesHash;
    private int textureTrianglesHash;
    private int xVerticesHash;
    private int yVerticesHash;
    private int zVerticesHash;
    private int faceIndicesOneHash;
    private int faceIndicesTwoHash;
    private int faceIndicesThreeHash;

    public void setModel(Model model) {
        this.model = model;
        this.faceCount = model.getFaceCount();
        this.faceColorsOneHash = ModelHasher.fastIntHash(model.getFaceColors1(), -1);
        this.faceColorsTwoHash = ModelHasher.fastIntHash(model.getFaceColors2(), -1);
        this.faceColorsThreeHash = ModelHasher.fastIntHash(model.getFaceColors3(), -1);
        this.faceTransparenciesHash = ModelHasher.fastByteHash(model.getFaceTransparencies());
        this.faceTexturesHash = ModelHasher.fastShortHash(model.getFaceTextures());
        this.textureTrianglesHash = 0;
        int[] textureFaces = model.getTextureFaces();
        if (textureFaces != null) {
            boolean hasVanillaTexturedFaces = false;
            for (int textureId : textureFaces) {
                if (textureId == -1) continue;
                hasVanillaTexturedFaces = true;
                break;
            }
            if (hasVanillaTexturedFaces) {
                int[] texIndices1 = model.getTexIndices1();
                int[] texIndices2 = model.getTexIndices2();
                int[] texIndices3 = model.getTexIndices3();
                int[] vertexX = model.getVerticesX();
                int[] vertexY = model.getVerticesY();
                int[] vertexZ = model.getVerticesZ();
                int h2 = 0;
                for (int i = 0; i < model.getFaceCount(); ++i) {
                    int texFace = textureFaces[i];
                    if (texFace == -1) continue;
                    int texA = texIndices1[texFace &= 0xFF];
                    int texB = texIndices2[texFace];
                    int texC = texIndices3[texFace];
                    h2 = h2 * 31 + vertexX[texA];
                    h2 = h2 * 31 + vertexY[texA];
                    h2 = h2 * 31 + vertexZ[texA];
                    h2 = h2 * 31 + vertexX[texB];
                    h2 = h2 * 31 + vertexY[texB];
                    h2 = h2 * 31 + vertexZ[texB];
                    h2 = h2 * 31 + vertexX[texC];
                    h2 = h2 * 31 + vertexY[texC];
                    h2 = h2 * 31 + vertexZ[texC];
                }
                this.textureTrianglesHash = h2;
            }
        }
        this.xVerticesHash = ModelHasher.fastIntHash(model.getVerticesX(), model.getVerticesCount());
        this.yVerticesHash = ModelHasher.fastIntHash(model.getVerticesY(), model.getVerticesCount());
        this.zVerticesHash = ModelHasher.fastIntHash(model.getVerticesZ(), model.getVerticesCount());
        this.faceIndicesOneHash = ModelHasher.fastIntHash(model.getFaceIndices1(), -1);
        this.faceIndicesTwoHash = ModelHasher.fastIntHash(model.getFaceIndices2(), -1);
        this.faceIndicesThreeHash = ModelHasher.fastIntHash(model.getFaceIndices3(), -1);
    }

    public int calculateVertexCacheHash() {
        return ModelHasher.fastIntHash(new int[]{this.faceCount, this.faceColorsOneHash, this.faceColorsTwoHash, this.faceColorsThreeHash, this.faceTransparenciesHash, this.faceTexturesHash, this.textureTrianglesHash, this.model.getOverrideAmount(), this.model.getOverrideHue(), this.model.getOverrideSaturation(), this.model.getOverrideLuminance(), this.faceIndicesOneHash, this.faceIndicesTwoHash, this.faceIndicesThreeHash, this.xVerticesHash, this.yVerticesHash, this.zVerticesHash}, -1);
    }

    public int calculateNormalCacheHash() {
        return ModelHasher.fastIntHash(new int[]{this.faceCount, this.faceIndicesOneHash, this.faceIndicesTwoHash, this.faceIndicesThreeHash, ModelHasher.fastIntHash(this.model.getVertexNormalsX(), -1), ModelHasher.fastIntHash(this.model.getVertexNormalsY(), -1), ModelHasher.fastIntHash(this.model.getVertexNormalsZ(), -1)}, -1);
    }

    public int calculateUvCacheHash(int orientation, @NonNull ModelOverride modelOverride) {
        if (modelOverride == null) {
            throw new NullPointerException("modelOverride is marked non-null but is null");
        }
        int h2 = this.faceCount;
        h2 = h2 * 31 + (modelOverride.uvType == UvType.VANILLA ? this.textureTrianglesHash : 0);
        h2 = h2 * 31 + (modelOverride.uvType.orientationDependent ? orientation : 0);
        h2 = h2 * 31 + modelOverride.hashCode();
        h2 = h2 * 31 + this.faceTexturesHash;
        return h2;
    }

    public int calculateBatchHash() {
        return this.calculateVertexCacheHash();
    }

    public static int fastIntHash(int[] a, int actualLength) {
        if (a == null) {
            return 0;
        }
        int i = 0;
        int r = 1;
        int length = a.length;
        if (actualLength != -1) {
            length = actualLength;
        }
        while (i + 5 < length) {
            r = 887503681 * r + 28629151 * a[i] + 923521 * a[i + 1] + 29791 * a[i + 2] + 961 * a[i + 3] + 31 * a[i + 4] + a[i + 5];
            i += 6;
        }
        while (i < length) {
            r = 31 * r + a[i];
            ++i;
        }
        return r;
    }

    public static int fastByteHash(byte[] a) {
        if (a == null) {
            return 0;
        }
        int i = 0;
        int r = 1;
        while (i + 5 < a.length) {
            r = 887503681 * r + 28629151 * a[i] + 923521 * a[i + 1] + 29791 * a[i + 2] + 961 * a[i + 3] + 31 * a[i + 4] + a[i + 5];
            i += 6;
        }
        while (i < a.length) {
            r = 31 * r + a[i];
            ++i;
        }
        return r;
    }

    public static int fastShortHash(int[] a) {
        if (a == null) {
            return 0;
        }
        int i = 0;
        int r = 1;
        while (i + 5 < a.length) {
            r = 887503681 * r + 28629151 * a[i] + 923521 * a[i + 1] + 29791 * a[i + 2] + 961 * a[i + 3] + 31 * a[i + 4] + a[i + 5];
            i += 6;
        }
        while (i < a.length) {
            r = 31 * r + a[i];
            ++i;
        }
        return r;
    }

    public static int fastFloatHash(float[] a) {
        if (a == null) {
            return 0;
        }
        int i = 0;
        int r = 1;
        while (i + 5 < a.length) {
            r = 887503681 * r + 28629151 * Float.floatToIntBits(a[i]) + 923521 * Float.floatToIntBits(a[i + 1]) + 29791 * Float.floatToIntBits(a[i + 2]) + 961 * Float.floatToIntBits(a[i + 3]) + 31 * Float.floatToIntBits(a[i + 4]) + Float.floatToIntBits(a[i + 5]);
            i += 6;
        }
        while (i < a.length) {
            r = 31 * r + Float.floatToIntBits(a[i]);
            ++i;
        }
        return r;
    }
}

