/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.model;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.Model;
import net.runelite.api.Player;
import net.runelite.api.Scene;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Tile;
import net.runelite.api.kit.KitType;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.plugins.hd.HdPlugin;
import net.runelite.client.plugins.hd.HdPluginConfig;
import net.runelite.client.plugins.hd.data.WaterType;
import net.runelite.client.plugins.hd.data.materials.Material;
import net.runelite.client.plugins.hd.data.materials.Overlay;
import net.runelite.client.plugins.hd.data.materials.Underlay;
import net.runelite.client.plugins.hd.data.materials.UvType;
import net.runelite.client.plugins.hd.model.ModelCache;
import net.runelite.client.plugins.hd.model.ModelHasher;
import net.runelite.client.plugins.hd.scene.ProceduralGenerator;
import net.runelite.client.plugins.hd.scene.SceneContext;
import net.runelite.client.plugins.hd.scene.SceneUploader;
import net.runelite.client.plugins.hd.scene.model_overrides.InheritTileColorType;
import net.runelite.client.plugins.hd.scene.model_overrides.ModelOverride;
import net.runelite.client.plugins.hd.scene.model_overrides.ObjectType;
import net.runelite.client.plugins.hd.scene.model_overrides.TzHaarRecolorType;
import net.runelite.client.plugins.hd.utils.HDUtils;
import net.runelite.client.plugins.hd.utils.ModelHash;
import net.runelite.client.plugins.hd.utils.PopupUtils;
import net.runelite.client.util.LinkBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ModelPusher {
    private static final Logger log = LoggerFactory.getLogger(ModelPusher.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private HdPlugin plugin;
    @Inject
    private HdPluginConfig config;
    @Inject
    private ModelHasher modelHasher;
    public static final int DATUM_PER_FACE = 12;
    public static final int BYTES_PER_DATUM = 4;
    public static final int MAX_MATERIAL_COUNT = 1023;
    private static final int IGNORE_LOW_LIGHTNESS = 3;
    private static final float LIGHTNESS_MULTIPLIER = 3.0f;
    private static final int BASE_LIGHTEN = 10;
    private static final int[] INT_ZEROS = new int[12];
    private static final float[] FLOAT_ZEROS = new float[12];
    private ModelCache modelCache;

    public void startUp() {
        if (Material.values().length - 1 >= 1023) {
            throw new IllegalStateException("Too many materials (" + Material.values().length + ") to fit into packed material data.");
        }
        if (this.config.enableModelCaching()) {
            int size = this.config.modelCacheSizeMiB();
            try {
                this.modelCache = new ModelCache(size);
            }
            catch (Throwable err) {
                log.error("Error while initializing model cache. Stopping the plugin...", err);
                if (err instanceof OutOfMemoryError) {
                    String arch = System.getProperty("sun.arch.data.model", "Unknown");
                    PopupUtils.displayPopupMessage(this.client, "117HD Error", "117HD ran out of memory while trying to allocate the model cache.<br><br>" + (String)(arch.equals("32") ? "You are currently using the 32-bit RuneLite launcher, which heavily restricts<br>the amount of memory RuneLite is allowed to use.<br>Please install the 64-bit launcher from <a href=\"https://runelite.net\">RuneLite's website</a> and try again.<br>" : (String)(size <= 2048 ? "" : "Your cache size of " + size + " MiB is " + (size >= 4096 ? "very large. We would recommend reducing it.<br>" : "bigger than the default size. Try reducing it.<br>")) + "Normally, a cache size above 2048 MiB is unnecessary, and the game should<br>run acceptably even at 1024 MiB. If you end up having to reduce the size far<br>below 512 MiB, you may be better off disabling the model cache entirely.<br>") + "<br>You can also try closing some other programs on your PC to free up memory.<br><br>If you need further assistance, please join our <a href=\"https://discord.gg/EVpDNJTKG4\">Discord</a> server, and<br>drag and drop your client log file into one of our support channels.", new String[]{"Open log folder", "Ok, let me try that..."}, i -> {
                        if (i == 0) {
                            LinkBrowser.open(RuneLite.LOGS_DIR.toString());
                        }
                    });
                }
                this.clientThread.invokeLater(this.plugin::stopPlugin);
            }
        }
    }

    public void shutDown() {
        if (this.modelCache != null) {
            this.modelCache.destroy();
            this.modelCache = null;
        }
    }

    public void clearModelCache() {
        if (this.modelCache != null) {
            this.modelCache.clear();
        }
    }

    public void pushModel(SceneContext sceneContext, @Nullable Tile tile, long hash, Model model, @NonNull ModelOverride modelOverride, ObjectType objectType, int preOrientation, boolean shouldCache) {
        if (modelOverride == null) {
            throw new NullPointerException("modelOverride is marked non-null but is null");
        }
        if (this.modelCache == null) {
            shouldCache = false;
        }
        int faceCount = Math.min(model.getFaceCount(), 6144);
        int bufferSize = faceCount * 12;
        int vertexLength = 0;
        int uvLength = 0;
        boolean useMaterialOverrides = this.plugin.configModelTextures || modelOverride.forceOverride;
        int[] faceTextures = model.getFaceTextures();
        int[] textureFaces = model.getTextureFaces();
        boolean isVanillaTextured = faceTextures != null;
        boolean isVanillaUVMapped = isVanillaTextured && model.getTexIndices1() != null && model.getTexIndices2() != null && model.getTexIndices3() != null && model.getTextureFaces() != null;
        Material baseMaterial = Material.NONE;
        Material textureMaterial = Material.NONE;
        if (useMaterialOverrides) {
            baseMaterial = modelOverride.baseMaterial;
            textureMaterial = modelOverride.textureMaterial;
        }
        boolean skipUVs = !isVanillaTextured && baseMaterial == Material.NONE && this.packMaterialData(Material.NONE, modelOverride, UvType.GEOMETRY, false) == 0;
        sceneContext.stagingBufferVertices.ensureCapacity(bufferSize);
        sceneContext.stagingBufferNormals.ensureCapacity(bufferSize);
        if (!skipUVs) {
            sceneContext.stagingBufferUvs.ensureCapacity(bufferSize);
        }
        boolean foundCachedVertexData = false;
        boolean foundCachedNormalData = false;
        boolean foundCachedUvData = skipUVs;
        int vertexDataCacheHash = 0;
        int normalDataCacheHash = 0;
        int uvDataCacheHash = 0;
        if (shouldCache) {
            FloatBuffer normalData;
            vertexDataCacheHash = this.modelHasher.calculateVertexCacheHash();
            IntBuffer vertexData = this.modelCache.getVertexData(vertexDataCacheHash);
            boolean bl = foundCachedVertexData = vertexData != null && vertexData.remaining() == bufferSize;
            if (foundCachedVertexData) {
                vertexLength = faceCount * 3;
                sceneContext.stagingBufferVertices.put(vertexData);
                vertexData.rewind();
            }
            boolean bl2 = foundCachedNormalData = (normalData = this.modelCache.getNormalData(normalDataCacheHash = this.modelHasher.calculateNormalCacheHash())) != null && normalData.remaining() == bufferSize;
            if (foundCachedNormalData) {
                sceneContext.stagingBufferNormals.put(normalData);
                normalData.rewind();
            }
            if (!foundCachedUvData) {
                uvDataCacheHash = this.modelHasher.calculateUvCacheHash(preOrientation, modelOverride);
                FloatBuffer uvData = this.modelCache.getUvData(uvDataCacheHash);
                boolean bl3 = foundCachedUvData = uvData != null && uvData.remaining() == bufferSize;
                if (foundCachedUvData) {
                    uvLength = faceCount * 3;
                    sceneContext.stagingBufferUvs.put(uvData);
                    uvData.rewind();
                }
            }
            if (foundCachedVertexData && foundCachedNormalData && foundCachedUvData) {
                sceneContext.modelPusherResults[0] = vertexLength;
                sceneContext.modelPusherResults[1] = uvLength;
                return;
            }
        }
        IntBuffer fullVertexData = null;
        FloatBuffer fullNormalData = null;
        FloatBuffer fullUvData = null;
        boolean shouldCacheVertexData = false;
        boolean shouldCacheNormalData = false;
        boolean shouldCacheUvData = false;
        if (shouldCache) {
            shouldCacheVertexData = !foundCachedVertexData;
            shouldCacheNormalData = !foundCachedNormalData;
            boolean bl = shouldCacheUvData = !foundCachedUvData;
            if (shouldCacheVertexData && (fullVertexData = this.modelCache.takeIntBuffer(bufferSize)) == null) {
                log.error("failed to grab vertex buffer");
                shouldCacheVertexData = false;
            }
            if (shouldCacheNormalData && (fullNormalData = this.modelCache.takeFloatBuffer(bufferSize)) == null) {
                log.error("failed to grab normal buffer");
                shouldCacheNormalData = false;
            }
            if (shouldCacheUvData && (fullUvData = this.modelCache.takeFloatBuffer(bufferSize)) == null) {
                log.error("failed to grab uv buffer");
                shouldCacheUvData = false;
            }
        }
        for (int face = 0; face < faceCount; ++face) {
            boolean isFaceVanillaTextured;
            int textureId;
            if (!foundCachedVertexData) {
                this.getFaceVertices(sceneContext, tile, hash, model, modelOverride, objectType, face);
                sceneContext.stagingBufferVertices.put(sceneContext.modelFaceVertices);
                vertexLength += 3;
                if (shouldCacheVertexData) {
                    fullVertexData.put(sceneContext.modelFaceVertices);
                }
            }
            if (!foundCachedNormalData) {
                this.getNormalDataForFace(sceneContext, model, modelOverride, face);
                sceneContext.stagingBufferNormals.put(sceneContext.modelFaceNormals);
                if (shouldCacheNormalData) {
                    fullNormalData.put(sceneContext.modelFaceNormals);
                }
            }
            if (foundCachedUvData) continue;
            Material material = baseMaterial;
            int n = textureId = isVanillaTextured ? faceTextures[face] : -1;
            if (textureId != -1 && (material = textureMaterial) == Material.NONE) {
                material = Material.getTexture(textureId);
            }
            UvType uvType = modelOverride.uvType;
            boolean bl = isFaceVanillaTextured = isVanillaUVMapped && textureId != -1 && textureFaces[face] != -1;
            if (uvType == UvType.VANILLA && !isFaceVanillaTextured) {
                uvType = UvType.GEOMETRY;
            }
            int materialData = this.packMaterialData(material, modelOverride, uvType, false);
            float[] uvData = sceneContext.modelFaceNormals;
            if (materialData == 0) {
                Arrays.fill(uvData, 0.0f);
            } else {
                modelOverride.fillUvsForFace(uvData, model, preOrientation, uvType, face);
                uvData[7] = uvData[11] = (float)materialData;
                uvData[3] = uvData[11];
            }
            sceneContext.stagingBufferUvs.put(uvData);
            if (shouldCacheUvData) {
                fullUvData.put(uvData);
            }
            uvLength += 3;
        }
        if (shouldCacheVertexData) {
            fullVertexData.flip();
            this.modelCache.putVertexData(vertexDataCacheHash, fullVertexData);
        }
        if (shouldCacheNormalData) {
            fullNormalData.flip();
            this.modelCache.putNormalData(normalDataCacheHash, fullNormalData);
        }
        if (shouldCacheUvData) {
            fullUvData.flip();
            this.modelCache.putUvData(uvDataCacheHash, fullUvData);
        }
        sceneContext.modelPusherResults[0] = vertexLength;
        sceneContext.modelPusherResults[1] = uvLength;
    }

    private void getNormalDataForFace(SceneContext sceneContext, Model model, @NonNull ModelOverride modelOverride, int face) {
        if (modelOverride == null) {
            throw new NullPointerException("modelOverride is marked non-null but is null");
        }
        int terrainData = SceneUploader.packTerrainData(false, 0, WaterType.NONE, 0);
        if (terrainData == 0 && (modelOverride.flatNormals || model.getFaceColors3()[face] == -1)) {
            Arrays.fill(sceneContext.modelFaceNormals, 0.0f);
            return;
        }
        int triA = model.getFaceIndices1()[face];
        int triB = model.getFaceIndices2()[face];
        int triC = model.getFaceIndices3()[face];
        int[] xVertexNormals = model.getVertexNormalsX();
        int[] yVertexNormals = model.getVertexNormalsY();
        int[] zVertexNormals = model.getVertexNormalsZ();
        sceneContext.modelFaceNormals[0] = xVertexNormals[triA];
        sceneContext.modelFaceNormals[1] = yVertexNormals[triA];
        sceneContext.modelFaceNormals[2] = zVertexNormals[triA];
        sceneContext.modelFaceNormals[3] = terrainData;
        sceneContext.modelFaceNormals[4] = xVertexNormals[triB];
        sceneContext.modelFaceNormals[5] = yVertexNormals[triB];
        sceneContext.modelFaceNormals[6] = zVertexNormals[triB];
        sceneContext.modelFaceNormals[7] = terrainData;
        sceneContext.modelFaceNormals[8] = xVertexNormals[triC];
        sceneContext.modelFaceNormals[9] = yVertexNormals[triC];
        sceneContext.modelFaceNormals[10] = zVertexNormals[triC];
        sceneContext.modelFaceNormals[11] = terrainData;
    }

    public int packMaterialData(Material material, @NonNull ModelOverride modelOverride, UvType uvType, boolean isOverlay) {
        if (modelOverride == null) {
            throw new NullPointerException("modelOverride is marked non-null but is null");
        }
        return (material.ordinal() & 0x3FF) << 12 | ((int)(modelOverride.shadowOpacityThreshold * 63.0f) & 0x3F) << 5 | (!modelOverride.receiveShadows ? 1 : 0) << 4 | (modelOverride.flatNormals ? 1 : 0) << 3 | (uvType.worldUvs ? 1 : 0) << 2 | (uvType == UvType.VANILLA ? 1 : 0) << 1 | (isOverlay ? 1 : 0);
    }

    private boolean isBakedGroundShading(int face, int heightA, int heightB, int heightC, byte[] faceTransparencies, int[] faceTextures) {
        return faceTransparencies != null && heightA >= -8 && heightA == heightB && heightA == heightC && (faceTextures == null || faceTextures[face] == -1) && (faceTransparencies[face] & 0xFF) > 100;
    }

    private void getFaceVertices(SceneContext sceneContext, Tile tile, long hash, Model model, @NonNull ModelOverride modelOverride, ObjectType objectType, int face) {
        if (modelOverride == null) {
            throw new NullPointerException("modelOverride is marked non-null but is null");
        }
        Scene scene = sceneContext.scene;
        int triA = model.getFaceIndices1()[face];
        int triB = model.getFaceIndices2()[face];
        int triC = model.getFaceIndices3()[face];
        byte[] faceTransparencies = model.getFaceTransparencies();
        int[] faceTextures = model.getFaceTextures();
        int[] xVertices = model.getVerticesX();
        int[] yVertices = model.getVerticesY();
        int[] zVertices = model.getVerticesZ();
        int[] xVertexNormals = model.getVertexNormalsX();
        int[] yVertexNormals = model.getVertexNormalsY();
        int[] zVertexNormals = model.getVertexNormalsZ();
        byte overrideAmount = model.getOverrideAmount();
        byte overrideHue = model.getOverrideHue();
        byte overrideSat = model.getOverrideSaturation();
        byte overrideLum = model.getOverrideLuminance();
        int heightA = yVertices[triA];
        int heightB = yVertices[triB];
        int heightC = yVertices[triC];
        int color1 = model.getFaceColors1()[face];
        int color2 = model.getFaceColors2()[face];
        int color3 = model.getFaceColors3()[face];
        if (this.plugin.configHideBakedEffects && this.isBakedGroundShading(face, heightA, heightB, heightC, faceTransparencies, faceTextures)) {
            boolean removeBakedLighting = modelOverride.removeBakedLighting;
            if (ModelHash.getType(hash) == 0) {
                Player player;
                int index = ModelHash.getIdOrIndex(hash);
                Player[] players = this.client.getCachedPlayers();
                Player player2 = player = index >= 0 && index < players.length ? players[index] : null;
                if (player != null && player.getPlayerComposition().getEquipmentId(KitType.WEAPON) == 5614) {
                    removeBakedLighting = true;
                }
            }
            if (removeBakedLighting) {
                color3 = -2;
            }
        }
        if (color3 == -2) {
            Arrays.fill(sceneContext.modelFaceVertices, 0);
            return;
        }
        if (color3 == -1) {
            color2 = color3 = color1;
        } else if ((faceTextures == null || faceTextures[face] == -1) && overrideAmount > 0) {
            color1 = ModelPusher.interpolateHSL(color1, overrideHue, overrideSat, overrideLum, overrideAmount);
            color2 = ModelPusher.interpolateHSL(color2, overrideHue, overrideSat, overrideLum, overrideAmount);
            color3 = ModelPusher.interpolateHSL(color3, overrideHue, overrideSat, overrideLum, overrideAmount);
        }
        int color1H = color1 >> 10 & 0x3F;
        int color1S = color1 >> 7 & 7;
        int color1L = color1 & 0x7F;
        int color2H = color2 >> 10 & 0x3F;
        int color2S = color2 >> 7 & 7;
        int color2L = color2 & 0x7F;
        int color3H = color3 >> 10 & 0x3F;
        int color3S = color3 >> 7 & 7;
        int color3L = color3 & 0x7F;
        if (modelOverride.flatNormals) {
            float[] T = new float[]{xVertices[triA] - xVertices[triB], yVertices[triA] - yVertices[triB], zVertices[triA] - zVertices[triB]};
            float[] B = new float[]{xVertices[triA] - xVertices[triC], yVertices[triA] - yVertices[triC], zVertices[triA] - zVertices[triC]};
            float[] N2 = new float[]{T[1] * B[2] - T[2] * B[1], T[2] * B[0] - T[0] * B[2], T[0] * B[1] - T[1] * B[0]};
            float length = (float)Math.sqrt(N2[0] * N2[0] + N2[1] * N2[1] + N2[2] * N2[2]);
            if (length < 1.1920929E-7f) {
                N2[2] = 0.0f;
                N2[1] = 0.0f;
                N2[0] = 0.0f;
            } else {
                N2[0] = N2[0] / length;
                N2[1] = N2[1] / length;
                N2[2] = N2[2] / length;
            }
            float[] L = HDUtils.lightDirModel;
            float lightDotNormal = Math.max(0.0f, N2[0] * L[0] + N2[1] * L[1] + N2[2] * L[2]);
            int lightenA = (int)((float)Math.max(color1L - 3, 0) * 3.0f) + 10;
            color1L = (int)HDUtils.lerp(color1L, lightenA, lightDotNormal);
            int lightenB = (int)((float)Math.max(color2L - 3, 0) * 3.0f) + 10;
            color2L = (int)HDUtils.lerp(color2L, lightenB, lightDotNormal);
            int lightenC = (int)((float)Math.max(color3L - 3, 0) * 3.0f) + 10;
            color3L = (int)HDUtils.lerp(color3L, lightenC, lightDotNormal);
        } else {
            int lightenA = (int)((float)Math.max(color1L - 3, 0) * 3.0f) + 10;
            float dotA = Math.max(0.0f, HDUtils.dotLightDirectionModel(xVertexNormals[triA], yVertexNormals[triA], zVertexNormals[triA]));
            color1L = (int)HDUtils.lerp(color1L, lightenA, dotA);
            int lightenB = (int)((float)Math.max(color2L - 3, 0) * 3.0f) + 10;
            float dotB = Math.max(0.0f, HDUtils.dotLightDirectionModel(xVertexNormals[triB], yVertexNormals[triB], zVertexNormals[triB]));
            color2L = (int)HDUtils.lerp(color2L, lightenB, dotB);
            int lightenC = (int)((float)Math.max(color3L - 3, 0) * 3.0f) + 10;
            float dotC = Math.max(0.0f, HDUtils.dotLightDirectionModel(xVertexNormals[triC], yVertexNormals[triC], zVertexNormals[triC]));
            color3L = (int)HDUtils.lerp(color3L, lightenC, dotC);
        }
        int maxBrightness1 = 55;
        int maxBrightness2 = 55;
        int maxBrightness3 = 55;
        if (!this.plugin.configReduceOverExposure) {
            maxBrightness1 = (int)HDUtils.lerp(127.0f, maxBrightness1, (float)Math.pow((float)color1S / 7.0f, 0.05));
            maxBrightness2 = (int)HDUtils.lerp(127.0f, maxBrightness2, (float)Math.pow((float)color2S / 7.0f, 0.05));
            maxBrightness3 = (int)HDUtils.lerp(127.0f, maxBrightness3, (float)Math.pow((float)color3S / 7.0f, 0.05));
        }
        if (faceTextures != null && faceTextures[face] != -1) {
            color3H = 0;
            color2H = 0;
            color1H = 0;
            color3S = 0;
            color2S = 0;
            color1S = 0;
            color3L = 127;
            color2L = 127;
            color1L = 127;
            maxBrightness3 = 90;
            maxBrightness2 = 90;
            maxBrightness1 = 90;
        }
        if (tile != null && modelOverride.inheritTileColorType != InheritTileColorType.NONE) {
            SceneTileModel tileModel = tile.getSceneTileModel();
            SceneTilePaint tilePaint = tile.getSceneTilePaint();
            if (tilePaint != null || tileModel != null) {
                if (tilePaint != null && tilePaint.getTexture() == -1 && tilePaint.getRBG() != 0 && tilePaint.getNeColor() != 12345678) {
                    int[] tileColorHSL = HDUtils.colorIntToHSL(tilePaint.getNeColor());
                    tileColorHSL[1] = (tileColorHSL[1] + HDUtils.colorIntToHSL(tilePaint.getSeColor())[1] + HDUtils.colorIntToHSL(tilePaint.getNwColor())[1] + HDUtils.colorIntToHSL(tilePaint.getNeColor())[1]) / 4;
                    tileColorHSL[2] = (tileColorHSL[2] + HDUtils.colorIntToHSL(tilePaint.getSeColor())[2] + HDUtils.colorIntToHSL(tilePaint.getNwColor())[2] + HDUtils.colorIntToHSL(tilePaint.getNeColor())[2]) / 4;
                    Overlay overlay = Overlay.getOverlay(scene, tile, this.plugin);
                    if (overlay != Overlay.NONE) {
                        overlay.modifyColor(tileColorHSL);
                    } else {
                        Underlay underlay = Underlay.getUnderlay(scene, tile, this.plugin);
                        underlay.modifyColor(tileColorHSL);
                    }
                    color2H = color3H = tileColorHSL[0];
                    color1H = color3H;
                    color2S = color3S = tileColorHSL[1];
                    color1S = color3S;
                    color2L = color3L = tileColorHSL[2];
                    color1L = color3L;
                } else if (tileModel != null && tileModel.getTriangleTextureId() == null) {
                    int color;
                    int faceColorIndex = -1;
                    for (int i = 0; i < tileModel.getTriangleColorA().length; ++i) {
                        boolean isOverlayFace = ProceduralGenerator.isOverlayFace(tile, i);
                        if (modelOverride.inheritTileColorType == InheritTileColorType.UNDERLAY || tileModel.getModelOverlay() == 0) {
                            if (isOverlayFace) continue;
                            faceColorIndex = i;
                            break;
                        }
                        if (modelOverride.inheritTileColorType != InheritTileColorType.OVERLAY || !isOverlayFace) continue;
                        faceColorIndex = i;
                        break;
                    }
                    if (faceColorIndex != -1 && (color = tileModel.getTriangleColorA()[faceColorIndex]) != 12345678) {
                        int[] tileColorHSL = HDUtils.colorIntToHSL(color);
                        Underlay underlay = Underlay.getUnderlay(scene, tile, this.plugin);
                        underlay.modifyColor(tileColorHSL);
                        color2H = color3H = tileColorHSL[0];
                        color1H = color3H;
                        color2S = color3S = tileColorHSL[1];
                        color1S = color3S;
                        color2L = color3L = tileColorHSL[2];
                        color1L = color3L;
                    }
                }
            }
        }
        int packedAlphaPriority = this.getPackedAlphaPriority(model, face);
        if (this.plugin.configTzhaarHD && modelOverride.tzHaarRecolorType != TzHaarRecolorType.NONE) {
            int[][] tzHaarRecolored = ProceduralGenerator.recolorTzHaar(modelOverride, heightA, heightB, heightC, packedAlphaPriority, objectType, color1S, color1L, color2S, color2L, color3S, color3L);
            color1H = tzHaarRecolored[0][0];
            color1S = tzHaarRecolored[0][1];
            color1L = tzHaarRecolored[0][2];
            color2H = tzHaarRecolored[1][0];
            color2S = tzHaarRecolored[1][1];
            color2L = tzHaarRecolored[1][2];
            color3H = tzHaarRecolored[2][0];
            color3S = tzHaarRecolored[2][1];
            color3L = tzHaarRecolored[2][2];
            packedAlphaPriority = tzHaarRecolored[3][0];
        }
        color1L = HDUtils.clamp(color1L, 0, maxBrightness1);
        color2L = HDUtils.clamp(color2L, 0, maxBrightness2);
        color3L = HDUtils.clamp(color3L, 0, maxBrightness3);
        color1 = (color1H << 3 | color1S) << 7 | color1L;
        color2 = (color2H << 3 | color2S) << 7 | color2L;
        color3 = (color3H << 3 | color3S) << 7 | color3L;
        sceneContext.modelFaceVertices[0] = xVertices[triA];
        sceneContext.modelFaceVertices[1] = yVertices[triA];
        sceneContext.modelFaceVertices[2] = zVertices[triA];
        sceneContext.modelFaceVertices[3] = packedAlphaPriority | color1;
        sceneContext.modelFaceVertices[4] = xVertices[triB];
        sceneContext.modelFaceVertices[5] = yVertices[triB];
        sceneContext.modelFaceVertices[6] = zVertices[triB];
        sceneContext.modelFaceVertices[7] = packedAlphaPriority | color2;
        sceneContext.modelFaceVertices[8] = xVertices[triC];
        sceneContext.modelFaceVertices[9] = yVertices[triC];
        sceneContext.modelFaceVertices[10] = zVertices[triC];
        sceneContext.modelFaceVertices[11] = packedAlphaPriority | color3;
    }

    private static int interpolateHSL(int hsl, byte hue2, byte sat2, byte lum2, byte lerp) {
        int hue = hsl >> 10 & 0x3F;
        int sat = hsl >> 7 & 7;
        int lum = hsl & 0x7F;
        int var9 = lerp & 0xFF;
        if (hue2 != -1) {
            hue += var9 * (hue2 - hue) >> 7;
        }
        if (sat2 != -1) {
            sat += var9 * (sat2 - sat) >> 7;
        }
        if (lum2 != -1) {
            lum += var9 * (lum2 - lum) >> 7;
        }
        return (hue << 10 | sat << 7 | lum) & 0xFFFF;
    }

    private int getPackedAlphaPriority(Model model, int face) {
        int[] faceTextures = model.getFaceTextures();
        byte[] faceTransparencies = model.getFaceTransparencies();
        byte[] facePriorities = model.getFaceRenderPriorities();
        int alpha = 0;
        if (faceTransparencies != null && (faceTextures == null || faceTextures[face] == -1)) {
            alpha = (faceTransparencies[face] & 0xFF) << 24;
        }
        int priority = 0;
        if (facePriorities != null) {
            priority = (facePriorities[face] & 0xFF) << 16;
        }
        return alpha | priority;
    }
}

