/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.scene;

import com.google.common.base.Stopwatch;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.GroundObject;
import net.runelite.api.Model;
import net.runelite.api.Point;
import net.runelite.api.Renderable;
import net.runelite.api.Scene;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Tile;
import net.runelite.api.WallObject;
import net.runelite.client.plugins.hd.HdPlugin;
import net.runelite.client.plugins.hd.HdPluginConfig;
import net.runelite.client.plugins.hd.data.WaterType;
import net.runelite.client.plugins.hd.data.materials.GroundMaterial;
import net.runelite.client.plugins.hd.data.materials.Material;
import net.runelite.client.plugins.hd.data.materials.Overlay;
import net.runelite.client.plugins.hd.data.materials.Underlay;
import net.runelite.client.plugins.hd.data.materials.UvType;
import net.runelite.client.plugins.hd.model.ModelPusher;
import net.runelite.client.plugins.hd.scene.ModelOverrideManager;
import net.runelite.client.plugins.hd.scene.ProceduralGenerator;
import net.runelite.client.plugins.hd.scene.SceneContext;
import net.runelite.client.plugins.hd.scene.model_overrides.ModelOverride;
import net.runelite.client.plugins.hd.scene.model_overrides.ObjectType;
import net.runelite.client.plugins.hd.utils.HDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SceneUploader {
    private static final Logger log = LoggerFactory.getLogger(SceneUploader.class);
    private static final float[] UP_NORMAL = new float[]{0.0f, -1.0f, 0.0f};
    @Inject
    private Client client;
    @Inject
    private HdPlugin plugin;
    @Inject
    private HdPluginConfig config;
    @Inject
    public ProceduralGenerator proceduralGenerator;
    @Inject
    private ModelPusher modelPusher;
    @Inject
    private ModelOverrideManager modelOverrideManager;

    public void upload(SceneContext sceneContext) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (int z = 0; z < 4; ++z) {
            for (int x = 0; x < 104; ++x) {
                for (int y = 0; y < 104; ++y) {
                    Tile tile = sceneContext.scene.getTiles()[z][x][y];
                    if (tile == null) continue;
                    this.upload(sceneContext, tile);
                }
            }
        }
        stopwatch.stop();
        log.debug("Scene upload time: {}", (Object)stopwatch);
    }

    private void uploadModel(SceneContext sceneContext, Tile tile, long hash, Model model, int orientation, ObjectType objectType) {
        if (model.getSceneId() == sceneContext.id) {
            return;
        }
        Scene scene = sceneContext.scene;
        Point tilePoint = tile.getSceneLocation();
        int tileX = tilePoint.getX();
        int tileY = tilePoint.getY();
        int skipObject = 0;
        if (scene.getBaseX() + tileX == 2558 && scene.getBaseY() + tileY >= 3249 && scene.getBaseY() + tileY <= 3252) {
            skipObject = 3;
        }
        ModelOverride modelOverride = this.modelOverrideManager.getOverride(hash);
        model.setBufferOffset(sceneContext.getVertexOffset() << 2 | skipObject);
        model.setUvBufferOffset(sceneContext.getUvOffset());
        this.modelPusher.pushModel(sceneContext, tile, hash, model, modelOverride, objectType, orientation, false);
        if (sceneContext.modelPusherResults[1] == 0) {
            model.setUvBufferOffset(-1);
        }
        model.setSceneId(sceneContext.id);
    }

    private void upload(SceneContext sceneContext, Tile tile) {
        GameObject[] gameObjects;
        DecorativeObject decorativeObject;
        Renderable renderable;
        GroundObject groundObject;
        WallObject wallObject;
        SceneTileModel sceneTileModel;
        SceneTilePaint sceneTilePaint;
        Tile bridge = tile.getBridge();
        if (bridge != null) {
            this.upload(sceneContext, bridge);
        }
        if ((sceneTilePaint = tile.getSceneTilePaint()) != null) {
            sceneTilePaint.setBufferOffset(sceneContext.getVertexOffset());
            sceneTilePaint.setUvBufferOffset(sceneContext.getUvOffset());
            int[] uploadedTilePaintData = this.upload(sceneContext, tile, sceneTilePaint);
            int bufferLength = uploadedTilePaintData[0];
            int uvBufferLength = uploadedTilePaintData[1];
            int underwaterTerrain = uploadedTilePaintData[2];
            if (uvBufferLength <= 0) {
                sceneTilePaint.setUvBufferOffset(-1);
            }
            int packedBufferLength = bufferLength << 1 | underwaterTerrain;
            sceneTilePaint.setBufferLen(packedBufferLength);
        }
        if ((sceneTileModel = tile.getSceneTileModel()) != null) {
            sceneTileModel.setBufferOffset(sceneContext.getVertexOffset());
            sceneTileModel.setUvBufferOffset(sceneContext.getUvOffset());
            int[] uploadedTileModelData = this.upload(sceneContext, tile, sceneTileModel);
            int bufferLength = uploadedTileModelData[0];
            int uvBufferLength = uploadedTileModelData[1];
            int underwaterTerrain = uploadedTileModelData[2];
            if (uvBufferLength <= 0) {
                sceneTileModel.setUvBufferOffset(-1);
            }
            int packedBufferLength = bufferLength << 1 | underwaterTerrain;
            sceneTileModel.setBufferLen(packedBufferLength);
        }
        if ((wallObject = tile.getWallObject()) != null) {
            Renderable renderable2;
            Renderable renderable1 = wallObject.getRenderable1();
            if (renderable1 instanceof Model) {
                this.uploadModel(sceneContext, tile, wallObject.getHash(), (Model)renderable1, HDUtils.convertWallObjectOrientation(wallObject.getOrientationA()), ObjectType.WALL_OBJECT);
            }
            if ((renderable2 = wallObject.getRenderable2()) instanceof Model) {
                this.uploadModel(sceneContext, tile, wallObject.getHash(), (Model)renderable2, HDUtils.convertWallObjectOrientation(wallObject.getOrientationB()), ObjectType.WALL_OBJECT);
            }
        }
        if ((groundObject = tile.getGroundObject()) != null && (renderable = groundObject.getRenderable()) instanceof Model) {
            this.uploadModel(sceneContext, tile, groundObject.getHash(), (Model)renderable, HDUtils.extractConfigOrientation(groundObject.getConfig()), ObjectType.GROUND_OBJECT);
        }
        if ((decorativeObject = tile.getDecorativeObject()) != null) {
            Renderable renderable2;
            Renderable renderable3 = decorativeObject.getRenderable();
            if (renderable3 instanceof Model) {
                this.uploadModel(sceneContext, tile, decorativeObject.getHash(), (Model)renderable3, HDUtils.extractConfigOrientation(decorativeObject.getConfig()), ObjectType.DECORATIVE_OBJECT);
            }
            if ((renderable2 = decorativeObject.getRenderable2()) instanceof Model) {
                this.uploadModel(sceneContext, tile, decorativeObject.getHash(), (Model)renderable2, HDUtils.extractConfigOrientation(decorativeObject.getConfig()), ObjectType.DECORATIVE_OBJECT);
            }
        }
        for (GameObject gameObject : gameObjects = tile.getGameObjects()) {
            Renderable renderable4;
            if (gameObject == null || !((renderable4 = gameObject.getRenderable()) instanceof Model)) continue;
            this.uploadModel(sceneContext, tile, gameObject.getHash(), (Model)gameObject.getRenderable(), gameObject.getModelOrientation(), ObjectType.GAME_OBJECT);
        }
    }

    private int[] upload(SceneContext sceneContext, Tile tile, SceneTilePaint sceneTilePaint) {
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        int[] bufferLengths = this.uploadHDTilePaintSurface(sceneContext, tile, sceneTilePaint);
        bufferLength += bufferLengths[0];
        uvBufferLength += bufferLengths[1];
        underwaterTerrain += bufferLengths[2];
        bufferLengths = this.uploadHDTilePaintUnderwater(sceneContext, tile, sceneTilePaint);
        return new int[]{bufferLength += bufferLengths[0], uvBufferLength += bufferLengths[1], underwaterTerrain += bufferLengths[2]};
    }

    private int[] uploadHDTilePaintSurface(SceneContext sceneContext, Tile tile, SceneTilePaint sceneTilePaint) {
        Scene scene = sceneContext.scene;
        Point tilePoint = tile.getSceneLocation();
        int tileX = tilePoint.getX();
        int tileY = tilePoint.getY();
        int tileZ = tile.getRenderLevel();
        boolean localX = false;
        boolean localY = false;
        int baseX = scene.getBaseX();
        int baseY = scene.getBaseY();
        int[][][] tileHeights = scene.getTileHeights();
        int swHeight = tileHeights[tileZ][tileX][tileY];
        int seHeight = tileHeights[tileZ][tileX + 1][tileY];
        int neHeight = tileHeights[tileZ][tileX + 1][tileY + 1];
        int nwHeight = tileHeights[tileZ][tileX][tileY + 1];
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        int localSwVertexX = 0;
        int localSwVertexY = 0;
        int localSeVertexX = 128;
        int localSeVertexY = 0;
        int localNwVertexX = 0;
        int localNwVertexY = 128;
        int localNeVertexX = 128;
        int localNeVertexY = 128;
        int[] vertexKeys = ProceduralGenerator.tileVertexKeys(scene, tile);
        int swVertexKey = vertexKeys[0];
        int seVertexKey = vertexKeys[1];
        int nwVertexKey = vertexKeys[2];
        int neVertexKey = vertexKeys[3];
        if (sceneTilePaint.getNeColor() != 12345678) {
            int swColor = sceneTilePaint.getSwColor();
            int seColor = sceneTilePaint.getSeColor();
            int neColor = sceneTilePaint.getNeColor();
            int nwColor = sceneTilePaint.getNwColor();
            int tileTexture = sceneTilePaint.getTexture();
            boolean neVertexIsOverlay = false;
            boolean nwVertexIsOverlay = false;
            boolean seVertexIsOverlay = false;
            boolean swVertexIsOverlay = false;
            Material swMaterial = Material.NONE;
            Material seMaterial = Material.NONE;
            Material neMaterial = Material.NONE;
            Material nwMaterial = Material.NONE;
            float[] swNormals = UP_NORMAL;
            float[] seNormals = UP_NORMAL;
            float[] neNormals = UP_NORMAL;
            float[] nwNormals = UP_NORMAL;
            WaterType waterType = this.proceduralGenerator.tileWaterType(scene, tile, sceneTilePaint);
            if (waterType == WaterType.NONE) {
                swMaterial = Material.getTexture(tileTexture);
                seMaterial = Material.getTexture(tileTexture);
                neMaterial = Material.getTexture(tileTexture);
                nwMaterial = Material.getTexture(tileTexture);
                swNormals = sceneContext.vertexTerrainNormals.getOrDefault(swVertexKey, swNormals);
                seNormals = sceneContext.vertexTerrainNormals.getOrDefault(seVertexKey, seNormals);
                neNormals = sceneContext.vertexTerrainNormals.getOrDefault(neVertexKey, neNormals);
                nwNormals = sceneContext.vertexTerrainNormals.getOrDefault(nwVertexKey, nwNormals);
                if (this.plugin.configGroundBlending && !this.proceduralGenerator.useDefaultColor(scene, tile) && sceneTilePaint.getTexture() == -1) {
                    swColor = sceneContext.vertexTerrainColor.getOrDefault(swVertexKey, swColor);
                    seColor = sceneContext.vertexTerrainColor.getOrDefault(seVertexKey, seColor);
                    neColor = sceneContext.vertexTerrainColor.getOrDefault(neVertexKey, neColor);
                    nwColor = sceneContext.vertexTerrainColor.getOrDefault(nwVertexKey, nwColor);
                    if (this.plugin.configGroundTextures) {
                        swMaterial = sceneContext.vertexTerrainTexture.getOrDefault(swVertexKey, swMaterial);
                        seMaterial = sceneContext.vertexTerrainTexture.getOrDefault(seVertexKey, seMaterial);
                        neMaterial = sceneContext.vertexTerrainTexture.getOrDefault(neVertexKey, neMaterial);
                        nwMaterial = sceneContext.vertexTerrainTexture.getOrDefault(nwVertexKey, nwMaterial);
                    }
                } else if (this.plugin.configGroundTextures && !this.shouldSkipTile(baseX + tileX, baseY + tileY)) {
                    GroundMaterial groundMaterial;
                    Overlay overlay = Overlay.getOverlay(scene, tile, this.plugin);
                    if (overlay != Overlay.NONE) {
                        groundMaterial = overlay.groundMaterial;
                        swColor = HDUtils.colorHSLToInt(overlay.modifyColor(HDUtils.colorIntToHSL(swColor)));
                        seColor = HDUtils.colorHSLToInt(overlay.modifyColor(HDUtils.colorIntToHSL(seColor)));
                        nwColor = HDUtils.colorHSLToInt(overlay.modifyColor(HDUtils.colorIntToHSL(nwColor)));
                        neColor = HDUtils.colorHSLToInt(overlay.modifyColor(HDUtils.colorIntToHSL(neColor)));
                    } else {
                        Underlay underlay = Underlay.getUnderlay(scene, tile, this.plugin);
                        groundMaterial = underlay.groundMaterial;
                        swColor = HDUtils.colorHSLToInt(underlay.modifyColor(HDUtils.colorIntToHSL(swColor)));
                        seColor = HDUtils.colorHSLToInt(underlay.modifyColor(HDUtils.colorIntToHSL(seColor)));
                        nwColor = HDUtils.colorHSLToInt(underlay.modifyColor(HDUtils.colorIntToHSL(nwColor)));
                        neColor = HDUtils.colorHSLToInt(underlay.modifyColor(HDUtils.colorIntToHSL(neColor)));
                    }
                    swMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX, baseY + tileY);
                    seMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX + 1, baseY + tileY);
                    nwMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX, baseY + tileY + 1);
                    neMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX + 1, baseY + tileY + 1);
                } else if (this.plugin.configWinterTheme) {
                    Overlay overlay = Overlay.getOverlay(scene, tile, this.plugin);
                    if (overlay != Overlay.NONE) {
                        swColor = HDUtils.colorHSLToInt(overlay.modifyColor(HDUtils.colorIntToHSL(swColor)));
                        seColor = HDUtils.colorHSLToInt(overlay.modifyColor(HDUtils.colorIntToHSL(seColor)));
                        nwColor = HDUtils.colorHSLToInt(overlay.modifyColor(HDUtils.colorIntToHSL(nwColor)));
                        neColor = HDUtils.colorHSLToInt(overlay.modifyColor(HDUtils.colorIntToHSL(neColor)));
                    } else {
                        Underlay underlay = Underlay.getUnderlay(scene, tile, this.plugin);
                        swColor = HDUtils.colorHSLToInt(underlay.modifyColor(HDUtils.colorIntToHSL(swColor)));
                        seColor = HDUtils.colorHSLToInt(underlay.modifyColor(HDUtils.colorIntToHSL(seColor)));
                        nwColor = HDUtils.colorHSLToInt(underlay.modifyColor(HDUtils.colorIntToHSL(nwColor)));
                        neColor = HDUtils.colorHSLToInt(underlay.modifyColor(HDUtils.colorIntToHSL(neColor)));
                    }
                }
            } else {
                neColor = 127;
                nwColor = 127;
                seColor = 127;
                swColor = 127;
                if (sceneContext.vertexIsWater.containsKey(swVertexKey) && sceneContext.vertexIsLand.containsKey(swVertexKey)) {
                    swColor = 0;
                }
                if (sceneContext.vertexIsWater.containsKey(seVertexKey) && sceneContext.vertexIsLand.containsKey(seVertexKey)) {
                    seColor = 0;
                }
                if (sceneContext.vertexIsWater.containsKey(nwVertexKey) && sceneContext.vertexIsLand.containsKey(nwVertexKey)) {
                    nwColor = 0;
                }
                if (sceneContext.vertexIsWater.containsKey(neVertexKey) && sceneContext.vertexIsLand.containsKey(neVertexKey)) {
                    neColor = 0;
                }
            }
            if (sceneContext.vertexIsOverlay.containsKey(neVertexKey) && sceneContext.vertexIsUnderlay.containsKey(neVertexKey)) {
                neVertexIsOverlay = true;
            }
            if (sceneContext.vertexIsOverlay.containsKey(nwVertexKey) && sceneContext.vertexIsUnderlay.containsKey(nwVertexKey)) {
                nwVertexIsOverlay = true;
            }
            if (sceneContext.vertexIsOverlay.containsKey(seVertexKey) && sceneContext.vertexIsUnderlay.containsKey(seVertexKey)) {
                seVertexIsOverlay = true;
            }
            if (sceneContext.vertexIsOverlay.containsKey(swVertexKey) && sceneContext.vertexIsUnderlay.containsKey(swVertexKey)) {
                swVertexIsOverlay = true;
            }
            int swTerrainData = SceneUploader.packTerrainData(true, 0, waterType, tileZ);
            int seTerrainData = SceneUploader.packTerrainData(true, 0, waterType, tileZ);
            int nwTerrainData = SceneUploader.packTerrainData(true, 0, waterType, tileZ);
            int neTerrainData = SceneUploader.packTerrainData(true, 0, waterType, tileZ);
            sceneContext.stagingBufferNormals.ensureCapacity(24);
            sceneContext.stagingBufferNormals.put(neNormals[0], neNormals[2], neNormals[1], neTerrainData);
            sceneContext.stagingBufferNormals.put(nwNormals[0], nwNormals[2], nwNormals[1], nwTerrainData);
            sceneContext.stagingBufferNormals.put(seNormals[0], seNormals[2], seNormals[1], seTerrainData);
            sceneContext.stagingBufferNormals.put(swNormals[0], swNormals[2], swNormals[1], swTerrainData);
            sceneContext.stagingBufferNormals.put(seNormals[0], seNormals[2], seNormals[1], seTerrainData);
            sceneContext.stagingBufferNormals.put(nwNormals[0], nwNormals[2], nwNormals[1], nwTerrainData);
            sceneContext.stagingBufferVertices.ensureCapacity(24);
            sceneContext.stagingBufferVertices.put(localNeVertexX, neHeight, localNeVertexY, neColor);
            sceneContext.stagingBufferVertices.put(localNwVertexX, nwHeight, localNwVertexY, nwColor);
            sceneContext.stagingBufferVertices.put(localSeVertexX, seHeight, localSeVertexY, seColor);
            sceneContext.stagingBufferVertices.put(localSwVertexX, swHeight, localSwVertexY, swColor);
            sceneContext.stagingBufferVertices.put(localSeVertexX, seHeight, localSeVertexY, seColor);
            sceneContext.stagingBufferVertices.put(localNwVertexX, nwHeight, localNwVertexY, nwColor);
            bufferLength += 6;
            int packedMaterialDataSW = this.modelPusher.packMaterialData(swMaterial, ModelOverride.NONE, UvType.GEOMETRY, swVertexIsOverlay);
            int packedMaterialDataSE = this.modelPusher.packMaterialData(seMaterial, ModelOverride.NONE, UvType.GEOMETRY, seVertexIsOverlay);
            int packedMaterialDataNW = this.modelPusher.packMaterialData(nwMaterial, ModelOverride.NONE, UvType.GEOMETRY, nwVertexIsOverlay);
            int packedMaterialDataNE = this.modelPusher.packMaterialData(neMaterial, ModelOverride.NONE, UvType.GEOMETRY, neVertexIsOverlay);
            sceneContext.stagingBufferUvs.ensureCapacity(24);
            sceneContext.stagingBufferUvs.put(1.0f, 0.0f, 0.0f, packedMaterialDataNE);
            sceneContext.stagingBufferUvs.put(0.0f, 0.0f, 0.0f, packedMaterialDataNW);
            sceneContext.stagingBufferUvs.put(1.0f, 1.0f, 0.0f, packedMaterialDataSE);
            sceneContext.stagingBufferUvs.put(0.0f, 1.0f, 0.0f, packedMaterialDataSW);
            sceneContext.stagingBufferUvs.put(1.0f, 1.0f, 0.0f, packedMaterialDataSE);
            sceneContext.stagingBufferUvs.put(0.0f, 0.0f, 0.0f, packedMaterialDataNW);
            uvBufferLength += 6;
        }
        return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
    }

    private int[] uploadHDTilePaintUnderwater(SceneContext sceneContext, Tile tile, SceneTilePaint sceneTilePaint) {
        Scene scene = sceneContext.scene;
        Point tilePoint = tile.getSceneLocation();
        int tileX = tilePoint.getX();
        int tileY = tilePoint.getY();
        int tileZ = tile.getRenderLevel();
        int baseX = scene.getBaseX();
        int baseY = scene.getBaseY();
        if (baseX >= 2816 && baseX <= 2970 && baseY <= 5375 && baseY >= 5220) {
            return new int[]{0, 0, 0};
        }
        int[][][] tileHeights = scene.getTileHeights();
        int swHeight = tileHeights[tileZ][tileX][tileY];
        int seHeight = tileHeights[tileZ][tileX + 1][tileY];
        int neHeight = tileHeights[tileZ][tileX + 1][tileY + 1];
        int nwHeight = tileHeights[tileZ][tileX][tileY + 1];
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        int localSwVertexX = 0;
        int localSwVertexY = 0;
        int localSeVertexX = 128;
        int localSeVertexY = 0;
        int localNwVertexX = 0;
        int localNwVertexY = 128;
        int localNeVertexX = 128;
        int localNeVertexY = 128;
        int[] vertexKeys = ProceduralGenerator.tileVertexKeys(scene, tile);
        int swVertexKey = vertexKeys[0];
        int seVertexKey = vertexKeys[1];
        int nwVertexKey = vertexKeys[2];
        int neVertexKey = vertexKeys[3];
        if (sceneContext.tileIsWater[tileZ][tileX][tileY]) {
            underwaterTerrain = 1;
            int swColor = 6676;
            int seColor = 6676;
            int neColor = 6676;
            int nwColor = 6676;
            int swDepth = sceneContext.vertexUnderwaterDepth.getOrDefault(swVertexKey, 0);
            int seDepth = sceneContext.vertexUnderwaterDepth.getOrDefault(seVertexKey, 0);
            int nwDepth = sceneContext.vertexUnderwaterDepth.getOrDefault(nwVertexKey, 0);
            int neDepth = sceneContext.vertexUnderwaterDepth.getOrDefault(neVertexKey, 0);
            float[] swNormals = sceneContext.vertexTerrainNormals.getOrDefault(swVertexKey, UP_NORMAL);
            float[] seNormals = sceneContext.vertexTerrainNormals.getOrDefault(seVertexKey, UP_NORMAL);
            float[] nwNormals = sceneContext.vertexTerrainNormals.getOrDefault(nwVertexKey, UP_NORMAL);
            float[] neNormals = sceneContext.vertexTerrainNormals.getOrDefault(neVertexKey, UP_NORMAL);
            Material swMaterial = Material.NONE;
            Material seMaterial = Material.NONE;
            Material nwMaterial = Material.NONE;
            Material neMaterial = Material.NONE;
            if (this.plugin.configGroundTextures) {
                GroundMaterial groundMaterial = GroundMaterial.UNDERWATER_GENERIC;
                swMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX, baseY + tileY);
                seMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX + 1, baseY + tileY);
                nwMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX, baseY + tileY + 1);
                neMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX + 1, baseY + tileY + 1);
            }
            WaterType waterType = this.proceduralGenerator.tileWaterType(scene, tile, sceneTilePaint);
            int swTerrainData = SceneUploader.packTerrainData(true, Math.max(1, swDepth), waterType, tileZ);
            int seTerrainData = SceneUploader.packTerrainData(true, Math.max(1, seDepth), waterType, tileZ);
            int nwTerrainData = SceneUploader.packTerrainData(true, Math.max(1, nwDepth), waterType, tileZ);
            int neTerrainData = SceneUploader.packTerrainData(true, Math.max(1, neDepth), waterType, tileZ);
            sceneContext.stagingBufferNormals.ensureCapacity(24);
            sceneContext.stagingBufferNormals.put(neNormals[0], neNormals[2], neNormals[1], neTerrainData);
            sceneContext.stagingBufferNormals.put(nwNormals[0], nwNormals[2], nwNormals[1], nwTerrainData);
            sceneContext.stagingBufferNormals.put(seNormals[0], seNormals[2], seNormals[1], seTerrainData);
            sceneContext.stagingBufferNormals.put(swNormals[0], swNormals[2], swNormals[1], swTerrainData);
            sceneContext.stagingBufferNormals.put(seNormals[0], seNormals[2], seNormals[1], seTerrainData);
            sceneContext.stagingBufferNormals.put(nwNormals[0], nwNormals[2], nwNormals[1], nwTerrainData);
            sceneContext.stagingBufferVertices.ensureCapacity(24);
            sceneContext.stagingBufferVertices.put(localNeVertexX, neHeight + neDepth, localNeVertexY, neColor);
            sceneContext.stagingBufferVertices.put(localNwVertexX, nwHeight + nwDepth, localNwVertexY, nwColor);
            sceneContext.stagingBufferVertices.put(localSeVertexX, seHeight + seDepth, localSeVertexY, seColor);
            sceneContext.stagingBufferVertices.put(localSwVertexX, swHeight + swDepth, localSwVertexY, swColor);
            sceneContext.stagingBufferVertices.put(localSeVertexX, seHeight + seDepth, localSeVertexY, seColor);
            sceneContext.stagingBufferVertices.put(localNwVertexX, nwHeight + nwDepth, localNwVertexY, nwColor);
            bufferLength += 6;
            int packedMaterialDataSW = this.modelPusher.packMaterialData(swMaterial, ModelOverride.NONE, UvType.GEOMETRY, false);
            int packedMaterialDataSE = this.modelPusher.packMaterialData(seMaterial, ModelOverride.NONE, UvType.GEOMETRY, false);
            int packedMaterialDataNW = this.modelPusher.packMaterialData(nwMaterial, ModelOverride.NONE, UvType.GEOMETRY, false);
            int packedMaterialDataNE = this.modelPusher.packMaterialData(neMaterial, ModelOverride.NONE, UvType.GEOMETRY, false);
            sceneContext.stagingBufferUvs.ensureCapacity(24);
            sceneContext.stagingBufferUvs.put(1.0f, 0.0f, 0.0f, packedMaterialDataNE);
            sceneContext.stagingBufferUvs.put(0.0f, 0.0f, 0.0f, packedMaterialDataNW);
            sceneContext.stagingBufferUvs.put(1.0f, 1.0f, 0.0f, packedMaterialDataSE);
            sceneContext.stagingBufferUvs.put(0.0f, 1.0f, 0.0f, packedMaterialDataSW);
            sceneContext.stagingBufferUvs.put(1.0f, 1.0f, 0.0f, packedMaterialDataSE);
            sceneContext.stagingBufferUvs.put(0.0f, 0.0f, 0.0f, packedMaterialDataNW);
            uvBufferLength += 6;
        }
        return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
    }

    private int[] upload(SceneContext sceneContext, Tile tile, SceneTileModel sceneTileModel) {
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        int[] bufferLengths = this.uploadHDTileModelSurface(sceneContext, tile, sceneTileModel);
        bufferLength += bufferLengths[0];
        uvBufferLength += bufferLengths[1];
        underwaterTerrain += bufferLengths[2];
        bufferLengths = this.uploadHDTileModelUnderwater(sceneContext, tile, sceneTileModel);
        return new int[]{bufferLength += bufferLengths[0], uvBufferLength += bufferLengths[1], underwaterTerrain += bufferLengths[2]};
    }

    private int[] uploadHDTileModelSurface(SceneContext sceneContext, Tile tile, SceneTileModel sceneTileModel) {
        Scene scene = sceneContext.scene;
        Point tilePoint = tile.getSceneLocation();
        int tileX = tilePoint.getX();
        int tileY = tilePoint.getY();
        int tileZ = tile.getRenderLevel();
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        if (sceneContext.skipTile[tileZ][tileX][tileY]) {
            return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
        }
        int[] faceColorA = sceneTileModel.getTriangleColorA();
        int[] faceColorB = sceneTileModel.getTriangleColorB();
        int[] faceColorC = sceneTileModel.getTriangleColorC();
        int[] faceTextures = sceneTileModel.getTriangleTextureId();
        int faceCount = sceneTileModel.getFaceX().length;
        int baseX = scene.getBaseX();
        int baseY = scene.getBaseY();
        for (int face = 0; face < faceCount; ++face) {
            int colorA = faceColorA[face];
            int colorB = faceColorB[face];
            int colorC = faceColorC[face];
            if (colorA == 12345678) continue;
            int[][] localVertices = ProceduralGenerator.faceLocalVertices(tile, face);
            int[] vertexKeys = ProceduralGenerator.faceVertexKeys(tile, face);
            int vertexKeyA = vertexKeys[0];
            int vertexKeyB = vertexKeys[1];
            int vertexKeyC = vertexKeys[2];
            boolean vertexAIsOverlay = false;
            boolean vertexBIsOverlay = false;
            boolean vertexCIsOverlay = false;
            Material materialA = Material.NONE;
            Material materialB = Material.NONE;
            Material materialC = Material.NONE;
            float[] normalsA = UP_NORMAL;
            float[] normalsB = UP_NORMAL;
            float[] normalsC = UP_NORMAL;
            WaterType waterType = this.proceduralGenerator.faceWaterType(scene, tile, face, sceneTileModel);
            if (waterType == WaterType.NONE) {
                if (faceTextures != null) {
                    materialA = Material.getTexture(faceTextures[face]);
                    materialB = Material.getTexture(faceTextures[face]);
                    materialC = Material.getTexture(faceTextures[face]);
                }
                normalsA = sceneContext.vertexTerrainNormals.getOrDefault(vertexKeyA, normalsA);
                normalsB = sceneContext.vertexTerrainNormals.getOrDefault(vertexKeyB, normalsB);
                normalsC = sceneContext.vertexTerrainNormals.getOrDefault(vertexKeyC, normalsC);
                if (!(!this.plugin.configGroundBlending || ProceduralGenerator.isOverlayFace(tile, face) && this.proceduralGenerator.useDefaultColor(scene, tile) || materialA != Material.NONE)) {
                    colorA = sceneContext.vertexTerrainColor.getOrDefault(vertexKeyA, colorA);
                    colorB = sceneContext.vertexTerrainColor.getOrDefault(vertexKeyB, colorB);
                    colorC = sceneContext.vertexTerrainColor.getOrDefault(vertexKeyC, colorC);
                    if (this.plugin.configGroundTextures) {
                        materialA = sceneContext.vertexTerrainTexture.getOrDefault(vertexKeyA, materialA);
                        materialB = sceneContext.vertexTerrainTexture.getOrDefault(vertexKeyB, materialB);
                        materialC = sceneContext.vertexTerrainTexture.getOrDefault(vertexKeyC, materialC);
                    }
                } else if (this.plugin.configGroundTextures) {
                    GroundMaterial groundMaterial;
                    if (ProceduralGenerator.isOverlayFace(tile, face)) {
                        Overlay overlay = Overlay.getOverlay(scene, tile, this.plugin);
                        groundMaterial = overlay.groundMaterial;
                        colorA = HDUtils.colorHSLToInt(overlay.modifyColor(HDUtils.colorIntToHSL(colorA)));
                        colorB = HDUtils.colorHSLToInt(overlay.modifyColor(HDUtils.colorIntToHSL(colorB)));
                        colorC = HDUtils.colorHSLToInt(overlay.modifyColor(HDUtils.colorIntToHSL(colorC)));
                    } else {
                        Underlay underlay = Underlay.getUnderlay(scene, tile, this.plugin);
                        groundMaterial = underlay.groundMaterial;
                        colorA = HDUtils.colorHSLToInt(underlay.modifyColor(HDUtils.colorIntToHSL(colorA)));
                        colorB = HDUtils.colorHSLToInt(underlay.modifyColor(HDUtils.colorIntToHSL(colorB)));
                        colorC = HDUtils.colorHSLToInt(underlay.modifyColor(HDUtils.colorIntToHSL(colorC)));
                    }
                    materialA = groundMaterial.getRandomMaterial(tileZ, baseX + tileX + (int)Math.floor((float)localVertices[0][0] / 128.0f), baseY + tileY + (int)Math.floor((float)localVertices[0][1] / 128.0f));
                    materialB = groundMaterial.getRandomMaterial(tileZ, baseX + tileX + (int)Math.floor((float)localVertices[1][0] / 128.0f), baseY + tileY + (int)Math.floor((float)localVertices[1][1] / 128.0f));
                    materialC = groundMaterial.getRandomMaterial(tileZ, baseX + tileX + (int)Math.floor((float)localVertices[2][0] / 128.0f), baseY + tileY + (int)Math.floor((float)localVertices[2][1] / 128.0f));
                } else if (this.plugin.configWinterTheme) {
                    if (ProceduralGenerator.isOverlayFace(tile, face)) {
                        Overlay overlay = Overlay.getOverlay(scene, tile, this.plugin);
                        colorA = HDUtils.colorHSLToInt(overlay.modifyColor(HDUtils.colorIntToHSL(colorA)));
                        colorB = HDUtils.colorHSLToInt(overlay.modifyColor(HDUtils.colorIntToHSL(colorB)));
                        colorC = HDUtils.colorHSLToInt(overlay.modifyColor(HDUtils.colorIntToHSL(colorC)));
                    } else {
                        Underlay underlay = Underlay.getUnderlay(scene, tile, this.plugin);
                        colorA = HDUtils.colorHSLToInt(underlay.modifyColor(HDUtils.colorIntToHSL(colorA)));
                        colorB = HDUtils.colorHSLToInt(underlay.modifyColor(HDUtils.colorIntToHSL(colorB)));
                        colorC = HDUtils.colorHSLToInt(underlay.modifyColor(HDUtils.colorIntToHSL(colorC)));
                    }
                }
            } else {
                colorC = 127;
                colorB = 127;
                colorA = 127;
                if (sceneContext.vertexIsWater.containsKey(vertexKeyA) && sceneContext.vertexIsLand.containsKey(vertexKeyA)) {
                    colorA = 0;
                }
                if (sceneContext.vertexIsWater.containsKey(vertexKeyB) && sceneContext.vertexIsLand.containsKey(vertexKeyB)) {
                    colorB = 0;
                }
                if (sceneContext.vertexIsWater.containsKey(vertexKeyC) && sceneContext.vertexIsLand.containsKey(vertexKeyC)) {
                    colorC = 0;
                }
            }
            if (sceneContext.vertexIsOverlay.containsKey(vertexKeyA) && sceneContext.vertexIsUnderlay.containsKey(vertexKeyA)) {
                vertexAIsOverlay = true;
            }
            if (sceneContext.vertexIsOverlay.containsKey(vertexKeyB) && sceneContext.vertexIsUnderlay.containsKey(vertexKeyB)) {
                vertexBIsOverlay = true;
            }
            if (sceneContext.vertexIsOverlay.containsKey(vertexKeyC) && sceneContext.vertexIsUnderlay.containsKey(vertexKeyC)) {
                vertexCIsOverlay = true;
            }
            int aTerrainData = SceneUploader.packTerrainData(true, 0, waterType, tileZ);
            int bTerrainData = SceneUploader.packTerrainData(true, 0, waterType, tileZ);
            int cTerrainData = SceneUploader.packTerrainData(true, 0, waterType, tileZ);
            sceneContext.stagingBufferNormals.ensureCapacity(12);
            sceneContext.stagingBufferNormals.put(normalsA[0], normalsA[2], normalsA[1], aTerrainData);
            sceneContext.stagingBufferNormals.put(normalsB[0], normalsB[2], normalsB[1], bTerrainData);
            sceneContext.stagingBufferNormals.put(normalsC[0], normalsC[2], normalsC[1], cTerrainData);
            sceneContext.stagingBufferVertices.ensureCapacity(12);
            sceneContext.stagingBufferVertices.put(localVertices[0][0], localVertices[0][2], localVertices[0][1], colorA);
            sceneContext.stagingBufferVertices.put(localVertices[1][0], localVertices[1][2], localVertices[1][1], colorB);
            sceneContext.stagingBufferVertices.put(localVertices[2][0], localVertices[2][2], localVertices[2][1], colorC);
            bufferLength += 3;
            int packedMaterialDataA = this.modelPusher.packMaterialData(materialA, ModelOverride.NONE, UvType.GEOMETRY, vertexAIsOverlay);
            int packedMaterialDataB = this.modelPusher.packMaterialData(materialB, ModelOverride.NONE, UvType.GEOMETRY, vertexBIsOverlay);
            int packedMaterialDataC = this.modelPusher.packMaterialData(materialC, ModelOverride.NONE, UvType.GEOMETRY, vertexCIsOverlay);
            sceneContext.stagingBufferUvs.ensureCapacity(12);
            sceneContext.stagingBufferUvs.put((float)localVertices[0][0] / 128.0f, 1.0f - (float)localVertices[0][1] / 128.0f, 0.0f, packedMaterialDataA);
            sceneContext.stagingBufferUvs.put((float)localVertices[1][0] / 128.0f, 1.0f - (float)localVertices[1][1] / 128.0f, 0.0f, packedMaterialDataB);
            sceneContext.stagingBufferUvs.put((float)localVertices[2][0] / 128.0f, 1.0f - (float)localVertices[2][1] / 128.0f, 0.0f, packedMaterialDataC);
            uvBufferLength += 3;
        }
        return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
    }

    private int[] uploadHDTileModelUnderwater(SceneContext sceneContext, Tile tile, SceneTileModel sceneTileModel) {
        Scene scene = sceneContext.scene;
        Point tilePoint = tile.getSceneLocation();
        int tileX = tilePoint.getX();
        int tileY = tilePoint.getY();
        int tileZ = tile.getRenderLevel();
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        if (sceneContext.skipTile[tileZ][tileX][tileY]) {
            return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
        }
        int[] faceColorA = sceneTileModel.getTriangleColorA();
        int faceCount = sceneTileModel.getFaceX().length;
        int baseX = scene.getBaseX();
        int baseY = scene.getBaseY();
        if (baseX >= 2816 && baseX <= 2970 && baseY <= 5375 && baseY >= 5220) {
            return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
        }
        if (sceneContext.tileIsWater[tileZ][tileX][tileY]) {
            underwaterTerrain = 1;
            for (int face = 0; face < faceCount; ++face) {
                int colorA = 6676;
                int colorB = 6676;
                int colorC = 6676;
                if (faceColorA[face] == 12345678) continue;
                int[][] localVertices = ProceduralGenerator.faceLocalVertices(tile, face);
                Material materialA = Material.NONE;
                Material materialB = Material.NONE;
                Material materialC = Material.NONE;
                int[] vertexKeys = ProceduralGenerator.faceVertexKeys(tile, face);
                int vertexKeyA = vertexKeys[0];
                int vertexKeyB = vertexKeys[1];
                int vertexKeyC = vertexKeys[2];
                int depthA = sceneContext.vertexUnderwaterDepth.getOrDefault(vertexKeyA, 0);
                int depthB = sceneContext.vertexUnderwaterDepth.getOrDefault(vertexKeyB, 0);
                int depthC = sceneContext.vertexUnderwaterDepth.getOrDefault(vertexKeyC, 0);
                if (this.plugin.configGroundTextures) {
                    GroundMaterial groundMaterial = GroundMaterial.UNDERWATER_GENERIC;
                    int tileVertexX = Math.round((float)localVertices[0][0] / 128.0f) + tileX + baseX;
                    int tileVertexY = Math.round((float)localVertices[0][1] / 128.0f) + tileY + baseY;
                    materialA = groundMaterial.getRandomMaterial(tileZ, tileVertexX, tileVertexY);
                    tileVertexX = Math.round((float)localVertices[1][0] / 128.0f) + tileX + baseX;
                    tileVertexY = Math.round((float)localVertices[1][1] / 128.0f) + tileY + baseY;
                    materialB = groundMaterial.getRandomMaterial(tileZ, tileVertexX, tileVertexY);
                    tileVertexX = Math.round((float)localVertices[2][0] / 128.0f) + tileX + baseX;
                    tileVertexY = Math.round((float)localVertices[2][1] / 128.0f) + tileY + baseY;
                    materialC = groundMaterial.getRandomMaterial(tileZ, tileVertexX, tileVertexY);
                }
                float[] normalsA = sceneContext.vertexTerrainNormals.getOrDefault(vertexKeyA, UP_NORMAL);
                float[] normalsB = sceneContext.vertexTerrainNormals.getOrDefault(vertexKeyB, UP_NORMAL);
                float[] normalsC = sceneContext.vertexTerrainNormals.getOrDefault(vertexKeyC, UP_NORMAL);
                WaterType waterType = this.proceduralGenerator.faceWaterType(scene, tile, face, sceneTileModel);
                int aTerrainData = SceneUploader.packTerrainData(true, Math.max(1, depthA), waterType, tileZ);
                int bTerrainData = SceneUploader.packTerrainData(true, Math.max(1, depthB), waterType, tileZ);
                int cTerrainData = SceneUploader.packTerrainData(true, Math.max(1, depthC), waterType, tileZ);
                sceneContext.stagingBufferNormals.ensureCapacity(12);
                sceneContext.stagingBufferNormals.put(normalsA[0], normalsA[2], normalsA[1], aTerrainData);
                sceneContext.stagingBufferNormals.put(normalsB[0], normalsB[2], normalsB[1], bTerrainData);
                sceneContext.stagingBufferNormals.put(normalsC[0], normalsC[2], normalsC[1], cTerrainData);
                sceneContext.stagingBufferVertices.ensureCapacity(12);
                sceneContext.stagingBufferVertices.put(localVertices[0][0], localVertices[0][2] + depthA, localVertices[0][1], colorA);
                sceneContext.stagingBufferVertices.put(localVertices[1][0], localVertices[1][2] + depthB, localVertices[1][1], colorB);
                sceneContext.stagingBufferVertices.put(localVertices[2][0], localVertices[2][2] + depthC, localVertices[2][1], colorC);
                bufferLength += 3;
                int packedMaterialDataA = this.modelPusher.packMaterialData(materialA, ModelOverride.NONE, UvType.GEOMETRY, false);
                int packedMaterialDataB = this.modelPusher.packMaterialData(materialB, ModelOverride.NONE, UvType.GEOMETRY, false);
                int packedMaterialDataC = this.modelPusher.packMaterialData(materialC, ModelOverride.NONE, UvType.GEOMETRY, false);
                sceneContext.stagingBufferUvs.ensureCapacity(12);
                sceneContext.stagingBufferUvs.put((float)localVertices[0][0] / 128.0f, 1.0f - (float)localVertices[0][1] / 128.0f, 0.0f, packedMaterialDataA);
                sceneContext.stagingBufferUvs.put((float)localVertices[1][0] / 128.0f, 1.0f - (float)localVertices[1][1] / 128.0f, 0.0f, packedMaterialDataB);
                sceneContext.stagingBufferUvs.put((float)localVertices[2][0] / 128.0f, 1.0f - (float)localVertices[2][1] / 128.0f, 0.0f, packedMaterialDataC);
                uvBufferLength += 3;
            }
        }
        return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
    }

    private boolean shouldSkipTile(int worldX, int worldY) {
        return worldX == 2796 && worldY >= 2961 && worldY <= 2967;
    }

    public static int packTerrainData(boolean isTerrain, int waterDepth, WaterType waterType, int plane) {
        return waterDepth << 8 | waterType.ordinal() << 3 | plane << 1 | (isTerrain ? 1 : 0);
    }
}

