/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonUtils {
    private static final Logger log = LoggerFactory.getLogger(GsonUtils.class);
    @VisibleForTesting
    public static boolean THROW_WHEN_PARSING_FAILS = false;

    public static HashSet<Integer> parseIDArray(JsonReader in, @Nullable Class<?> idContainer) throws IOException {
        HashSet<Integer> ids = new HashSet<Integer>();
        in.beginArray();
        while (in.hasNext()) {
            switch (in.peek()) {
                case NUMBER: {
                    String message2;
                    try {
                        ids.add(in.nextInt());
                    }
                    catch (NumberFormatException ex) {
                        message2 = "Failed to parse int";
                        if (THROW_WHEN_PARSING_FAILS) {
                            throw new RuntimeException(message2, ex);
                        }
                        log.error(message2, ex);
                    }
                    break;
                }
                case STRING: {
                    String message;
                    String message2;
                    String fieldName = in.nextString();
                    if (idContainer == null) {
                        message2 = String.format("String '%s' is not supported by this parser", fieldName);
                        if (THROW_WHEN_PARSING_FAILS) {
                            throw new RuntimeException(message2);
                        }
                        log.error(message2);
                        break;
                    }
                    try {
                        Field field = idContainer.getField(fieldName);
                        if (!field.getType().equals(Integer.TYPE)) {
                            message = String.format("Field '%s' in %s is not an int", fieldName, idContainer.getName());
                            if (THROW_WHEN_PARSING_FAILS) {
                                throw new RuntimeException(message);
                            }
                            log.error(message);
                            break;
                        }
                        ids.add(field.getInt(null));
                        break;
                    }
                    catch (NoSuchFieldException ex) {
                        message = String.format("Missing key '%s' in %s", fieldName, idContainer.getName());
                        if (THROW_WHEN_PARSING_FAILS) {
                            throw new RuntimeException(message, ex);
                        }
                        log.error(message, ex);
                        break;
                    }
                    catch (IllegalAccessException ex) {
                        message = String.format("Unable to access field '%s' in %s", fieldName, idContainer.getName());
                        if (THROW_WHEN_PARSING_FAILS) {
                            throw new RuntimeException(message, ex);
                        }
                        log.error(message, ex);
                    }
                }
            }
        }
        in.endArray();
        return ids;
    }

    public static void writeIDArray(JsonWriter out, HashSet<Integer> listToWrite, @Nullable Class<?> idContainer) throws IOException {
        if (listToWrite.size() == 0) {
            out.nullValue();
            return;
        }
        if (idContainer == null) {
            out.beginArray();
            for (int i : listToWrite) {
                out.value(i);
            }
            out.endArray();
            return;
        }
        HashMap<Integer, String> idNames = new HashMap<Integer, String>();
        for (Field field : idContainer.getFields()) {
            if (!field.getType().equals(Integer.TYPE)) continue;
            try {
                int value = field.getInt(null);
                idNames.put(value, field.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        out.beginArray();
        Iterator<Integer> iterator2 = listToWrite.iterator();
        while (iterator2.hasNext()) {
            int id = (Integer)iterator2.next();
            String name = (String)idNames.get(id);
            if (name == null) {
                out.value(id);
                continue;
            }
            out.value(name);
        }
        out.endArray();
    }
}

