/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui.components.colorpicker;

import java.awt.Color;
import java.awt.Window;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.ui.components.colorpicker.RuneliteColorPicker;

@Singleton
public class ColorPickerManager {
    private final ConfigManager configManager;
    private RuneliteColorPicker currentPicker;

    @Inject
    private ColorPickerManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public RuneliteColorPicker create(Window owner, Color previousColor, String title, boolean alphaHidden) {
        this.currentPicker = new RuneliteColorPicker(owner, previousColor, title, alphaHidden, this.configManager, this);
        if (this.currentPicker.isAlwaysOnTopSupported() && owner != null) {
            this.currentPicker.setAlwaysOnTop(owner.isAlwaysOnTop());
        }
        return this.currentPicker;
    }

    void setCurrentPicker(RuneliteColorPicker currentPicker) {
        this.currentPicker = currentPicker;
    }

    RuneliteColorPicker getCurrentPicker() {
        return this.currentPicker;
    }
}

