/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.http.api.feed;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.runelite.http.api.RuneLiteAPI;
import net.runelite.http.api.feed.FeedResult;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedClient {
    private static final Logger log = LoggerFactory.getLogger(FeedClient.class);
    private final OkHttpClient client;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FeedResult lookupFeed() throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("feed.js").build();
        log.debug("Built URI: {}", (Object)url);
        Request request = new Request.Builder().url(url).build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                log.debug("Error looking up feed: {}", (Object)response);
                FeedResult feedResult = null;
                return feedResult;
            }
            InputStream in = response.body().byteStream();
            FeedResult feedResult = RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), FeedResult.class);
            return feedResult;
        }
        catch (JsonParseException ex) {
            throw new IOException(ex);
        }
    }

    public FeedClient(OkHttpClient client) {
        this.client = client;
    }
}

