/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.http.api.npc;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.runelite.http.api.RuneLiteAPI;
import net.runelite.http.api.npc.NpcInfo;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NpcInfoClient {
    private static final Logger log = LoggerFactory.getLogger(NpcInfoClient.class);
    private final OkHttpClient client;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<Integer, NpcInfo> getNpcs() throws IOException {
        HttpUrl.Builder urlBuilder = RuneLiteAPI.getStaticBase().newBuilder().addPathSegment("npcs").addPathSegment("npcs.min.json");
        HttpUrl url = urlBuilder.build();
        log.debug("Built URI: {}", (Object)url);
        Request request = new Request.Builder().url(url).build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                log.warn("Error looking up npcs: {}", (Object)response);
                Map<Integer, NpcInfo> map = null;
                return map;
            }
            InputStream in = response.body().byteStream();
            Type typeToken = new TypeToken<Map<Integer, NpcInfo>>(){}.getType();
            Map map = (Map)RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), typeToken);
            return map;
        }
        catch (JsonParseException ex) {
            throw new IOException(ex);
        }
    }

    public NpcInfoClient(OkHttpClient client) {
        this.client = client;
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NpcInfoClient)) {
            return false;
        }
        NpcInfoClient other = (NpcInfoClient)o;
        OkHttpClient this$client = this.getClient();
        OkHttpClient other$client = other.getClient();
        return !(this$client == null ? other$client != null : !this$client.equals(other$client));
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        OkHttpClient $client = this.getClient();
        result2 = result2 * 59 + ($client == null ? 43 : $client.hashCode());
        return result2;
    }

    public String toString() {
        return "NpcInfoClient(client=" + String.valueOf(this.getClient()) + ")";
    }
}

