/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.protocols.relay.SiteMaster;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class RelayDemoRpc
implements Receiver {
    protected JChannel ch;
    protected RpcDispatcher disp;
    protected String local_addr;
    protected View view;
    protected static final long RPC_TIMEOUT = 10000L;

    public static void main(String[] args2) throws Exception {
        String props = "udp.xml";
        String name = null;
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i].equals("-props")) {
                props = args2[++i];
                continue;
            }
            if (args2[i].equals("-name")) {
                name = args2[++i];
                continue;
            }
            System.out.println("RelayDemo [-props props] [-name name]");
            return;
        }
        RelayDemoRpc demo = new RelayDemoRpc();
        demo.start(props, name);
    }

    @Override
    public void receive(Message msg) {
    }

    public void start(String props, String name) throws Exception {
        this.ch = new JChannel(props);
        if (name != null) {
            this.ch.setName(name);
        }
        this.disp = new RpcDispatcher(this.ch, this).setReceiver(this);
        this.ch.connect("RelayDemo");
        this.local_addr = this.ch.getAddress().toString();
        MethodCall call = new MethodCall(this.getClass().getMethod("handleMessage", String.class, String.class), new Object[0]);
        block6: while (true) {
            Collection<String> site_masters;
            Object dest;
            String line;
            if ((line = Util.readStringFromStdin(": ")).startsWith("help")) {
                System.out.println("unicast <text>  // unicasts to all members of local view\nsite <site>+    // unicasts to all listed site masters, e.g. \"site sfo lon\"\nmcast <site>+   // anycasts to all local members, plus listed site masters \n<text>          // multicast, RELAY2 will relay to all members of sites");
                continue;
            }
            call.setArgs(line, this.local_addr);
            if (line.equalsIgnoreCase("unicast")) {
                Iterator<Address> iterator2 = this.view.getMembers().iterator();
                while (true) {
                    if (!iterator2.hasNext()) continue block6;
                    dest = iterator2.next();
                    System.out.println("invoking method in " + (Address)dest + ": ");
                    try {
                        Object rsp = this.disp.callRemoteMethod((Address)dest, call, new RequestOptions(ResponseMode.GET_ALL, 10000L));
                        System.out.println("rsp from " + (Address)dest + ": " + rsp);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
            if (line.startsWith("site")) {
                site_masters = RelayDemoRpc.parseSiteMasters(line.substring("site".length()));
                dest = site_masters.iterator();
                while (true) {
                    if (!dest.hasNext()) continue block6;
                    String site_master = (String)dest.next();
                    try {
                        SiteMaster dest2 = new SiteMaster(site_master);
                        System.out.println("invoking method in " + dest2 + ": ");
                        Object rsp = this.disp.callRemoteMethod(dest2, call, new RequestOptions(ResponseMode.GET_ALL, 10000L));
                        System.out.println("rsp from " + dest2 + ": " + rsp);
                    }
                    catch (Throwable t2) {
                        t2.printStackTrace();
                    }
                }
            }
            if (line.startsWith("mcast")) {
                site_masters = RelayDemoRpc.parseSiteMasters(line.substring("mcast".length()));
                ArrayList<Address> dests = new ArrayList<Address>(site_masters.size());
                for (String site_master : site_masters) {
                    try {
                        dests.add(new SiteMaster(site_master));
                    }
                    catch (Throwable t3) {
                        System.err.println("failed adding SiteMaster for " + site_master + ": " + t3);
                    }
                }
                dests.addAll(this.view.getMembers());
                System.out.println("invoking method in " + dests + ": ");
                RspList rsps = this.disp.callRemoteMethods(dests, call, new RequestOptions(ResponseMode.GET_ALL, 10000L).anycasting(true));
                Iterator iterator3 = rsps.entrySet().iterator();
                while (true) {
                    if (!iterator3.hasNext()) continue block6;
                    Map.Entry entry = iterator3.next();
                    Address sender = (Address)entry.getKey();
                    Rsp rsp = (Rsp)entry.getValue();
                    if (rsp.wasUnreachable()) {
                        System.out.println("<< unreachable: " + sender);
                        continue;
                    }
                    System.out.println("<< " + rsp.getValue() + " from " + sender);
                }
            }
            RspList rsps = this.disp.callRemoteMethods(null, call, new RequestOptions(ResponseMode.GET_ALL, 10000L).anycasting(false));
            rsps.forEach((key, val) -> System.out.println("<< " + val.getValue() + " from " + key));
        }
    }

    protected static Collection<String> parseSiteMasters(String line) {
        String[] tmp;
        HashSet<String> retval = new HashSet<String>();
        for (String s2 : tmp = line.split("\\s")) {
            String result2 = s2.trim();
            if (result2.isEmpty()) continue;
            retval.add(result2);
        }
        return retval;
    }

    public static String handleMessage(String msg, String sender) {
        System.out.println("<< " + msg + " from " + sender);
        return "this is a response";
    }

    @Override
    public void viewAccepted(View new_view) {
        System.out.println(RelayDemoRpc.print(new_view));
        this.view = new_view;
    }

    static String print(View view) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append(view.getClass().getSimpleName() + ": ").append(view.getViewId()).append(": ");
        for (Address mbr : view.getMembers()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(mbr);
        }
        return sb.toString();
    }
}

