/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jgroups.JChannelProbeHandler;
import org.jgroups.Version;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.protocols.TP;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

@MBean(description="Periodically fetches some attributes from selected (use-configurable) protocols and writes them to a file")
public class SOS
extends Protocol {
    @Property(description="File to which the periodic data is written", writable=false)
    protected String filename = "${sos.filename:jgroups.sos}";
    @Property(description="Interval in ms at which the attributes are fetched and written to the file", writable=false, type=AttributeType.TIME)
    protected long interval = 900000L;
    @Property(description="The attributes to be fetched. In probe format ('jmx' or 'op' command)", writable=false)
    protected String cmd = "jmx=TP.bind_,thread_pool_ jmx=FD_ALL3.num_s op=TP.printLogicalAddressCache";
    @Property(description="The configuration file containing all protocols and attributes to be dumped")
    protected String config = "sos.cfg";
    protected Set<DiagnosticsHandler.ProbeHandler> handlers;
    private Future<?> task;

    public String getFilename() {
        return this.filename;
    }

    public SOS setFileName(String f) {
        this.filename = f;
        return this;
    }

    public long getInterval() {
        return this.interval;
    }

    public SOS setInterval(long i) {
        this.interval = i;
        return this;
    }

    @ManagedOperation(description="Reads the contents of the given file and sets cmd")
    public SOS setCommand(String filename) throws IOException {
        this.cmd = Util.readFile(filename);
        return this;
    }

    @ManagedOperation(description="Reads the attributes to be dumped from the default configuration file")
    public SOS read() throws IOException {
        try (InputStream input = this.getInput(this.config);){
            this.cmd = Util.readContents(input);
        }
        return this;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.read();
    }

    @Override
    public void start() throws Exception {
        super.start();
        TP tp = this.getTransport();
        this.handlers = tp.getDiagnosticsHandler() != null ? tp.getDiagnosticsHandler().getProbeHandlers() : Collections.singleton(new JChannelProbeHandler(this.stack.getChannel()));
        this.task = tp.getTimer().scheduleWithFixedDelay(new DumperTask(), this.interval, this.interval, TimeUnit.MILLISECONDS, false);
    }

    @Override
    public void stop() {
        super.stop();
        this.task.cancel(true);
    }

    @Override
    public void up(MessageBatch batch) {
        this.up_prot.up(batch);
    }

    @ManagedOperation(description="Dumps attributes / invokes operations from given protocols")
    public String exec() {
        StringTokenizer t2 = new StringTokenizer(this.cmd);
        ArrayList<String> list = new ArrayList<String>();
        while (t2.hasMoreTokens()) {
            list.add(t2.nextToken());
        }
        String[] args2 = list.toArray(new String[0]);
        StringBuilder sb = new StringBuilder(this.getMetadata());
        for (DiagnosticsHandler.ProbeHandler ph : this.handlers) {
            Map<String, String> ret = ph.handleProbe(args2);
            if (ret == null || ret.isEmpty()) continue;
            for (Map.Entry<String, String> e : ret.entrySet()) {
                sb.append(String.format("\n* %s: %s", e.getKey(), e.getValue()));
            }
        }
        return sb.append("\n").toString();
    }

    protected String getMetadata() {
        TP tp = this.stack.getTransport();
        return String.format("\nDate: %s, member: %s (%s), version: %s\nview: %s\n", new Date(), tp.getAddress(), tp.getPhysicalAddress(), Version.printVersion(), tp.view());
    }

    protected InputStream getInput(String name) throws FileNotFoundException {
        InputStream input = Util.getResourceAsStream(name, this.getClass());
        if (input == null) {
            input = new FileInputStream(name);
        }
        if (input == null) {
            throw new IllegalArgumentException(String.format("config file %s not found", name));
        }
        return input;
    }

    protected class DumperTask
    implements Runnable {
        protected DumperTask() {
        }

        @Override
        public void run() {
            try (FileOutputStream out = new FileOutputStream(SOS.this.filename);){
                String dump = SOS.this.exec();
                ((OutputStream)out).write(dump.getBytes());
            }
            catch (Exception e) {
                SOS.this.log.error("%s: failed dumping SOS information to %s: %s", SOS.this.getTransport().getAddress(), SOS.this.filename, e);
            }
        }

        public String toString() {
            return String.format("%s: %s (%s)", SOS.class.getSimpleName(), this.getClass().getSimpleName(), SOS.this.getTransport().getAddress());
        }
    }
}

