/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.BytesMessage;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.BoundedList;
import org.jgroups.util.ByteArray;
import org.jgroups.util.NameCache;
import org.jgroups.util.Responses;
import org.jgroups.util.StackType;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

public class TCPPING
extends Discovery {
    @Property(name="initial_hosts", description="Comma delimited list of hosts to be contacted for initial membership. Ideally, all members should be listed. If this is not possible, send_cache_on_join and / or return_entire_cache can be set to true", dependsUpon="port_range", systemProperty={"jgroups.tcpping.initial_hosts"})
    protected String initial_hosts_str;
    @Property(description="Number of additional ports to be probed for membership. A port_range of 0 does not probe additional ports. Example: initial_hosts=A[7800] port_range=0 probes A:7800, port_range=1 probes A:7800 and A:7801")
    protected int port_range = 1;
    @ManagedAttribute(description="True if initial hosts were set programmatically (via setInitialHosts())")
    protected boolean initial_hosts_set_programmatically;
    @ManagedAttribute(description="A list of unresolved hosts of initial_hosts")
    protected Collection<String> unresolved_hosts = new HashSet<String>();
    @Property(description="max number of hosts to keep beyond the ones in initial_hosts")
    protected int max_dynamic_hosts = 2000;
    protected Collection<PhysicalAddress> initial_hosts = new HashSet<PhysicalAddress>();
    protected BoundedList<PhysicalAddress> dynamic_hosts;
    protected StackType stack_type = StackType.Dual;

    @Override
    public boolean isDynamic() {
        return false;
    }

    public Collection<PhysicalAddress> getInitialHosts() {
        return this.initial_hosts;
    }

    @ManagedAttribute(description="The list of resolved hosts:ports")
    public Collection<PhysicalAddress> getResolvedHosts() {
        return this.initial_hosts;
    }

    public <T extends TCPPING> T setInitialHosts(Collection<InetSocketAddress> hosts) {
        if (hosts == null || hosts.isEmpty()) {
            return (T)this;
        }
        this.initial_hosts = hosts.stream().map(h2 -> new IpAddress(h2.getAddress(), h2.getPort())).collect(Collectors.toList());
        this.initial_hosts_str = TCPPING.hostsToStr(this.initial_hosts);
        this.initial_hosts_set_programmatically = true;
        return (T)this;
    }

    public <T extends TCPPING> T setInitialHosts2(Collection<PhysicalAddress> hosts) {
        if (hosts == null || hosts.isEmpty()) {
            return (T)this;
        }
        this.initial_hosts = hosts;
        this.initial_hosts_str = TCPPING.hostsToStr(this.initial_hosts);
        this.initial_hosts_set_programmatically = true;
        return (T)this;
    }

    public <T extends TCPPING> T initialHosts(Collection<InetSocketAddress> h2) {
        this.setInitialHosts(h2);
        return (T)this;
    }

    public int getPortRange() {
        return this.port_range;
    }

    public <T extends TCPPING> T setPortRange(int port_range) {
        this.port_range = port_range;
        return (T)this;
    }

    public <T extends TCPPING> T portRange(int r) {
        this.port_range = r;
        return (T)this;
    }

    @ManagedAttribute
    public String getDynamicHostList() {
        return this.dynamic_hosts.toString();
    }

    @ManagedOperation
    public <T extends TCPPING> T clearDynamicHostList() {
        this.dynamic_hosts.clear();
        return (T)this;
    }

    @Override
    public void init() throws Exception {
        boolean all_resolved;
        super.init();
        InetAddress bind_addr = this.transport.getBindAddr();
        if (bind_addr != null) {
            this.stack_type = bind_addr instanceof Inet6Address ? StackType.IPv6 : StackType.IPv4;
        }
        this.dynamic_hosts = new BoundedList(this.max_dynamic_hosts);
        if (!this.initial_hosts_set_programmatically && !(all_resolved = Util.parseCommaDelimitedHostsInto(this.initial_hosts, this.unresolved_hosts, this.initial_hosts_str, this.port_range, this.stack_type))) {
            this.log.warn("unable to resolve the following hostnames: %s", this.unresolved_hosts);
        }
    }

    @Override
    public Object down(Event evt) {
        Object retval = super.down(evt);
        switch (evt.getType()) {
            case 6: {
                for (Address logical_addr : this.view.getMembersRaw()) {
                    PhysicalAddress physical_addr = (PhysicalAddress)this.down_prot.down(new Event(87, logical_addr));
                    if (physical_addr == null || this.initial_hosts.contains(physical_addr)) continue;
                    this.dynamic_hosts.addIfAbsent(physical_addr);
                }
                break;
            }
            case 89: {
                Tuple tuple = (Tuple)evt.getArg();
                PhysicalAddress physical_addr = (PhysicalAddress)tuple.getVal2();
                if (physical_addr == null || this.initial_hosts.contains(physical_addr)) break;
                this.dynamic_hosts.addIfAbsent(physical_addr);
            }
        }
        return retval;
    }

    @Override
    public void discoveryRequestReceived(Address sender, String logical_name, PhysicalAddress physical_addr) {
        super.discoveryRequestReceived(sender, logical_name, physical_addr);
        if (physical_addr != null && !this.initial_hosts.contains(physical_addr)) {
            this.dynamic_hosts.addIfAbsent(physical_addr);
        }
    }

    @Override
    public void findMembers(List<Address> members2, boolean initial_discovery, Responses responses) {
        Collection list;
        PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, this.local_addr));
        PingData data2 = new PingData(this.local_addr, false, NameCache.get(this.local_addr), physical_addr);
        if (members2 != null && members2.size() <= this.max_members_in_discovery_request) {
            data2.mbrs(members2);
        }
        ArrayList cluster_members = new ArrayList(this.initial_hosts.size() + (this.dynamic_hosts != null ? this.dynamic_hosts.size() : 0) + 5);
        this.initial_hosts.stream().filter(phys_addr -> !cluster_members.contains(phys_addr)).forEach(cluster_members::add);
        if (this.dynamic_hosts != null) {
            this.dynamic_hosts.stream().filter(phys_addr -> !cluster_members.contains(phys_addr)).forEach(cluster_members::add);
        }
        if (!this.initial_hosts_set_programmatically && !this.unresolved_hosts.isEmpty()) {
            this.unresolved_hosts.clear();
            if (Util.parseCommaDelimitedHostsInto(this.initial_hosts, this.unresolved_hosts, this.initial_hosts_str, this.port_range, this.stack_type)) {
                this.log.debug("finally resolved all hosts: %s", this.initial_hosts);
            }
        }
        if (this.use_disk_cache && (list = (Collection)this.down_prot.down(new Event(102))) != null) {
            list.stream().filter(phys_addr -> !cluster_members.contains(phys_addr)).forEach(cluster_members::add);
        }
        ByteArray data_buf = data2 != null ? TCPPING.marshal(data2) : null;
        PingHeader hdr = new PingHeader(1).clusterName(this.cluster_name).initialDiscovery(initial_discovery);
        for (PhysicalAddress addr : cluster_members) {
            if (addr.equals(physical_addr)) continue;
            Message msg = new BytesMessage(addr).setFlag(Message.Flag.DONT_BUNDLE, Message.Flag.OOB).setFlag(Message.TransientFlag.DONT_LOOPBACK).putHeader(this.id, hdr);
            if (data_buf != null) {
                msg.setArray(data_buf);
            }
            if (this.async_discovery_use_separate_thread_per_request) {
                this.timer.execute(() -> this.sendDiscoveryRequest(msg), this.sends_can_block);
                continue;
            }
            this.sendDiscoveryRequest(msg);
        }
    }

    protected void sendDiscoveryRequest(Message req) {
        try {
            this.log.trace("%s: sending discovery request to %s", this.local_addr, req.getDest());
            this.down_prot.down(req);
        }
        catch (Throwable t2) {
            this.log.trace("sending discovery request to %s failed: %s", req.getDest(), t2);
        }
    }

    protected static String hostsToStr(Collection<PhysicalAddress> hosts) {
        if (hosts == null || hosts.isEmpty()) {
            return "";
        }
        return hosts.stream().map(a -> ((IpAddress)a).printIpAddress2()).collect(Collectors.joining(","));
    }
}

