/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.EmptyMessage;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.logging.Log;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.protocols.relay.Route;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.protocols.relay.SiteUUID;
import org.jgroups.protocols.relay.config.RelayConfig;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

public class Relayer {
    protected ConcurrentMap<String, List<Route>> routes = new ConcurrentHashMap<String, List<Route>>(5);
    protected final Queue<Bridge> bridges = new ConcurrentLinkedQueue<Bridge>();
    protected final Log log;
    protected final RELAY2 relay;
    protected volatile boolean done;
    protected boolean stats;

    public Relayer(RELAY2 relay, Log log) {
        this.relay = relay;
        this.stats = relay.statsEnabled();
        this.log = log;
    }

    public boolean done() {
        return this.done;
    }

    public void start(List<RelayConfig.BridgeConfig> bridge_configs, String bridge_name, String my_site_id) throws Throwable {
        if (this.done) {
            this.log.trace(this.relay.getAddress() + ": will not start the Relayer as stop() has been called");
            return;
        }
        try {
            for (RelayConfig.BridgeConfig bridge_config : bridge_configs) {
                Bridge bridge = new Bridge(bridge_config.createChannel(), bridge_config.getClusterName(), bridge_name, () -> new SiteUUID(UUID.randomUUID(), null, my_site_id));
                this.bridges.add(bridge);
            }
            for (Bridge bridge : this.bridges) {
                bridge.start();
            }
        }
        catch (Throwable t2) {
            this.stop();
            throw t2;
        }
        finally {
            if (this.done) {
                this.log.trace(this.relay.getAddress() + ": stop() was called while starting the relayer; stopping the relayer now");
                this.stop();
            }
        }
    }

    public void stop() {
        this.done = true;
        this.bridges.forEach(Bridge::stop);
        this.bridges.clear();
    }

    public synchronized String printRoutes() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.routes.entrySet()) {
            List list = (List)entry.getValue();
            if (list == null || list.isEmpty()) continue;
            sb.append((String)entry.getKey() + " --> ").append(Util.print(list)).append("\n");
        }
        return sb.toString();
    }

    protected Route getRoute(String site) {
        return this.getRoute(site, null);
    }

    protected synchronized Route getRoute(String site, Address sender) {
        List list = (List)this.routes.get(site);
        if (list == null) {
            return null;
        }
        if (list.size() == 1) {
            return (Route)list.get(0);
        }
        return this.relay.site_master_picker.pickRoute(site, list, sender);
    }

    protected List<String> getSiteNames() {
        return new ArrayList<String>(this.routes.keySet());
    }

    protected synchronized List<Route> getRoutes(String ... excluded_sites) {
        ArrayList<Route> retval = new ArrayList<Route>(this.routes.size());
        block0: for (List list : this.routes.values()) {
            for (Route route : list) {
                if (route == null || Relayer.isExcluded(route, excluded_sites)) continue;
                retval.add(route);
                continue block0;
            }
        }
        return retval;
    }

    protected View getBridgeView(String cluster_name) {
        if (cluster_name == null || this.bridges == null) {
            return null;
        }
        for (Bridge bridge : this.bridges) {
            if (!Objects.equals(bridge.cluster_name, cluster_name)) continue;
            return bridge.view;
        }
        return null;
    }

    protected static boolean isExcluded(Route route, String ... excluded_sites) {
        if (excluded_sites == null) {
            return false;
        }
        String site = ((SiteUUID)route.site_master).getSite();
        for (String excluded_site : excluded_sites) {
            if (!site.equals(excluded_site)) continue;
            return true;
        }
        return false;
    }

    protected class Bridge
    implements Receiver {
        protected JChannel channel;
        protected final String cluster_name;
        protected View view;

        protected Bridge(JChannel ch, String cluster_name, String channel_name, AddressGenerator addr_generator) throws Exception {
            this.channel = ch;
            this.channel.setName(channel_name);
            this.channel.setReceiver(this);
            this.channel.addAddressGenerator(addr_generator);
            this.cluster_name = cluster_name;
        }

        protected void start() throws Exception {
            this.channel.connect(this.cluster_name);
            Relayer.this.log.info("%s: joined bridge cluster '%s'", this.channel.getAddress(), this.cluster_name);
        }

        protected void stop() {
            Relayer.this.log.info("%s: leaving bridge cluster '%s'", this.channel.getAddress(), this.channel.getClusterName());
            Util.close((Closeable)this.channel);
        }

        @Override
        public void receive(Message msg) {
            RELAY2.Relay2Header hdr = (RELAY2.Relay2Header)msg.getHeader(Relayer.this.relay.getId());
            if (hdr == null) {
                Relayer.this.log.warn("received a message without a relay header; discarding it");
                return;
            }
            switch (hdr.type) {
                case 6: {
                    RELAY2.Relay2Header rsp_hdr = new RELAY2.Relay2Header(7).setSites(Relayer.this.relay.printLocalTopology());
                    Message topo_rsp = new EmptyMessage(msg.src()).putHeader(Relayer.this.relay.getId(), rsp_hdr);
                    try {
                        this.channel.send(topo_rsp);
                    }
                    catch (Exception e) {
                        Relayer.this.log.warn("%s: failed sending TOPO-RSP message to %s: %s", this.channel.getAddress(), msg.src(), e);
                    }
                    return;
                }
                case 7: {
                    String[] sites = hdr.getSites();
                    if (sites != null && sites.length > 0 && sites[0] != null) {
                        Relayer.this.relay.topo_collector.add(msg.src(), sites[0]);
                    }
                    return;
                }
            }
            Relayer.this.relay.handleRelayMessage(hdr, msg);
        }

        @Override
        public void viewAccepted(View new_view) {
            this.view = new_view;
            Relayer.this.log.trace("[Relayer " + this.channel.getAddress() + "] view: " + new_view);
            Map<String, List<Address>> tmp = this.extract(new_view);
            HashSet down2 = new HashSet(Relayer.this.routes.keySet());
            HashSet<String> up2 = new HashSet<String>();
            down2.removeAll(tmp.keySet());
            Relayer.this.routes.keySet().retainAll(tmp.keySet());
            for (Map.Entry<String, List<Address>> entry : tmp.entrySet()) {
                ArrayList<Route> newRoutes;
                String key = entry.getKey();
                List<Address> val = entry.getValue();
                if (Relayer.this.routes.containsKey(key)) {
                    newRoutes = new ArrayList((Collection)Relayer.this.routes.get(key));
                } else {
                    newRoutes = new ArrayList<Route>();
                    if (up2 != null) {
                        up2.add(key);
                    }
                }
                newRoutes.removeIf(route -> !val.contains(route.siteMaster()));
                val.stream().filter(addr -> !this.contains((List<Route>)newRoutes, (Address)addr)).forEach(addr -> newRoutes.add(new Route((Address)addr, this.channel, Relayer.this.relay, Relayer.this.log).stats(Relayer.this.stats)));
                if (newRoutes.isEmpty()) {
                    Relayer.this.routes.remove(key);
                    down2.add(key);
                    up2.remove(key);
                    continue;
                }
                Relayer.this.routes.put(key, Collections.unmodifiableList(newRoutes));
            }
            if (!down2.isEmpty()) {
                Relayer.this.relay.sitesChange(true, down2.toArray(new String[0]));
            }
            if (!up2.isEmpty()) {
                Relayer.this.relay.sitesChange(false, up2.toArray(new String[0]));
            }
        }

        protected boolean contains(List<Route> routes, Address addr) {
            return routes.stream().anyMatch(route -> route.siteMaster().equals(addr));
        }

        protected Map<String, List<Address>> extract(View view) {
            HashMap<String, List<Address>> map = new HashMap<String, List<Address>>(view.size());
            for (Address mbr : view) {
                SiteAddress member = (SiteAddress)mbr;
                String key = member.getSite();
                List list = map.computeIfAbsent(key, k -> new ArrayList());
                if (list.contains(member)) continue;
                list.add(member);
            }
            return map;
        }
    }
}

