/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.BytesMessage;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.util.ByteArray;
import org.jgroups.util.Util;

public class MessageDispatcherSpeedTest
implements Receiver,
RequestHandler {
    JChannel channel;
    MessageDispatcher disp;
    String props = null;
    boolean server = false;
    int num = 1000;
    int received = 0;
    static final long TIMEOUT = 10000L;

    public MessageDispatcherSpeedTest(String props, boolean server, int num) {
        this.props = props;
        this.server = server;
        this.num = num;
    }

    @Override
    public Object handle(Message msg) throws Exception {
        ++this.received;
        if (this.received % 1000 == 0) {
            System.out.println("-- received " + this.received);
        }
        return null;
    }

    public void start() throws Exception {
        this.channel = new JChannel(this.props);
        this.disp = new MessageDispatcher(this.channel, this).setReceiver(this);
        this.channel.connect("MessageDispatcherSpeedTestGroup");
        try {
            if (this.server) {
                System.out.println("-- Started as server. Press ctrl-c to kill");
                while (true) {
                    Util.sleep(10000L);
                }
            }
            this.sendMessages(this.num);
        }
        catch (Throwable t2) {
            t2.printStackTrace(System.err);
        }
        finally {
            this.channel.close();
            this.disp.stop();
        }
    }

    void sendMessages(int num) throws Exception {
        int show = num / 10;
        if (show <= 0) {
            show = 1;
        }
        long start = System.currentTimeMillis();
        RequestOptions opts = new RequestOptions(ResponseMode.GET_ALL, 10000L).flags(Message.Flag.DONT_BUNDLE, Message.Flag.NO_FC);
        byte[] data2 = "bla".getBytes();
        ByteArray buf = new ByteArray(data2, 0, data2.length);
        System.out.println("-- sending " + num + " messages");
        for (int i = 1; i <= num; ++i) {
            this.disp.castMessage(null, new BytesMessage(null, buf), opts);
            if (i % show != 0) continue;
            System.out.println("-- sent " + i);
        }
        long stop = System.currentTimeMillis();
        MessageDispatcherSpeedTest.printStats(stop - start, num);
    }

    static void printStats(long total_time, int num) {
        double throughput = (double)num / ((double)total_time / 1000.0);
        System.out.println("time for " + num + " remote calls was " + total_time + ", avg=" + (double)total_time / (double)num + "ms/invocation, " + (long)throughput + " calls/sec");
    }

    @Override
    public void viewAccepted(View new_view) {
        System.out.println("-- new view: " + new_view);
    }

    public static void main(String[] args2) throws Exception {
        String props = null;
        boolean server = false;
        int num = 1000;
        for (int i = 0; i < args2.length; ++i) {
            if ("-props".equals(args2[i])) {
                props = args2[++i];
                continue;
            }
            if ("-server".equals(args2[i])) {
                server = true;
                continue;
            }
            if ("-num".equals(args2[i])) {
                num = Integer.parseInt(args2[++i]);
                continue;
            }
            MessageDispatcherSpeedTest.help();
            return;
        }
        MessageDispatcherSpeedTest test2 = new MessageDispatcherSpeedTest(props, server, num);
        test2.start();
    }

    static void help() {
        System.out.println("MessageDispatcherSpeedTest [-help] [-props <props>] [-server] [-num <number of calls>]");
    }
}

