/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.util.Date;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.jgroups.util.Util;

public class UdpPerf {
    protected MulticastSocket mcast_sock;
    protected SocketAddress sock_addr;
    protected Receiver receiver;
    protected int num_msgs = 1000000;
    protected int msg_size = 1000;
    protected int num_threads = 1;
    protected int log_interval = this.num_msgs / 10;
    protected int receive_log_interval = this.num_msgs / 10;
    protected final LongAdder total_received_msgs = new LongAdder();
    protected boolean looping = true;
    protected long last_interval;

    public void start() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n----------------------- MPerf -----------------------\n");
        sb.append("Date: ").append(new Date()).append('\n');
        sb.append("Run by: ").append(System.getProperty("user.name")).append("\n");
        System.out.println(sb);
        this.mcast_sock = new MulticastSocket(7500);
        this.sock_addr = new InetSocketAddress(InetAddress.getByName("232.5.5.5"), 7500);
        this.mcast_sock.joinGroup(this.sock_addr, null);
        this.mcast_sock.setReceiveBufferSize(10000000);
        this.mcast_sock.setSendBufferSize(5000000);
        this.mcast_sock.setTrafficClass(8);
        this.receiver = new Receiver();
        this.receiver.start();
    }

    protected void loop() {
        String INPUT2 = "[1] Send [x] Exit";
        while (this.looping) {
            try {
                int c = Util.keyPress(String.format("[1] Send [x] Exit", new Object[0]));
                switch (c) {
                    case 49: {
                        this.sendMessages();
                        break;
                    }
                    case -1: 
                    case 120: {
                        this.looping = false;
                    }
                }
            }
            catch (Throwable t2) {
                System.err.println(t2);
            }
        }
        this.stop();
    }

    protected void send(byte[] payload) throws Exception {
        DatagramPacket packet = new DatagramPacket(payload, 0, payload.length, this.sock_addr);
        this.mcast_sock.send(packet);
    }

    public void stop() {
        this.looping = false;
        this.mcast_sock.close();
    }

    protected void handleData() {
        if (this.last_interval == 0L) {
            this.last_interval = System.currentTimeMillis();
        }
        this.total_received_msgs.increment();
        long received_so_far = this.total_received_msgs.sum();
        if (received_so_far % (long)this.receive_log_interval == 0L) {
            long curr_time = System.currentTimeMillis();
            long diff = curr_time - this.last_interval;
            double msgs_sec = (double)this.receive_log_interval / ((double)diff / 1000.0);
            double throughput = msgs_sec * (double)this.msg_size;
            this.last_interval = curr_time;
            System.out.println(String.format("-- received %d msgs %d ms, %.2f msgs/sec, %s / sec)", received_so_far, diff, msgs_sec, Util.printBytes(throughput)));
        }
    }

    void reset() {
        this.total_received_msgs.reset();
        this.last_interval = 0L;
    }

    protected void sendMessages() {
        AtomicInteger num_msgs_sent = new AtomicInteger(0);
        Sender[] senders = new Sender[this.num_threads];
        CyclicBarrier barrier = new CyclicBarrier(this.num_threads + 1);
        byte[] payload = new byte[this.msg_size];
        this.reset();
        for (int i = 0; i < this.num_threads; ++i) {
            senders[i] = new Sender(barrier, num_msgs_sent, payload);
            senders[i].setName("sender-" + i);
            senders[i].start();
        }
        try {
            System.out.println("-- sending " + this.num_msgs + " msgs");
            barrier.await();
        }
        catch (Exception e) {
            System.err.println("failed triggering send threads: " + e);
        }
    }

    public static void main(String[] args2) {
        UdpPerf test2 = new UdpPerf();
        try {
            test2.start();
            test2.loop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected class Receiver
    extends Thread {
        byte[] buf = new byte[10000];

        protected Receiver() {
        }

        @Override
        public void run() {
            while (!UdpPerf.this.mcast_sock.isClosed()) {
                DatagramPacket packet = new DatagramPacket(this.buf, 0, this.buf.length);
                try {
                    UdpPerf.this.mcast_sock.receive(packet);
                    UdpPerf.this.handleData();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected class Sender
    extends Thread {
        protected final CyclicBarrier barrier;
        protected final AtomicInteger num_msgs_sent;
        protected final byte[] payload;

        protected Sender(CyclicBarrier barrier, AtomicInteger num_msgs_sent, byte[] payload) {
            this.barrier = barrier;
            this.num_msgs_sent = num_msgs_sent;
            this.payload = payload;
        }

        @Override
        public void run() {
            try {
                this.barrier.await();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            block4: while (true) {
                try {
                    int tmp;
                    while ((tmp = this.num_msgs_sent.incrementAndGet()) <= UdpPerf.this.num_msgs) {
                        UdpPerf.this.send(this.payload);
                        if (tmp % UdpPerf.this.log_interval == 0) {
                            System.out.println("++ sent " + tmp);
                        }
                        if (tmp != UdpPerf.this.num_msgs) continue;
                        break block4;
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }
}

